/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.recovery;

import java.util.Enumeration;
import java.util.Hashtable;
import se.ericsson.cello.mopersistence.MoTypeStorage;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class MoTypeLookup {
    private static MoTypeLookup theInstance = null;
    private int nextKey;
    boolean isCleaned = false;
    private Hashtable moTypeKeys = new Hashtable();
    private Hashtable moTypeKeysToRemove = null;
    private Hashtable moTypes = new Hashtable();

    public static MoTypeLookup instance() {
        if (theInstance == null) {
            theInstance = new MoTypeLookup();
        }
        return theInstance;
    }

    public static void setInstance(MoTypeLookup moTypeLookup) {
        theInstance = moTypeLookup;
    }

    public synchronized void clean() {
        if (this.moTypeKeysToRemove.size() > 0) {
            try {
                Control control = MoTypeLookup.createTransaction();
                MoTypeStorage moTypeStorage = MoTypeStorage.instance();
                Enumeration enumeration = this.moTypeKeysToRemove.keys();
                while (enumeration.hasMoreElements()) {
                    int n = (Integer)enumeration.nextElement();
                    moTypeStorage.deleteRow(control.getCoordinator().getTransactionID(), n);
                    this.moTypes.remove(this.moTypeKeys.get(new Integer(n)));
                    this.moTypeKeys.remove(new Integer(n));
                }
                control.getTerminator().commit();
            }
            catch (DbAccessException dbAccessException) {
                Assert.cppAssert((boolean)false, (String)("MoTypeLookup clean() exception :" + (Object)((Object)dbAccessException)));
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                Assert.cppAssert((boolean)false, (String)("MoTypeLookup clean() exception :" + (Object)((Object)transactionRolledBackException)));
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Assert.cppAssert((boolean)false, (String)("MoTypeLookup clean() exception :" + (Object)((Object)inactiveTransactionException)));
            }
        }
        this.isCleaned = true;
        this.moTypeKeysToRemove = null;
    }

    public synchronized String lookup(int n) {
        String string = (String)this.moTypeKeys.get(new Integer(n));
        Assert.cppAssert((Object)string, (String)"MoTypeLookup.lookup moType");
        if (!this.isCleaned) {
            this.moTypeKeysToRemove.remove(new Integer(n));
        }
        return string;
    }

    public synchronized int lookup(String string) {
        Assert.cppAssert((Object)string, (String)"MoTypeLookup.lookup moTypeName");
        Integer n = (Integer)this.moTypes.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this.createNewEntry(string);
        this.moTypes.put(string, new Integer(n2));
        this.moTypeKeys.put(new Integer(n2), string);
        return n2;
    }

    public synchronized String convertToShortLDNFormat(String string) {
        StringBuffer stringBuffer = new StringBuffer(20);
        LDNStringHandler lDNStringHandler = new LDNStringHandler(string);
        String[] stringArray = lDNStringHandler.nextSubstring();
        while (stringArray != null) {
            int n = this.lookup(stringArray[0]);
            stringBuffer.append(n);
            stringBuffer.append(stringArray[1]);
            stringArray = lDNStringHandler.nextSubstring();
        }
        return stringBuffer.toString();
    }

    public synchronized String convertToLDN(String string) {
        StringBuffer stringBuffer = new StringBuffer(60);
        LDNStringHandler lDNStringHandler = new LDNStringHandler(string);
        String[] stringArray = lDNStringHandler.nextSubstring();
        while (stringArray != null) {
            String string2 = null;
            try {
                string2 = this.lookup(Integer.parseInt(stringArray[0]));
            }
            catch (NumberFormatException numberFormatException) {
                Assert.cppAssert((boolean)false, (String)("MoTypeLookup convertToLDN() exception :" + numberFormatException));
            }
            stringBuffer.append(string2);
            stringBuffer.append(stringArray[1]);
            stringArray = lDNStringHandler.nextSubstring();
        }
        return stringBuffer.toString();
    }

    private MoTypeLookup() {
        MoTypeStorage moTypeStorage = null;
        int[] nArray = null;
        try {
            moTypeStorage = MoTypeStorage.instance();
            moTypeStorage.connectToDatabase();
            nArray = moTypeStorage.retrieveAllPrimaryKeys();
            for (int i = 0; i < nArray.length; ++i) {
                String string = moTypeStorage.retrieveRow(nArray[i]);
                this.moTypes.put(string, new Integer(nArray[i]));
                this.moTypeKeys.put(new Integer(nArray[i]), string);
                if (this.nextKey >= nArray[i]) continue;
                this.nextKey = nArray[i];
            }
            moTypeStorage.disconnectFromDatabase();
            this.moTypeKeysToRemove = (Hashtable)this.moTypeKeys.clone();
        }
        catch (DbAccessException dbAccessException) {
            Assert.cppAssert((boolean)false, (String)("MoTypeLookup MoTypeLookup() exception :" + (Object)((Object)dbAccessException)));
        }
    }

    private int createNewEntry(String string) {
        int n = ++this.nextKey;
        try {
            Control control = MoTypeLookup.createTransaction();
            MoTypeStorage moTypeStorage = MoTypeStorage.instance();
            moTypeStorage.createRow(control.getCoordinator().getTransactionID(), n, string);
            control.getTerminator().commit();
        }
        catch (DbAccessException dbAccessException) {
            Assert.cppAssert((boolean)false, (String)("MoTypeLookup createNewEntry() exception :" + (Object)((Object)dbAccessException)));
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Assert.cppAssert((boolean)false, (String)("MoTypeLookup createNewEntry() exception :" + (Object)((Object)transactionRolledBackException)));
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            Assert.cppAssert((boolean)false, (String)("MoTypeLookup createNewEntry() exception :" + (Object)((Object)inactiveTransactionException)));
        }
        return n;
    }

    private static Control createTransaction() throws TransactionRolledBackException, InactiveTransactionException {
        Control control = TransactionServiceImpl.instance().getTransactionFactory().create(600);
        Coordinator coordinator = control.getCoordinator();
        MessageLog.trace((int)5, (Class)MoTypeLookup.class, (String)("Cello_OMS txId = " + coordinator.getTransactionID() + ", timeout = 600 sec"));
        return control;
    }

    private static class LDNStringHandler {
        private String str;
        private int index = 0;
        private boolean eos = false;

        LDNStringHandler(String string) {
            this.str = string;
        }

        String[] nextSubstring() {
            if (this.eos) {
                return null;
            }
            int n = this.str.indexOf(61, this.index);
            String[] stringArray = new String[2];
            stringArray[0] = this.str.substring(this.index, n);
            int n2 = this.str.indexOf(44, this.index) + 1;
            if (n2 == 0) {
                this.eos = true;
                stringArray[1] = this.str.substring(n);
            } else {
                stringArray[1] = this.str.substring(n, n2);
            }
            this.index = n2;
            return stringArray;
        }
    }
}

