/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security;

import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerFactoryImpl;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ContextAwareMoFactory;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoAccessor;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.security.SecurityMo;
import se.ericsson.cello.security.TlsMoImpl;
import se.ericsson.cello.security.ipom_tls_mi;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class TlsMoFactory
implements ContextAwareMoFactory,
SingletonMoFactory {
    protected String identity = "1";
    protected ManagedObject tlsMo = null;
    protected InitialMaoContext initialMaoContext;
    protected FroProxy proxy = null;
    protected MaoFroIndicationHandler indicationHandler = null;

    public ManagedObject createMo(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        throw new MoCanNotBeCreatedException("Tls");
    }

    public void autoCreateMo(ManagedObject managedObject, String string, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkTransaction((Coordinator)coordinator);
        MoGenUtil.checkParent((ManagedObject)managedObject, (String)"Security");
        if (managedObject instanceof SecurityMo) {
            MoGenUtil.checkNoOfSiblings((ManagedObject)managedObject, (String)"Tls", (int)1);
        }
        MoGenUtil.checkIdentity((String)"Tls", (String)string);
        new TlsMoImpl(managedObject, (AttrList)new AttrListImpl(), string, coordinator, this.initialMaoContext, this.proxy, this.indicationHandler);
    }

    public ManagedObject recoverMo(MoData moData) throws MoNameAlreadyTakenException {
        this.tlsMo = new TlsMoImpl(moData, this.initialMaoContext, this.proxy, this.indicationHandler);
        return this.tlsMo;
    }

    public String getMoTypeName() {
        return "Tls";
    }

    public void registerFactory() {
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    protected TlsMoFactory(FroProxy froProxy) {
        this.proxy = froProxy;
        this.indicationHandler = MaoFroIndicationHandlerFactoryImpl.instance().create(ipom_tls_mi.class);
    }

    public void setMaoContext(InitialMaoContext initialMaoContext) {
        this.initialMaoContext = initialMaoContext;
    }

    public ManagedObject getMo() {
        if (this.tlsMo == null) {
            MoIterator moIterator = this.initialMaoContext.getMoAccessor().lookupType("Tls");
            if (moIterator == null || !moIterator.hasMoreElements()) {
                this.createMo(this.identity);
            } else {
                this.tlsMo = moIterator.nextMo();
            }
        }
        return this.tlsMo;
    }

    protected void createMo(String string) {
        try {
            MoAccessor moAccessor = this.initialMaoContext.getMoAccessor();
            MoIterator moIterator = moAccessor.lookupType("Security");
            if (moIterator != null && moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(120);
                Coordinator coordinator = control.getCoordinator();
                this.tlsMo = new TlsMoImpl(managedObject, (AttrList)new AttrListImpl(), string, coordinator, this.initialMaoContext, this.proxy, this.indicationHandler);
                control.getTerminator().commit();
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unable to create Tls");
            }
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Unable to create Tls", (Throwable)exception);
        }
    }
}

