/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.MediumAccessUnitMo;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.ipoam.EthIpv6AddressInfo;
import se.ericsson.cello.ipoam.EthernetLinkMoGen;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipoam.IpMoImpl;
import se.ericsson.cello.ipoam.IpValidationUtil;
import se.ericsson.cello.ipoam.Ipv4AddressInfo;
import se.ericsson.cello.ipoam.NetworkMask;
import se.ericsson.cello.ipoam.NodeIpAddressCarrier;
import se.ericsson.cello.ipoam.ipom_ethlink_mi;
import se.ericsson.cello.ipoam.suaccess.EthernetLinkMoSU_Access;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericMomDefinedEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.ValueNotFoundException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class EthernetLinkMoImpl
extends EthernetLinkMoGen
implements EthernetLinkMoSU_Access,
Reservable,
NodeIpAddressCarrier,
FroInfo {
    protected static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new ipom_ethlink_mi());
    private static final String BROADCASTADDR_CURRENT = "CURRENT_VALUE";
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1"};

    protected void validateIpv4Addresses(AttrList attrList, Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        for (int i = 0; i < structArray.length; ++i) {
            Struct struct = structArray[i];
            String string = (String)struct.getValue("ipAddress");
            Integer n = (Integer)struct.getValue("prefixLength");
            if (n == null) {
                throw new IllegalAttributeValueException("Null Value for prefixLength in Struct ipv4Addresses", "EthernetLink");
            }
            int n2 = n;
            MoGenUtil.checkIntegerAttribute((String)"prefixLength", (int)n2, (int)0, (int)30, (String)"EthernetLink");
            for (int j = 0; j < i; ++j) {
                if (!string.equals((String)structArray[j].getValue("ipAddress"))) continue;
                throw new ConfigurationMismatchException("The ipv4Address " + string + " is duplicated !!!", "EthernetLink");
            }
            IpValidationUtil.checkIpAdressUniqueness(this.getParent(), string, n2, this, "EthernetLink", coordinator);
            String string2 = (String)struct.getValue("broadcastAddress");
            if (!Ipv4AddressValidation.isIpv4((String)string2)) {
                throw new IpFormatException("The address " + string2 + " is not a valid IPv4 address");
            }
            Ipv4AddressValidation.validateIpv4((String)string2);
            if (string.equals(string2) || Ipv4AddressValidation.isMultiCastIpAddress((String)string)) {
                throw new IllegalAttributeValueException("ipaddress must not be broadcast address or multicast address", "EthernetLink");
            }
            EthernetLinkMoImpl.validateIpAddresses(n2, new IpAddress(string), new IpAddress(string2));
        }
    }

    protected void validateIpv4AddressesWithNodeInterfaceName(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        if ((structArray.length == 0 || ((String)structArray[0].getValue("ipAddress")).equals("") || Ipv4AddressValidation.isDefault((String)((String)structArray[0].getValue("ipAddress")))) && this.getInterfaceName(coordinator).equals(((IpMoImpl)this.getParent()).getNodeInterfaceName(coordinator))) {
            throw new ConfigurationMismatchException("The ipv4Address cannot be set to empty because Ip Mo (nodeInterfaceName) refers to EthernetLink !!!", "EthernetLink");
        }
    }

    protected void validateIpv6Addresses(AttrList attrList, Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        if (structArray.length == 0 ? this.getInterfaceName(coordinator).equals(((IpMoImpl)this.getParent()).getNodeIpv6InterfaceName(coordinator)) : (((String)structArray[0].getValue("ipAddress")).equals("") || ((String)structArray[0].getValue("ipAddress")).equals("::")) && this.getInterfaceName(coordinator).equals(((IpMoImpl)this.getParent()).getNodeIpv6InterfaceName(coordinator))) {
            throw new ConfigurationMismatchException("The ipv6Address cannot be set to empty because Ip Mo (nodeIpv6InterfaceName) refers to EthernetLink !!!", "EthernetLink");
        }
        for (int i = 0; i < structArray.length; ++i) {
            Struct struct = structArray[i];
            String string = (String)struct.getValue("ipAddress");
            Integer n = (Integer)struct.getValue("prefixLength");
            if (n == null) {
                throw new IllegalAttributeValueException("Null Value for prefixLength  in Struct ipv6Addresses", "EthernetLink");
            }
            int n2 = n;
            MoGenUtil.checkIntegerAttribute((String)"prefixLength", (int)n2, (int)1, (int)126, (String)"EthernetLink");
            if (!Ipv6AddressValidation.isIpv6((String)string)) {
                throw new IpFormatException("The address " + string + " is not a valid IPv6 address");
            }
            Ipv6AddressValidation.validateIpv6((String)string);
            if (Ipv6AddressValidation.isLoopBackIpv6Address((String)string)) {
                throw new IllegalAttributeValueException("Loopback ipAddress " + string + "  cannot be set, choose other ipAddress ", "EthernetLink");
            }
            for (int j = 0; j < i; ++j) {
                if (!string.equals((String)structArray[j].getValue("ipAddress"))) continue;
                throw new ConfigurationMismatchException("The ipv6Address " + string + " is duplicated !!!", "EthernetLink");
            }
        }
    }

    public EthernetLinkMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, attrList, maoFroIndicationHandler);
    }

    public EthernetLinkMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, froProxy, maoFroIndicationHandler);
    }

    public void actionAssignAllIpAddresses(String string, String string2, String string3, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!Ipv4AddressValidation.isIpv4((String)string)) {
            throw new IpFormatException("The address " + string + " is not a valid IPv4 address");
        }
        Ipv4AddressValidation.validateIpv4((String)string);
        if (Ipv4AddressValidation.isDefault((String)string)) {
            throw new IllegalAttributeValueException("IpAddress 0.0.0.0 cannot be set,choose other IpAddress", "EthernetLink");
        }
        String string4 = null;
        if (string3.equalsIgnoreCase(BROADCASTADDR_CURRENT)) {
            string4 = this.getBroadcastAddress(coordinator);
        } else {
            Ipv4AddressValidation.validateIpv4((String)string3);
            string4 = string3;
        }
        int n = NetworkMask.calculateIpV4Prefix(string2);
        MoGenUtil.checkIntegerAttribute((String)"subnetMask", (int)n, (int)0, (int)30, (String)"EthernetLink");
        Struct struct = Ipv4AddressInfo.createMomStruct(string, n, string4);
        ArrayList<Struct> arrayList = new ArrayList<Struct>();
        arrayList.add(struct);
        this.setIpv4Addresses(arrayList.toArray(new Struct[0]), coordinator);
        String[] stringArray = new String[]{"ipAddress", "subnetMask", "broadcastAddress"};
        Object[] objectArray = new Object[]{string, new Integer(n), string4};
        this.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public void actionDisablePersistent(Coordinator coordinator) throws MoAccessException {
        this.checkifNodeisIntegrated(coordinator);
        this.checkEthernetLinkConfiguration(coordinator);
        this.froProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 100, null);
    }

    private void checkifNodeisIntegrated(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType("Slot");
        if (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            int n = ((SlotMo)managedObject).getIntegratedHardware(coordinator);
            if (n != 1) {
                throw new OperationNotAllowedException("EthernetLink cannot be disabled as the node is not integrated", "EthernetLink");
            }
            return;
        }
    }

    private void checkEthernetLinkConfiguration(Coordinator coordinator) throws MoAccessException {
        IpMo ipMo = (IpMo)this.getParent();
        String string = ipMo.getNodeInterfaceName(coordinator);
        String string2 = ipMo.getNodeIpv6InterfaceName(coordinator);
        String string3 = (String)this.getAttribute("interfaceName", coordinator);
        if (string.equals(string3) && (string2.equals("") || string2.equals(string3))) {
            throw new OperationNotAllowedException("EthernetLink cannot be disabled as it is configured as node IP address.", "EthernetLink");
        }
    }

    protected Object handleGetBroadcastAddress(Map map, Coordinator coordinator) throws MoAccessException {
        ArrayParameter arrayParameter = (ArrayParameter)map.get("ipv4Addresses");
        if (arrayParameter.size() == 0) {
            return null;
        }
        Parameter parameter = arrayParameter.get(0);
        if (parameter instanceof StructParameter) {
            StructParameter structParameter = (StructParameter)parameter;
            Struct struct = Ipv4AddressInfo.toMomStruct(structParameter);
            Object object = struct.getValue("broadcastAddress");
            return object;
        }
        throw new ValueNotFoundException("Value not Found");
    }

    protected Object handleGetIpAddress(Map map, Coordinator coordinator) throws MoAccessException {
        ArrayParameter arrayParameter = (ArrayParameter)map.get("ipv4Addresses");
        if (arrayParameter.size() == 0) {
            return null;
        }
        Parameter parameter = arrayParameter.get(0);
        if (parameter instanceof StructParameter) {
            StructParameter structParameter = (StructParameter)parameter;
            Struct struct = Ipv4AddressInfo.toMomStruct(structParameter);
            Object object = struct.getValue("ipAddress");
            return object;
        }
        throw new ValueNotFoundException("Value not Found");
    }

    protected Object handleGetSubnetMask(Map map, Coordinator coordinator) throws MoAccessException {
        ArrayParameter arrayParameter = (ArrayParameter)map.get("ipv4Addresses");
        if (arrayParameter.size() == 0) {
            return null;
        }
        Parameter parameter = arrayParameter.get(0);
        if (parameter instanceof StructParameter) {
            StructParameter structParameter = (StructParameter)parameter;
            Struct struct = Ipv4AddressInfo.toMomStruct(structParameter);
            String string = this.calculateIpV4SubnetMask((Integer)struct.getValue("prefixLength")).toString();
            return string;
        }
        throw new ValueNotFoundException("Value not Found");
    }

    protected void handleSetBroadcastAddress(int n, Object[] objectArray, ArrayList arrayList, Coordinator coordinator) throws MoAccessException {
        if (!(objectArray[n] instanceof String)) {
            throw new WrongAttributeTypeException("broadcastAddress", "EthernetLink");
        }
        String string = (String)objectArray[n];
        String[] stringArray = new String[]{"ipAddress", "subnetMask"};
        Object[] objectArray2 = this.getAttributes(stringArray, coordinator);
        if (objectArray2[0] == null || objectArray2[1] == null) {
            throw new ConfigurationMismatchException("Cannot Set Broadcast without IpAddress and Subnetmask", "EthernetLink");
        }
        int n2 = NetworkMask.calculateIpV4Prefix(objectArray2[1].toString());
        Struct struct = Ipv4AddressInfo.createMomStruct(objectArray2[0].toString(), n2, string);
        ArrayList<Struct> arrayList2 = new ArrayList<Struct>();
        arrayList2.add(struct);
        this.setIpv4Addresses(arrayList2.toArray(new Struct[0]), coordinator);
        super.sendNotification("broadcastAddress", string, coordinator);
    }

    private void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender.instance().pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    public ManagedObject fetchActiveMau(SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        MediumAccessUnitMo mediumAccessUnitMo = null;
        MoIterator moIterator = MoRepository.instance().lookupType("MediumAccessUnit");
        while (moIterator != null && moIterator.hasMoreElements()) {
            mediumAccessUnitMo = (MediumAccessUnitMo)moIterator.nextElement();
            if (mediumAccessUnitMo.getFroId(coordinator) != signedIntParameter.getValue()) continue;
            return mediumAccessUnitMo;
        }
        return null;
    }

    public ManagedObject[] fetchAvailableMaus(ArrayParameter arrayParameter, Coordinator coordinator) throws MoAccessException {
        HashSet<MediumAccessUnitMo> hashSet = new HashSet<MediumAccessUnitMo>();
        MediumAccessUnitMo mediumAccessUnitMo = null;
        Iterator iterator = arrayParameter.iterator();
        while (iterator.hasNext()) {
            int n = ((SignedIntParameter)iterator.next()).getValue();
            MoIterator moIterator = MoRepository.instance().lookupType("MediumAccessUnit");
            while (moIterator != null && moIterator.hasMoreElements()) {
                mediumAccessUnitMo = (MediumAccessUnitMo)moIterator.nextElement();
                if (mediumAccessUnitMo.getFroId(coordinator) != n) continue;
                hashSet.add(mediumAccessUnitMo);
            }
        }
        return hashSet.toArray(new ManagedObject[0]);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String string = ((IpMoImpl)this.getParent()).getNodeInterfaceName(coordinator);
        String string2 = this.getInterfaceName(coordinator);
        if (string2.equals(string)) {
            throw new MoCanNotBeDeletedException(this + " cannot be deleted when its ipAddress is used as nodeIpAddress");
        }
        super.delete(coordinator);
    }

    static void validateIpAddresses(int n, IpAddress ipAddress, IpAddress ipAddress2) throws MoAccessException {
        IpAddress ipAddress3 = ipAddress.getSubnetAddress(n);
        IpAddress ipAddress4 = IpAddress.getDefaultIpAddress();
        if (!ipAddress2.equals((Object)ipAddress4)) {
            ipAddress2.validateIpAddrWithinSubnet(n, ipAddress3, "EthernetLink");
        }
    }

    private IpAddress calculateIpV4SubnetMask(int n) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"subnetMask", (int)n, (int)0, (int)30, (String)"EthernetLink");
        long l = 0xFFFFFFFFL;
        long l2 = 0L;
        l2 = l >>> n;
        return new IpAddress(l2 ^= 0xFFFFFFFFFFFFFFFFL);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("mtuSize");
            SignedIntParameter signedIntParameter2 = (SignedIntParameter)map.get("metric");
            StringParameter stringParameter = (StringParameter)map.get("macAddress");
            ArrayParameter arrayParameter = (ArrayParameter)map.get("ipv4Addresses");
            ArrayParameter arrayParameter2 = (ArrayParameter)map.get("ipv6Addresses");
            if (signedIntParameter != null) {
                super.sendNotification("mtuSize", new Integer(signedIntParameter.getValue()));
            }
            if (signedIntParameter2 != null) {
                super.sendNotification("metric", new Integer(signedIntParameter2.getValue()));
            }
            if (stringParameter != null) {
                super.sendNotification("macAddress", stringParameter.getValue());
            }
            if (arrayParameter != null) {
                super.sendNotification("ipv4Addresses", Ipv4AddressInfo.toMomStructs(arrayParameter));
            }
            if (arrayParameter2 != null) {
                super.sendNotification("ipv6Addresses", EthIpv6AddressInfo.toMomStructs(arrayParameter2));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not found");
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void eventRaised(MaoFroGenericMomDefinedEventInd maoFroGenericMomDefinedEventInd) {
        try {
            if (maoFroGenericMomDefinedEventInd.getEventId() == 5) {
                Map map = maoFroGenericMomDefinedEventInd.getParameters(DICTIONARY);
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("activeMau");
                String string = "";
                if (map != null && signedIntParameter != null) {
                    string = "The Active Client MAU LDN: " + this.fetchActiveMau(signedIntParameter, null);
                }
                AlarmManager.getReporter().reportEvent(maoFroGenericMomDefinedEventInd.getEventId(), (ManagedObject)this, "", string, null);
            } else {
                super.eventRaised(maoFroGenericMomDefinedEventInd);
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getIpv4Address(Coordinator coordinator) throws MoAccessException {
        Struct[] structArray = this.getIpv4Addresses(coordinator);
        if (structArray.length > 0) {
            return (String)structArray[0].getValue("ipAddress");
        }
        return null;
    }

    public String getIpv6Address(Coordinator coordinator) throws MoAccessException {
        Struct[] structArray = this.getIpv6Addresses(coordinator);
        if (structArray.length > 0) {
            return (String)structArray[0].getValue("ipAddress");
        }
        return null;
    }
}

