/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import [Lse.ericsson.cello.moframework.Struct;;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.configirpimpl.AsynchronousTxCollector;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipoam.IpHostIpv6AddressInfo;
import se.ericsson.cello.ipoam.IpHostLinkIpInterfaceBuildIF;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpInterfaceBuildIF;
import se.ericsson.cello.ipoam.IpMoImpl;
import se.ericsson.cello.ipoam.IpValidationUtil;
import se.ericsson.cello.ipoam.NodeIpAddressCarrier;
import se.ericsson.cello.ipoam.ipom_iphostlinkmi;
import se.ericsson.cello.ipoam.suaccess.IpHostLinkMoSU_Access;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.HostIpAddress;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.IpException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;

public class IpHostLinkMoImpl
extends CelloMao
implements IpHostLinkMo,
NodeIpAddressCarrier,
IpHostLinkMoSU_Access,
FroInfo {
    protected static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new ipom_iphostlinkmi());
    public static final String PIU_FRO_ID = "piuFroId";
    private static final int MAX_NO_IP_HOST_LINK = 2;
    private static final String EMPTY_STRING = "";
    private static final String AUTOCONFIGURATION_IP_ADDRESS = "0.0.0.0";
    private static final int MAX_NO_IPV4ADDRESSESS = 5;
    public static final String INTERFACE_TYPE = "interfaceType";
    public static final String CONF_MODE = "confMode";
    public static final String IPACCESSHOSTET_FROID = "ipAccessHostEtFroId";
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1"};
    private static final int MO_DATA_REVISION_70 = 7000;
    private static final int MO_DATA_REVISION_LATEST = 7000;
    private MoData moData;
    private MaoFroIndicationHandler indHandler;
    private FroProxy ipHostLinkProxy = null;

    public static synchronized IpHostLinkMo create(ManagedObject managedObject, AttrList attrList, String string, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, Coordinator coordinator) throws MoAccessException {
        Object object;
        Struct[] structArray;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Ip");
        MoAttributeValidator.checkIdentity((String)"IpHostLink", (String)string);
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"IpHostLink", (int)2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Class[] classArray = new Class[]{IpHostLinkIpInterfaceBuildIF.class};
        ManagedObject managedObject2 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipInterfaceMoRef", (AttrList)attrList, (boolean)true, (Class[])classArray, (String)"IpHostLink");
        SignedIntParameter signedIntParameter = new SignedIntParameter("ipInterfaceMoRef", ((IpHostLinkIpInterfaceBuildIF)managedObject2).getFroId(coordinator));
        arrayList.add(signedIntParameter);
        String[] stringArray = IpHostLinkMoImpl.checkAndGetIpv4Addresses(attrList);
        String string2 = MoAttributeValidator.checkAndGetStringAttribute((String)"ipAddress", (AttrList)attrList, (boolean)false, (String)EMPTY_STRING, (String)"IpHostLink");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[] stringArray2 = IpHostLinkMoImpl.createIpAddressArray(managedObject, string2, stringArray, managedObject2, coordinator);
        if (stringArray2.length > 0 && !stringArray2[0].equals(EMPTY_STRING)) {
            arrayList2.add(stringArray2[0]);
        }
        if ((structArray = (Struct[])MoGenUtil.checkAndGetAttributeType((String)"ipv6Addresses", (AttrList)attrList, (Class)Struct;.class, (String)"IpHostLink")) != null && structArray.length != 0) {
            structArray = IpHostLinkMoImpl.validateIpv6Addresses(structArray, managedObject2, coordinator);
            arrayList2.add((String)structArray[0].getValue("ipAddress"));
            arrayList.add(IpHostIpv6AddressInfo.createArrayParameter(structArray, "IpHostLink", "ipv6Addresses", 5));
        }
        if (!arrayList2.isEmpty()) {
            IpHostLinkMoImpl.checkIpAddressWithIpAccessHostEt(arrayList2, coordinator);
        }
        if (stringArray2.length != 0) {
            object = new ArrayParameter("ipv4Addresses");
            for (int i = 0; i < stringArray2.length; ++i) {
                object.add((Parameter)new StringParameter("ipv4Address", stringArray2[i], 15));
            }
            arrayList.add(object);
        }
        object = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)EMPTY_STRING, (String)"IpHostLink", (int)128, (int)0);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpHostLink");
        return new IpHostLinkMoImpl(managedObject, string, (String)object, managedObject2, stringArray2, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    private IpHostLinkMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, String[] stringArray, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "IpHostLink", string, coordinator);
        this.ipHostLinkProxy = froProxy;
        this.moData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.indHandler = maoFroIndicationHandler;
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        SignedIntParameter signedIntParameter = new SignedIntParameter(PIU_FRO_ID, ((IpHostLinkIpInterfaceBuildIF)managedObject2).getConnectedPiuFroId(coordinator));
        arrayList.add(signedIntParameter);
        if (stringArray != null && stringArray.length > 0) {
            this.validateIpv4AddressArray(stringArray, managedObject2, coordinator);
        }
        SignedIntParameter signedIntParameter2 = new SignedIntParameter(INTERFACE_TYPE, ((IpHostLinkIpInterfaceBuildIF)managedObject2).getFroType(coordinator));
        arrayList.add(signedIntParameter2);
        int n = 0;
        if (managedObject2 instanceof VpnInterfaceBuildIF) {
            n = ((VpnInterfaceBuildIF)managedObject2).getConfigurationMode(coordinator);
        } else if (managedObject2 instanceof IpInterfaceMo && (n = ((IpInterfaceMo)managedObject2).getConfigurationMode(coordinator)) == 1) {
            n = 2;
        }
        arrayList.add(new SignedIntParameter(CONF_MODE, n));
        FroData froData = this.ipHostLinkProxy.create(coordinator, (Collection)arrayList);
        int n2 = froData.getFroId();
        this.moData.registerPersistentAttr((Attribute)new ReferenceAttribute("ipInterfaceMoRef", false, managedObject2));
        this.moData.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.moData.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n2));
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.getFroId(coordinator));
        this.moData.setRevision(7000);
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpHostLinkMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.moData = moData;
        this.ipHostLinkProxy = froProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.moData, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(7000);
        moDataRecoveryHelper.assertAttribute("ipInterfaceMoRef");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        this.indHandler = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.moData.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.checkNodeIpAddressAtDelete(coordinator);
        ((Reservable)this.getIpInterfaceMoRef(coordinator)).release((ManagedObject)this, coordinator);
        this.ipHostLinkProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.moData.delete(coordinator);
    }

    private void checkNodeIpAddressAtDelete(Coordinator coordinator) throws MoAccessException {
        String string = ((IpMoImpl)this.getParent()).getNodeInterfaceName(coordinator);
        String string2 = ((IpMoImpl)this.getParent()).getNodeIpv6InterfaceName(coordinator);
        String string3 = this.getInterfaceName(coordinator);
        if (string3.equals(string) || string3.equals(string2)) {
            String string4 = ((IpMoImpl)this.getParent()).getNodeIpAddress(coordinator);
            String string5 = ((IpMoImpl)this.getParent()).getNodeIpv6Address(coordinator);
            Struct[] structArray = (Struct[])this.getAttribute("ipv6Addresses", coordinator);
            String string6 = EMPTY_STRING;
            if (structArray.length > 0) {
                string6 = (String)structArray[0].getValue("ipAddress");
            }
            if (!this.getIpAddress(coordinator).equals(EMPTY_STRING) && this.getIpAddress(coordinator).equals(string4)) {
                throw new MoCanNotBeDeletedException(this + " cannot be deleted when its ipAddress is used as nodeIpAddress, nodeIpAddress: " + string4);
            }
            if (!string6.equals(EMPTY_STRING) && string6.equals(string5)) {
                throw new MoCanNotBeDeletedException(this + " cannot be deleted when its ipAddress is used as nodeIpv6Address, nodeIpv6Address: " + string5);
            }
        }
    }

    private static void checkIpAddressWithIpAccessHostEt(List list, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType("IpAccessHostEt");
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            String string = ((IpAccessHostEtMo)managedObject).getIpAddress(coordinator);
            Iterator iterator = list.iterator();
            do {
                String string2;
                if (!IpAddressValidation.getIpAddress((String)(string2 = (String)iterator.next())).equals(IpAddressValidation.getIpAddress((String)string))) continue;
                throw new IllegalAttributeValueException("The IpAddress " + string2 + " is already using by IpAccessHostEt  MO,choose other value for IpAddress", "IpHostLink");
            } while (iterator.hasNext());
        }
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getInterfaceName(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("interfaceName", coordinator);
    }

    public String getIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ipAddress", coordinator);
    }

    public void setIpAddress(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAddress", string, coordinator);
    }

    public void setIpv4Addresses(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipv4Addresses", stringArray, coordinator);
    }

    public String[] getIpv4Addresses(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("ipv4Addresses", coordinator);
    }

    public void setIpv6Addresses(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipv6Addresses", structArray, coordinator);
    }

    public Struct[] getIpv6Addresses(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("ipv6Addresses", coordinator);
    }

    public ManagedObject getIpInterfaceMoRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipInterfaceMoRef", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getPmNoOfIfInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfInDiscards", coordinator);
    }

    public int getPmNoOfIfInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfInErrors", coordinator);
    }

    public int getPmNoOfIfInNUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfInNUcastPkts", coordinator);
    }

    public int getPmNoOfIfInUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfInUcastPkts", coordinator);
    }

    public int getPmNoOfIfOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfOutDiscards", coordinator);
    }

    public int getPmNoOfIfOutNUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfOutNUcastPkts", coordinator);
    }

    public int getPmNoOfIfOutUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmNoOfIfOutUcastPkts", coordinator);
    }

    public void actionAssignIpAddress(String string, int n, String string2, String string3, String string4, String string5, Coordinator coordinator) throws MoAccessException {
        HostIpAddress hostIpAddress;
        ManagedObject managedObject;
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        AsynchronousTxCollector asynchronousTxCollector = (AsynchronousTxCollector)ServiceLocatorFacade.getRepository().getService(AsynchronousTxCollector.class);
        if (asynchronousTxCollector != null) {
            asynchronousTxCollector.register(coordinator);
        }
        if ((managedObject = this.getIpInterfaceMoRef(coordinator)) instanceof IpInterfaceBuildIF && ((IpInterfaceMo)managedObject).getConfigurationMode(coordinator) == 0) {
            HostIpAddress hostIpAddress2 = null;
            if (!string.equals(EMPTY_STRING)) {
                hostIpAddress2 = new HostIpAddress(string, n);
            }
            hostIpAddress = new HostIpAddress(string2, n);
            if (!string.equals(AUTOCONFIGURATION_IP_ADDRESS) && !string.equals(EMPTY_STRING)) {
                IpAddress ipAddress = hostIpAddress.getSubnetAddress(n);
                hostIpAddress2.validateIpAddrWithinSubnet(n, ipAddress, "IpHostLink");
            }
        } else {
            throw new OperationNotAllowedException("Action actionAssignIpAddress is only allowed when IpHostLink refers to a IpInterface which has attribute configurationMode set to MANUAL:  ", "IpHostLink");
        }
        ((IpInterfaceBuildIF)this.getIpInterfaceMoRef(coordinator)).helpAssignIpAddress(n, hostIpAddress, new HostIpAddress(string3, n), new HostIpAddress(string4, n), new HostIpAddress(string5, n), this, coordinator);
        this.setAttribute("ipAddress", string, coordinator);
    }

    public void actionAssignIpAddress2(String string, int n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject;
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        AsynchronousTxCollector asynchronousTxCollector = (AsynchronousTxCollector)ServiceLocatorFacade.getRepository().getService(AsynchronousTxCollector.class);
        if (asynchronousTxCollector != null) {
            asynchronousTxCollector.register(coordinator);
        }
        if ((managedObject = this.getIpInterfaceMoRef(coordinator)).getType().equals("VpnInterface")) {
            int n2 = IpHostLinkMoImpl.getVpnInterfaceConfMode(managedObject, coordinator);
            int n3 = IpHostLinkMoImpl.getVpnInterfaceIpVersion(managedObject, coordinator);
            if (n2 == 1) {
                throw new OperationNotAllowedException("IpHostLink refers to a VpnInterface with configurationMode IKE. ", "IpHostLink");
            }
            if (Ipv6AddressValidation.isIpv6((String)string)) {
                if (n2 == 0 && n3 != 1) {
                    throw new IllegalAttributeValueException("Ipv6 addresses are only allowed when the referenced VpnInterface configurationMode is MANUAL and ipVersion is IP_V6", "IpHostLink");
                }
                Struct[] structArray = new Struct[]{IpHostIpv6AddressInfo.getIpv6AddresInfoStruct(string, 128)};
                structArray = IpHostLinkMoImpl.validateIpv6Addresses(structArray, managedObject, coordinator);
                this.validateIpv6AddressesWithNodeIpv6InterfaceName(structArray, managedObject, coordinator);
                this.setAttribute("ipv6Addresses", structArray, coordinator);
            } else {
                IpAddress ipAddress = new IpAddress(string);
                int n4 = 32;
                if (n2 == 0 && n3 != 0) {
                    throw new IllegalAttributeValueException("Ipv4 addresses are only allowed when the referenced VpnInterface configurationMode is MANUAL and ipVersion is IP_V4", "IpHostLink");
                }
                if (string.equals(AUTOCONFIGURATION_IP_ADDRESS)) {
                    throw new OperationNotAllowedException("IpAddress cannot be set to 0.0.0.0 when IpHostLink refers to a VpnInterface", "IpHostLink");
                }
                IpAddress ipAddress2 = ipAddress.getSubnetAddress(n4);
                ipAddress.validateIpAddrWithinSubnet(n4, ipAddress2, "IpHostLink");
                ((VpnInterfaceBuildIF)this.getIpInterfaceMoRef(coordinator)).helpAssignVpnAddress(n4, new IpAddress(string), coordinator);
                this.setAttribute("ipAddress", string, coordinator);
            }
        } else {
            throw new OperationNotAllowedException("Only allowed when IpHostLink refers to a VpnInterface", "IpHostLink");
        }
    }

    private static int getVpnInterfaceConfMode(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (managedObject.getType().equalsIgnoreCase("VpnInterface")) {
            n = ((VpnInterfaceBuildIF)managedObject).getConfigurationMode(coordinator);
        }
        return n;
    }

    private static int getVpnInterfaceIpVersion(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (managedObject.getType().equalsIgnoreCase("VpnInterface")) {
            n = ((VpnInterfaceBuildIF)managedObject).getIpVersion(coordinator);
        }
        return n;
    }

    private boolean isAttachedToVpnIf(ManagedObject managedObject) throws MoAccessException {
        return managedObject instanceof VpnInterfaceBuildIF;
    }

    private boolean isConfModeIKE(int n) throws MoAccessException {
        return n == 1;
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        String[] stringArray2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3;
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.moData.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.moData.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("interfaceName")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (StringParameter)map.get("interfaceName");
                objectArray[i] = signedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress")) {
                signedIntParameter = (ArrayParameter)(map = this.getAttrFromRes(map, coordinator)).get("ipv4Addresses");
                if (signedIntParameter.size() > 0) {
                    stringArray3 = signedIntParameter.get(0);
                    objectArray[i] = ((StringParameter)stringArray3).getValue();
                    continue;
                }
                objectArray[i] = EMPTY_STRING;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipInterfaceMoRef")) {
                objectArray[i] = ((ReferenceAttribute)this.moData.getAttribute("ipInterfaceMoRef")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipv4Addresses")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (ArrayParameter)map.get("ipv4Addresses");
                stringArray3 = new String[signedIntParameter.size()];
                for (int j = 0; j < stringArray3.length; ++j) {
                    StringParameter stringParameter = (StringParameter)signedIntParameter.get(j);
                    stringArray3[j] = stringParameter.getValue();
                }
                objectArray[i] = stringArray3;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipv6Addresses")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (ArrayParameter)map.get("ipv6Addresses");
                objectArray[i] = IpHostIpv6AddressInfo.getStructs((ArrayParameter)signedIntParameter);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = stringArray2 = this.helpGetCurrentPmRegister(coordinator, stringArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfInDiscards")) {
                stringArray2 = this.helpGetCurrentPmRegister(coordinator, stringArray2);
                objectArray[i] = this.helpGetPmValue("pmNoOfIfInDiscards", stringArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfInErrors")) {
                stringArray2 = this.helpGetCurrentPmRegister(coordinator, stringArray2);
                objectArray[i] = this.helpGetPmValue("pmNoOfIfInErrors", stringArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfInNUcastPkts")) {
                stringArray2 = this.helpGetCurrentPmRegister(coordinator, stringArray2);
                objectArray[i] = this.helpGetPmValue("pmNoOfIfInNUcastPkts", stringArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfInUcastPkts")) {
                stringArray2 = this.helpGetCurrentPmRegister(coordinator, stringArray2);
                objectArray[i] = this.helpGetPmValue("pmNoOfIfInUcastPkts", stringArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfOutDiscards")) {
                stringArray2 = this.helpGetCurrentPmRegister(coordinator, stringArray2);
                objectArray[i] = this.helpGetPmValue("pmNoOfIfOutDiscards", stringArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfOutNUcastPkts")) {
                stringArray2 = this.helpGetCurrentPmRegister(coordinator, stringArray2);
                objectArray[i] = this.helpGetPmValue("pmNoOfIfOutNUcastPkts", stringArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmNoOfIfOutUcastPkts")) {
                stringArray2 = this.helpGetCurrentPmRegister(coordinator, stringArray2);
                objectArray[i] = this.helpGetPmValue("pmNoOfIfOutUcastPkts", stringArray2);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpHostLink");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<ArrayParameter> arrayList = new ArrayList<ArrayParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayParameter arrayParameter;
            Object object;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpHostLink");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpHostLink", (int)128, (int)0);
                ((StringAttribute)this.moData.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipv6Addresses")) {
                if (!(objectArray[i] instanceof Struct[])) {
                    throw new WrongAttributeTypeException("ipv6Addresses", "IpHostLink");
                }
                object = (Struct[])objectArray[i];
                if (((Struct[])(object = IpHostLinkMoImpl.validateIpv6Addresses(object, this.getIpInterfaceMoRef(coordinator), coordinator))).length > 0) {
                    arrayParameter = new ArrayList();
                    arrayParameter.add((String)object[0].getValue("ipAddress"));
                    IpHostLinkMoImpl.checkIpAddressWithIpAccessHostEt(arrayParameter, coordinator);
                }
                this.validateIpv6AddressesWithNodeIpv6InterfaceName((Struct[])object, this.getIpInterfaceMoRef(coordinator), coordinator);
                arrayList.add(IpHostIpv6AddressInfo.createArrayParameter(object, "IpHostLink", "ipv6Addresses", 5));
                this.sendNotification("ipv6Addresses", object, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipv4Addresses")) {
                if (!(objectArray[i] instanceof String[])) {
                    throw new WrongAttributeTypeException("ipv4Addresses", "IpHostLink");
                }
                object = (String[])objectArray[i];
                this.validateIpv4AddressesWithNodeInterfaceName((String[])object, coordinator);
                this.validateIpv4AddressArray((String[])object, this.getIpInterfaceMoRef(coordinator), coordinator);
                if (((Struct[])object).length != 0) {
                    IpValidationUtil.checkIpAdressUniqueness(this.getParent(), (String)object[0], this.getIpInterfaceMoRef(coordinator), coordinator, this, "IpHostLink");
                    if (!object[0].equals(EMPTY_STRING)) {
                        arrayParameter = new ArrayList();
                        arrayParameter.add(object[0]);
                        IpHostLinkMoImpl.checkIpAddressWithIpAccessHostEt((List)arrayParameter, coordinator);
                    }
                    arrayParameter = new ArrayParameter("ipv4Addresses");
                    for (int j = 0; j < ((Struct[])object).length; ++j) {
                        arrayParameter.add((Parameter)new StringParameter("ipv4Address", (String)object[j], 15));
                    }
                    arrayList.add(arrayParameter);
                    this.sendNotification("ipv4Addresses", object, coordinator);
                    continue;
                }
                throw new IllegalAttributeValueException("The given value is not valid .", "IpHostLink");
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("ipAddress", "IpHostLink");
                }
                object = (String)objectArray[i];
                this.setIpv4Addresses(new String[]{object}, coordinator);
                this.sendNotification("ipAddress", object, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpHostLink");
        }
        if (arrayList.size() > 0) {
            this.ipHostLinkProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("froId", coordinator);
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.ipHostLinkProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    private String[] helpGetCurrentPmRegister(Coordinator coordinator, String[] stringArray) throws MoAccessException {
        if (stringArray == null) {
            stringArray = this.getCurrentPmRegister(coordinator);
        }
        return stringArray;
    }

    private Integer helpGetPmValue(String string, String[] stringArray) throws NoSuchAttributeException {
        return new Integer(super.getPmIntAttributeValue(string, stringArray));
    }

    public static String[] checkAndGetIpv4Addresses(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("ipv4Addresses");
        if (n == -1) {
            return new String[0];
        }
        if (attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException("ipv4Addresses", "IpHostLink");
        }
        if (!(attrList.getValue(n) instanceof String[])) {
            throw new WrongAttributeTypeException("ipv4Addresses", "IpHostLink");
        }
        String[] stringArray = (String[])attrList.getValue(n);
        attrList.removeElementAt(n);
        return stringArray;
    }

    private void validateIpv4AddressesWithNodeInterfaceName(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        if (this.getInterfaceName(coordinator).equals(((IpMoImpl)this.getParent()).getNodeInterfaceName(coordinator))) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!Ipv4AddressValidation.isDefault((String)stringArray[i])) continue;
                bl = true;
            }
            if (stringArray.length == 0 || stringArray[0].equals(EMPTY_STRING) || bl) {
                throw new ConfigurationMismatchException("The ipv4Address cannot be set to empty because Ip Mo (nodeInterfaceName) refers to IpHostLink !!!", "IpHostLink");
            }
        }
    }

    private void validateIpv4AddressArray(String[] stringArray, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (stringArray.length > 0 && managedObject instanceof Ipv6InterfaceMo) {
            throw new WrongAttributeTypeException("If an IpV4Address is set the ipInterfaceRef must be of type IpInterface or VpnInterface", "IpHostLink");
        }
        if (stringArray.length > 5) {
            throw new ConfigurationMismatchException("Cannot create IpHostLink with more than 5 elements of Ipv4Addresses Array", "IpHostLink");
        }
        if (this.isAttachedToVpnIf(managedObject)) {
            if (this.isConfModeIKE(((VpnInterfaceBuildIF)managedObject).getConfigurationMode(coordinator))) {
                throw new OperationNotAllowedException("Setting an IPv4 address is only allowed when IpHostLink refers to a VpnInterface with configurationMode MANUAL", "IpHostLink");
            }
            if (stringArray.length > 1) {
                throw new IllegalAttributeValueException("Not allowed to set more than 1 address when IpHostLink refers to VpnInterface", "IpHostLink");
            }
            int n = IpHostLinkMoImpl.getVpnInterfaceConfMode(managedObject, coordinator);
            int n2 = IpHostLinkMoImpl.getVpnInterfaceIpVersion(managedObject, coordinator);
            if (n == 0 && n2 != 0 && stringArray.length > 0) {
                throw new IllegalAttributeValueException("Ipv4 addresses are only allowed when the referenced VpnInterface configurationMode is MANUAL and ipVersion is IP_V4", "IpHostLink");
            }
        } else if (managedObject instanceof IpInterfaceBuildIF && ((IpInterfaceMo)managedObject).getConfigurationMode(coordinator) == 1) {
            throw new OperationNotAllowedException("ipv4Addresses attribute cannot be set, if the configuration mode on the IpInterface MO is set to DHCP", "IpHostLink");
        }
        this.validateIPv4Addresses(stringArray, managedObject, coordinator);
    }

    private void validateIPv4Addresses(String[] stringArray, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException, OperationNotAllowedException, ConfigurationMismatchException, IpFormatException, IpException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(AUTOCONFIGURATION_IP_ADDRESS)) {
                ManagedObject[] managedObjectArray = null;
                if (managedObject instanceof IpInterfaceBuildIF) {
                    managedObjectArray = ((IpInterfaceBuildIF)managedObject).getReservedBy(coordinator);
                    if (managedObjectArray.length != 1) {
                        throw new ValueOutOfRangeException("ipAddress", "IpHostLink", "Value '0.0.0.0' not allowed when referenced IpInterface MO is reserved by several hosts");
                    }
                    if (managedObjectArray[0].equals(this)) continue;
                    throw new ValueOutOfRangeException("ipAddress", "IpHostLink", "Value '0.0.0.0' not allowed when referenced IpInterface MO is reserved by another host. Currently reserved by: " + managedObjectArray[0]);
                }
                if (!(managedObject instanceof VpnInterfaceBuildIF)) continue;
                throw new OperationNotAllowedException("IpHostLink Mo tied with VpnInterface cannot be created since ipAddress is set to 0.0.0.0", "IpHostLink");
            }
            if (stringArray[i].equals(EMPTY_STRING)) {
                hashSet.add(stringArray[i]);
                continue;
            }
            if (hashSet.contains(stringArray[i])) {
                throw new ConfigurationMismatchException("Duplicate ipAddress " + stringArray[i], "IpHostLink");
            }
            hashSet.add(stringArray[i]);
            if (!(managedObject instanceof IpInterfaceBuildIF)) continue;
            int n = ((IpInterfaceBuildIF)managedObject).getNetworkPrefixLength(coordinator);
            HostIpAddress hostIpAddress = new HostIpAddress(stringArray[i], n);
            ((IpInterfaceBuildIF)managedObject).checkIfIpAddressInSubnet((IpAddress)hostIpAddress, coordinator);
        }
    }

    private static String[] createIpAddressArray(ManagedObject managedObject, String string, String[] stringArray, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (stringArray.length == 0) {
            if (string.equals(EMPTY_STRING)) {
                return new String[0];
            }
            IpValidationUtil.checkIpAdressUniqueness(managedObject, string, managedObject2, coordinator, null, "IpHostLink");
            return new String[]{string};
        }
        if (string.equals(EMPTY_STRING)) {
            IpValidationUtil.checkIpAdressUniqueness(managedObject, stringArray[0], managedObject2, coordinator, null, "IpHostLink");
            return stringArray;
        }
        throw new ConfigurationMismatchException("It is not allowed to configure both ipAddress and ipv4Addresses", "IpHostLink");
    }

    private static Struct[] validateIpv6Addresses(Struct[] structArray, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n = IpHostLinkMoImpl.getVpnInterfaceConfMode(managedObject, coordinator);
        if (!managedObject.getType().equals("Ipv6Interface") && !managedObject.getType().equals("VpnInterface")) {
            throw new WrongAttributeTypeException("IpV6Address can only be set if the ipInterfaceRef refers to a Ipv6Interface or VpnInterface", "IpHostLink");
        }
        if (managedObject.getType().equals("VpnInterface")) {
            if (n == 1) {
                throw new OperationNotAllowedException("IpHostLink refers to a VpnInterface with configurationMode IKE. ", "IpHostLink");
            }
            if (structArray.length > 1) {
                throw new IllegalAttributeValueException("Not allowed to set more than 1 address when IpHostLink refers to VpnInterface", "IpHostLink");
            }
            int n2 = IpHostLinkMoImpl.getVpnInterfaceIpVersion(managedObject, coordinator);
            if (n == 0 && n2 != 1 && structArray.length > 0) {
                throw new IllegalAttributeValueException("Ipv6 addresses are only allowed when the referenced VpnInterface configurationMode is MANUAL and ipVersion is IP_V6", "IpHostLink");
            }
        }
        Struct[] structArray2 = null;
        if (structArray != null) {
            structArray2 = new Struct[structArray.length];
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < structArray.length; ++i) {
                Struct struct = structArray[i];
                String string = (String)struct.getValue("ipAddress");
                structArray2[i] = structArray[i];
                if (!Ipv6AddressValidation.isValidIpv6Addres((String)string)) {
                    throw new IpFormatException("The address " + string + " is not a valid IPv6 address");
                }
                if (Ipv6AddressValidation.isLoopBackIpv6Address((String)string)) {
                    throw new IllegalAttributeValueException("Loopback ipAddress " + string + "  cannot be set, choose other ipAddress ", "IpHostLink");
                }
                Integer n3 = (Integer)struct.getValue("prefixLength");
                if (n3 == null) {
                    throw new IllegalAttributeValueException("Null Value for prefixLength in Struct + ipv6Addresses", "IpHostLink");
                }
                int n4 = n3;
                if (managedObject.getType().equals("VpnInterface")) {
                    structArray2[i] = IpHostIpv6AddressInfo.getIpv6AddresInfoStruct(string, 128);
                    MoGenUtil.checkIntegerAttribute((String)"prefixLength", (int)n4, (int)1, (int)128, (String)"IpHostLink");
                } else {
                    MoGenUtil.checkIntegerAttribute((String)"prefixLength", (int)n4, (int)1, (int)126, (String)"IpHostLink");
                }
                if (hashSet.contains(string)) {
                    throw new ConfigurationMismatchException("Duplicate ipAddress" + string, "IpHostLink");
                }
                hashSet.add(string);
            }
        }
        return structArray2;
    }

    private void validateIpv6AddressesWithNodeIpv6InterfaceName(Struct[] structArray, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (structArray != null && (structArray.length == 0 || Ipv6AddressValidation.isUnspecifiedIpv6((String)((String)structArray[0].getValue("ipAddress")))) && this.getInterfaceName(coordinator).equals(((IpMoImpl)this.getParent()).getNodeIpv6InterfaceName(coordinator))) {
            throw new ConfigurationMismatchException("The ipv6Address cannot be set to empty because IpMo (nodeIpv6InterfaceName) refers to IpHostLink !!!", "IpHostLink");
        }
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            ArrayParameter arrayParameter = (ArrayParameter)map.get("ipv4Addresses");
            ArrayParameter arrayParameter2 = (ArrayParameter)map.get("ipv6Addresses");
            if (arrayParameter != null) {
                String[] stringArray = new String[arrayParameter.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    StringParameter stringParameter = (StringParameter)arrayParameter.get(i);
                    stringArray[i] = stringParameter.getValue();
                }
                this.sendNotification("ipv4Addresses", stringArray);
            }
            if (arrayParameter2 != null) {
                this.sendNotification("ipv6Addresses", IpHostIpv6AddressInfo.getStructs(arrayParameter2));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not found");
        }
    }

    private void sendNotification(String string, Object object) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getIpv4Address(Coordinator coordinator) throws MoAccessException {
        String[] stringArray = this.getIpv4Addresses(coordinator);
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String getIpv6Address(Coordinator coordinator) throws MoAccessException {
        Struct[] structArray = this.getIpv6Addresses(coordinator);
        if (structArray.length > 0) {
            return (String)structArray[0].getValue("ipAddress");
        }
        return null;
    }

    public String getType() {
        return "IpHostLink";
    }
}

