/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import se.ericsson.cello.mao.InetAddressUtil;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;

public class NetworkMask {
    public static int calculateIpV4Prefix(String string) throws IpFormatException {
        int n = 0;
        if (NetworkMask.isValidInt(string)) {
            n = Integer.parseInt(string);
        } else {
            IpAddress ipAddress = new IpAddress(string);
            int n2 = ipAddress.toInt();
            boolean bl = false;
            for (int i = 32; i > 0; --i) {
                if (bl) {
                    if ((n2 & 1) != 1) {
                        throw new IpFormatException(string + " is not a valid subnet mask");
                    }
                } else if ((n2 & 1) == 1) {
                    bl = true;
                    n = i;
                }
                n2 >>= 1;
            }
        }
        return n;
    }

    public static IpAddress calculateIpV4SubnetMask(int n) throws IpException, IpFormatException {
        if (n < 0 || n > 32) {
            throw new IpException("Illegal value for networkPrefix. Allowed value is [0,32]. Value is: " + n);
        }
        long l = 0xFFFFFFFFL;
        long l2 = 0L;
        l2 = l >>> n;
        return new IpAddress(l2 ^= 0xFFFFFFFFFFFFFFFFL);
    }

    public static int calculateIpV6Prefix(String string) throws IpFormatException, ValueOutOfRangeException {
        int n = 0;
        if (!NetworkMask.isValidIpv6Int(string)) {
            throw new ValueOutOfRangeException("networkMask is not a valid subnet mask, needs to be networkPrefixLength for Ipv6", "IpRoutingTable");
        }
        n = Integer.parseInt(string);
        return n;
    }

    private static boolean isValidInt(String string) throws IpFormatException {
        try {
            int n = Integer.parseInt(string);
            if (n < 0 || n > 32) {
                throw new IpFormatException(string + " is not a valid network prefix");
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static boolean isValidIpv6Int(String string) throws IpFormatException {
        try {
            int n = Integer.parseInt(string);
            if (n < 0 || n > 128) {
                throw new IpFormatException(string + " is not a valid network prefix");
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static String getNetworkPrefixLength(String string) throws IpException, IpFormatException {
        byte[] byArray = InetAddressUtil.ipStringToBytes((String)string);
        if (byArray == null) {
            throw new IllegalArgumentException("Invalid netmask.");
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = 128;
            for (int j = 0; j < 8; ++j) {
                int n3 = byArray[i] & n2;
                if (n3 != 0) {
                    ++n;
                }
                n2 >>>= 1;
            }
        }
        return Integer.toString(n);
    }

    static boolean isNetworkMaskIpFormat(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n;
        }
        return n == 3;
    }
}

