/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractMap;
import edu.emory.mathcs.backport.java.util.NavigableMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentNavigableMap;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class ConcurrentSkipListMap
extends AbstractMap
implements ConcurrentNavigableMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8627078645895051609L;
    private static final Object BASE_HEADER = new Object();
    private volatile transient HeadIndex head;
    private final Comparator comparator;
    private transient int randomSeed;
    private transient KeySet keySet;
    private transient EntrySet entrySet;
    private transient Values values;
    private transient DescendingKeySet descendingKeySet;
    private transient DescendingEntrySet descendingEntrySet;
    private static final int EQ = 1;
    private static final int LT = 2;
    private static final int GT = 0;

    final void initialize() {
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.descendingEntrySet = null;
        this.descendingKeySet = null;
        this.randomSeed = (int)Utils.nanoTime() | 1;
        this.head = new HeadIndex(new Node(null, BASE_HEADER, null), null, null, 1);
    }

    private synchronized boolean casHead(HeadIndex headIndex, HeadIndex headIndex2) {
        if (this.head == headIndex) {
            this.head = headIndex2;
            return true;
        }
        return false;
    }

    private Comparable comparable(Object object) throws ClassCastException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.comparator != null) {
            return new ComparableUsingComparator(object, this.comparator);
        }
        return (Comparable)object;
    }

    int compare(Object object, Object object2) throws ClassCastException {
        Comparator comparator = this.comparator;
        if (comparator != null) {
            return comparator.compare(object, object2);
        }
        return ((Comparable)object).compareTo(object2);
    }

    boolean inHalfOpenRange(Object object, Object object2, Object object3) {
        if (object == null) {
            throw new NullPointerException();
        }
        return !(object2 != null && this.compare(object, object2) < 0 || object3 != null && this.compare(object, object3) >= 0);
    }

    boolean inOpenRange(Object object, Object object2, Object object3) {
        if (object == null) {
            throw new NullPointerException();
        }
        return !(object2 != null && this.compare(object, object2) < 0 || object3 != null && this.compare(object, object3) > 0);
    }

    private Node findPredecessor(Comparable comparable) {
        Index index;
        block0: while (true) {
            index = this.head;
            while (true) {
                Index index2;
                Index index3;
                if ((index3 = index.right) != null) {
                    if (index3.indexesDeletedNode()) {
                        if (!index.unlink(index3)) continue block0;
                        continue;
                    }
                    if (comparable.compareTo(index3.key) > 0) {
                        index = index3;
                        continue;
                    }
                }
                if ((index2 = index.down) == null) break block0;
                index = index2;
            }
            break;
        }
        return index.node;
    }

    /*
     * Unable to fully structure code
     */
    private Node findNode(Comparable var1_1) {
        block0: while (true) {
            var2_2 = this.findPredecessor(var1_1);
            var3_3 = var2_2.next;
            while (true) {
                if (var3_3 == null) {
                    return null;
                }
                var4_4 = var3_3.next;
                if (var3_3 != var2_2.next) continue block0;
                var5_5 = var3_3.value;
                if (var5_5 == null) {
                    var3_3.helpDelete(var2_2, var4_4);
                    continue block0;
                }
                if (var5_5 != var3_3 && var2_2.value != null) ** break;
                continue block0;
                var6_6 = var1_1.compareTo(var3_3.key);
                if (var6_6 < 0) {
                    return null;
                }
                if (var6_6 == 0) {
                    return var3_3;
                }
                var2_2 = var3_3;
                var3_3 = var4_4;
            }
            break;
        }
    }

    private Object doGet(Object object) {
        Comparable comparable = this.comparable(object);
        Object object2 = null;
        Index index = this.head;
        while (true) {
            Index index2;
            Object object3;
            Index index3;
            if ((index3 = index.right) != null && (object3 = index3.key) != null && object3 != object2) {
                int n2 = comparable.compareTo(object3);
                if (n2 > 0) {
                    index = index3;
                    continue;
                }
                if (n2 == 0) {
                    Object object4 = index3.node.value;
                    return object4 != null ? object4 : this.getUsingFindNode(comparable);
                }
                object2 = object3;
            }
            if ((index2 = index.down) == null) break;
            index = index2;
        }
        Node node = index.node.next;
        while (node != null) {
            Object object5 = node.key;
            if (object5 != null) {
                int n3 = comparable.compareTo(object5);
                if (n3 == 0) {
                    Object object6 = node.value;
                    return object6 != null ? object6 : this.getUsingFindNode(comparable);
                }
                if (n3 < 0) {
                    return null;
                }
            }
            node = node.next;
        }
        return null;
    }

    private Object getUsingFindNode(Comparable comparable) {
        Node node;
        Object object;
        do {
            if ((node = this.findNode(comparable)) != null) continue;
            return null;
        } while ((object = node.value) == null);
        return object;
    }

    private Object doPut(Object object, Object object2, boolean bl) {
        Node node;
        Comparable comparable = this.comparable(object);
        block0: while (true) {
            Node node2 = this.findPredecessor(comparable);
            Node node3 = node2.next;
            while (node3 != null) {
                node = node3.next;
                if (node3 != node2.next) continue block0;
                Object object3 = node3.value;
                if (object3 == null) {
                    node3.helpDelete(node2, node);
                    continue block0;
                }
                if (object3 == node3 || node2.value == null) continue block0;
                int n2 = comparable.compareTo(node3.key);
                if (n2 > 0) {
                    node2 = node3;
                    node3 = node;
                    continue;
                }
                if (n2 != 0) break;
                if (!bl && !node3.casValue(object3, object2)) continue block0;
                return object3;
            }
            if (node2.casNext(node3, node = new Node(object, object2, node3))) break;
        }
        int n3 = this.randomLevel();
        if (n3 > 0) {
            this.insertIndex(node, n3);
        }
        return null;
    }

    private int randomLevel() {
        int n2 = 0;
        int n3 = this.randomSeed;
        int n4 = n3 ^ n3 << 13;
        n4 ^= n4 >>> 17;
        this.randomSeed = n4 ^ n4 << 5;
        if (n3 < 0) {
            while ((n3 <<= 1) > 0) {
                ++n2;
            }
        }
        return n2;
    }

    private void insertIndex(Node node, int n2) {
        HeadIndex headIndex = this.head;
        int n3 = headIndex.level;
        if (n2 <= n3) {
            Index index = null;
            for (int i2 = 1; i2 <= n2; ++i2) {
                index = new Index(node, index, null);
            }
            this.addIndex(index, headIndex, n2);
        } else {
            int n4;
            HeadIndex headIndex2;
            Index[] indexArray;
            block7: {
                int n5;
                HeadIndex headIndex3;
                n2 = n3 + 1;
                indexArray = new Index[n2 + 1];
                Index index = null;
                for (int i3 = 1; i3 <= n2; ++i3) {
                    indexArray[i3] = index = new Index(node, index, null);
                }
                do {
                    headIndex2 = this.head;
                    n5 = headIndex2.level;
                    if (n2 <= n5) {
                        n4 = n2;
                        break block7;
                    }
                    headIndex3 = headIndex2;
                    Node node2 = headIndex2.node;
                    for (int i4 = n5 + 1; i4 <= n2; ++i4) {
                        headIndex3 = new HeadIndex(node2, headIndex3, indexArray[i4], i4);
                    }
                } while (!this.casHead(headIndex2, headIndex3));
                n4 = n5;
            }
            this.addIndex(indexArray[n4], headIndex2, n4);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void addIndex(Index var1_1, HeadIndex var2_2, int var3_3) {
        var4_4 = var3_3;
        var5_5 = this.comparable(var1_1.key);
        block0: while (true) {
            var6_6 /* !! */  = var2_2;
            var7_7 = var1_1;
            var8_8 = var2_2.level;
            while (true) {
                if ((var9_9 = var6_6 /* !! */ .right) != null) {
                    var10_10 = var5_5.compareTo(var9_9.key);
                    if (var9_9.indexesDeletedNode()) {
                        if (!var6_6 /* !! */ .unlink(var9_9)) continue block0;
                        continue;
                    }
                    if (var10_10 > 0) {
                        var6_6 /* !! */  = var9_9;
                        continue;
                    }
                }
                if (var8_8 == var4_4) {
                    if (var7_7.indexesDeletedNode()) {
                        this.findNode(var5_5);
                        return;
                    }
                    if (var6_6 /* !! */ .link(var9_9, var7_7)) ** break;
                    continue block0;
                    if (--var4_4 == 0) {
                        if (var7_7.indexesDeletedNode()) {
                            this.findNode(var5_5);
                        }
                        return;
                    }
                }
                if (var8_8 > var4_4 && var8_8 <= var3_3) {
                    var7_7 = var7_7.down;
                }
                var6_6 /* !! */  = var6_6 /* !! */ .down;
                --var8_8;
            }
            break;
        }
    }

    private Object doRemove(Object object, Object object2) {
        Object object3;
        Node node;
        Node node2;
        Node node3;
        Comparable comparable = this.comparable(object);
        block0: while (true) {
            node3 = this.findPredecessor(comparable);
            node2 = node3.next;
            while (true) {
                if (node2 == null) {
                    return null;
                }
                node = node2.next;
                if (node2 != node3.next) continue block0;
                object3 = node2.value;
                if (object3 == null) {
                    node2.helpDelete(node3, node);
                    continue block0;
                }
                if (object3 == node2 || node3.value == null) continue block0;
                int n2 = comparable.compareTo(node2.key);
                if (n2 < 0) {
                    return null;
                }
                if (n2 <= 0) break;
                node3 = node2;
                node2 = node;
            }
            if (object2 != null && !object2.equals(object3)) {
                return null;
            }
            if (node2.casValue(object3, null)) break;
        }
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findNode(comparable);
        } else {
            this.findPredecessor(comparable);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return object3;
    }

    private void tryReduceLevel() {
        HeadIndex headIndex;
        HeadIndex headIndex2;
        HeadIndex headIndex3 = this.head;
        if (headIndex3.level > 3 && (headIndex2 = (HeadIndex)headIndex3.down) != null && (headIndex = (HeadIndex)headIndex2.down) != null && headIndex.right == null && headIndex2.right == null && headIndex3.right == null && this.casHead(headIndex3, headIndex2) && headIndex3.right != null) {
            this.casHead(headIndex2, headIndex3);
        }
    }

    boolean removep(Object object) {
        return this.doRemove(object, null) != null;
    }

    Node findFirst() {
        while (true) {
            Node node = this.head.node;
            Node node2 = node.next;
            if (node2 == null) {
                return null;
            }
            if (node2.value != null) {
                return node2;
            }
            node2.helpDelete(node, node2.next);
        }
    }

    Object pollFirstKey() {
        Node node;
        Node node2;
        Node node3;
        while (true) {
            node3 = this.head.node;
            node2 = node3.next;
            if (node2 == null) {
                return null;
            }
            node = node2.next;
            if (node2 != node3.next) continue;
            Object object = node2.value;
            if (object == null) {
                node2.helpDelete(node3, node);
                continue;
            }
            if (node2.casValue(object, null)) break;
        }
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        return node2.key;
    }

    Map.Entry doRemoveFirstEntry() {
        Object object;
        Node node;
        Node node2;
        Node node3;
        while (true) {
            node3 = this.head.node;
            node2 = node3.next;
            if (node2 == null) {
                return null;
            }
            node = node2.next;
            if (node2 != node3.next) continue;
            object = node2.value;
            if (object == null) {
                node2.helpDelete(node3, node);
                continue;
            }
            if (node2.casValue(object, null)) break;
        }
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        return new AbstractMap.SimpleImmutableEntry(node2.key, object);
    }

    private void clearIndexToFirst() {
        block0: while (true) {
            Index index = this.head;
            do {
                Index index2;
                if ((index2 = index.right) != null && index2.indexesDeletedNode() && !index.unlink(index2)) continue block0;
            } while ((index = index.down) != null);
            break;
        }
        if (this.head.right == null) {
            this.tryReduceLevel();
        }
    }

    Node findLast() {
        Index index = this.head;
        while (true) {
            Index index2;
            if ((index2 = index.right) != null) {
                if (index2.indexesDeletedNode()) {
                    index.unlink(index2);
                    index = this.head;
                    continue;
                }
                index = index2;
                continue;
            }
            Index index3 = index.down;
            if (index3 != null) {
                index = index3;
                continue;
            }
            Node node = index.node;
            Node node2 = node.next;
            while (true) {
                if (node2 == null) {
                    return node.isBaseHeader() ? null : node;
                }
                Node node3 = node2.next;
                if (node2 != node.next) break;
                Object object = node2.value;
                if (object == null) {
                    node2.helpDelete(node, node3);
                    break;
                }
                if (object == node2 || node.value == null) break;
                node = node2;
                node2 = node3;
            }
            index = this.head;
        }
    }

    private Node findPredecessorOfLast() {
        Index index;
        block0: while (true) {
            index = this.head;
            while (true) {
                Index index2;
                Index index3;
                if ((index3 = index.right) != null) {
                    if (index3.indexesDeletedNode()) {
                        index.unlink(index3);
                        continue block0;
                    }
                    if (index3.node.next != null) {
                        index = index3;
                        continue;
                    }
                }
                if ((index2 = index.down) == null) break block0;
                index = index2;
            }
            break;
        }
        return index.node;
    }

    Object pollLastKey() {
        Node node;
        Node node2;
        Node node3;
        block0: while (true) {
            Object object;
            node3 = this.findPredecessorOfLast();
            node2 = node3.next;
            if (node2 == null) {
                if (!node3.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                node = node2.next;
                if (node2 != node3.next) continue block0;
                object = node2.value;
                if (object == null) {
                    node2.helpDelete(node3, node);
                    continue block0;
                }
                if (object == node2 || node3.value == null) continue block0;
                if (node == null) break;
                node3 = node2;
                node2 = node;
            }
            if (node2.casValue(object, null)) break;
        }
        Object object = node2.key;
        Comparable comparable = this.comparable(object);
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findNode(comparable);
        } else {
            this.findPredecessor(comparable);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return object;
    }

    Map.Entry doRemoveLastEntry() {
        Object object;
        Node node;
        Node node2;
        Node node3;
        block0: while (true) {
            node3 = this.findPredecessorOfLast();
            node2 = node3.next;
            if (node2 == null) {
                if (!node3.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                node = node2.next;
                if (node2 != node3.next) continue block0;
                object = node2.value;
                if (object == null) {
                    node2.helpDelete(node3, node);
                    continue block0;
                }
                if (object == node2 || node3.value == null) continue block0;
                if (node == null) break;
                node3 = node2;
                node2 = node;
            }
            if (node2.casValue(object, null)) break;
        }
        Object object2 = node2.key;
        Comparable comparable = this.comparable(object2);
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findNode(comparable);
        } else {
            this.findPredecessor(comparable);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return new AbstractMap.SimpleImmutableEntry(object2, object);
    }

    /*
     * Unable to fully structure code
     */
    Node findNear(Object var1_1, int var2_2) {
        var3_3 = this.comparable(var1_1);
        block0: while (true) {
            var4_4 = this.findPredecessor(var3_3);
            var5_5 = var4_4.next;
            while (true) {
                if (var5_5 == null) {
                    return (var2_2 & 2) == 0 || var4_4.isBaseHeader() != false ? null : var4_4;
                }
                var6_6 = var5_5.next;
                if (var5_5 != var4_4.next) continue block0;
                var7_7 = var5_5.value;
                if (var7_7 == null) {
                    var5_5.helpDelete(var4_4, var6_6);
                    continue block0;
                }
                if (var7_7 != var5_5 && var4_4.value != null) ** break;
                continue block0;
                var8_8 = var3_3.compareTo(var5_5.key);
                if (var8_8 == 0 && (var2_2 & 1) != 0 || var8_8 < 0 && (var2_2 & 2) == 0) {
                    return var5_5;
                }
                if (var8_8 <= 0 && (var2_2 & 2) != 0) {
                    return var4_4.isBaseHeader() != false ? null : var4_4;
                }
                var4_4 = var5_5;
                var5_5 = var6_6;
            }
            break;
        }
    }

    AbstractMap.SimpleImmutableEntry getNear(Object object, int n2) {
        Node node;
        AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
        do {
            if ((node = this.findNear(object, n2)) != null) continue;
            return null;
        } while ((simpleImmutableEntry = node.createSnapshot()) == null);
        return simpleImmutableEntry;
    }

    Node findCeiling(Object object) {
        return object == null ? this.findFirst() : this.findNear(object, 1);
    }

    Node findLower(Object object) {
        return object == null ? this.findLast() : this.findNear(object, 2);
    }

    Object getNearKey(Object object, int n2, Object object2, Object object3) {
        Object object4;
        Node node;
        Object object5;
        Object object6 = object;
        if ((n2 & 2) == 0 && this.compare(object6, object2) < 0) {
            object6 = object2;
            n2 |= 1;
        }
        do {
            if ((node = this.findNear(object6, n2)) == null || !this.inHalfOpenRange(node.key, object2, object3)) {
                return null;
            }
            object4 = node.key;
        } while ((object5 = node.getValidValue()) == null);
        return object4;
    }

    Map.Entry getNearEntry(Object object, int n2, Object object2, Object object3) {
        Object object4;
        Node node;
        Object object5;
        Object object6 = object;
        if ((n2 & 2) == 0 && this.compare(object6, object2) < 0) {
            object6 = object2;
            n2 |= 1;
        }
        do {
            if ((node = this.findNear(object6, n2)) == null || !this.inHalfOpenRange(node.key, object2, object3)) {
                return null;
            }
            object4 = node.key;
        } while ((object5 = node.getValidValue()) == null);
        return new AbstractMap.SimpleImmutableEntry(object4, object5);
    }

    Map.Entry removeFirstEntryOfSubrange(Object object, Object object2) {
        Object object3;
        Object object4;
        do {
            Node node;
            if ((node = this.findCeiling(object)) == null) {
                return null;
            }
            object3 = node.key;
            if (object2 == null || this.compare(object3, object2) < 0) continue;
            return null;
        } while ((object4 = this.doRemove(object3, null)) == null);
        return new AbstractMap.SimpleImmutableEntry(object3, object4);
    }

    Map.Entry removeLastEntryOfSubrange(Object object, Object object2) {
        Object object3;
        Object object4;
        do {
            Node node;
            if ((node = this.findLower(object2)) == null) {
                return null;
            }
            object3 = node.key;
            if (object == null || this.compare(object3, object) >= 0) continue;
            return null;
        } while ((object4 = this.doRemove(object3, null)) == null);
        return new AbstractMap.SimpleImmutableEntry(object3, object4);
    }

    public ConcurrentSkipListMap() {
        this.comparator = null;
        this.initialize();
    }

    public ConcurrentSkipListMap(Comparator comparator) {
        this.comparator = comparator;
        this.initialize();
    }

    public ConcurrentSkipListMap(Map map) {
        this.comparator = null;
        this.initialize();
        this.putAll(map);
    }

    public ConcurrentSkipListMap(SortedMap sortedMap) {
        this.comparator = sortedMap.comparator();
        this.initialize();
        this.buildFromSorted(sortedMap);
    }

    public Object clone() {
        ConcurrentSkipListMap concurrentSkipListMap = null;
        try {
            concurrentSkipListMap = (ConcurrentSkipListMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        concurrentSkipListMap.initialize();
        concurrentSkipListMap.buildFromSorted(this);
        return concurrentSkipListMap;
    }

    private void buildFromSorted(SortedMap sortedMap) {
        if (sortedMap == null) {
            throw new NullPointerException();
        }
        HeadIndex headIndex = this.head;
        Node node = headIndex.node;
        ArrayList<Index> arrayList = new ArrayList<Index>();
        for (int i2 = 0; i2 <= headIndex.level; ++i2) {
            arrayList.add(null);
        }
        Index index = headIndex;
        for (int i3 = headIndex.level; i3 > 0; --i3) {
            arrayList.set(i3, index);
            index = index.down;
        }
        Iterator iterator = sortedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Node node2;
            Map.Entry entry = iterator.next();
            int n2 = this.randomLevel();
            if (n2 > headIndex.level) {
                n2 = headIndex.level + 1;
            }
            Object k2 = entry.getKey();
            Object v = entry.getValue();
            if (k2 == null || v == null) {
                throw new NullPointerException();
            }
            node.next = node2 = new Node(k2, v, null);
            node = node2;
            if (n2 <= 0) continue;
            Index index2 = null;
            for (int i4 = 1; i4 <= n2; ++i4) {
                index2 = new Index(node2, index2, null);
                if (i4 > headIndex.level) {
                    headIndex = new HeadIndex(headIndex.node, headIndex, index2, i4);
                }
                if (i4 < arrayList.size()) {
                    ((Index)arrayList.get((int)i4)).right = index2;
                    arrayList.set(i4, index2);
                    continue;
                }
                arrayList.add(index2);
            }
        }
        this.head = headIndex;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Node node = this.findFirst();
        while (node != null) {
            Object object = node.getValidValue();
            if (object != null) {
                objectOutputStream.writeObject(node.key);
                objectOutputStream.writeObject(object);
            }
            node = node.next;
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.initialize();
        HeadIndex headIndex = this.head;
        Node node = headIndex.node;
        ArrayList<Index> arrayList = new ArrayList<Index>();
        for (int i2 = 0; i2 <= headIndex.level; ++i2) {
            arrayList.add(null);
        }
        Index index = headIndex;
        for (int i3 = headIndex.level; i3 > 0; --i3) {
            arrayList.set(i3, index);
            index = index.down;
        }
        while ((object = objectInputStream.readObject()) != null) {
            Node node2;
            Object object2 = objectInputStream.readObject();
            if (object2 == null) {
                throw new NullPointerException();
            }
            Object object3 = object;
            Object object4 = object2;
            int n2 = this.randomLevel();
            if (n2 > headIndex.level) {
                n2 = headIndex.level + 1;
            }
            node.next = node2 = new Node(object3, object4, null);
            node = node2;
            if (n2 <= 0) continue;
            Index index2 = null;
            for (int i4 = 1; i4 <= n2; ++i4) {
                index2 = new Index(node2, index2, null);
                if (i4 > headIndex.level) {
                    headIndex = new HeadIndex(headIndex.node, headIndex, index2, i4);
                }
                if (i4 < arrayList.size()) {
                    ((Index)arrayList.get((int)i4)).right = index2;
                    arrayList.set(i4, index2);
                    continue;
                }
                arrayList.add(index2);
            }
        }
        this.head = headIndex;
    }

    public boolean containsKey(Object object) {
        return this.doGet(object) != null;
    }

    public Object get(Object object) {
        return this.doGet(object);
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        return this.doPut(object, object2, false);
    }

    public Object remove(Object object) {
        return this.doRemove(object, null);
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Node node = this.findFirst();
        while (node != null) {
            Object object2 = node.getValidValue();
            if (object2 != null && object.equals(object2)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    public int size() {
        long l2 = 0L;
        Node node = this.findFirst();
        while (node != null) {
            if (node.getValidValue() != null) {
                ++l2;
            }
            node = node.next;
        }
        return l2 >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
    }

    public boolean isEmpty() {
        return this.findFirst() == null;
    }

    public void clear() {
        this.initialize();
    }

    public Set keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    public Set descendingKeySet() {
        DescendingKeySet descendingKeySet = this.descendingKeySet;
        return descendingKeySet != null ? descendingKeySet : (this.descendingKeySet = new DescendingKeySet());
    }

    public Collection values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    public Set entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    public Set descendingEntrySet() {
        DescendingEntrySet descendingEntrySet = this.descendingEntrySet;
        return descendingEntrySet != null ? descendingEntrySet : (this.descendingEntrySet = new DescendingEntrySet());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        try {
            Map.Entry entry;
            Iterator<Object> iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                if (entry.getValue().equals(map.get(entry.getKey()))) continue;
                return false;
            }
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                Object k2 = entry.getKey();
                Object v = entry.getValue();
                if (k2 != null && v != null && v.equals(this.get(k2))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public Object putIfAbsent(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        return this.doPut(object, object2, true);
    }

    public boolean remove(Object object, Object object2) {
        if (object2 == null) {
            return false;
        }
        return this.doRemove(object, object2) != null;
    }

    public boolean replace(Object object, Object object2, Object object3) {
        if (object2 == null || object3 == null) {
            throw new NullPointerException();
        }
        Comparable comparable = this.comparable(object);
        while (true) {
            Node node;
            if ((node = this.findNode(comparable)) == null) {
                return false;
            }
            Object object4 = node.value;
            if (object4 == null) continue;
            if (!object2.equals(object4)) {
                return false;
            }
            if (node.casValue(object4, object3)) break;
        }
        return true;
    }

    public Object replace(Object object, Object object2) {
        Node node;
        Object object3;
        if (object2 == null) {
            throw new NullPointerException();
        }
        Comparable comparable = this.comparable(object);
        do {
            if ((node = this.findNode(comparable)) != null) continue;
            return null;
        } while ((object3 = node.value) == null || !node.casValue(object3, object2));
        return object3;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public Object firstKey() {
        Node node = this.findFirst();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.key;
    }

    public Object lastKey() {
        Node node = this.findLast();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.key;
    }

    public NavigableMap navigableSubMap(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        return new ConcurrentSkipListSubMap(this, object, object2);
    }

    public NavigableMap navigableHeadMap(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return new ConcurrentSkipListSubMap(this, null, object);
    }

    public NavigableMap navigableTailMap(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return new ConcurrentSkipListSubMap(this, object, null);
    }

    public SortedMap subMap(Object object, Object object2) {
        return this.navigableSubMap(object, object2);
    }

    public SortedMap headMap(Object object) {
        return this.navigableHeadMap(object);
    }

    public SortedMap tailMap(Object object) {
        return this.navigableTailMap(object);
    }

    public Map.Entry lowerEntry(Object object) {
        return this.getNear(object, 2);
    }

    public Object lowerKey(Object object) {
        Node node = this.findNear(object, 2);
        return node == null ? null : node.key;
    }

    public Map.Entry floorEntry(Object object) {
        return this.getNear(object, 3);
    }

    public Object floorKey(Object object) {
        Node node = this.findNear(object, 3);
        return node == null ? null : node.key;
    }

    public Map.Entry ceilingEntry(Object object) {
        return this.getNear(object, 1);
    }

    public Object ceilingKey(Object object) {
        Node node = this.findNear(object, 1);
        return node == null ? null : node.key;
    }

    public Map.Entry higherEntry(Object object) {
        return this.getNear(object, 0);
    }

    public Object higherKey(Object object) {
        Node node = this.findNear(object, 0);
        return node == null ? null : node.key;
    }

    public Map.Entry firstEntry() {
        Node node;
        AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
        do {
            if ((node = this.findFirst()) != null) continue;
            return null;
        } while ((simpleImmutableEntry = node.createSnapshot()) == null);
        return simpleImmutableEntry;
    }

    public Map.Entry lastEntry() {
        Node node;
        AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
        do {
            if ((node = this.findLast()) != null) continue;
            return null;
        } while ((simpleImmutableEntry = node.createSnapshot()) == null);
        return simpleImmutableEntry;
    }

    public Map.Entry pollFirstEntry() {
        return this.doRemoveFirstEntry();
    }

    public Map.Entry pollLastEntry() {
        return this.doRemoveLastEntry();
    }

    Iterator keyIterator() {
        return new KeyIterator();
    }

    Iterator descendingKeyIterator() {
        return new DescendingKeyIterator();
    }

    SubMapEntryIterator subMapEntryIterator(Object object, Object object2) {
        return new SubMapEntryIterator(object, object2);
    }

    DescendingSubMapEntryIterator descendingSubMapEntryIterator(Object object, Object object2) {
        return new DescendingSubMapEntryIterator(object, object2);
    }

    SubMapKeyIterator subMapKeyIterator(Object object, Object object2) {
        return new SubMapKeyIterator(object, object2);
    }

    DescendingSubMapKeyIterator descendingSubMapKeyIterator(Object object, Object object2) {
        return new DescendingSubMapKeyIterator(object, object2);
    }

    SubMapValueIterator subMapValueIterator(Object object, Object object2) {
        return new SubMapValueIterator(object, object2);
    }

    private static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static class ConcurrentSkipListSubMap
    extends AbstractMap
    implements ConcurrentNavigableMap,
    Serializable {
        private static final long serialVersionUID = -7647078645895051609L;
        private final ConcurrentSkipListMap m;
        private final Object least;
        private final Object fence;
        private transient Set keySetView;
        private transient Set entrySetView;
        private transient Collection valuesView;
        private transient Set descendingKeySetView;
        private transient Set descendingEntrySetView;

        ConcurrentSkipListSubMap(ConcurrentSkipListMap concurrentSkipListMap, Object object, Object object2) {
            if (object != null && object2 != null && concurrentSkipListMap.compare(object, object2) > 0) {
                throw new IllegalArgumentException("inconsistent range");
            }
            this.m = concurrentSkipListMap;
            this.least = object;
            this.fence = object2;
        }

        boolean inHalfOpenRange(Object object) {
            return this.m.inHalfOpenRange(object, this.least, this.fence);
        }

        boolean inOpenRange(Object object) {
            return this.m.inOpenRange(object, this.least, this.fence);
        }

        Node firstNode() {
            return this.m.findCeiling(this.least);
        }

        Node lastNode() {
            return this.m.findLower(this.fence);
        }

        boolean isBeforeEnd(Node node) {
            return node != null && (this.fence == null || node.key == null || this.m.compare(this.fence, node.key) > 0);
        }

        void checkKey(Object object) throws IllegalArgumentException {
            if (!this.inHalfOpenRange(object)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        ConcurrentSkipListMap getMap() {
            return this.m;
        }

        Object getLeast() {
            return this.least;
        }

        Object getFence() {
            return this.fence;
        }

        public boolean containsKey(Object object) {
            Object object2 = object;
            return this.inHalfOpenRange(object2) && this.m.containsKey(object2);
        }

        public Object get(Object object) {
            Object object2 = object;
            return !this.inHalfOpenRange(object2) ? null : this.m.get(object2);
        }

        public Object put(Object object, Object object2) {
            this.checkKey(object);
            return this.m.put(object, object2);
        }

        public Object remove(Object object) {
            Object object2 = object;
            return !this.inHalfOpenRange(object2) ? null : this.m.remove(object2);
        }

        public int size() {
            long l2 = 0L;
            Node node = this.firstNode();
            while (this.isBeforeEnd(node)) {
                if (node.getValidValue() != null) {
                    ++l2;
                }
                node = node.next;
            }
            return l2 >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        }

        public boolean isEmpty() {
            return !this.isBeforeEnd(this.firstNode());
        }

        public boolean containsValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Node node = this.firstNode();
            while (this.isBeforeEnd(node)) {
                Object object2 = node.getValidValue();
                if (object2 != null && object.equals(object2)) {
                    return true;
                }
                node = node.next;
            }
            return false;
        }

        public void clear() {
            Node node = this.firstNode();
            while (this.isBeforeEnd(node)) {
                if (node.getValidValue() != null) {
                    this.m.remove(node.key);
                }
                node = node.next;
            }
        }

        public Object putIfAbsent(Object object, Object object2) {
            this.checkKey(object);
            return this.m.putIfAbsent(object, object2);
        }

        public boolean remove(Object object, Object object2) {
            Object object3 = object;
            return this.inHalfOpenRange(object3) && this.m.remove(object3, object2);
        }

        public boolean replace(Object object, Object object2, Object object3) {
            this.checkKey(object);
            return this.m.replace(object, object2, object3);
        }

        public Object replace(Object object, Object object2) {
            this.checkKey(object);
            return this.m.replace(object, object2);
        }

        public Comparator comparator() {
            return this.m.comparator();
        }

        public Object firstKey() {
            Node node = this.firstNode();
            if (this.isBeforeEnd(node)) {
                return node.key;
            }
            throw new NoSuchElementException();
        }

        public Object lastKey() {
            Object object;
            Node node = this.lastNode();
            if (node != null && this.inHalfOpenRange(object = node.key)) {
                return object;
            }
            throw new NoSuchElementException();
        }

        public NavigableMap navigableSubMap(Object object, Object object2) {
            if (object == null || object2 == null) {
                throw new NullPointerException();
            }
            if (!this.inOpenRange(object) || !this.inOpenRange(object2)) {
                throw new IllegalArgumentException("key out of range");
            }
            return new ConcurrentSkipListSubMap(this.m, object, object2);
        }

        public NavigableMap navigableHeadMap(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (!this.inOpenRange(object)) {
                throw new IllegalArgumentException("key out of range");
            }
            return new ConcurrentSkipListSubMap(this.m, this.least, object);
        }

        public NavigableMap navigableTailMap(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (!this.inOpenRange(object)) {
                throw new IllegalArgumentException("key out of range");
            }
            return new ConcurrentSkipListSubMap(this.m, object, this.fence);
        }

        public SortedMap subMap(Object object, Object object2) {
            return this.navigableSubMap(object, object2);
        }

        public SortedMap headMap(Object object) {
            return this.navigableHeadMap(object);
        }

        public SortedMap tailMap(Object object) {
            return this.navigableTailMap(object);
        }

        public Map.Entry ceilingEntry(Object object) {
            return this.m.getNearEntry(object, 0 | 1, this.least, this.fence);
        }

        public Object ceilingKey(Object object) {
            return this.m.getNearKey(object, 0 | 1, this.least, this.fence);
        }

        public Map.Entry lowerEntry(Object object) {
            return this.m.getNearEntry(object, 2, this.least, this.fence);
        }

        public Object lowerKey(Object object) {
            return this.m.getNearKey(object, 2, this.least, this.fence);
        }

        public Map.Entry floorEntry(Object object) {
            return this.m.getNearEntry(object, 2 | 1, this.least, this.fence);
        }

        public Object floorKey(Object object) {
            return this.m.getNearKey(object, 2 | 1, this.least, this.fence);
        }

        public Map.Entry higherEntry(Object object) {
            return this.m.getNearEntry(object, 0, this.least, this.fence);
        }

        public Object higherKey(Object object) {
            return this.m.getNearKey(object, 0, this.least, this.fence);
        }

        public Map.Entry firstEntry() {
            Node node;
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
            do {
                if (this.isBeforeEnd(node = this.firstNode())) continue;
                return null;
            } while ((simpleImmutableEntry = node.createSnapshot()) == null);
            return simpleImmutableEntry;
        }

        public Map.Entry lastEntry() {
            Node node;
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
            do {
                if ((node = this.lastNode()) != null && this.inHalfOpenRange(node.key)) continue;
                return null;
            } while ((simpleImmutableEntry = node.createSnapshot()) == null);
            return simpleImmutableEntry;
        }

        public Map.Entry pollFirstEntry() {
            return this.m.removeFirstEntryOfSubrange(this.least, this.fence);
        }

        public Map.Entry pollLastEntry() {
            return this.m.removeLastEntryOfSubrange(this.least, this.fence);
        }

        public Set keySet() {
            Set set = this.keySetView;
            return set != null ? set : (this.keySetView = new KeySetView());
        }

        public Set descendingKeySet() {
            Set set = this.descendingKeySetView;
            return set != null ? set : (this.descendingKeySetView = new DescendingKeySetView());
        }

        public Collection values() {
            Collection collection = this.valuesView;
            return collection != null ? collection : (this.valuesView = new ValuesView());
        }

        public Set entrySet() {
            Set set = this.entrySetView;
            return set != null ? set : (this.entrySetView = new EntrySetView());
        }

        public Set descendingEntrySet() {
            Set set = this.descendingEntrySetView;
            return set != null ? set : (this.descendingEntrySetView = new DescendingEntrySetView());
        }

        class DescendingEntrySetView
        extends EntrySetView {
            DescendingEntrySetView() {
            }

            public Iterator iterator() {
                return ConcurrentSkipListSubMap.this.m.descendingSubMapEntryIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }
        }

        class EntrySetView
        extends AbstractSet {
            EntrySetView() {
            }

            public Iterator iterator() {
                return ConcurrentSkipListSubMap.this.m.subMapEntryIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }

            public int size() {
                return ConcurrentSkipListSubMap.this.size();
            }

            public boolean isEmpty() {
                return ConcurrentSkipListSubMap.this.isEmpty();
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k2 = entry.getKey();
                if (!ConcurrentSkipListSubMap.this.inHalfOpenRange(k2)) {
                    return false;
                }
                Object object2 = ConcurrentSkipListSubMap.this.m.get(k2);
                return object2 != null && object2.equals(entry.getValue());
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k2 = entry.getKey();
                if (!ConcurrentSkipListSubMap.this.inHalfOpenRange(k2)) {
                    return false;
                }
                return ConcurrentSkipListSubMap.this.m.remove(k2, entry.getValue());
            }

            public Object[] toArray() {
                ArrayList<AbstractMap.SimpleEntry> arrayList = new ArrayList<AbstractMap.SimpleEntry>();
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    arrayList.add(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
                }
                return arrayList.toArray();
            }

            public Object[] toArray(Object[] objectArray) {
                ArrayList<AbstractMap.SimpleEntry> arrayList = new ArrayList<AbstractMap.SimpleEntry>();
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    arrayList.add(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
                }
                return arrayList.toArray(objectArray);
            }
        }

        class ValuesView
        extends AbstractCollection {
            ValuesView() {
            }

            public Iterator iterator() {
                return ConcurrentSkipListSubMap.this.m.subMapValueIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }

            public int size() {
                return ConcurrentSkipListSubMap.this.size();
            }

            public boolean isEmpty() {
                return ConcurrentSkipListSubMap.this.isEmpty();
            }

            public boolean contains(Object object) {
                return ConcurrentSkipListSubMap.this.containsValue(object);
            }

            public Object[] toArray() {
                ArrayList arrayList = new ArrayList();
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList.toArray();
            }

            public Object[] toArray(Object[] objectArray) {
                ArrayList arrayList = new ArrayList();
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList.toArray(objectArray);
            }
        }

        class DescendingKeySetView
        extends KeySetView {
            DescendingKeySetView() {
            }

            public Iterator iterator() {
                return ConcurrentSkipListSubMap.this.m.descendingSubMapKeyIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }
        }

        class KeySetView
        extends AbstractSet {
            KeySetView() {
            }

            public Iterator iterator() {
                return ConcurrentSkipListSubMap.this.m.subMapKeyIterator(ConcurrentSkipListSubMap.this.least, ConcurrentSkipListSubMap.this.fence);
            }

            public int size() {
                return ConcurrentSkipListSubMap.this.size();
            }

            public boolean isEmpty() {
                return ConcurrentSkipListSubMap.this.isEmpty();
            }

            public boolean contains(Object object) {
                return ConcurrentSkipListSubMap.this.containsKey(object);
            }

            public Object[] toArray() {
                ArrayList arrayList = new ArrayList();
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList.toArray();
            }

            public Object[] toArray(Object[] objectArray) {
                ArrayList arrayList = new ArrayList();
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList.toArray(objectArray);
            }
        }
    }

    class DescendingEntrySet
    extends EntrySet {
        DescendingEntrySet() {
        }

        public Iterator iterator() {
            return new DescendingEntryIterator();
        }
    }

    class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = ConcurrentSkipListMap.this.get(entry.getKey());
            return object2 != null && object2.equals(entry.getValue());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentSkipListMap.this.remove(entry.getKey(), entry.getValue());
        }

        public boolean isEmpty() {
            return ConcurrentSkipListMap.this.isEmpty();
        }

        public int size() {
            return ConcurrentSkipListMap.this.size();
        }

        public void clear() {
            ConcurrentSkipListMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList<AbstractMap.SimpleEntry> arrayList = new ArrayList<AbstractMap.SimpleEntry>();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                arrayList.add(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
            }
            return arrayList.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList<AbstractMap.SimpleEntry> arrayList = new ArrayList<AbstractMap.SimpleEntry>();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                arrayList.add(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
            }
            return arrayList.toArray(objectArray);
        }
    }

    final class Values
    extends AbstractCollection {
        Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public boolean isEmpty() {
            return ConcurrentSkipListMap.this.isEmpty();
        }

        public int size() {
            return ConcurrentSkipListMap.this.size();
        }

        public boolean contains(Object object) {
            return ConcurrentSkipListMap.this.containsValue(object);
        }

        public void clear() {
            ConcurrentSkipListMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }
    }

    class DescendingKeySet
    extends KeySet {
        DescendingKeySet() {
        }

        public Iterator iterator() {
            return new DescendingKeyIterator();
        }
    }

    class KeySet
    extends AbstractSet {
        KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean isEmpty() {
            return ConcurrentSkipListMap.this.isEmpty();
        }

        public int size() {
            return ConcurrentSkipListMap.this.size();
        }

        public boolean contains(Object object) {
            return ConcurrentSkipListMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return ConcurrentSkipListMap.this.removep(object);
        }

        public void clear() {
            ConcurrentSkipListMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }
    }

    final class DescendingSubMapEntryIterator
    extends EntryIter
    implements Iterator {
        final Object least;

        DescendingSubMapEntryIterator(Object object, Object object2) {
            this.initDescending(object, object2);
            this.least = object;
        }

        public Object next() {
            this.lastValue = this.nextValue;
            this.descend(this.least);
            return this;
        }
    }

    final class DescendingEntryIterator
    extends EntryIter
    implements Iterator {
        DescendingEntryIterator() {
            this.initDescending();
        }

        public Object next() {
            this.lastValue = this.nextValue;
            this.descend();
            return this;
        }
    }

    final class SubMapEntryIterator
    extends EntryIter
    implements Iterator {
        final Object fence;

        SubMapEntryIterator(Object object, Object object2) {
            this.initAscending(object, object2);
            this.fence = object2;
        }

        public Object next() {
            this.lastValue = this.nextValue;
            this.ascend(this.fence);
            return this;
        }
    }

    final class EntryIterator
    extends EntryIter
    implements Iterator {
        EntryIterator() {
            this.initAscending();
        }

        public Object next() {
            this.lastValue = this.nextValue;
            this.ascend();
            return this;
        }
    }

    abstract class EntryIter
    extends Iter
    implements Map.Entry {
        Object lastValue;

        EntryIter() {
        }

        public Object getKey() {
            Node node = this.last;
            if (node == null) {
                throw new IllegalStateException();
            }
            return node.key;
        }

        public Object getValue() {
            Object object = this.lastValue;
            if (this.last == null || object == null) {
                throw new IllegalStateException();
            }
            return object;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            if (this.last == null) {
                return super.equals(object);
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.getKey().equals(entry.getKey()) && this.getValue().equals(entry.getValue());
        }

        public int hashCode() {
            if (this.last == null) {
                return super.hashCode();
            }
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        public String toString() {
            if (this.last == null) {
                return super.toString();
            }
            return this.getKey() + "=" + this.getValue();
        }
    }

    final class DescendingSubMapKeyIterator
    extends Iter
    implements Iterator {
        final Object least;

        DescendingSubMapKeyIterator(Object object, Object object2) {
            this.initDescending(object, object2);
            this.least = object;
        }

        public Object next() {
            Node node = this.next;
            this.descend(this.least);
            return node.key;
        }
    }

    final class DescendingKeyIterator
    extends Iter
    implements Iterator {
        DescendingKeyIterator() {
            this.initDescending();
        }

        public Object next() {
            Node node = this.next;
            this.descend();
            return node.key;
        }
    }

    final class SubMapKeyIterator
    extends Iter
    implements Iterator {
        final Object fence;

        SubMapKeyIterator(Object object, Object object2) {
            this.initAscending(object, object2);
            this.fence = object2;
        }

        public Object next() {
            Node node = this.next;
            this.ascend(this.fence);
            return node.key;
        }
    }

    class SubMapValueIterator
    extends Iter
    implements Iterator {
        final Object fence;

        SubMapValueIterator(Object object, Object object2) {
            this.initAscending(object, object2);
            this.fence = object2;
        }

        public Object next() {
            Object object = this.nextValue;
            this.ascend(this.fence);
            return object;
        }
    }

    final class KeyIterator
    extends Iter
    implements Iterator {
        KeyIterator() {
            this.initAscending();
        }

        public Object next() {
            Node node = this.next;
            this.ascend();
            return node.key;
        }
    }

    final class ValueIterator
    extends Iter
    implements Iterator {
        ValueIterator() {
            this.initAscending();
        }

        public Object next() {
            Object object = this.nextValue;
            this.ascend();
            return object;
        }
    }

    abstract class Iter {
        Node last;
        Node next;
        Object nextValue;

        Iter() {
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final void initAscending() {
            do {
                this.next = ConcurrentSkipListMap.this.findFirst();
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void initAscending(Object object, Object object2) {
            block2: {
                do {
                    this.next = ConcurrentSkipListMap.this.findCeiling(object);
                    if (this.next == null) break block2;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (object2 != null && ConcurrentSkipListMap.this.compare(object2, this.next.key) <= 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        final void ascend() {
            this.last = this.next;
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            do {
                this.next = this.next.next;
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void ascend(Object object) {
            block3: {
                this.last = this.next;
                if (this.last == null) {
                    throw new NoSuchElementException();
                }
                do {
                    this.next = this.next.next;
                    if (this.next == null) break block3;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (object != null && ConcurrentSkipListMap.this.compare(object, this.next.key) <= 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        final void initDescending() {
            do {
                this.next = ConcurrentSkipListMap.this.findLast();
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void initDescending(Object object, Object object2) {
            block2: {
                do {
                    this.next = ConcurrentSkipListMap.this.findLower(object2);
                    if (this.next == null) break block2;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (object != null && ConcurrentSkipListMap.this.compare(object, this.next.key) > 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        final void descend() {
            this.last = this.next;
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            Object object = this.last.key;
            do {
                this.next = ConcurrentSkipListMap.this.findNear(object, 2);
                if (this.next == null) break;
                this.nextValue = this.next.value;
            } while (this.nextValue == null || this.nextValue == this.next);
        }

        final void descend(Object object) {
            block3: {
                this.last = this.next;
                if (this.last == null) {
                    throw new NoSuchElementException();
                }
                Object object2 = this.last.key;
                do {
                    this.next = ConcurrentSkipListMap.this.findNear(object2, 2);
                    if (this.next == null) break block3;
                    this.nextValue = this.next.value;
                } while (this.nextValue == null || this.nextValue == this.next);
                if (object != null && ConcurrentSkipListMap.this.compare(object, this.next.key) > 0) {
                    this.next = null;
                    this.nextValue = null;
                }
            }
        }

        public void remove() {
            Node node = this.last;
            if (node == null) {
                throw new IllegalStateException();
            }
            ConcurrentSkipListMap.this.remove(node.key);
        }
    }

    static final class ComparableUsingComparator
    implements Comparable {
        final Object actualKey;
        final Comparator cmp;

        ComparableUsingComparator(Object object, Comparator comparator) {
            this.actualKey = object;
            this.cmp = comparator;
        }

        public int compareTo(Object object) {
            return this.cmp.compare(this.actualKey, object);
        }
    }

    static final class HeadIndex
    extends Index {
        final int level;

        HeadIndex(Node node, Index index, Index index2, int n2) {
            super(node, index, index2);
            this.level = n2;
        }
    }

    static class Index {
        final Object key;
        final Node node;
        final Index down;
        volatile Index right;

        Index(Node node, Index index, Index index2) {
            this.node = node;
            this.key = node.key;
            this.down = index;
            this.right = index2;
        }

        final synchronized boolean casRight(Index index, Index index2) {
            if (this.right == index) {
                this.right = index2;
                return true;
            }
            return false;
        }

        final boolean indexesDeletedNode() {
            return this.node.value == null;
        }

        final boolean link(Index index, Index index2) {
            Node node = this.node;
            index2.right = index;
            return node.value != null && this.casRight(index, index2);
        }

        final boolean unlink(Index index) {
            return !this.indexesDeletedNode() && this.casRight(index, index.right);
        }
    }

    static final class Node {
        final Object key;
        volatile Object value;
        volatile Node next;

        Node(Object object, Object object2, Node node) {
            this.key = object;
            this.value = object2;
            this.next = node;
        }

        Node(Node node) {
            this.key = null;
            this.value = this;
            this.next = node;
        }

        synchronized boolean casValue(Object object, Object object2) {
            if (this.value == object) {
                this.value = object2;
                return true;
            }
            return false;
        }

        synchronized boolean casNext(Node node, Node node2) {
            if (this.next == node) {
                this.next = node2;
                return true;
            }
            return false;
        }

        boolean isMarker() {
            return this.value == this;
        }

        boolean isBaseHeader() {
            return this.value == BASE_HEADER;
        }

        boolean appendMarker(Node node) {
            return this.casNext(node, new Node(node));
        }

        void helpDelete(Node node, Node node2) {
            if (node2 == this.next && this == node.next) {
                if (node2 == null || node2.value != node2) {
                    this.appendMarker(node2);
                } else {
                    node.casNext(this, node2.next);
                }
            }
        }

        Object getValidValue() {
            Object object = this.value;
            if (object == this || object == BASE_HEADER) {
                return null;
            }
            return object;
        }

        AbstractMap.SimpleImmutableEntry createSnapshot() {
            Object object = this.getValidValue();
            if (object == null) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry(this.key, object);
        }
    }
}

