/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.io.PrintStream;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.AliasDefHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.AttributeDescription;
import org.omg.CORBA.AttributeDescriptionHelper;
import org.omg.CORBA.AttributeMode;
import org.omg.CORBA.ConstantDescription;
import org.omg.CORBA.ConstantDescriptionHelper;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.EnumDefHelper;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.ExceptionDefHelper;
import org.omg.CORBA.ExceptionDescription;
import org.omg.CORBA.ExceptionDescriptionHelper;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription;
import org.omg.CORBA.InterfaceDescriptionHelper;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.ModuleDefHelper;
import org.omg.CORBA.ModuleDescription;
import org.omg.CORBA.ModuleDescriptionHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.OperationDescriptionHelper;
import org.omg.CORBA.OperationMode;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructDefHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeDescription;
import org.omg.CORBA.TypeDescriptionHelper;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionDefHelper;
import org.omg.CORBA.UnionMember;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynEnum;
import org.omg.DynamicAny.DynEnumHelper;

public class IdlWriter {
    private final PrintStream printStream;
    private final Repository ir;
    private final DynAnyFactory factory;
    private final Logger logger;
    private int indent = 0;

    public IdlWriter(ORB orb, PrintStream ps, Logger logger) {
        this.printStream = ps;
        this.logger = logger;
        try {
            this.ir = RepositoryHelper.narrow(orb.resolve_initial_references("InterfaceRepository"));
            this.factory = DynAnyFactoryHelper.narrow(orb.resolve_initial_references("DynAnyFactory"));
        }
        catch (InvalidName e2) {
            throw new INTERNAL(e2.toString());
        }
        if (this.ir == null) {
            logger.fatalError("No IR configured! Exiting..");
            System.exit(1);
        }
    }

    public void close() {
        this.printStream.flush();
        this.printStream.close();
    }

    private void indent(int indentation) {
        this.indent = indentation;
    }

    private void print(String s2) {
        for (int i2 = 0; i2 < this.indent; ++i2) {
            this.printStream.print(" ");
        }
        this.printStream.print(s2);
    }

    public void printContained(Contained c2, int indentation) {
        Description descr = c2.describe();
        switch (descr.kind.value()) {
            case 6: {
                this.printModule(ModuleDescriptionHelper.extract(descr.value), indentation + 3);
                break;
            }
            case 5: {
                InterfaceDef idef = InterfaceDefHelper.narrow(this.ir.lookup_id(InterfaceDescriptionHelper.extract((Any)descr.value).id));
                this.printInterface(idef, indentation + 3);
                break;
            }
            case 2: {
                this.printAttribute(AttributeDescriptionHelper.extract(descr.value), indentation + 3);
                break;
            }
            case 7: {
                this.printOperation(OperationDescriptionHelper.extract(descr.value), indentation + 3);
                break;
            }
            case 4: {
                this.printException(ExceptionDescriptionHelper.extract(descr.value), indentation + 3);
                break;
            }
            case 3: {
                this.printConstant(ConstantDescriptionHelper.extract(descr.value), indentation + 3);
                break;
            }
            case 10: {
                this.printStruct(TypeDescriptionHelper.extract(descr.value), indentation + 3);
                break;
            }
            case 12: {
                this.printEnum(TypeDescriptionHelper.extract(descr.value), indentation + 3);
                break;
            }
            case 11: {
                this.printUnion(TypeDescriptionHelper.extract(descr.value), indentation + 3);
                break;
            }
            case 9: {
                this.printAlias(TypeDescriptionHelper.extract(descr.value), indentation + 3);
            }
        }
    }

    public void printModule(ModuleDescription mdes, int indentation) {
        this.indent(indentation);
        ModuleDef mdef = ModuleDefHelper.narrow(this.ir.lookup_id(mdes.id));
        this.print("module " + mdef.name() + "\n");
        this.print("{\n");
        Contained[] contents = mdef.contents(DefinitionKind.dk_all, true);
        for (int x = 0; x < contents.length; ++x) {
            this.printContained(contents[x], indentation);
        }
        this.indent(indentation);
        this.print("};\n\n");
    }

    public void printInterface(InterfaceDef idef, int indentation) {
        FullInterfaceDescription idfid = idef.describe_interface();
        Contained[] contents = idef.contents(DefinitionKind.dk_all, true);
        this.indent(indentation);
        StringBuffer inheritanceSb = new StringBuffer();
        if (idfid.base_interfaces.length > 0) {
            inheritanceSb.append(" : " + idfid.base_interfaces[0]);
        }
        for (int b2 = 1; b2 < idfid.base_interfaces.length; ++b2) {
            inheritanceSb.append(", " + idfid.base_interfaces[b2]);
        }
        this.print("interface " + idfid.name + inheritanceSb.toString() + "\n");
        this.print("{\n");
        for (int x = 0; x < contents.length; ++x) {
            this.printContained(contents[x], indentation);
        }
        this.indent(indentation);
        this.print("};\n\n");
    }

    public void printException(ExceptionDescription e2, int indentation) {
        ExceptionDef e_def = ExceptionDefHelper.narrow(this.ir.lookup_id(e2.id));
        if (e_def != null) {
            StructMember[] members = e_def.members();
            this.indent(indentation);
            this.print("exception " + e2.name + " {" + "\n");
            this.indent(indentation + 3);
            for (int i2 = 0; i2 < members.length; ++i2) {
                this.print(this.idlTypeName(members[i2].type) + " " + members[i2].name + ";" + "\n");
            }
            this.indent(indentation);
            this.print("};\n\n");
        } else {
            this.logger.error("Error, could not find exception " + e2.id + " in IR ");
        }
    }

    public void printStruct(TypeDescription t2, int indentation) {
        StructDef s_def = StructDefHelper.narrow(this.ir.lookup_id(t2.id));
        if (s_def != null) {
            int i2;
            StructMember[] members = s_def.members();
            Contained[] contents = s_def.contents(DefinitionKind.dk_all, false);
            this.indent(indentation);
            this.print("struct " + s_def.name() + " {" + "\n");
            this.indent(indentation + 3);
            for (i2 = 0; i2 < members.length; ++i2) {
                this.print(this.idlTypeName(members[i2].type) + " " + members[i2].name + ";" + "\n");
            }
            for (i2 = 0; i2 < contents.length; ++i2) {
                this.printContained(contents[i2], indentation);
            }
            this.indent(indentation);
            this.print("};\n\n");
        } else {
            this.logger.error("Error, could not find struct " + t2.id + " in IR ");
        }
    }

    public void printConstant(ConstantDescription c2, int indentation) {
        this.indent(indentation);
        StringBuffer sb = new StringBuffer("const " + this.idlTypeName(c2.type) + " " + c2.name + " = ");
        switch (c2.type.kind().value()) {
            case 18: {
                sb.append("\"" + c2.value.extract_string() + "\"");
                break;
            }
            case 27: {
                sb.append("\"" + c2.value.extract_wstring() + "\"");
                break;
            }
            case 8: {
                sb.append(c2.value.extract_boolean());
                break;
            }
            case 3: {
                sb.append(c2.value.extract_long());
                break;
            }
            case 5: {
                sb.append(c2.value.extract_ulong());
                break;
            }
            case 23: {
                sb.append(c2.value.extract_longlong());
                break;
            }
            case 24: {
                sb.append(c2.value.extract_ulonglong());
                break;
            }
            case 2: {
                sb.append(c2.value.extract_short());
                break;
            }
            case 4: {
                sb.append(c2.value.extract_ushort());
                break;
            }
            case 6: {
                sb.append(c2.value.extract_float());
                break;
            }
            case 10: {
                sb.append(c2.value.extract_octet());
                break;
            }
            case 9: {
                sb.append("'" + c2.value.extract_char() + "'");
                break;
            }
            case 26: {
                sb.append("'" + c2.value.extract_wchar() + "'");
                break;
            }
            case 28: {
                sb.append(c2.value.extract_fixed());
            }
        }
        this.print(sb.toString() + ";\n\n");
    }

    public void printAttribute(AttributeDescription a2, int indentation) {
        this.indent(indentation);
        String mode = "";
        if (a2.mode.equals(AttributeMode.ATTR_READONLY)) {
            mode = "readonly ";
        }
        this.print(mode + "attribute " + this.idlTypeName(a2.type) + " " + a2.name + ";" + "\n");
    }

    public void printEnum(TypeDescription t2, int indentation) {
        EnumDef e_def = EnumDefHelper.narrow(this.ir.lookup_id(t2.id));
        if (e_def != null) {
            String[] members = e_def.members();
            this.indent(indentation);
            StringBuffer vals = new StringBuffer();
            if (members.length > 0) {
                vals.append(members[0]);
            }
            for (int i2 = 1; i2 < members.length; ++i2) {
                vals.append("," + members[i2]);
            }
            this.print("enum " + e_def.name() + " {" + vals + "};" + "\n\n");
        } else {
            this.logger.error("Error, could not find enum " + t2.id + " in IR ");
        }
    }

    public void printUnion(TypeDescription t2, int indentation) {
        UnionDef u_def = UnionDefHelper.narrow(this.ir.lookup_id(t2.id));
        if (u_def != null) {
            UnionMember[] members = u_def.members();
            this.indent(indentation);
            this.print("union " + u_def.name() + " switch ( " + this.idlTypeName(u_def.discriminator_type()) + " )\n");
            this.print("{\n");
            this.indent(indentation + 4);
            int def_idx = -1;
            for (int i2 = 0; i2 < members.length; ++i2) {
                if (members[i2].label.type().kind() == TCKind.tk_octet && members[i2].label.extract_octet() == 0) {
                    def_idx = i2;
                    continue;
                }
                if (members[i2].label.type().kind() == TCKind.tk_char) {
                    this.print("case '" + members[i2].label.extract_char() + "' : " + this.idlTypeName(members[i2].type) + " " + members[i2].name + ";" + "\n");
                    continue;
                }
                if (members[i2].label.type().kind() == TCKind.tk_enum) {
                    try {
                        DynEnum dEnum = DynEnumHelper.narrow(this.factory.create_dyn_any(members[i2].label));
                        this.print("case " + dEnum.get_as_string() + " : " + this.idlTypeName(members[i2].type) + " " + members[i2].name + ";" + "\n");
                    }
                    catch (Exception bk) {
                        this.logger.error("unexpected exception", bk);
                    }
                    continue;
                }
                this.print("case " + members[i2].label.type() + " : " + this.idlTypeName(members[i2].type) + " " + members[i2].name + ";" + "\n");
            }
            if (def_idx != -1) {
                this.print("default : " + this.idlTypeName(members[def_idx].type) + " " + members[def_idx].name + ";" + "\n");
            }
            this.indent(indentation);
            this.print("};\n\n");
        } else {
            this.logger.error("Error, could not find union " + t2.id + " in IR ");
        }
    }

    public void printAlias(TypeDescription t2, int indentation) {
        AliasDef adef = AliasDefHelper.narrow(this.ir.lookup_id(t2.id));
        this.indent(indentation);
        String originalTypeName = this.idlTypeName(adef.original_type_def().type());
        this.print("typedef " + originalTypeName + " " + adef.name() + ";\n\n");
    }

    public void printOperation(OperationDescription op, int indentation) {
        int i2;
        this.indent(indentation);
        String mode = "";
        if (op.mode.equals(OperationMode.OP_ONEWAY)) {
            mode = "oneway ";
        }
        this.print(mode + this.idlTypeName(op.result) + " " + op.name + "(");
        this.indent(0);
        for (i2 = 0; i2 < op.parameters.length - 1; ++i2) {
            this.printParameter(op.parameters[i2], ",");
        }
        if (op.parameters.length > 0) {
            this.printParameter(op.parameters[op.parameters.length - 1], "");
        }
        this.print(")");
        if (op.exceptions.length > 0) {
            this.print(" raises (");
            this.print(this.idlTypeName(op.exceptions[0].type));
            for (i2 = 1; i2 < op.exceptions.length; ++i2) {
                this.print(this.idlTypeName(op.exceptions[0].type) + ",");
            }
            this.print(")");
        }
        this.print(";\n");
        this.indent(indentation);
    }

    public void printParameter(ParameterDescription p2, String separator) {
        if (p2.mode.equals(ParameterMode.PARAM_OUT)) {
            this.print("out ");
        } else if (p2.mode.equals(ParameterMode.PARAM_INOUT)) {
            this.print("inout ");
        } else {
            this.print("in ");
        }
        this.print(this.idlTypeName(p2.type) + " " + p2.name);
        this.print(separator);
    }

    private static String idToIDL(String id) {
        if (id.length() > 4) {
            id = id.startsWith("IDL:") ? id.substring(4, id.lastIndexOf(":")) : id.replace('.', '/') + ":1.0";
        }
        StringBuffer sb = new StringBuffer(id);
        for (int i2 = 0; i2 < sb.length(); ++i2) {
            if (sb.charAt(i2) != '/') continue;
            sb.setCharAt(i2, ':');
            sb.insert(i2, ':');
        }
        return sb.toString();
    }

    public String idlTypeName(TypeCode tc) {
        switch (tc.kind().value()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 33: {
                try {
                    return IdlWriter.idToIDL(tc.id());
                }
                catch (BadKind bk) {
                    throw new INTERNAL("should never happen");
                }
            }
            case 1: {
                return "void";
            }
            case 18: {
                return "string";
            }
            case 27: {
                return "wstring";
            }
            case 20: {
                try {
                    return this.idlTypeName(tc.content_type()) + "[]";
                }
                catch (BadKind bk) {
                    throw new INTERNAL("should never happen");
                }
            }
            case 3: {
                return "long";
            }
            case 5: {
                return "ulong";
            }
            case 23: {
                return "long long";
            }
            case 24: {
                return "ulong long";
            }
            case 4: {
                return "ushort";
            }
            case 2: {
                return "short";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 28: {
                try {
                    return "fixed <" + tc.fixed_digits() + "," + tc.fixed_scale() + ">";
                }
                catch (BadKind bk) {
                    throw new INTERNAL("should never happen");
                }
            }
            case 8: {
                return "boolean";
            }
            case 10: {
                return "octet";
            }
            case 9: {
                return "char";
            }
            case 26: {
                return "wchar";
            }
            case 11: {
                return "any";
            }
            case 19: {
                try {
                    return "sequence <" + this.idlTypeName(tc.content_type()) + ">";
                }
                catch (BadKind bk) {
                    throw new INTERNAL("should never happen");
                }
            }
            case -1: {
                return "recursive";
            }
        }
        return "* no typeName for TK " + tc.kind().value() + " *";
    }
}

