/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ClientInterceptorHandler;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ExceptionHolderImpl;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ReplyReceiverConfiguration;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.MessageInputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.util.Time;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA.portable.ServantObjectExt;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.Messaging.ReplyHandler;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.TimeBase.UtcT;

public class ReplyReceiver
extends ReplyPlaceholder
implements Configurable {
    private final Delegate delegate;
    private final ClientInterceptorHandler interceptors;
    private final ReplyHandler replyHandler;
    private final String operation;
    private final Timer timer;
    private Logger logger;
    private boolean retry_on_failure = false;
    private UtcT replyEndTime = null;

    public ReplyReceiver(Delegate delegate, String operation, UtcT replyEndTime, ClientInterceptorHandler interceptors, ReplyHandler replyHandler) {
        this.delegate = delegate;
        this.operation = operation;
        this.interceptors = interceptors;
        this.replyHandler = replyHandler;
        this.replyEndTime = replyEndTime;
        if (replyEndTime != null) {
            this.timer = new Timer(replyEndTime);
            this.timer.setName("ReplyReceiver Timer");
            this.timer.start();
        } else {
            this.timer = null;
        }
    }

    public void configure(Configuration configuration) {
        super.configure(configuration);
        org.jacorb.config.Configuration jconfig = (org.jacorb.config.Configuration)configuration;
        try {
            ReplyReceiverConfiguration config = (ReplyReceiverConfiguration)jconfig.getAttributeAsObject("jacorb.orb.reply_receiver.config", ReplyReceiverConfiguration.DEFAULT);
            this.logger = config.logger;
            this.retry_on_failure = config.retry_on_failure;
        }
        catch (ConfigurationException e2) {
            throw new RuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyReceived(MessageInputStream in) {
        Set pending_replies;
        if (this.timeoutException) {
            return;
        }
        if (this.timer != null) {
            this.timer.wakeup();
        }
        Set set = pending_replies = this.delegate.get_pending_replies();
        synchronized (set) {
            java.lang.Object object = this.lock;
            synchronized (object) {
                if (this.timeoutException) {
                    return;
                }
                this.in = in;
                this.delegate.replyDone(this);
                if (this.replyHandler != null) {
                    this.performCallback((ReplyInputStream)in);
                } else {
                    this.ready = true;
                    this.lock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCallback(ReplyInputStream reply) {
        org.omg.CORBA.portable.Delegate replyHandlerDelegate = ((ObjectImpl)((java.lang.Object)this.replyHandler))._get_delegate();
        ServantObject so = replyHandlerDelegate.servant_preinvoke(this.replyHandler, this.operation, InvokeHandler.class);
        try {
            switch (reply.getStatus().value()) {
                case 0: {
                    ((InvokeHandler)so.servant)._invoke(this.operation, reply, new DummyResponseHandler());
                    break;
                }
                case 1: 
                case 2: {
                    ExceptionHolderImpl holder = new ExceptionHolderImpl((ORB)this.delegate.orb(null), reply);
                    org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)replyHandlerDelegate.orb(null);
                    orb.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", new ExceptionHolderFactory((ORB)orb));
                    CDRInputStream input = new CDRInputStream(orb, holder.marshal());
                    ((InvokeHandler)so.servant)._invoke(this.operation + "_excep", input, new DummyResponseHandler());
                    break;
                }
            }
            if (so instanceof ServantObjectExt) {
                ((ServantObjectExt)so).normalCompletion();
            }
        }
        catch (Exception e2) {
            this.logger.warn("Exception during callback", e2);
            if (so instanceof ServantObjectExt) {
                ((ServantObjectExt)so).exceptionalCompletion(e2);
            }
        }
        finally {
            replyHandlerDelegate.servant_postinvoke(this.replyHandler, so);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performExceptionCallback(ExceptionHolderImpl holder) {
        org.omg.CORBA.portable.Delegate replyHandlerDelegate = ((ObjectImpl)((java.lang.Object)this.replyHandler))._get_delegate();
        ServantObject so = replyHandlerDelegate.servant_preinvoke(this.replyHandler, this.operation, InvokeHandler.class);
        try {
            org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)replyHandlerDelegate.orb(null);
            orb.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", new ExceptionHolderFactory((ORB)orb));
            CDRInputStream input = new CDRInputStream(orb, holder.marshal());
            ((InvokeHandler)so.servant)._invoke(this.operation + "_excep", input, new DummyResponseHandler());
            if (so instanceof ServantObjectExt) {
                ((ServantObjectExt)so).normalCompletion();
            }
        }
        catch (Exception e2) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception during callback: " + e2.toString());
            }
            if (so instanceof ServantObjectExt) {
                ((ServantObjectExt)so).exceptionalCompletion(e2);
            }
        }
        finally {
            replyHandlerDelegate.servant_postinvoke(this.replyHandler, so);
        }
    }

    public synchronized ReplyInputStream getReply() throws RemarshalException, ApplicationException {
        try {
            try {
                this.getInputStream(this.timer != null);
            }
            catch (COMM_FAILURE ex) {
                if (this.retry_on_failure) {
                    throw new RemarshalException();
                }
                throw ex;
            }
        }
        catch (SystemException se) {
            try {
                this.interceptors.handle_receive_exception(se);
            }
            catch (ForwardRequest fwd) {
                // empty catch block
            }
            throw se;
        }
        catch (RemarshalException re) {
            this.delegate.waitOnBarrier();
            throw re;
        }
        ReplyInputStream reply = (ReplyInputStream)this.in;
        ReplyStatusType_1_2 status = reply.getStatus();
        if (!this.delegate.isCtxNegotiated()) {
            if (reply.rep_hdr != null && reply.rep_hdr.service_context != null) {
                for (int i2 = 0; i2 < reply.rep_hdr.service_context.length; ++i2) {
                    if (reply.rep_hdr.service_context[i2].context_id != 1245904912) continue;
                    if (reply.rep_hdr.service_context[i2].context_data.length == 0) {
                        throw new INTERNAL("JacORB ServiceContext tag has no context data");
                    }
                    this.delegate.setSvcObjectID(reply.rep_hdr.service_context[i2].context_data);
                }
            }
            this.delegate.setCtxNegotiated(true);
        }
        switch (status.value()) {
            case 0: {
                try {
                    this.interceptors.handle_receive_reply(reply);
                }
                catch (ForwardRequest fwd) {
                    // empty catch block
                }
                this.checkTimeout();
                return reply;
            }
            case 1: {
                ApplicationException ae = this.getApplicationException(reply);
                try {
                    this.interceptors.handle_receive_exception(ae, reply);
                }
                catch (ForwardRequest fwd) {
                    // empty catch block
                }
                this.checkTimeout();
                throw ae;
            }
            case 2: {
                SystemException se = SystemExceptionHelper.read(reply);
                if (1245904912 == se.minor) {
                    this.delegate.setSvcObjectID(null);
                    this.delegate.setCtxNegotiated(false);
                    throw new RemarshalException();
                }
                try {
                    this.interceptors.handle_receive_exception(se, reply);
                }
                catch (ForwardRequest fwd) {
                    // empty catch block
                }
                this.checkTimeout();
                throw se;
            }
            case 4: {
                if (!this.delegate.isIOGR()) {
                    this.logger.warn("received reply with deprecated status LOCATION_FORWARD_PERM");
                }
            }
            case 3: {
                Object forward_reference = reply.read_Object();
                try {
                    this.interceptors.handle_location_forward(reply, forward_reference);
                }
                catch (ForwardRequest fwd) {
                    // empty catch block
                }
                this.checkTimeout();
                this.delegate.rebind(forward_reference, status.value() == 4);
                throw new RemarshalException();
            }
            case 5: {
                throw new NO_IMPLEMENT("WARNING: Got reply status NEEDS_ADDRESSING_MODE (not implemented).");
            }
        }
        throw new MARSHAL("Received unexpected reply status: " + status.value());
    }

    private void checkTimeout() {
        if (this.replyEndTime != null && Time.hasPassed(this.replyEndTime)) {
            throw new TIMEOUT("Reply End Time exceeded", 3, CompletionStatus.COMPLETED_NO);
        }
    }

    private ApplicationException getApplicationException(ReplyInputStream reply) {
        reply.mark(0);
        String id = reply.read_string();
        try {
            reply.reset();
        }
        catch (IOException e2) {
            this.logger.error("unexpected Exception in reset()", e2);
        }
        return new ApplicationException(id, reply);
    }

    private class Timer
    extends Thread {
        private final UtcT endTime;
        private boolean awakened;

        public Timer(UtcT endTime) {
            super("ReplyReceiverTimer");
            this.awakened = false;
            this.endTime = endTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            java.lang.Object object = ReplyReceiver.this.lock;
            synchronized (object) {
                ReplyReceiver.this.timeoutException = false;
                if (!this.awakened) {
                    long time = Time.millisTo(this.endTime);
                    if (time > 0L) {
                        try {
                            ReplyReceiver.this.lock.wait(time);
                        }
                        catch (InterruptedException ex) {
                            ReplyReceiver.this.logger.info("Interrupted while waiting for timeout");
                        }
                    }
                    if (!this.awakened) {
                        ReplyReceiver.this.timeoutException = true;
                        if (ReplyReceiver.this.replyHandler != null) {
                            ExceptionHolderImpl exHolder = new ExceptionHolderImpl((ORB)ReplyReceiver.this.delegate.orb(null), new TIMEOUT());
                            ReplyReceiver.this.performExceptionCallback(exHolder);
                        }
                        ReplyReceiver.this.ready = true;
                        ReplyReceiver.this.lock.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeup() {
            java.lang.Object object = ReplyReceiver.this.lock;
            synchronized (object) {
                this.awakened = true;
                ReplyReceiver.this.timeoutException = false;
                ReplyReceiver.this.lock.notifyAll();
            }
        }
    }

    private static class ExceptionHolderFactory
    implements ValueFactory {
        private final ORB orb;

        public ExceptionHolderFactory(ORB orb) {
            this.orb = orb;
        }

        public Serializable read_value(InputStream is) {
            ExceptionHolderImpl result = new ExceptionHolderImpl(this.orb);
            result._read(is);
            return result;
        }
    }

    private class DummyResponseHandler
    implements ResponseHandler {
        private DummyResponseHandler() {
        }

        public OutputStream createReply() {
            Time.waitFor(ReplyReceiver.this.delegate.getReplyStartTime());
            return null;
        }

        public OutputStream createExceptionReply() {
            return null;
        }
    }
}

