/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.ETF.BufferHolder;
import org.omg.ETF.Profile;

public class ServerIIOPConnection
extends IIOPConnection {
    private final TCPConnectionListener tcpListener;
    private final Object inputStreamLock = new Object();
    private final Object outputStreamLock = new Object();

    public ServerIIOPConnection(Socket socket, boolean is_ssl, TCPConnectionListener tcpListener) throws IOException {
        this.socket = socket;
        this.use_ssl = is_ssl;
        this.in_stream = null;
        this.out_stream = null;
        this.tcpListener = tcpListener;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        IIOPAddress address = new IIOPAddress(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
        address.configure(configuration);
        this.profile = new IIOPProfile(address, null);
        this.profile.configure(configuration);
        this.connection_info = address.toString();
        this.connected = true;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Opened new server-side TCP/IP transport to " + this.connection_info);
        }
    }

    public synchronized void close() {
        if (this.socket != null) {
            try {
                try {
                    IOException exception = null;
                    try {
                        if (!(this.socket instanceof SSLSocket) && !this.socket.isClosed()) {
                            this.socket.shutdownOutput();
                        }
                    }
                    catch (IOException ex) {
                        this.logger.warn("ServerIIOPConnection - Unexpected exception is thrown during socket.shutdownOutput call", ex);
                        exception = ex;
                    }
                    this.socket.close();
                    if (this.in_stream != null) {
                        this.in_stream.close();
                    }
                    if (this.out_stream != null) {
                        this.out_stream.close();
                    }
                    if (exception != null) {
                        throw exception;
                    }
                    Object var4_4 = null;
                    if (this.tcpListener.isListenerEnabled()) {
                        this.tcpListener.connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
                    }
                }
                catch (IOException ex) {
                    throw this.handleCommFailure(ex);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this.tcpListener.isListenerEnabled()) {
                    this.tcpListener.connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
                }
                throw throwable;
            }
        }
        this.socket = null;
        this.connected = false;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Closed server-side transport to " + this.connection_info);
        }
    }

    public void connect(Profile server_profile, long time_out) {
    }

    public void read(BufferHolder data, int offset, int min_length, int max_length, long time_out) {
        this.initialiseInputStream();
        super.read(data, offset, min_length, max_length, time_out);
    }

    public boolean is_data_available() {
        this.initialiseInputStream();
        return super.is_data_available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseInputStream() {
        Object object = this.inputStreamLock;
        synchronized (object) {
            if (this.in_stream == null) {
                try {
                    this.in_stream = this.socket.getInputStream();
                }
                catch (IOException ioe) {
                    this.logger.error(this + " :: unable to perform lazy initialisation of in_stream", ioe);
                    throw new COMM_FAILURE("Unable to lazily initialise input stream");
                }
            }
        }
    }

    public void write(boolean is_first, boolean is_last, byte[] data, int offset, int length, long time_out) {
        this.initialiseOutputStream();
        super.write(is_first, is_last, data, offset, length, time_out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseOutputStream() {
        Object object = this.outputStreamLock;
        synchronized (object) {
            if (this.out_stream == null) {
                try {
                    this.out_stream = this.socket.getOutputStream();
                }
                catch (IOException ioe) {
                    this.logger.error(this + " :: unable to perform lazy initialisation of out_stream", ioe);
                    throw new COMM_FAILURE("Unable to lazily initialise output stream");
                }
            }
        }
    }
}

