/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.etf.ProfileBaseOperations;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.RequestOutputStream;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.RequestInfoImpl;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TypeCode;
import org.omg.Dynamic.Parameter;
import org.omg.ETF.Profile;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;
import org.omg.PortableInterceptor.ClientRequestInfo;

public class ClientRequestInfoImpl
extends RequestInfoImpl
implements ClientRequestInfo {
    private static final String KEY_EXPIRATION_TIME = "ft_expiration_time";
    private final Logger logger;
    private final Object target;
    private final Object effective_target;
    private final TaggedProfile effective_profile;
    private final TaggedComponent[] effective_components;
    public final Any received_exception;
    public String received_exception_id;
    public final Delegate delegate;
    public final ORB orb;
    public final RequestOutputStream request_os;
    public ReplyInputStream reply_is;
    public final ClientConnection connection;
    private final Map invocationContext;

    public ClientRequestInfoImpl(ORB orb, ClientRequestInfoImpl original, RequestOutputStream ros, Object self, Delegate delegate, ParsedIOR piorOriginal, ClientConnection connection, Map invocationContext) {
        boolean spsShow;
        this.orb = orb;
        this.logger = orb.getConfiguration().getNamedLogger("jacorb.orb.interceptors");
        this.operation = ros.operation();
        this.response_expected = ros.response_expected();
        this.received_exception = orb.create_any();
        this.sync_scope = ros.syncScope();
        if (ros.getRequest() != null) {
            this.setRequest(ros.getRequest());
        }
        this.effective_target = self;
        ParsedIOR pior = delegate.getParsedIOR();
        this.target = piorOriginal == null ? self : orb._getDelegate(piorOriginal);
        Profile profile = pior.getEffectiveProfile();
        String spsVal = System.getProperty("ShowProfileSelection");
        boolean bl = spsShow = spsVal != null && spsVal.equals("1");
        if (spsShow) {
            System.out.println("[JAC824] ClientRequestInfoImpl(1): profile class is " + profile.getClass().getName());
        }
        if (profile instanceof ProfileBaseOperations) {
            if (spsShow) {
                System.out.println("[JAC824] ClientRequestInfoImpl(1): profile is instance of ProfileBaseOperations");
            }
            ProfileBaseOperations profileBase = (ProfileBaseOperations)profile;
            this.effective_profile = profileBase.asTaggedProfile();
            this.effective_components = profileBase.getComponents() == null ? new TaggedComponent[]{} : profileBase.getComponents().asArray();
        } else {
            if (spsShow) {
                System.out.println("[JAC824] ClientRequestInfoImpl(1): profile is NOT instance of ProfileBaseOperations");
            }
            this.effective_components = new TaggedComponent[0];
            this.effective_profile = null;
        }
        this.delegate = delegate;
        this.request_id = ros.requestId();
        InterceptorManager manager = orb.getInterceptorManager();
        this.current = manager.getCurrent();
        this.request_os = ros;
        this.connection = connection;
        if (original != null && original.forward_reference != null) {
            this.forward_reference = original.forward_reference;
        }
        this.invocationContext = invocationContext;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("created with invocationContext: " + invocationContext);
        }
    }

    public ClientRequestInfoImpl(ORB orb, String operation, boolean response_expected, short sync_scope, Object self, Delegate delegate, ParsedIOR piorOriginal, Map invocationContext) {
        boolean spsShow;
        this.orb = orb;
        this.logger = orb.getConfiguration().getNamedLogger("jacorb.orb.interceptors");
        this.operation = operation;
        this.response_expected = response_expected;
        this.received_exception = orb.create_any();
        this.sync_scope = sync_scope;
        this.effective_target = self;
        ParsedIOR pior = delegate.getParsedIOR();
        this.target = piorOriginal == null ? self : orb._getDelegate(piorOriginal);
        Profile profile = pior.getEffectiveProfile();
        String spsVal = System.getProperty("ShowProfileSelection");
        boolean bl = spsShow = spsVal != null && spsVal.equals("1");
        if (spsShow) {
            System.out.println("[JAC824] ClientRequestInfoImpl(2): profile class is " + profile.getClass().getName());
        }
        if (profile instanceof ProfileBaseOperations) {
            if (spsShow) {
                System.out.println("[JAC824] ClientRequestInfoImpl(2): profile is instance of ProfileBaseOperations");
            }
            ProfileBaseOperations profileBase = (ProfileBaseOperations)profile;
            this.effective_profile = profileBase.asTaggedProfile();
            this.effective_components = profileBase.getComponents() == null ? new TaggedComponent[]{} : profileBase.getComponents().asArray();
        } else {
            if (spsShow) {
                System.out.println("[JAC824] ClientRequestInfoImpl(2): profile is instance of ProfileBaseOperations");
            }
            this.effective_components = new TaggedComponent[0];
            this.effective_profile = null;
        }
        this.delegate = delegate;
        this.invocationContext = invocationContext;
        InterceptorManager manager = orb.getInterceptorManager();
        this.current = manager.getCurrent();
        this.request_os = null;
        this.connection = null;
    }

    public final void setRequest(Request request) {
        this.arguments = new Parameter[request.arguments.count()];
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            try {
                NamedValue value = request.arguments.item(i2);
                ParameterMode mode = null;
                if (value.flags() == 1) {
                    mode = ParameterMode.PARAM_IN;
                } else if (value.flags() == 2) {
                    mode = ParameterMode.PARAM_OUT;
                } else if (value.flags() == 3) {
                    mode = ParameterMode.PARAM_INOUT;
                }
                this.arguments[i2] = new Parameter(value.value(), mode);
                continue;
            }
            catch (Exception e2) {
                this.logger.debug("unexpected exception", e2);
            }
        }
    }

    public Iterator getRequestServiceContexts() {
        return this.request_ctx.values().iterator();
    }

    public Parameter[] arguments() {
        if (this.caller_op != 0 && this.caller_op != 2) {
            throw new BAD_INV_ORDER("The attribute \"arguments\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.arguments == null) {
            throw new NO_RESOURCES("Stream-based skeletons/stubs do not support this op", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.arguments;
    }

    public TypeCode[] exceptions() {
        if (this.caller_op == 1) {
            throw new BAD_INV_ORDER("The attribute \"exceptions\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.exceptions == null) {
            throw new NO_RESOURCES("Stream-based skeletons/stubs do not support this op", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.exceptions;
    }

    public Any result() {
        if (this.caller_op != 2) {
            throw new BAD_INV_ORDER("The attribute \"result\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.result == null) {
            throw new NO_RESOURCES("Stream-based skeletons/stubs do not support this op", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.result;
    }

    public short sync_scope() {
        if (this.caller_op == 1) {
            throw new BAD_INV_ORDER("The attribute \"sync_scope\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.sync_scope;
    }

    public short reply_status() {
        if (this.caller_op == 0 || this.caller_op == 1) {
            throw new BAD_INV_ORDER("The attribute \"reply_status\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.reply_status;
    }

    public Object forward_reference() {
        if (this.caller_op != 0 && this.caller_op != 4 && this.reply_status != 3) {
            throw new BAD_INV_ORDER("The attribute \"forward_reference\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.forward_reference;
    }

    public ServiceContext get_request_service_context(int id) {
        if (this.caller_op == 1) {
            throw new BAD_INV_ORDER("The attribute \"operation_context\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return super.get_request_service_context(id);
    }

    public ServiceContext get_reply_service_context(int id) {
        if (this.caller_op == 0 || this.caller_op == 1) {
            throw new BAD_INV_ORDER("The attribute \"reply_status\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return super.get_reply_service_context(id);
    }

    public Object target() {
        return this.target;
    }

    public Object effective_target() {
        return this.effective_target;
    }

    public TaggedProfile effective_profile() {
        return this.effective_profile;
    }

    public Any received_exception() {
        if (this.caller_op != 3) {
            throw new BAD_INV_ORDER("The attribute \"received_exception\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.received_exception;
    }

    public String received_exception_id() {
        if (this.caller_op != 3) {
            throw new BAD_INV_ORDER("The attribute \"received_exception_id\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.received_exception_id;
    }

    public TaggedComponent get_effective_component(int id) {
        if (this.caller_op == 1) {
            throw new BAD_INV_ORDER("The operation \"get_effective_component\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        for (int _i = 0; _i < this.effective_components.length; ++_i) {
            if (this.effective_components[_i].tag != id) continue;
            return this.effective_components[_i];
        }
        throw new BAD_PARAM("No TaggedComponent with id " + id + " found", 25, CompletionStatus.COMPLETED_MAYBE);
    }

    public TaggedComponent[] get_effective_components(int id) {
        if (this.caller_op == 1) {
            throw new BAD_INV_ORDER("The operation \"get_effective_components\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        ArrayList<TaggedComponent> _store = new ArrayList<TaggedComponent>();
        for (int _i = 0; _i < this.effective_components.length; ++_i) {
            if (this.effective_components[_i].tag != id) continue;
            _store.add(this.effective_components[_i]);
        }
        if (_store.size() == 0) {
            throw new BAD_PARAM("No TaggedComponents with id " + id + " found", 25, CompletionStatus.COMPLETED_MAYBE);
        }
        TaggedComponent[] _result = new TaggedComponent[_store.size()];
        for (int _i = 0; _i < _result.length; ++_i) {
            _result[_i] = (TaggedComponent)_store.get(_i);
        }
        return _result;
    }

    public Policy get_request_policy(int type) {
        if (this.caller_op == 1) {
            throw new BAD_INV_ORDER("The operation \"get_request_policy\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        if (!this.orb.hasPolicyFactoryForType(type)) {
            throw new INV_POLICY("No PolicyFactory for type " + type + " has been registered!", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        try {
            return this.delegate.get_policy(this.target, type);
        }
        catch (INV_POLICY e2) {
            e2.minor = 1;
            throw e2;
        }
    }

    public void add_request_service_context(ServiceContext service_context, boolean replace) {
        if (this.caller_op != 0) {
            throw new BAD_INV_ORDER("The operation \"add_request_service_context\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        Integer _id = ObjectUtil.newInteger(service_context.context_id);
        if (!replace && this.request_ctx.containsKey(_id)) {
            throw new BAD_INV_ORDER("The ServiceContext with id " + _id.toString() + " has already been set!", 11, CompletionStatus.COMPLETED_MAYBE);
        }
        this.request_ctx.put(_id, service_context);
    }

    public boolean hasFtExpirationTime() {
        return this.invocationContext.containsKey(KEY_EXPIRATION_TIME);
    }

    public long getFtExpirationTime() {
        Long value = (Long)this.invocationContext.get(KEY_EXPIRATION_TIME);
        if (value == null) {
            throw new BAD_INV_ORDER();
        }
        return value;
    }

    public void setFtExpirationTime(long time) {
        this.invocationContext.put(KEY_EXPIRATION_TIME, new Long(time));
    }

    public int getFtRetentionId() {
        Integer value = (Integer)this.invocationContext.get("ft_retention_id");
        if (value == null) {
            throw new BAD_INV_ORDER();
        }
        return value;
    }

    public void setFtRetentionId(int id) {
        this.invocationContext.put("ft_retention_id", ObjectUtil.newInteger(id));
    }
}

