/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.orb.util.CorbaLoc;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.FT.TagFTGroupTaggedComponent;
import org.omg.FT.TagFTGroupTaggedComponentHelper;
import org.omg.FT.TagFTHeartbeatEnabledTaggedComponent;
import org.omg.FT.TagFTHeartbeatEnabledTaggedComponentHelper;
import org.omg.FT.TagFTPrimaryTaggedComponent;
import org.omg.FT.TagFTPrimaryTaggedComponentHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableGroup.TagGroupTaggedComponent;
import org.omg.PortableGroup.TagGroupTaggedComponentHelper;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class PrintIOR {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        org.omg.CORBA.ORB orb;
        block16: {
            orb = org.omg.CORBA.ORB.init(args, null);
            ORB jorb = (ORB)orb;
            Logger logger = jorb.getConfiguration().getNamedLogger("jacorb.print_ior");
            boolean urlForm = false;
            String iorString = null;
            String file = null;
            if (args.length < 2 || args.length > 3) {
                PrintIOR.usage();
            }
            for (int i2 = 0; i2 < args.length; ++i2) {
                if ("-u".equals(args[i2])) {
                    urlForm = true;
                    continue;
                }
                if ("-i".equals(args[i2])) {
                    iorString = args[i2 + 1];
                    ++i2;
                    continue;
                }
                if ("-f".equals(args[i2])) {
                    file = args[i2 + 1];
                    ++i2;
                    continue;
                }
                PrintIOR.usage();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Under " + System.getProperty("os.name") + " the encoding name is " + System.getProperty("file.encoding") + " and the canonical encoding name is " + new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
            }
            PrintWriter out = new PrintWriter(System.out, true);
            try {
                if (iorString != null) {
                    PrintIOR.printIOR(jorb, urlForm, iorString, out);
                    break block16;
                }
                if (file != null) {
                    LineNumberReader in = new LineNumberReader(new BufferedReader(new FileReader(file)));
                    try {
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            PrintIOR.printIOR(jorb, urlForm, line, out);
                        }
                        break block16;
                    }
                    finally {
                        in.close();
                    }
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            finally {
                out.flush();
            }
        }
        orb.shutdown(true);
    }

    private static void printIOR(ORB jorb, boolean urlForm, String iorString, PrintWriter out) {
        if (iorString.startsWith("IOR:")) {
            ParsedIOR pior = new ParsedIOR(jorb, iorString);
            if (urlForm) {
                out.println(CorbaLoc.parseKey(pior.get_object_key()));
            } else {
                PrintIOR.printIOR(jorb, pior, out);
            }
        } else {
            out.println("Sorry, we only unparse IORs in the standard IOR URL scheme");
        }
    }

    private static void usage() {
        System.err.println("Usage: java PrintIOR [ -i ior_str ] [ -f filename] [-u]\n\tior_str\t IOR as String\n\t-f\t reads one or more IOR's from the file <filename>\n\t-u\t extract object key in URL-Form instead of HEX ");
        System.exit(1);
    }

    public static void printIOR(org.omg.CORBA.ORB orb, ParsedIOR pior, PrintWriter out) {
        IOR ior = pior.getIOR();
        out.println("------IOR components-----");
        out.println("TypeId\t:\t" + ior.type_id);
        List profiles = pior.getProfiles();
        out.println("TAG_INTERNET_IOP Profiles:");
        for (int i2 = 0; i2 < profiles.size(); ++i2) {
            out.println("\tProfile Id:\t\t" + i2);
            ProfileBase profile = (ProfileBase)profiles.get(i2);
            out.println("\tIIOP Version:\t\t" + profile.version().major + "." + profile.version().minor);
            if (profile instanceof IIOPProfile) {
                IIOPProfile ip = (IIOPProfile)profile;
                out.println("\tHost:\t\t\t" + ((IIOPAddress)ip.getAddress()).getOriginalHost());
                int port = ((IIOPAddress)ip.getAddress()).getPort();
                if (port < 0) {
                    port += 65536;
                }
                out.println("\tPort:\t\t\t" + port);
            } else if (profile instanceof MIOPProfile) {
                out.println("MIOPProfile:\t" + ((MIOPProfile)profile).toString());
            }
            out.println("\tObject key (URL):\t" + CorbaLoc.parseKey(profile.get_object_key()));
            out.print("\tObject key (hex):\t0x");
            PrintIOR.dumpHex(profile.get_object_key(), out);
            out.println();
            if (profile.version().minor >= 1) {
                if (profile.getComponents().size() > 0) {
                    out.println("\t-- Found " + profile.getComponents().size() + " Tagged Components--");
                }
                PrintIOR.printTaggedComponents(orb, profile.getComponents().asArray(), out);
            }
            out.print("\n");
        }
        TaggedComponentList multiple_components = pior.getMultipleComponents();
        if (multiple_components.size() > 0) {
            out.println("Components in MULTIPLE_COMPONENTS profile: " + multiple_components.size());
            PrintIOR.printTaggedComponents(orb, multiple_components.asArray(), out);
        }
        for (int i3 = 0; i3 < ior.profiles.length; ++i3) {
            int tag = ior.profiles[i3].tag;
            boolean found = false;
            for (int j2 = 0; j2 < profiles.size(); ++j2) {
                ProfileBase profile = (ProfileBase)profiles.get(j2);
                if (profile.tag() == tag) {
                    found = true;
                }
                if (tag != 1) continue;
                found = true;
            }
            if (found) continue;
            out.println("Unknown profile found with tag " + tag);
        }
    }

    private static void printTaggedComponents(org.omg.CORBA.ORB orb, TaggedComponent[] taggedComponents, PrintWriter out) {
        block15: for (int i2 = 0; i2 < taggedComponents.length; ++i2) {
            switch (taggedComponents[i2].tag) {
                case 20: {
                    out.println("\t#" + i2 + ": TAG_SSL_SEC_TRANS");
                    PrintIOR.printSSLTaggedComponent(taggedComponents[i2], out);
                    continue block15;
                }
                case 33: {
                    out.println("\t#" + i2 + ": TAG_CSI_SEC_MECH_LIST");
                    PrintIOR.printCSIMechComponent(taggedComponents[i2], out);
                    continue block15;
                }
                case 35: {
                    out.println("\t#" + i2 + ": TAG_SECIOP_SEC_TRANS");
                    continue block15;
                }
                case 3: {
                    out.println("\t#" + i2 + ": TAG_ALTERNATE_IIOP_ADDRESS");
                    PrintIOR.printAlternateAddress(orb, taggedComponents[i2], out);
                    continue block15;
                }
                case 1: {
                    out.println("\t#" + i2 + ": TAG_CODE_SETS");
                    PrintIOR.printCodeSetComponent(taggedComponents[i2], out);
                    continue block15;
                }
                case 25: {
                    out.println("\t#" + i2 + ": TAG_JAVA_CODEBASE");
                    PrintIOR.printJavaCodebaseComponent(taggedComponents[i2], out);
                    continue block15;
                }
                case 0: {
                    out.println("\t#" + i2 + ": TAG_ORB_TYPE");
                    PrintIOR.printOrbTypeComponent(taggedComponents[i2], out);
                    continue block15;
                }
                case 2: {
                    out.println("\t#" + i2 + ": TAG_POLICIES");
                    PrintIOR.printPolicyComponent(taggedComponents[i2], out);
                    continue block15;
                }
                case 34: {
                    out.println("\t#" + i2 + ": TAG_NULL_TAG");
                    continue block15;
                }
                case 39: {
                    out.println("\t#" + i2 + ": TAG_GROUP");
                    PrintIOR.printTagGroupTaggedComponent(taggedComponents[i2], out);
                    continue block15;
                }
                case 27: {
                    out.println("\t#" + i2 + ": TAG_FT_GROUP");
                    PrintIOR.printFTGroupComponent(taggedComponents[i2], out);
                    continue block15;
                }
                case 28: {
                    out.println("\t#" + i2 + ": TAG_FT_PRIMARY");
                    PrintIOR.printFTPrimaryComponent(taggedComponents[i2], out);
                    continue block15;
                }
                case 29: {
                    out.println("\t#" + i2 + ": TAG_FT_HEARTBEAT_ENABLED");
                    PrintIOR.printFTHeartbeatEnabled(taggedComponents[i2], out);
                    continue block15;
                }
                default: {
                    out.println("\tUnknown tag : " + taggedComponents[i2].tag);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printFTHeartbeatEnabled(TaggedComponent component, PrintWriter out) {
        CDRInputStream in = new CDRInputStream(component.component_data);
        try {
            in.openEncapsulatedArray();
            TagFTHeartbeatEnabledTaggedComponent value = TagFTHeartbeatEnabledTaggedComponentHelper.read(in);
            out.println("\t\tHeartbeat support enabled: " + value.heartbeat_enabled);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printFTPrimaryComponent(TaggedComponent component, PrintWriter out) {
        CDRInputStream in = new CDRInputStream(component.component_data);
        try {
            in.openEncapsulatedArray();
            TagFTPrimaryTaggedComponent ftPrimaryTag = TagFTPrimaryTaggedComponentHelper.read(in);
            out.println("\t\tprimary object: " + ftPrimaryTag.primary);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printFTGroupComponent(TaggedComponent component, PrintWriter out) {
        CDRInputStream in = new CDRInputStream(component.component_data);
        try {
            in.openEncapsulatedArray();
            TagFTGroupTaggedComponent ftGroupTag = TagFTGroupTaggedComponentHelper.read(in);
            out.println("\t\tversion: " + ftGroupTag.version.major + "." + ftGroupTag.version.minor);
            out.println("\t\tdomain id: " + ftGroupTag.ft_domain_id);
            out.println("\t\tobject group id: " + ftGroupTag.object_group_id);
            out.println("\t\treference version: " + ftGroupTag.object_group_ref_version);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printCSIMechComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(taggedComponent.component_data);
        try {
            is.openEncapsulatedArray();
            CompoundSecMechList csmList = CompoundSecMechListHelper.read(is);
            if (csmList != null) {
                out.println("\t\tis stateful: " + csmList.stateful);
                for (int i2 = 0; i2 < csmList.mechanism_list.length; ++i2) {
                    out.println("\t\tCompoundSecMech #" + i2);
                    out.println("\t\t\ttarget_requires: " + csmList.mechanism_list[i2].target_requires);
                    out.print("\t\t\ttransport mechanism tag: ");
                    switch (csmList.mechanism_list[i2].transport_mech.tag) {
                        case 36: {
                            out.println("TAG_TLS_SEC_TRANS");
                            PrintIOR.printTlsSecTrans(csmList.mechanism_list[i2].transport_mech.component_data, out);
                            break;
                        }
                        case 34: {
                            out.println("TAG_NULL_TAG");
                            break;
                        }
                        default: {
                            out.println("Unknown tag : " + csmList.mechanism_list[i2].transport_mech.tag);
                        }
                    }
                    out.println("\t\t\tAS_ContextSec target_supports: " + csmList.mechanism_list[i2].as_context_mech.target_supports);
                    out.println("\t\t\tAS_ContextSec target_requires: " + csmList.mechanism_list[i2].as_context_mech.target_requires);
                    out.print("\t\t\tAS_ContextSec mech: ");
                    PrintIOR.dumpHex(csmList.mechanism_list[i2].as_context_mech.client_authentication_mech, out);
                    out.println();
                    out.print("\t\t\tAS_ContextSec target_name: ");
                    PrintIOR.printNTExportedName(csmList.mechanism_list[i2].as_context_mech.target_name, out);
                    out.println("\t\t\tSAS_ContextSec target_supports: " + csmList.mechanism_list[i2].sas_context_mech.target_supports);
                    out.println("\t\t\tSAS_ContextSec target_requires: " + csmList.mechanism_list[i2].sas_context_mech.target_requires);
                    for (int j2 = 0; j2 < csmList.mechanism_list[i2].sas_context_mech.supported_naming_mechanisms.length; ++j2) {
                        out.print("\t\t\tSAS_ContextSec Naming mech: ");
                        PrintIOR.dumpHex(csmList.mechanism_list[i2].sas_context_mech.supported_naming_mechanisms[j2], out);
                        out.println();
                    }
                    out.println("\t\t\tSAS_ContextSec Naming types: " + csmList.mechanism_list[i2].sas_context_mech.supported_identity_types);
                    out.println();
                }
            }
        }
        finally {
            is.close();
        }
    }

    private static void printNTExportedName(byte[] nameData, PrintWriter out) {
        if (nameData.length < 2 || nameData[0] != 4 || nameData[1] != 1) {
            PrintIOR.dumpHex(nameData, out);
            out.println();
            return;
        }
        int mechLen = (nameData[2] << 8) + nameData[3];
        if (mechLen > nameData.length - 8) {
            PrintIOR.dumpHex(nameData, out);
            out.println();
            return;
        }
        int nameLen = (nameData[mechLen + 4] << 24) + (nameData[mechLen + 5] << 16) + (nameData[mechLen + 6] << 8) + nameData[mechLen + 7];
        if (mechLen + nameLen > nameData.length - 8) {
            PrintIOR.dumpHex(nameData, out);
            out.println();
            return;
        }
        byte[] name = new byte[nameLen];
        System.arraycopy(nameData, mechLen + 8, name, 0, nameLen);
        out.println(new String(name));
    }

    private static void printTlsSecTrans(byte[] tagData, PrintWriter out) {
        CDRInputStream in = new CDRInputStream(tagData);
        try {
            in.openEncapsulatedArray();
            TLS_SEC_TRANS tls = TLS_SEC_TRANSHelper.read(in);
            out.println("\t\t\tTLS SEC TRANS target requires: " + tls.target_requires);
            out.println("\t\t\tTLS SEC TRANS target supports: " + tls.target_supports);
            for (int i2 = 0; i2 < tls.addresses.length; ++i2) {
                int ssl_port = tls.addresses[i2].port;
                if (ssl_port < 0) {
                    ssl_port += 65536;
                }
                out.println("\t\t\tTLS SEC TRANS address: " + tls.addresses[i2].host_name + ":" + ssl_port);
            }
        }
        catch (Exception ex) {
            out.print("\t\t\tTLS SEC TRANS: ");
            PrintIOR.dumpHex(tagData, out);
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printCodeSetComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(taggedComponent.component_data);
        try {
            is.openEncapsulatedArray();
            CodeSetComponentInfo codeSet = CodeSetComponentInfoHelper.read(is);
            if (codeSet != null) {
                int ji;
                out.println("\t\tForChar native code set Id:  " + CodeSet.csName(codeSet.ForCharData.native_code_set));
                out.print("\t\tChar Conversion Code Sets: ");
                for (ji = 0; ji < codeSet.ForCharData.conversion_code_sets.length; ++ji) {
                    out.print(CodeSet.csName(codeSet.ForCharData.conversion_code_sets[ji]));
                    if (ji >= codeSet.ForCharData.conversion_code_sets.length - 1) continue;
                    out.print(" , ");
                }
                out.print("\n");
                out.println("\t\tForWChar native code set Id: " + CodeSet.csName(codeSet.ForWcharData.native_code_set));
                out.print("\t\tWChar Conversion Code Sets: ");
                for (ji = 0; ji < codeSet.ForWcharData.conversion_code_sets.length; ++ji) {
                    out.print(CodeSet.csName(codeSet.ForWcharData.conversion_code_sets[ji]));
                    if (ji >= codeSet.ForWcharData.conversion_code_sets.length - 1) continue;
                    out.print(" , ");
                }
                out.print("\n");
            }
        }
        finally {
            is.close();
        }
    }

    private static void printSSLTaggedComponent(TaggedComponent taggedComponent, PrintWriter out) {
        SSL ssl = null;
        if (taggedComponent.tag == 20) {
            CDRInputStream in = new CDRInputStream(taggedComponent.component_data);
            try {
                in.openEncapsulatedArray();
                ssl = SSLHelper.read(in);
            }
            catch (Exception ex) {
                return;
            }
            int ssl_port = ssl.port;
            if (ssl_port < 0) {
                ssl_port += 65536;
            }
            out.print("\t\ttarget_supports\t:\t");
            PrintIOR.decodeAssociationOption(ssl.target_supports, out);
            out.println();
            out.print("\t\ttarget_requires\t:\t");
            PrintIOR.decodeAssociationOption(ssl.target_requires, out);
            out.println();
            out.println("\t\tSSL Port\t:\t" + ssl_port);
        }
    }

    private static void decodeAssociationOption(int option, PrintWriter out) {
        boolean first = true;
        if ((option & 1) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("NoProtection");
            first = false;
        }
        if ((option & 2) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("Integrity");
            first = false;
        }
        if ((option & 4) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("Confidentiality");
            first = false;
        }
        if ((option & 8) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("DetectReplay");
            first = false;
        }
        if ((option & 0x10) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("DetectMisordering");
            first = false;
        }
        if ((option & 0x20) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("EstablishTrustInTarget");
            first = false;
        }
        if ((option & 0x40) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("EstablishTrustInClient");
            first = false;
        }
        if ((option & 0x80) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("NoDelegation");
            first = false;
        }
        if ((option & 0x100) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("SimpleDelegation");
            first = false;
        }
        if ((option & 0x200) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("CompositeDelegation");
            first = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printJavaCodebaseComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream in = new CDRInputStream(taggedComponent.component_data);
        try {
            in.openEncapsulatedArray();
            String codebase = in.read_string();
            out.println("\t\tCodebase: " + codebase);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printOrbTypeComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(taggedComponent.component_data);
        try {
            is.openEncapsulatedArray();
            int type = is.read_long();
            out.print("\t\tType: " + type);
            if (type == 1245790976) {
                out.println(" (JacORB)");
            } else if (type == 1230266177) {
                out.println(" (Orbix)");
            } else if (type == 1447645952) {
                out.println(" (Visibroker)");
            } else if (type == 1096045568) {
                out.println(" (omniORB)");
            } else if (type == 1413566208) {
                out.println(" (TAO)");
            } else {
                out.println(" (Foreign)");
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printAlternateAddress(org.omg.CORBA.ORB orb, TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(taggedComponent.component_data);
        try {
            is.openEncapsulatedArray();
            String hostname = is.read_string();
            short port = is.read_ushort();
            IIOPAddress result = new IIOPAddress(hostname, port);
            try {
                result.configure(((ORB)orb).getConfiguration());
            }
            catch (ConfigurationException ce) {
                ((ORB)orb).getConfiguration().getNamedLogger("PrintIOR").warn("ConfigurationException", ce);
            }
            out.println("\t\tAddress: " + result.toString());
        }
        finally {
            is.close();
        }
    }

    private static void printTagGroupTaggedComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(null, taggedComponent.component_data);
        is.openEncapsulatedArray();
        TagGroupTaggedComponent tagGroup = TagGroupTaggedComponentHelper.read(is);
        is.close();
        out.println("\t\tVersion: " + tagGroup.component_version.major + ":" + tagGroup.component_version.minor);
        out.println("\t\tDomain: " + tagGroup.group_domain_id);
        out.println("\t\tObjectGroupID: " + tagGroup.object_group_id);
        out.println("\t\tObject Version: " + tagGroup.object_group_ref_version);
    }

    private static void dumpHex(byte[] values, PrintWriter out) {
        for (int i2 = 0; i2 < values.length; ++i2) {
            int n1 = (values[i2] & 0xFF) / 16;
            int n2 = (values[i2] & 0xFF) % 16;
            char c1 = (char)(n1 > 9 ? 65 + (n1 - 10) : 48 + n1);
            char c2 = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
            out.print(c1);
            out.print(c2);
            out.print(' ');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printPolicyComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(taggedComponent.component_data);
        try {
            int count = 0;
            is.openEncapsulatedArray();
            int len = is.read_long();
            while (len-- != 0) {
                int val = is.read_long();
                out.print("\t\t#" + count++ + ": ");
                is.openEncapsulation();
                switch (val) {
                    case 45: {
                        out.println("RTCORBA::PRIORITY_BANDED_CONNECTION");
                        val = is.read_long();
                        for (long i2 = 0L; i2 < (long)val; ++i2) {
                            short low = is.read_short();
                            short high = is.read_short();
                            out.println("\t\t\tBand " + i2 + ": " + low + "-" + high);
                        }
                        break;
                    }
                    case 40: {
                        out.print("RTCORBA::PRIORITY_MODEL");
                        val = is.read_long();
                        switch (val) {
                            case 0: {
                                out.print(" (CLIENT_PROPAGATED, ");
                                break;
                            }
                            case 1: {
                                out.print(" (SERVER_DECLARED, ");
                                break;
                            }
                            default: {
                                out.print(" (Unknown, ");
                            }
                        }
                        short prio = is.read_short();
                        out.println(prio + ")");
                        break;
                    }
                    default: {
                        out.println("Unknown (" + val + ")");
                    }
                }
                is.closeEncapsulation();
            }
        }
        finally {
            is.close();
        }
    }

    static {
        $assertionsDisabled = !PrintIOR.class.desiredAssertionStatus();
    }
}

