/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.jacorb.util.IntegerFactory;
import org.jacorb.util.JDK14IntegerFactory;

public class ObjectUtil {
    private static final IntegerFactory integerFactory;
    public static final boolean isAtLeastJDK15;
    private static final char[] HEX_LOOKUP;

    private ObjectUtil() {
    }

    private static IntegerFactory getIntegerFactory() {
        Class clazz;
        Class clazz2 = clazz = JDK14IntegerFactory.class;
        if (isAtLeastJDK15) {
            try {
                clazz = ObjectUtil.classForName("org.jacorb.util.JDK15IntegerFactory");
            }
            catch (IllegalArgumentException e2) {
            }
            catch (ClassNotFoundException e3) {
                // empty catch block
            }
        }
        try {
            return (IntegerFactory)clazz.newInstance();
        }
        catch (InstantiationException e4) {
            e4.printStackTrace();
        }
        catch (IllegalAccessException e5) {
            e5.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readURL(String url) throws IOException {
        BufferedReader reader = new BufferedReader(ObjectUtil.newInputStreamReader(url));
        try {
            String string = reader.readLine();
            return string;
        }
        finally {
            reader.close();
        }
    }

    private static InputStreamReader newInputStreamReader(String url) throws MalformedURLException, IOException {
        String token = "file://";
        InputStreamReader isr = null;
        if (url.startsWith(token)) {
            try {
                isr = new FileReader(url.substring(token.length()));
            }
            catch (Exception e2) {
                System.out.println("Tried and failed to open file: " + url.substring(token.length()));
            }
        }
        if (isr == null) {
            URL urlCopy = new URL(url);
            isr = new InputStreamReader(urlCopy.openStream());
        }
        return isr;
    }

    public static Class classForName(String name) throws ClassNotFoundException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Class name must not be null!");
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e2) {
            return Class.forName(name);
        }
    }

    public static String bufToString(byte[] values, int start, int len) {
        StringBuffer result = new StringBuffer();
        StringBuffer chars = new StringBuffer();
        for (int i2 = start; i2 < start + len; ++i2) {
            if (i2 % 16 == 0) {
                result.append(chars.toString());
                result.append('\n');
                chars.setLength(0);
            }
            chars.append(ObjectUtil.toAscii(values[i2]));
            result.append(ObjectUtil.toHex(values[i2]));
            if (i2 % 4 != 3) continue;
            chars.append(' ');
            result.append(' ');
        }
        if (len % 16 != 0) {
            int pad = 0;
            int delta_bytes = 16 - len % 16;
            pad = delta_bytes * 3;
            pad += delta_bytes / 4;
            if (delta_bytes % 4 > 0) {
                ++pad;
            }
            for (int i3 = 0; i3 < pad; ++i3) {
                chars.insert(0, ' ');
            }
        }
        result.append(chars.toString());
        return result.toString();
    }

    public static void appendHex(StringBuffer buffer, int value) {
        buffer.append(HEX_LOOKUP[value]);
    }

    public static final String toHex(byte value) {
        StringBuffer buffer = new StringBuffer();
        int upper = value >> 4 & 0xF;
        ObjectUtil.appendHex(buffer, upper);
        int lower = value & 0xF;
        ObjectUtil.appendHex(buffer, lower);
        buffer.append(' ');
        return buffer.toString();
    }

    public static final char toAscii(byte value) {
        if (value > 31 && value < 127) {
            return (char)value;
        }
        return '.';
    }

    public static Properties argsToProps(String[] args) {
        Properties props = new Properties();
        for (int i2 = 0; i2 < args.length; ++i2) {
            int idx;
            if (!args[i2].startsWith("-D") || (idx = args[i2].indexOf(61)) < 3) continue;
            String key = args[i2].substring(2, idx);
            props.put(key, args[i2].substring(idx + 1));
        }
        return props;
    }

    public static URL getResource(String name) {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader().getResource(name);
        }
        return ObjectUtil.class.getResource(name);
    }

    public static Integer newInteger(int value) {
        return integerFactory.newInteger(value);
    }

    static {
        HEX_LOOKUP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String javaVersion = System.getProperty("java.specification.version");
        isAtLeastJDK15 = javaVersion.equals("1.5") || javaVersion.equals("1.6");
        integerFactory = ObjectUtil.getIntegerFactory();
    }
}

