/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe;

import javax.swing.JComponent;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.swe.LdnMvcContainer;
import se.ericsson.cello.swe.controller.CvSweController;
import se.ericsson.cello.swe.controller.CvSweControllerFactory;
import se.ericsson.cello.swe.model.CvSweModel;
import se.ericsson.cello.swe.model.CvSweModelFactory;
import se.ericsson.cello.swe.service.Configuration;
import se.ericsson.cello.swe.service.SweToolServiceFactory;
import se.ericsson.cello.swe.service.SweToolServices;
import se.ericsson.cello.swe.view.CvSweView;
import se.ericsson.cello.swe.view.CvSweViewFactory;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class CvLdnMvcContainerImpl
implements LdnMvcContainer {
    private String myLdn;
    private NodeServices myNodeServices;
    private SweToolServices myToolServices;
    private Configuration myConfiguration;
    private CvSweModel myCvSweModel = null;
    private CvSweController myCvSweController = null;
    private CvSweView myCvSweView = null;
    private Launchable myParentLaunchble = null;
    private LauncherInterface myLauncher = null;

    public CvLdnMvcContainerImpl(String myLdn, NodeServices aNodeServices, Configuration aConfiguration, Launchable parentLaunchble, LauncherInterface theLauncher) {
        this.myLdn = myLdn;
        this.myNodeServices = aNodeServices;
        this.myConfiguration = aConfiguration;
        this.myParentLaunchble = parentLaunchble;
        this.myLauncher = theLauncher;
        this.initModelViewControllerStructure();
    }

    public void activate() {
    }

    public void doStart() {
        this.myCvSweController.showUIView(true);
    }

    public void doStop() {
        this.myCvSweView.exit();
    }

    public String getLdn() {
        return this.myLdn;
    }

    private void initModelViewControllerStructure() {
        this.myToolServices = SweToolServiceFactory.createToolServices(this.myParentLaunchble, this.myLauncher, this.myConfiguration, this.myNodeServices);
        this.myCvSweModel = CvSweModelFactory.createCvSweModel(this.myLdn, this.myToolServices, this.myConfiguration);
        this.myCvSweController = CvSweControllerFactory.createCvSweController(this.myCvSweModel);
        this.myCvSweView = CvSweViewFactory.createCvSweView(this.myCvSweController, this.myCvSweModel);
        this.myCvSweView.initialize();
        this.myCvSweController.setView(this.myCvSweView);
        this.myCvSweModel.addUiView(this.myCvSweView);
    }

    public JComponent getComponent() {
        return this.myCvSweView.getComponent();
    }

    public void refresh(String itemToSelect) {
        this.myCvSweModel.refreshUiView();
        this.myCvSweView.selectRowWithItem(itemToSelect);
    }
}

