/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.controller.CvSweController;
import se.ericsson.cello.swe.model.CvSweModel;
import se.ericsson.cello.swe.model.momodel.CvMoModel;
import se.ericsson.cello.swe.service.StartFailureException;
import se.ericsson.cello.swe.service.SweToolServices;
import se.ericsson.cello.swe.view.CvSweView;
import se.ericsson.cello.swe.view.gui.CvHyperToolAction;
import se.ericsson.cello.swe.view.gui.CvTablePanel;

public class CvSweGui
implements CvSweView {
    private CvSweModel myModel = null;
    private CvMoModel myMoModel = null;
    private SweToolServices myToolServices = null;
    private CvTablePanel myCvPanel = null;
    private String theLdn;
    private CvHyperToolAction menuItemAction;
    private JPanel myComponentPanel = new JPanel(new BorderLayout(0, 0));

    public CvSweGui(CvSweController cvSweController, CvSweModel cvSweModel) {
        this.myModel = cvSweModel;
    }

    public void exit() {
        this.myModel = null;
        this.myMoModel = null;
        this.myToolServices = null;
        this.myCvPanel = null;
        this.theLdn = null;
        this.menuItemAction = null;
        this.myComponentPanel = null;
    }

    public JComponent getComponent() {
        return this.myComponentPanel;
    }

    public void initialize() {
        SweLog.logger().log(Level.INFO, "CvSweGui.initialize");
        try {
            this.myModel.getToolServices().getNodeServices();
        }
        catch (StartFailureException e) {
            String errorString = "Failed to launch NodeServices.";
            this.reportException(errorString, e);
            this.myModel.exit();
            return;
        }
        this.myToolServices = this.myModel.getToolServices();
        this.myMoModel = this.myModel.getMoModel();
        this.buildGui();
    }

    public void nodeConnectionLost() {
    }

    public void nodeConnectionRestored() {
    }

    public void setController(CvSweController controller) {
    }

    public void setModel(CvSweModel model) {
    }

    public void showUI(boolean visible) {
    }

    private void reportException(String reason, Exception e) {
        MessageDialogFactory.createMessageDialog((String)reason, (Exception)e, (boolean)false, null).setVisible(true);
    }

    private void buildGui() {
        String[] theTableHeader = this.myMoModel.getTableHeader();
        List<List<String>> theDataDataList = this.myMoModel.getTableData();
        this.myCvPanel = new CvTablePanel(theDataDataList, theTableHeader, this.myModel, this.myToolServices.getPreferenceService());
        this.myCvPanel.init();
        this.myCvPanel.setName("myCvPanel");
        this.myComponentPanel = this.makeTheCompleteComponent();
        this.myComponentPanel.setName("myComponentPanel");
        this.myCvPanel.setColumnSizes();
        SweLog.logger().log(Level.INFO, "CvSweGui.buildGui - done!");
    }

    private void reBuildGui() {
        try {
            this.myMoModel.refreshModels();
        }
        catch (Exception e) {
            SweLog.logger().log(Level.INFO, "Exception while refreshing model!", e);
            this.reportException("Could not refresh, This could happen if the node is restarting.", e);
        }
        this.buildGui();
        this.myComponentPanel.validate();
        SweLog.logger().log(Level.INFO, "CvSweGui.buildGui - done!");
        this.myToolServices.sendEmNotification("gui rebuilt ", GuiTestEventTypes.CV_PANEL_UPDATED, null, null);
    }

    private JPanel makeTheCompleteComponent() {
        this.myComponentPanel.removeAll();
        this.myComponentPanel.add((Component)this.myCvPanel, "Center");
        JPanel buttonPanel = this.makeButtonPanel();
        this.myComponentPanel.add((Component)buttonPanel, "South");
        return this.myComponentPanel;
    }

    private JPanel makeButtonPanel() {
        JPanel attrButtonPanel = new JPanel(new FlowLayout(2));
        this.theLdn = this.myModel.getLDN();
        this.menuItemAction = new CvHyperToolAction(this.theLdn, this.myCvPanel.getTable(), this.myToolServices);
        JButton getFromFtpB = new JButton("Get from FTP...");
        getFromFtpB.setMnemonic('G');
        attrButtonPanel.add(getFromFtpB);
        getFromFtpB.setEnabled(true);
        getFromFtpB.addActionListener(this.menuItemAction);
        getFromFtpB.setName("getFromFtpB");
        String cvCreate = "Create CV...";
        JButton createCvB = new JButton(cvCreate);
        createCvB.setName("createCvB");
        attrButtonPanel.add(createCvB);
        createCvB.setEnabled(true);
        createCvB.addActionListener(this.menuItemAction);
        JButton refreshB = new JButton("Refresh");
        refreshB.setMnemonic('e');
        attrButtonPanel.add(refreshB);
        refreshB.setEnabled(true);
        refreshB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CvSweGui.this.reBuildGui();
            }
        });
        return attrButtonPanel;
    }

    public void reInitialize() {
        this.reBuildGui();
    }

    public CvTablePanel getMyCvPanel() {
        return this.myCvPanel;
    }

    public void selectRowWithItem(String item) {
        if (item != null) {
            JTable table = this.myCvPanel.getTable();
            int max = table.getRowCount();
            int rowToSelect = -1;
            for (int row = 0; row < max; ++row) {
                String s = (String)table.getValueAt(row, 0);
                if (s.compareTo(item) != 0) continue;
                rowToSelect = row;
                break;
            }
            if (rowToSelect > -1) {
                table.setRowSelectionInterval(rowToSelect, rowToSelect);
            }
        }
    }
}

