/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.model.UpSweModel;
import se.ericsson.cello.swe.service.SweToolServices;
import se.ericsson.cello.swe.view.gui.ColumnHeaderListener;
import se.ericsson.cello.swe.view.gui.LeftDotRenderer;
import se.ericsson.cello.swe.view.gui.UpHyperToolAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpTablePanel
extends JPanel {
    private static final long serialVersionUID = 7683256723619650105L;
    protected List<List<String>> myTableDataList = null;
    protected DefaultTableModel theTableModel = null;
    private JTable table = null;
    private TablePopupMenu popupMenu = null;
    private ColumnHeaderListener myColumnHeaderListener;
    private UpSweModel myModel = null;
    private UserPreferencesI userPrefs;

    public UpTablePanel(List<List<String>> aTableDataListList, String[] theTableHeader, UpSweModel aModel, UserPreferencesI userPrefService) {
        super(new BorderLayout(0, 0));
        this.myModel = aModel;
        this.userPrefs = userPrefService;
        this.myTableDataList = aTableDataListList;
        int nRows = this.myTableDataList.size();
        if (nRows == 0) {
            this.theTableModel = new DefaultTableModel();
        } else {
            int nCols = theTableHeader.length;
            Object[][] data = new Object[nRows][nCols];
            for (int i = 0; i < nRows; ++i) {
                for (int j = 0; j < nCols; ++j) {
                    data[i][j] = this.myTableDataList.get(i).get(j);
                }
            }
            this.theTableModel = new DefaultTableModel(data, theTableHeader);
        }
        this.table = new JTable(this.theTableModel){
            private static final long serialVersionUID = -268329399240136878L;

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setName("tableUp");
        JTableHeader header = this.table.getTableHeader();
        this.myColumnHeaderListener = new ColumnHeaderListener(this.userPrefs, this.table);
        header.addMouseListener(this.myColumnHeaderListener);
        this.popupMenu = this.buildPopup();
        this.table.addMouseListener(new PopupListener(this.popupMenu));
        this.table.setAutoResizeMode(2);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoCreateColumnsFromModel(false);
        if (this.table.getColumnCount() > 0) {
            LeftDotRenderer leftDotRenderer = new LeftDotRenderer();
            this.table.getColumnModel().getColumn(0).setCellRenderer(leftDotRenderer);
        }
        int gapWidth = 10;
        int gapHeight = 4;
        this.table.setIntercellSpacing(new Dimension(gapWidth, gapHeight));
        this.table.setRowHeight(this.table.getRowHeight() + gapHeight);
        this.table.addMouseMotionListener(this.createToolTipListener());
        this.table.setSelectionMode(0);
        this.myColumnHeaderListener.sortAllRowsBy(this.theTableModel);
        JScrollPane attrscroller = new JScrollPane(this.table, 20, 30);
        attrscroller.getHorizontalScrollBar().setUnitIncrement(50);
        attrscroller.getVerticalScrollBar().setUnitIncrement(30);
        this.add((Component)attrscroller, "Center");
    }

    public void setColumnSizes() {
        if (null != this.userPrefs) {
            int length = this.table.getColumnCount();
            for (int i = 0; i < length; ++i) {
                try {
                    Integer width = new Integer(this.userPrefs.getPreference("cpp_swembed_columnwidth_" + this.table.getName() + this.table.getColumnName(i) + "_", "0"));
                    if (width <= 0) continue;
                    this.table.getColumn(this.table.getColumnName(i)).setPreferredWidth(width);
                    continue;
                }
                catch (Exception e) {
                    SweLog.logger().info("Exception while setting preferred size to columns:\n" + SweLog.stackToString(e));
                }
            }
        }
    }

    protected TablePopupMenu buildPopup() {
        TablePopupMenu popup = new TablePopupMenu();
        SweToolServices myToolServices = this.myModel.getToolServices();
        UpHyperToolAction menuItemAction = new UpHyperToolAction(this.table, myToolServices);
        LinkedList<String> myTools = new LinkedList<String>();
        myTools.addAll(myToolServices.getUpHyperToolNames());
        String[] toolItems = myTools.toArray(new String[0]);
        for (int i = 0; i < toolItems.length; ++i) {
            JMenuItem menuItem = new JMenuItem(toolItems[i]);
            if (menuItem.getText().equals("Create UP...")) continue;
            menuItem.addActionListener(menuItemAction);
            popup.add(menuItem);
        }
        return popup;
    }

    public DefaultTableModel getTheTableModel() {
        return this.theTableModel;
    }

    public TablePopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public JTable getTable() {
        return this.table;
    }

    private MouseMotionListener createToolTipListener() {
        return new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent ev) {
                Point p = ev.getPoint().getLocation();
                int row = UpTablePanel.this.getTable().rowAtPoint(p);
                int column = UpTablePanel.this.getTable().columnAtPoint(p);
                if (row > -1 && column > -1) {
                    UpTablePanel.this.getTable().setToolTipText(UpTablePanel.this.getTable().getValueAt(row, column).toString());
                }
            }
        };
    }

    public class PopupListener
    extends MouseAdapter {
        private TablePopupMenu popupMenu = null;

        public PopupListener(TablePopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Point clickPoint = new Point(e.getX(), e.getY());
                int selectedRow = UpTablePanel.this.table.rowAtPoint(clickPoint);
                if (selectedRow < 0 || selectedRow >= UpTablePanel.this.table.getRowCount()) {
                    return;
                }
                UpTablePanel.this.table.setRowSelectionInterval(selectedRow, selectedRow);
                this.popupMenu.beforeVisisble();
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public static class TablePopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = -2794516618454806190L;
        private LinkedList<JMenuItem> mItems = new LinkedList();

        public void addMenuItem(JMenuItem item) {
            this.mItems.add(item);
        }

        public JMenuItem add(JMenuItem item) {
            JMenuItem i = super.add(item);
            this.addMenuItem(item);
            return i;
        }

        public void beforeVisisble() {
        }
    }
}

