/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.helpservice;

import java.util.Collection;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import se.ericsson.cello.emt.helpservice.AlexBrowser;
import se.ericsson.cello.emt.helpservice.AlexInitializer;
import se.ericsson.cello.emt.helpservice.HelpServiceI;
import se.ericsson.cello.emt.helpservice.HelpServiceLog;
import se.ericsson.cello.emt.helpservice.HtmlBrowser;
import se.ericsson.cello.emt.helpservice.ProductFinder;
import se.ericsson.cello.emt.helpservice.ToolService;
import se.ericsson.cello.emt.helpservice.view.Display;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.launchhandler.LaunchHandler;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.ReusableLaunchable;

public class HelpService
implements ReusableLaunchable,
HelpServiceI {
    static final long GET_NODESERVICES_TIMEOUT = 60L;
    protected static final String ALEX_SEARCH_EXPRESSION_KEY = "ALEX_SEARCH_EXPRESSION";
    protected static final String CUSTOM_APPL_NAME_KEY = "CUSTOM_APPL_NAME";
    protected static final String SUPERSEDING_KEY = "SUPERSEDING_PARAMETER_LIST";
    private final String KEY_DELIMITER = ";";
    private static final String MISSING = "empty";
    private HtmlBrowser myHtmlBrowser = new HtmlBrowser();
    private AlexBrowser myAlexBrowser = null;
    private String myNodservicesConfig = "";
    private NodeServices myNodeServices = null;
    private String myHost = null;
    private LauncherInterface myLauncher;
    private String myAlexInitializerName = "";
    private AlexInitializer myAlexInitializer = null;
    private String myName = "Help Service";
    private String myIconPath = "";
    private Display myDisplay;
    private ToolService myToolService;
    private volatile boolean hasInintializedAlex = false;
    private CountDownLatch initInRunIsDone;

    public HelpService() {
        HelpServiceLog.logger().info("HelpService constructor");
        this.initInRunIsDone = new CountDownLatch(1);
        this.myDisplay = new Display();
    }

    public void run(final String hostName, final Properties parameters, final LauncherInterface launcher, final Launchable parent) {
        HelpServiceLog.logger().info("Entering run");
        Runnable runner = new Runnable(){

            public void run() {
                HelpService.this.handleRunAndReuse(hostName, parameters, launcher, parent);
                HelpService.this.initInRunIsDone.countDown();
            }
        };
        new Thread(runner, "HelpServiceRunThread").start();
    }

    public void reuse(final String hostName, final Properties parameters, final LauncherInterface launcher, final Launchable parent) {
        HelpServiceLog.logger().info("Entering reuse");
        try {
            this.initInRunIsDone.await();
        }
        catch (Exception e) {
            HelpServiceLog.logger().info("Exception while waithing for init in run is done. " + e.getMessage());
        }
        Runnable runner = new Runnable(){

            public void run() {
                HelpService.this.handleRunAndReuse(hostName, parameters, launcher, parent);
            }
        };
        new Thread(runner, "HelpServiceReuseThread").start();
    }

    public boolean reconnect(String arg0, Properties arg1) {
        return false;
    }

    public void exit() {
        HelpServiceLog.logger().info("HelpService will exit");
        this.myLauncher.onExit((Launchable)this);
    }

    public String toString() {
        return this.myName;
    }

    public void displayAbout(String applicationTitle, Collection configfiles, JFrame ownerFrame, ImageIcon detailedIcon, String additionalText, String copyRightYear, String thirdPartyText) {
        try {
            this.initInRunIsDone.await();
        }
        catch (Exception e) {
            HelpServiceLog.logger().info("Exception while waithing for init in run is done. " + e.getMessage());
        }
        TreeSet<String> executingAppRows = ProductFinder.constructExecutingApplicationRows(configfiles, this.myLauncher, this.myHost);
        this.myDisplay.displayAbout(applicationTitle, executingAppRows, ownerFrame, additionalText, copyRightYear, thirdPartyText);
    }

    public void displayUsingHelp(JFrame ownerFrame) {
        Display.displayUsingHelp(ownerFrame);
    }

    private boolean initAlex(String hostName, Properties parameters, LauncherInterface launcher, Launchable parent) {
        if (this.hasInintializedAlex) {
            return true;
        }
        Properties propsForNodeServ = this.getSupersedingProps(parameters);
        if (this.myIconPath.length() > 0) {
            propsForNodeServ.setProperty("TOOL_ICON", this.myIconPath);
        }
        try {
            HelpServiceLog.logger().info("HelpService initAlex before getting Nodeservices. config file for nodeservices:" + this.myNodservicesConfig + "\nicon path:" + this.myIconPath + "\nlauncher:" + launcher + "\nhost:" + this.myHost);
            this.myNodeServices = (NodeServices)LaunchHandler.getToolAsResource(launcher, this.myNodservicesConfig, this.myHost, propsForNodeServ, (Launchable)this, 60L);
            HelpServiceLog.logger().info("HelpService initAlex after getting Nodeservices.");
            if (this.myAlexInitializerName.length() > 1) {
                Mo managedElMo = this.myNodeServices.getNode().getCmService().getMo("ManagedElement=1");
                Mo managedElDataMo = this.myNodeServices.getNode().getCmService().getMo("ManagedElement=1,ManagedElementData=1");
                this.myAlexInitializer = (AlexInitializer)Class.forName(this.myAlexInitializerName).newInstance();
                String info = "Going to do initAlex(...) of instance type " + this.myAlexInitializer.getClass().getName();
                HelpServiceLog.logger().info(info);
                this.myAlexInitializer.initAlex(managedElMo, managedElDataMo);
            }
            if (this.myAlexBrowser == null) {
                this.myAlexBrowser = new AlexBrowser(this.myNodeServices, this.myIconPath, this.myHtmlBrowser, this.myToolService);
            }
            HelpServiceLog.logger().info("HelpService initialized alex");
            this.hasInintializedAlex = true;
        }
        catch (Exception ce) {
            HelpServiceLog.logger().log(Level.WARNING, "It was not possible to display the help.\n" + HelpServiceLog.stackToString(ce));
            MessageDialogFactory.createMessageDialog("Help display fault", "It was not possible to display the help. The Help service could not be started.\n", ce, this.myIconPath, false).setVisible(true);
        }
        return this.hasInintializedAlex;
    }

    private void handleRunAndReuse(String hostName, Properties parameters, LauncherInterface launcher, Launchable parent) {
        HelpServiceLog.logger().info("HelpService called with properties:" + parameters.toString());
        this.myLauncher = launcher;
        this.myHost = hostName;
        this.myName = parameters.getProperty(CUSTOM_APPL_NAME_KEY, this.myName);
        this.myIconPath = parameters.getProperty("TOOL_ICON", this.myIconPath);
        this.myHtmlBrowser.setIconPath(this.myIconPath);
        String title = parameters.getProperty("DOC_TITLE");
        String chapter = parameters.getProperty("SECTION_TAG");
        String url = parameters.getProperty("URL", MISSING);
        String alexSearchExpr = parameters.getProperty(ALEX_SEARCH_EXPRESSION_KEY, MISSING);
        String initOnly = parameters.getProperty("HELPSERVICE_INIT", "false");
        this.myNodservicesConfig = parameters.getProperty("NODESERVICES_CONFIG", this.myNodservicesConfig);
        this.myAlexInitializerName = parameters.getProperty("ALEX_INITIALIZER", this.myAlexInitializerName);
        this.myToolService = new ToolService(this.myHost, this.myLauncher, (Launchable)this, parameters, this.getSupersedingProps(parameters));
        if (initOnly.equalsIgnoreCase("TRUE")) {
            return;
        }
        if (!MISSING.equals(url)) {
            this.myHtmlBrowser.showURL(url);
            return;
        }
        if (!this.initAlex(hostName, parameters, this.myLauncher, (Launchable)this)) {
            return;
        }
        if (!MISSING.equals(alexSearchExpr)) {
            this.myAlexBrowser.showAlexUrl(alexSearchExpr);
        } else if (null != this.myAlexInitializer) {
            this.myAlexBrowser.showALEXdoc(this.myAlexInitializer.convertTitle(title), chapter);
        } else {
            this.myAlexBrowser.showALEXdoc(title, chapter);
        }
    }

    private Properties getSupersedingProps(Properties props) {
        Properties superProps = new Properties();
        String str = props.getProperty(SUPERSEDING_KEY, "");
        if (str.equals("")) {
            HelpServiceLog.logger().warning("No superseding properties found!");
        } else {
            String[] items = str.split(";");
            for (int i = 0; i < items.length; ++i) {
                String property = props.getProperty(items[i]);
                if (property != null) {
                    superProps.setProperty(items[i], property);
                    continue;
                }
                HelpServiceLog.logger().warning("Could not find property for key " + items[i]);
            }
        }
        superProps.setProperty(SUPERSEDING_KEY, str);
        return superProps;
    }
}

