/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.helpservice;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import se.ericsson.security.launcher.ApplicationFileInterface;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.VersionedLauncherInterface;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductFinder {
    private static final EmLogger LOG = EmLogger.HELP_SERVICE;
    private static final String LAUNCHER_NAME = "launcher.jar";
    private static final String NEWLINE = System.getProperties().getProperty("line.separator", "\n");
    private static Comparator<URL> URL_COMPARATOR = new Comparator<URL>(){

        @Override
        public int compare(URL o1, URL o2) {
            return String.valueOf(o1).compareTo(String.valueOf(o2));
        }
    };

    public static TreeSet<String> constructExecutingApplicationRows(Collection<ApplicationFileInterface> configfiles, LauncherInterface launcher, String host) {
        TreeSet<String> uniqueRows = new TreeSet<String>();
        for (ApplicationFileInterface aTool : configfiles) {
            String productNumber = aTool.getProductNumber();
            if (productNumber.equals("")) continue;
            StringBuffer toolInfo = new StringBuffer();
            toolInfo.append(aTool.getName()).append(" ");
            toolInfo.append(aTool.getProductNumber()).append(" ");
            toolInfo.append(aTool.getRevision());
            uniqueRows.add(toolInfo.toString());
        }
        uniqueRows.addAll(ProductFinder.getJarInfoFromConfigFile(configfiles, launcher, host));
        uniqueRows.add(ProductFinder.getLauncherNameAndVersion(launcher));
        return uniqueRows;
    }

    private static Collection<String> getJarInfoFromConfigFile(Collection<ApplicationFileInterface> configfiles, LauncherInterface launcherI, String host) {
        TreeSet<String> uniqueRows = new TreeSet<String>();
        Vector usedJars = new Vector();
        if (launcherI instanceof LauncherInterface.RevB) {
            LauncherInterface.RevB launcher = (LauncherInterface.RevB)launcherI;
            for (ApplicationFileInterface confFile : configfiles) {
                try {
                    usedJars.addAll(launcher.getUsedJars(confFile));
                }
                catch (Exception e) {
                    LOG.fine("Got Exception from getUsedJars for confFile=" + confFile + " ", (Throwable)e);
                }
                catch (AbstractMethodError methodEx) {
                    LOG.info("Launcher.RevB did not have the method getUsedJars.", new Object[0]);
                    break;
                }
            }
            SortedSet<URL> jarsFromClassLoaders = ProductFinder.getJarsFromClassLoaders(launcher);
            Iterator iter = usedJars.iterator();
            while (iter.hasNext()) {
                StringBuilder row = new StringBuilder();
                ApplicationFileInterface jarFileI = (ApplicationFileInterface)iter.next();
                JarFile jarFileFromClassLoader = ProductFinder.getJarFileFromUrls(jarsFromClassLoaders, jarFileI);
                row.append(ProductFinder.checkAndCorrectVersion(jarFileI, jarFileFromClassLoader));
                if (uniqueRows.contains(row.toString())) continue;
                uniqueRows.add(row.toString());
            }
        } else {
            LOG.info("LauncherI was not Launcher.RevB. Cannot display jar file versions in About window.", new Object[0]);
        }
        return uniqueRows;
    }

    private static String checkAndCorrectVersion(ApplicationFileInterface jarFileI, JarFile actualJarFile) {
        String actualRevisionInfo;
        StringBuilder sb;
        block14: {
            String fileNameOnNode = jarFileI.getFilePath().trim();
            String productName = jarFileI.getName();
            String productNumber = jarFileI.getProductNumber();
            String productRevision = jarFileI.getRevision();
            sb = new StringBuilder();
            sb.append(productName).append(" ");
            sb.append(productNumber).append(" ");
            sb.append(productRevision).append(" ");
            actualRevisionInfo = "(?? Got Exception while examining actual JAR??)";
            try {
                String actualFileName = "(The jar file was not found)";
                Manifest manifest = null;
                Attributes attributes = null;
                if (actualJarFile == null) {
                    actualRevisionInfo = TmUtilities.runningFromEclipse() ? "(Using files from Eclipse)" : "(The actual jar file was not found)";
                    LOG.fine(fileNameOnNode + " " + productName + " " + actualRevisionInfo, new Object[0]);
                    break block14;
                }
                actualFileName = actualJarFile.getName();
                manifest = actualJarFile.getManifest();
                try {
                    actualJarFile.close();
                }
                catch (Exception ioe) {
                    LOG.fine("Unexpected IOException during close of a Jar file. ", (Throwable)ioe);
                }
                if (manifest == null) {
                    actualRevisionInfo = "(Jar contains no Manifest)";
                    LOG.fine(fileNameOnNode + " " + actualRevisionInfo, new Object[0]);
                } else {
                    attributes = manifest.getMainAttributes();
                    if (null == attributes) {
                        actualRevisionInfo = "(Manifest has null attributes)";
                        LOG.fine(fileNameOnNode + " " + actualRevisionInfo, new Object[0]);
                    } else {
                        String cxc = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                        if (null == cxc) {
                            cxc = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                        }
                        String rev = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        String what1 = attributes.getValue("What-String1");
                        String what2 = attributes.getValue("What-String2");
                        actualRevisionInfo = "But is actually: " + cxc + " " + rev;
                        if (what1 != null) {
                            actualRevisionInfo = actualRevisionInfo + NEWLINE + "    " + what1;
                        }
                        if (what2 != null) {
                            actualRevisionInfo = actualRevisionInfo + NEWLINE + "    " + what2;
                        }
                        actualRevisionInfo = actualRevisionInfo + NEWLINE + "    " + actualFileName;
                        if (null != cxc && cxc.startsWith("CXC") && cxc.equalsIgnoreCase(productNumber) && rev.equalsIgnoreCase(productRevision)) {
                            actualRevisionInfo = "";
                        }
                        LOG.fine("Jar file path" + actualFileName + NEWLINE + "    Manifest attributes: " + attributes.entrySet().toString(), new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                actualRevisionInfo = actualRevisionInfo + NEWLINE + "    " + e.toString();
                LOG.fine("Executing " + productName + " product number and revision could not be read: ", (Throwable)e);
            }
        }
        if (!"".equals(actualRevisionInfo)) {
            sb.append(" - ");
            sb.append(actualRevisionInfo);
        }
        return sb.toString();
    }

    private static JarFile getJarFileFromUrls(SortedSet<URL> jarsOnClasspath, ApplicationFileInterface jarFileI) {
        JarFile jarFileFromClassLoader = null;
        TreeSet<URL> matching = new TreeSet<URL>(URL_COMPARATOR);
        try {
            URL url2;
            String jarFileName = jarFileI.getName();
            for (URL url2 : jarsOnClasspath) {
                if (!url2.getPath().endsWith(jarFileName)) continue;
                matching.add(url2);
            }
            int machingSize = matching.size();
            if (machingSize != 1) {
                if (machingSize == 0 && TmUtilities.isSemlaActive()) {
                    return null;
                }
                Exception e = new Exception("Found " + matching.size() + " matches for " + jarFileName + " among classloaded!");
                LOG.info("Found unexpected number of URL:s for same jarFileName=" + jarFileName + ": " + matching.size() + " ", (Throwable)e);
            }
            url2 = (URL)matching.first();
            LOG.finest("url=" + url2, new Object[0]);
            File file = new File(url2.getFile());
            jarFileFromClassLoader = new JarFile(file, false);
        }
        catch (Exception e) {
            LOG.fine("Unexpected Exception while scanning SortedSet<URL> for jar files: ", (Throwable)e);
        }
        return jarFileFromClassLoader;
    }

    private static URL[] getJarUrls(ClassLoader classLoader) {
        try {
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlLoader = (URLClassLoader)classLoader;
                URL[] jarUrls = urlLoader.getURLs();
                return jarUrls;
            }
            return new URL[0];
        }
        catch (Exception e) {
            LOG.fine("Got Exception while retrieving jar file URL:s from classLoader: ", (Throwable)e);
            return new URL[0];
        }
    }

    private static SortedSet<URL> getJarsFromClassLoaders(LauncherInterface.RevB launcher) {
        TreeSet<URL> urls = new TreeSet<URL>(URL_COMPARATOR);
        try {
            Collections.addAll(urls, ProductFinder.getJarUrls(Thread.currentThread().getContextClassLoader()));
            ArrayList launchabs = new ArrayList();
            launchabs.addAll(launcher.getRunningResources());
            launchabs.addAll(launcher.getRunningApplications());
            for (Launchable launchable : launchabs) {
                ClassLoader classLoader = launchable.getClass().getClassLoader();
                Collections.addAll(urls, ProductFinder.getJarUrls(classLoader));
            }
            LOG.finest("ClassLoaded jar files from all launched resources and applications: " + NEWLINE + urls, new Object[0]);
            return urls;
        }
        catch (Exception e) {
            LOG.fine("Got Exception while retrieving jar file URL:s from launcher classLoaders: ", (Throwable)e);
            return urls;
        }
    }

    private static String getLauncherNameAndVersion(LauncherInterface launcher) {
        String nameAndVersion = "";
        String launcherCxc = "";
        if (launcher instanceof LauncherInterface.RevB) {
            try {
                launcherCxc = ((LauncherInterface.RevB)launcher).getProductNumber();
                String version = ((VersionedLauncherInterface)launcher).getVersion();
                nameAndVersion = "launcher.jar " + launcherCxc + " " + version;
                return nameAndVersion;
            }
            catch (AbstractMethodError methodEx) {
                LOG.info("Launcher.RevB did not have the methods expected.", new Object[0]);
                launcherCxc = "CXC1721561";
            }
        } else {
            LOG.info("Launcher is not LauncherInterface.RevB", new Object[0]);
        }
        if (launcher instanceof VersionedLauncherInterface) {
            LOG.info("VersionedLauncherInterface", new Object[0]);
            String version = ((VersionedLauncherInterface)launcher).getVersion();
            nameAndVersion = "launcher.jar " + launcherCxc + " " + version + " ";
        } else {
            LOG.info("Launcher is not VersionedLauncherInterface", new Object[0]);
            if (launcherCxc.length() > 0) {
                nameAndVersion = "launcher.jar " + launcherCxc + " ";
            }
        }
        return nameAndVersion;
    }
}

