/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.nodeservices;

import se.ericsson.cello.emt.nodeservices.EmNealLog;
import se.ericsson.cello.emt.nodeservices.EmNodeImpl;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MimParser;
import se.ericsson.cello.neal.NealLogger;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeAccess;
import se.ericsson.cello.neal.NodeConfig;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.eprops.EmasRuntimeException;
import se.ericsson.security.utils.EmLogger;

public class NodeServicesImpl
implements NodeServices {
    private static final EmLogger LOG = EmLogger.NODE_SERVICE;
    private static final String SSU_AUTH_ENABLED = "se.ericsson.security.ssu.authenticationenabled";
    private MimModel myMimModel = null;
    private Node myNode = null;
    private String myMomFilePath = null;
    private NodeConfig myNodeConfig = null;

    public NodeServicesImpl(NodeConfig nodeConfig, String momFilePath) {
        this.myMomFilePath = momFilePath;
        this.myNodeConfig = nodeConfig;
    }

    public NodeServicesImpl(Node aNode, MimModel aMimModel) {
        this.myNode = aNode;
        this.myMimModel = aMimModel;
    }

    public MimModel getMimModel() {
        if (this.myMimModel == null) {
            LOG.info(NodeServicesImpl.class + " before MimParser.parse", new Object[0]);
            this.myMimModel = MimParser.parse((String)this.myMomFilePath);
            LOG.info(NodeServicesImpl.class + " after MimParser.parse", new Object[0]);
        }
        return this.myMimModel;
    }

    public Node getNode() {
        EProps ep = new EProps();
        ep.put(EKEY.JAVA_METHOD, "NodeServiceImpl.getNode()");
        ep.put(EKEY.JAVA_PARAMS, "\nNodeConfig         : " + this.myNodeConfig.getConnectionInfo());
        ep.append(EKEY.JAVA_PARAMS, "MomFilePath        : " + this.myMomFilePath);
        ep.append(EKEY.JAVA_PARAMS, "contextClassLoader : " + Thread.currentThread().getContextClassLoader());
        if (this.myNode == null) {
            EmNealLog nealLogger = new EmNealLog();
            NodeAccess.setLogger((NealLogger)nealLogger);
            Node aRealNealNode = null;
            if (System.getProperty(SSU_AUTH_ENABLED, "not defined").equalsIgnoreCase("true")) {
                LOG.info("The node to connect to is SECURE.", new Object[0]);
                System.setProperty("CelloSecurityState", "ON");
                ep.put(EKEY.JAVA_INFO, "CelloSecurityState=ON");
            } else {
                LOG.info("The node to connect to is NOT SECURE.", new Object[0]);
                ep.put(EKEY.JAVA_INFO, "CelloSecurityState=OFF");
            }
            try {
                LOG.finest(NodeServicesImpl.class + " before NodeAccess.getSetMockedNode", new Object[0]);
                LOG.info(NodeServicesImpl.class + " before NodeAccess.getNode", new Object[0]);
                aRealNealNode = NodeAccess.getNode((NodeConfig)this.myNodeConfig);
                ep.append(EKEY.JAVA_INFO, "\n", "getNode() returned '" + aRealNealNode + "'");
                LOG.info(NodeServicesImpl.class + " after NodeAccess.getNode", new Object[0]);
            }
            catch (Exception e) {
                String errMsg = "Not possible to connect to node ";
                ep.put(EKEY.PROBLEM_USER_LEVEL, errMsg);
                EmasRuntimeException eme = new EmasRuntimeException(errMsg, ep, (Throwable)e);
                LOG.severe(NodeServicesImpl.class + errMsg, (Throwable)eme);
                throw eme;
            }
            this.myNode = new EmNodeImpl(aRealNealNode);
            LOG.info(NodeServicesImpl.class + " create a decorated Neal Node", new Object[0]);
        } else {
            LOG.info("returning an already created myNode", new Object[0]);
        }
        return this.myNode;
    }
}

