/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice.maverickfacade.impl;

import com.maverick.sftp.SftpFile;
import com.maverick.sftp.SftpStatusException;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshException;
import com.sshtools.sftp.SftpClient;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import se.ericsson.cello.emt.sshsftpservice.EmSftp;
import se.ericsson.cello.emt.sshsftpservice.FileAttributes;
import se.ericsson.cello.emt.sshsftpservice.FileTransferProgress;
import se.ericsson.cello.emt.sshsftpservice.Permission;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshException;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshLoginException;
import se.ericsson.cello.emt.sshsftpservice.maverickfacade.ifc.Connection;
import se.ericsson.cello.emt.sshsftpservice.maverickfacade.impl.FileAttributesMav;
import se.ericsson.cello.emt.sshsftpservice.maverickfacade.impl.FileTransferProgressMav;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpCmdSender
implements EmSftp {
    private static final EmLogger LOG = EmLogger.SSH_SFTP_SERVICE;
    private static final String REMOTE_CONNECTION_CLOSED = "Remote connection closed.";
    private static final String REMOTE_CONNECTION_ESTABLISHED = "Remote connection established.";
    private static final String SFTP_CONNECTING_SSH_FAILURE = "SFTP, Connecting SSH failure: ";
    private static final String SFTP_FAILURE = "SFTP failure: ";
    private static final String SFTP_LOGIN_FAILURE = "SFTP, Login failure: ";
    private static final String SFTP_OPENING_CHANNEL_FAILURE = "SFTP, Opening channel failure: ";
    private SftpClient sftpClient = null;
    private SshClient sshClient;
    private Command cmd;

    public SftpCmdSender(Connection connection) throws EmSshLoginException, EmSshException {
        try {
            this.sshClient = connection.connect();
            this.sftpClient = new SftpClient(this.sshClient);
            this.sftpClient.setRegularExpressionSyntax(1);
            LOG.info(REMOTE_CONNECTION_ESTABLISHED, new Object[0]);
        }
        catch (EmSshLoginException e) {
            LOG.severe(SFTP_LOGIN_FAILURE + e.getMessage(), new Object[0]);
            throw e;
        }
        catch (SshException e) {
            LOG.severe(SFTP_CONNECTING_SSH_FAILURE + e.getMessage(), new Object[0]);
            throw new EmSshException(SFTP_CONNECTING_SSH_FAILURE, e);
        }
        catch (ChannelOpenException e) {
            LOG.severe(SFTP_OPENING_CHANNEL_FAILURE + e.getMessage(), new Object[0]);
            throw new EmSshException(SFTP_OPENING_CHANNEL_FAILURE, e);
        }
        catch (SftpStatusException e) {
            LOG.severe(SFTP_FAILURE + e.getMessage(), new Object[0]);
            throw new EmSshException(SFTP_FAILURE, e);
        }
    }

    @Override
    public void bye() {
        this.cmd = Command.BYE;
        this.closeSftpSsh();
    }

    @Override
    public void cd(String path) throws EmSshException {
        this.cmd = Command.CD;
        try {
            this.sftpClient.cd(path);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    @Override
    public void chgrp(String path, int gid) throws EmSshException {
        this.cmd = Command.CHGRP;
        try {
            this.sftpClient.chgrp(Integer.toString(gid), path);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    @Override
    public void chmod(String path, EnumSet<Permission> permissions) throws EmSshException {
        this.cmd = Command.CHMOD;
        int intPermissions = 0;
        for (Permission permission : permissions) {
            intPermissions |= permission.BIT_MASK;
        }
        try {
            this.sftpClient.chmod(intPermissions, path);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    @Override
    public void chown(String path, int uid) throws EmSshException {
        this.cmd = Command.CHOWN;
        try {
            this.sftpClient.chown(Integer.toString(uid), path);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    @Override
    public void exit() {
        this.cmd = Command.EXIT;
        this.closeSftpSsh();
    }

    @Override
    public Collection<FileAttributes> get(String remote, String local, FileTransferProgress emProgressListener) throws EmSshException {
        ArrayList<FileAttributes> fileAttr;
        this.cmd = Command.GET;
        try {
            SftpFile[] mavFiles;
            if (local == null && emProgressListener == null) {
                mavFiles = this.sftpClient.getFiles(remote);
            } else if (local != null && emProgressListener == null) {
                mavFiles = this.sftpClient.getFiles(remote, local);
            } else if (local == null && emProgressListener != null) {
                FileTransferProgressMav mavProgressListener = new FileTransferProgressMav(emProgressListener);
                mavFiles = this.sftpClient.getFiles(remote, (com.maverick.sftp.FileTransferProgress)mavProgressListener, false);
            } else {
                FileTransferProgressMav mavProgressListener = new FileTransferProgressMav(emProgressListener);
                mavFiles = this.sftpClient.getFiles(remote, local, (com.maverick.sftp.FileTransferProgress)mavProgressListener, false);
            }
            fileAttr = this.getAttributes(mavFiles);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
        return fileAttr;
    }

    @Override
    public InputStream getAsInputStream(String remote) throws EmSshException {
        this.cmd = Command.GET_AS_INPUTSTREAM;
        try {
            return this.sftpClient.getInputStream(remote);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.sftpClient.isClosed();
    }

    @Override
    public void lcd(String path) throws EmSshException {
        this.cmd = Command.LCD;
        try {
            this.sftpClient.lcd(path);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    @Override
    public String lpwd() {
        this.cmd = Command.LPWD;
        return this.sftpClient.lpwd();
    }

    @Override
    public Collection<FileAttributes> ls(String path) throws EmSshException {
        SftpFile[] mavFiles;
        this.cmd = Command.LS;
        try {
            mavFiles = path == null ? this.sftpClient.ls() : this.sftpClient.ls(path);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
        return this.getAttributes(mavFiles);
    }

    @Override
    public void mkdir(String path) throws EmSshException {
        this.cmd = Command.MKDIR;
        try {
            this.sftpClient.mkdir(path);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    @Override
    public void put(String local, String remote, FileTransferProgress emProgressListener) throws EmSshException {
        this.cmd = Command.PUT;
        try {
            if (remote == null && emProgressListener == null) {
                this.sftpClient.put(local);
            } else if (remote != null && emProgressListener == null) {
                this.sftpClient.put(local, remote);
            } else if (remote == null && emProgressListener != null) {
                FileTransferProgressMav mavProgressListener = new FileTransferProgressMav(emProgressListener);
                this.sftpClient.put(local, (com.maverick.sftp.FileTransferProgress)mavProgressListener, false);
            } else {
                FileTransferProgressMav mavProgressListener = new FileTransferProgressMav(emProgressListener);
                this.sftpClient.put(local, remote, (com.maverick.sftp.FileTransferProgress)mavProgressListener, false);
            }
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    @Override
    public String pwd() {
        this.cmd = Command.PWD;
        return this.sftpClient.pwd();
    }

    @Override
    public void quit() {
        this.cmd = Command.QUIT;
        this.closeSftpSsh();
    }

    @Override
    public void rename(String oldpath, String newpath) throws EmSshException {
        this.cmd = Command.RENAME;
        try {
            this.sftpClient.rename(oldpath, newpath);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    @Override
    public void rm(String path) throws EmSshException {
        this.cmd = Command.RM;
        try {
            this.sftpClient.rm(path);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    @Override
    public void rmdir(String path) throws EmSshException {
        this.cmd = Command.RMDIR;
        try {
            this.sftpClient.rm(path);
        }
        catch (Exception e) {
            String msg = this.cmdFailed(this.cmd, e);
            throw new EmSshException(msg, e);
        }
    }

    private void closeSftpSsh() {
        try {
            this.sftpClient.exit();
            this.sshClient.disconnect();
            this.sshClient.exit();
            LOG.info(REMOTE_CONNECTION_CLOSED, new Object[0]);
        }
        catch (Exception e) {
            this.cmdFailed(this.cmd, e);
        }
    }

    private String cmdFailed(Command cmd, Exception e) throws EmSshException {
        String msg = "Command " + cmd.name() + " failed: ";
        LOG.fine(msg + e.getMessage(), new Object[0]);
        return msg;
    }

    private ArrayList<FileAttributes> getAttributes(SftpFile[] mavFiles) {
        ArrayList<FileAttributes> emFilesAttr = new ArrayList<FileAttributes>();
        for (SftpFile file : mavFiles) {
            FileAttributesMav emFileAttr = new FileAttributesMav(file);
            emFilesAttr.add(emFileAttr);
        }
        return emFilesAttr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Command {
        BYE,
        CD,
        CHGRP,
        CHMOD,
        CHOWN,
        EXIT,
        GET,
        GET_AS_INPUTSTREAM,
        LCD,
        LPWD,
        LS,
        MKDIR,
        PUT,
        PWD,
        QUIT,
        RENAME,
        RM,
        RMDIR;

    }
}

