/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice.maverickfacade.impl;

import com.maverick.ssh.SshException;
import com.maverick.ssh2.AuthenticationClient;
import com.maverick.ssh2.AuthenticationProtocol;
import com.maverick.ssh2.AuthenticationResult;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import se.ericsson.cello.emt.sshsftpservice.utils.impl.SshBuf;
import se.ericsson.cello.emt.sshsftpservice.utils.impl.SshUtils;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509AuthenticationClient
implements AuthenticationClient {
    private static final EmLogger LOG = EmLogger.SSH_SFTP_SERVICE;
    private static final String PROBLEM_CREATING_AUTHENTICATION_PACKET = "Problem creating authentication packet.";
    private static final String AUTHENTICATION_REQUIREMENT = "%s is required for X509 authentication.";
    private static final String RSA_PRIVATE_KEY = "An RSA private key";
    private static final String USERNAME = "A user name";
    private static final String CERTIFICATE_CHAIN = "At least one X509 certificate";
    private Credentials credentials;
    private boolean doAuth;
    private String userName = null;

    public X509AuthenticationClient(Credentials credentials, boolean doAuth) {
        this.credentials = credentials;
        this.doAuth = doAuth;
    }

    public String getMethod() {
        return "publickey";
    }

    public String getUsername() {
        try {
            this.extractUserName(this.getX509Certificates().get(0));
        }
        catch (SshException e) {
            LOG.severe("User name cannot be extracted", new Object[0]);
        }
        return this.userName;
    }

    public void setUsername(String username) {
        if (this.isValidName(username)) {
            this.userName = username;
        }
    }

    public void authenticate(AuthenticationProtocol authentication, String serviceToStart) throws SshException, AuthenticationResult {
        ArrayList<X509Certificate> x509Certificates = this.getX509Certificates();
        this.extractUserName(x509Certificates.get(0));
        byte[] signature = null;
        String algorithm = "x509v3-sign";
        try {
            byte[] pkblob = SshUtils.certArray2pkblob(x509Certificates);
            if (this.doAuth) {
                SshBuf toSign = new SshBuf();
                toSign.putString(authentication.getSessionIdentifier());
                toSign.putByte((byte)50);
                toSign.putString(this.userName);
                toSign.putString(serviceToStart);
                toSign.putString(this.getMethod());
                toSign.putBoolean(true);
                toSign.putString(algorithm);
                toSign.putString(pkblob);
                signature = SshUtils.rsaSha1Sign(toSign.getBytes(), this.getRsaPrivateKey());
            }
            SshBuf requestdata = new SshBuf();
            requestdata.putBoolean(this.doAuth);
            requestdata.putString(algorithm);
            requestdata.putString(pkblob);
            if (this.doAuth) {
                requestdata.putString(signature);
            }
            authentication.sendRequest(this.userName, serviceToStart, this.getMethod(), requestdata.getBytes());
        }
        catch (GeneralSecurityException e) {
            String msg = PROBLEM_CREATING_AUTHENTICATION_PACKET;
            LOG.severe(msg, new Object[0]);
            throw new SshException(msg, 4);
        }
    }

    private RSAPrivateKey getRsaPrivateKey() throws SshException {
        PrivateKey tmpPrivateKey = this.credentials.getPrivateKey();
        if (tmpPrivateKey instanceof RSAPrivateKey) {
            return (RSAPrivateKey)tmpPrivateKey;
        }
        String msg = String.format(AUTHENTICATION_REQUIREMENT, RSA_PRIVATE_KEY);
        LOG.severe(msg, new Object[0]);
        throw new SshException(msg, 4);
    }

    private ArrayList<X509Certificate> getX509Certificates() throws SshException {
        Certificate[] certChain = this.credentials.getCertificateChain();
        if (certChain == null || certChain.length == 0) {
            String msg = String.format(AUTHENTICATION_REQUIREMENT, CERTIFICATE_CHAIN);
            LOG.severe(msg, new Object[0]);
            throw new SshException(msg, 4);
        }
        ArrayList<X509Certificate> x509CertificateChain = new ArrayList<X509Certificate>();
        for (int i = 0; i < certChain.length; ++i) {
            if (!(certChain[i] instanceof X509Certificate)) continue;
            x509CertificateChain.add((X509Certificate)certChain[i]);
        }
        if (x509CertificateChain.isEmpty()) {
            String msg = String.format(AUTHENTICATION_REQUIREMENT, CERTIFICATE_CHAIN);
            LOG.severe(msg, new Object[0]);
            throw new SshException(msg, 4);
        }
        return x509CertificateChain;
    }

    private void extractUserName(X509Certificate x509Certificate) throws SshException {
        if (this.userName == null) {
            String name = this.getUserNameFromSubjectDn(x509Certificate.getSubjectDN().getName());
            if (this.isValidName(name)) {
                this.userName = name;
            } else {
                String msg = String.format(AUTHENTICATION_REQUIREMENT, USERNAME);
                LOG.severe(msg, new Object[0]);
                throw new SshException(msg, 4);
            }
        }
    }

    private String getUserNameFromSubjectDn(String subDN) {
        String[] dnSplit = subDN.split(",");
        for (int i = 0; i < dnSplit.length; ++i) {
            String token = dnSplit[i];
            if (!token.startsWith("CN=")) continue;
            return token.substring(token.indexOf(61) + 1);
        }
        return null;
    }

    private boolean isValidName(String name) {
        return name != null && name.length() > 0;
    }
}

