/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AbstractEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AtmAndPtUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.CbuMapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Etm1Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Etm3Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Etm4Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Etmc1Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Etmc41Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.EtmBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;

public class EtmBoardManager
extends AbstractEtmBoardManager {
    private Map etmMappings = this.setupEtmMappings();

    public EtmBoardManager(Rbs rbs, EtmBoardProvider etmBoardProvider) {
        super(rbs, etmBoardProvider);
    }

    protected Map setupEtmMappings() {
        HashMap<String, Mapping> hashMap = new HashMap<String, Mapping>();
        hashMap.put(MimCbu.MOTYPENAME, new CbuMapping());
        hashMap.put("Etm1", new Etm1Mapping());
        hashMap.put("Etmc1", new Etmc1Mapping());
        hashMap.put("Etm3", new Etm3Mapping());
        hashMap.put("Etm4", new Etm4Mapping());
        hashMap.put("Etmc41", new Etmc41Mapping());
        return hashMap;
    }

    protected Map createBoardSlots(List list) {
        HashMap<String, TreeMap> hashMap = new HashMap<String, TreeMap>();
        String[] stringArray = super.getEtmBoardProvider().getSupportedEtmBoardTypesForAtm();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], new TreeMap());
        }
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EtmBoard etmBoard = (EtmBoard)iterator.next();
                String string = etmBoard.getTransportCapabilty();
                if (!"ATM".equals(string)) continue;
                String string2 = etmBoard.getType();
                String string3 = String.valueOf(etmBoard.getSlotNo());
                TreeMap treeMap = (TreeMap)hashMap.get(string2);
                treeMap.put(Integer.valueOf(string3), null);
                hashMap.remove(string2);
                hashMap.put(string2, treeMap);
            }
        }
        return hashMap;
    }

    public String[] getAvailableLines(String string, TerminationParameterList[] terminationParameterListArray, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        Set set = this.getAlreadyOccupiedLines(string, terminationParameterListArray);
        Mapping mapping = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            mapping = this.getEtmMapping(string, this.getSlotMappings());
            Integer n = mapping.getMaxNoOfLines(string2);
            for (int i = 1; i <= n; ++i) {
                String string3 = "" + i;
                if (set.contains(string3)) continue;
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList.toArray(new String[0]);
    }

    public String getStandard(String string, String string2) {
        Mapping mapping = this.getEtmMapping(string, this.getSlotMappings());
        return mapping.getStandard(string2);
    }

    protected void createSlotMappings(Map map, EtmBoardProvider etmBoardProvider) {
        String[] stringArray = etmBoardProvider.getSupportedEtmBoardTypesForAtm();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.getSlotsForBoardType(stringArray[i]);
            if (stringArray2 == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                map.put(stringArray2[j], this.etmMappings.get(stringArray[i]));
            }
        }
    }

    protected Collection getAllEtmMapping() {
        return this.etmMappings.values();
    }

    public String[] getAllSupportedStandards() {
        ArrayList arrayList = new ArrayList();
        Collection collection = this.getAllEtmMapping();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Mapping mapping = (Mapping)iterator.next();
            String[] stringArray = mapping.getSupportedStandards();
            AtmAndPtUtil.addSupportedValuesIntoRange(arrayList, stringArray);
        }
        return AtmAndPtUtil.convertListIntoStringArray(arrayList);
    }

    public String[] getAllSupportedTerminationTypes() {
        ArrayList arrayList = new ArrayList();
        Collection collection = this.getAllEtmMapping();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Mapping mapping = (Mapping)iterator.next();
            String[] stringArray = mapping.getSupportedTerminationTypes();
            AtmAndPtUtil.addSupportedValuesIntoRange(arrayList, stringArray);
        }
        return AtmAndPtUtil.convertListIntoStringArray(arrayList);
    }

    protected Mapping getEtmMapping(String string, Map map) {
        return (Mapping)map.get(string);
    }

    public String[] getAvailableTerminationTypes(String string, String string2) {
        Map map = super.getSlotMappings();
        Mapping mapping = this.getEtmMapping(string, map);
        if (mapping == null) {
            return null;
        }
        Mapping mapping2 = mapping;
        return mapping2.getTerminationTypes(string2);
    }

    public String[] getAvailableStandards(String string) throws BemException {
        Map map = super.getSlotMappings();
        Mapping mapping = this.getEtmMapping(string, map);
        if (mapping != null) {
            return this.getAvailableStandards(mapping);
        }
        return null;
    }

    public String[] getAvailableTerminationTypes(String string) throws BemException {
        Map map = super.getSlotMappings();
        Mapping mapping = this.getEtmMapping(string, map);
        if (mapping != null) {
            return this.getAvailableTerminationTypes(mapping);
        }
        return null;
    }

    private String[] getAvailableTerminationTypes(Mapping mapping) {
        String[] stringArray = null;
        stringArray = AbstractTerminationRI.getLoadedStandard() == null ? mapping.getSupportedTerminationTypes() : mapping.getTerminationTypes(AbstractTerminationRI.getLoadedStandard());
        return stringArray;
    }
}

