/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.MappingInfo;
import se.ericsson.wcdma.rbs.bem.common.mim.MimE1PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimJ1PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimT1PhysPathTerm;

public class DuwEtmc1Mapping
extends Mapping {
    private static final String[] ALL_TERMINATION_TYPES = new String[]{"E1", "IMA_E1", "J1", "IMA_J1", "T1", "IMA_T1"};
    private static final String[] ALL_STANDARDS = new String[]{"ETSI", "ANSI", "TTC"};

    public static int getAllTerminationTypesLength() {
        return ALL_TERMINATION_TYPES.length;
    }

    public static String getAllTerminationTypesByIndex(int n) {
        return ALL_TERMINATION_TYPES[n];
    }

    public static int getAllStandardsLength() {
        return ALL_STANDARDS.length;
    }

    public DuwEtmc1Mapping() {
        ArrayList arrayList = DuwEtmc1Mapping.createMappingInfo();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.addMappingInfo((MappingInfo)iterator.next());
        }
    }

    protected static ArrayList createMappingInfo() {
        ArrayList<MappingInfo> arrayList = new ArrayList<MappingInfo>();
        arrayList.add(new MappingInfo("E1", "ETSI", MimE1PhysPathTerm.MOTYPENAME, "lineNo", MAX_PCR_E1, MAX_LINE_NO_E1_DUW));
        arrayList.add(new MappingInfo("IMA_E1", "ETSI", MimE1PhysPathTerm.MOTYPENAME, "lineNo", MAX_PCR_E1, MAX_PCR_E1, MIN_LINE_NO_DEFAULT, MAX_LINE_NO_E1_DUW, MAX_LINE_NO_E1_DUW, false, false, true, null));
        arrayList.add(new MappingInfo("J1", "TTC", MimJ1PhysPathTerm.MOTYPENAME, "lineNo", MAX_PCR_J1, MAX_LINE_NO_J1_DUW));
        arrayList.add(new MappingInfo("IMA_J1", "TTC", MimJ1PhysPathTerm.MOTYPENAME, "lineNo", MAX_PCR_J1, MAX_PCR_J1, MIN_LINE_NO_DEFAULT, MAX_LINE_NO_J1_DUW, MAX_LINE_NO_J1_DUW, false, false, true, null));
        arrayList.add(new MappingInfo("T1", "ANSI", MimT1PhysPathTerm.MOTYPENAME, "lineNo", MAX_PCR_T1, MAX_LINE_NO_T1_DUW));
        arrayList.add(new MappingInfo("IMA_T1", "ANSI", MimT1PhysPathTerm.MOTYPENAME, "lineNo", MAX_PCR_T1, MAX_PCR_T1, MIN_LINE_NO_DEFAULT, MAX_LINE_NO_T1_DUW, MAX_LINE_NO_T1_DUW, false, false, true, null));
        return arrayList;
    }

    public static String getDefaultTerminationTypeForDefaultOamLink() {
        return "E1";
    }

    public static String getDefaultStandard() {
        return "ETSI";
    }

    public String[] getSupportedTerminationTypes() {
        return ALL_TERMINATION_TYPES;
    }

    public String[] getSupportedStandards() {
        return ALL_STANDARDS;
    }
}

