/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AbstractEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.PhysicalLineParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.ReqNoOfLinksParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mim.MimImaGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTransportNetwork;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class ImaRI
extends AbstractResourceItem {
    private static final String NAME = "ImaGroup";
    private static final String[] myInstallationPhases = new String[]{"FractionalAndImaTermCreationPhase", "FractionalAndImaTermDeletionPhase"};
    private static Set usedImaIds = new HashSet();
    private AbstractTerminationRI terminationRI = null;
    private String loadedLdn = null;
    private String ldn = null;
    private EtbSlotParameter slotParameter = null;
    private TerminationTypeParameter terminationTypeParameter = null;
    private ReqNoOfLinksParameter requiredNumberOfLinksParameter = null;
    private PhysicalLineParameter physicalLineParameter = null;
    private AbstractEtmBoardManager boardManager = null;
    private MoHandler theMoHandler = null;
    private boolean isToBeInstalled = true;

    public ImaRI(Rbs rbs, String string, AbstractEtmBoardManager abstractEtmBoardManager, TerminationParameterList terminationParameterList) {
        super(NAME, rbs, myInstallationPhases);
        this.loadedLdn = string;
        this.boardManager = abstractEtmBoardManager;
        this.slotParameter = terminationParameterList.getSlotParameter();
        this.terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
        this.requiredNumberOfLinksParameter = terminationParameterList.getRequiredNumberOfLinksParameter();
        this.physicalLineParameter = terminationParameterList.getLineParameter();
        this.theMoHandler = rbs.getMoHandler();
    }

    public void setTerminationRI(AbstractTerminationRI abstractTerminationRI) {
        this.terminationRI = abstractTerminationRI;
    }

    public void install(String string) throws BemException {
        if (string.equals("FractionalAndImaTermCreationPhase")) {
            if (this.terminationRI != null) {
                Mapping mapping;
                boolean bl;
                if (this.isToBeInstalled() && (bl = (mapping = this.terminationRI.getMapping()).isIma(this.getSelectedTerminationType()))) {
                    this.createImaGroup();
                }
            } else {
                throw new BemException(this.getClass().getName() + " install()");
            }
        }
    }

    private void createImaGroup() throws BemException {
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("ResourceItem  (RI)", this);
        exceptionProperties.setProperty("Failing Method", this.getClass().getName() + "createImaGroup()");
        try {
            String[] stringArray = this.terminationRI.getTerminationLdns();
            BemMo[] bemMoArray = new BemMo[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                bemMoArray[i] = this.theMoHandler.getMo(stringArray[i]);
            }
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("physicalPortList", bemMoArray));
            String string = this.requiredNumberOfLinksParameter.getValue();
            Integer n = new Integer(1);
            if (string != null) {
                n = new Integer(string);
            }
            vector.add(Nal.getFactory().getNameValue("requiredNumberOfLinks", n));
            String string2 = this.generateImaGroupLdn();
            BemMo bemMo = this.theMoHandler.getMo(string2);
            boolean bl = this.theMoHandler.isExisting(bemMo);
            if (bl) {
                this.setImaAttributes(bemMo);
            } else {
                this.createMoIfNotExisting(string2, vector);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Failed in createImaGroup()", exceptionProperties, (Throwable)moHandlerException);
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("FractionalAndImaTermDeletionPhase")) {
            if (this.terminationRI != null) {
                Mapping mapping;
                boolean bl;
                if (this.isToBeUnInstalled() && (bl = (mapping = this.terminationRI.getMapping()).isIma(this.getSelectedTerminationType()))) {
                    this.deleteImaGroup();
                }
            } else {
                throw new BemException(this.getClass().getName() + " uninstall()");
            }
        }
    }

    private void deleteImaGroup() throws BemException {
        this.deleteMoIfNotExisting(this.loadedLdn);
    }

    public boolean isToBeInstalled() {
        return this.isToBeInstalled;
    }

    public boolean isToBeUnInstalled() {
        return !this.isToBeInstalled;
    }

    public void setToBeInstalled() {
        this.isToBeInstalled = true;
    }

    public void setToBeUnInstalled() {
        this.isToBeInstalled = false;
    }

    public String generateImaGroupLdn() throws MoHandlerException {
        String string = this.loadedLdn;
        if (string == null && (string = this.ldn) == null) {
            String string2 = this.getSelectedSlot();
            String string3 = this.boardManager.getSubrackId(string2);
            String string4 = this.getFreeImaId(string3, string2);
            usedImaIds.add(string4);
            String string5 = MimImaGroup.MOTYPENAME + "=" + string4;
            String string6 = this.getTransportNetworkLdn();
            string = string6 + "," + string5;
        }
        this.ldn = string;
        return string;
    }

    private String getFreeImaId(String string, String string2) throws MoHandlerException {
        Object object;
        int n = 1;
        String string3 = string + "-" + string2 + "-ima";
        String string4 = string3 + n;
        int n2 = 0;
        String string5 = this.getTransportNetworkLdn();
        BemMo bemMo = this.theMoHandler.getMo(string5);
        BemMo[] bemMoArray = this.theMoHandler.getChildren(bemMo, 1, MimImaGroup.MOTYPENAME, "");
        if (bemMoArray == null) {
            return string4;
        }
        int n3 = bemMoArray.length;
        Vector<String> vector = new Vector<String>(0, 1);
        for (int i = 0; i < bemMoArray.length; ++i) {
            object = bemMoArray[i];
            String string6 = object.getId();
            vector.add(string6);
        }
        String[] stringArray = vector.toArray(new String[0]);
        for (n = 1; n <= n3; ++n) {
            string4 = string3 + n;
            if (usedImaIds.contains(string4)) continue;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                try {
                    object = stringArray[n2];
                    if (!((String)object).equals(string4)) continue;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n2 == stringArray.length) break;
        }
        while (n <= usedImaIds.size() + n3 + 1 && usedImaIds.contains(string4 = string3 + n)) {
            ++n;
        }
        return string4;
    }

    protected String getSelectedSlot() {
        return this.slotParameter.getValue();
    }

    protected String getSelectedTerminationType() {
        return this.terminationTypeParameter.getValue();
    }

    protected String[] getSelectedLines() {
        return this.physicalLineParameter.getAllLines();
    }

    protected String getTransportNetworkLdn() throws MoHandlerException {
        BemMo bemMo = this.theMoHandler.getRoot();
        BemMo[] bemMoArray = this.theMoHandler.getChildren(bemMo, 1, MimTransportNetwork.MOTYPENAME, "");
        String string = bemMoArray[0].getDN();
        return string;
    }

    public static void resetUsedImaIds() {
        usedImaIds = new HashSet();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public void resetLdn() {
        if (this.loadedLdn == null) {
            this.ldn = null;
        }
    }

    public String getLdn() {
        String string = "";
        if (this.loadedLdn != null) {
            string = this.loadedLdn;
        }
        return string;
    }

    private void setImaAttributes(BemMo bemMo) throws MoHandlerException {
        String string;
        String string2 = this.requiredNumberOfLinksParameter.getLoadedValue();
        if (!string2.equals(string = this.requiredNumberOfLinksParameter.getValue())) {
            String string3 = this.requiredNumberOfLinksParameter.getAttributeName();
            Object object = this.requiredNumberOfLinksParameter.getValueMom();
            this.theMoHandler.setAttribute(bemMo, string3, object);
        }
    }

    public void setLoadedLdn(String string) {
        this.loadedLdn = string;
    }

    public boolean usesSameTerminations(ImaRI imaRI) {
        String string;
        boolean bl = false;
        String string2 = imaRI.getSelectedSlot();
        if (string2.equals(string = this.getSelectedSlot())) {
            Object[] objectArray = imaRI.getSelectedLines();
            Object[] objectArray2 = this.getSelectedLines();
            bl = Arrays.equals(objectArray2, objectArray);
        }
        return bl;
    }
}

