/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.util;

import java.util.ArrayList;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOs155SpiTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSts3CspeTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVc4Ttp;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class Etm4TerminationUtil {
    public static final String RESERVEDBY = "reservedBy";

    public static void createTermination(AbstractTerminationRI abstractTerminationRI, Mapping mapping) throws BemException {
        String[] stringArray = abstractTerminationRI.getSelectedLines();
        String string = abstractTerminationRI.getSelectedStandard();
        String string2 = mapping.getLineAttributeName(string);
        String string3 = mapping.getMoTypeName(string);
        for (int i = 0; i < stringArray.length; ++i) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>(0, 1);
            NalNameValue nalNameValue = Nal.getFactory().getNameValue(string2, new Integer(stringArray[i]));
            vector.add(nalNameValue);
            Integer n = null;
            if (string.equals("ETSI")) {
                n = new Integer(1);
            } else if (string.equals("TTC")) {
                n = new Integer(2);
            } else if (string.equals("ANSI")) {
                n = new Integer(0);
            }
            NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("standardMode", n);
            vector.add(nalNameValue2);
            Integer n2 = new Integer(2);
            NalNameValue nalNameValue3 = Nal.getFactory().getNameValue("muxMode", n2);
            vector.add(nalNameValue3);
            String string4 = abstractTerminationRI.generateTerminationLdn(string3, stringArray[i]);
            abstractTerminationRI.createRiMoIfNotExisting(string4, vector);
        }
    }

    public static void deleteTermination(AbstractTerminationRI abstractTerminationRI, MoHandler moHandler) throws BemException {
        String[] stringArray = abstractTerminationRI.getLinesToUnInstall();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                ArrayList arrayList;
                String string2 = abstractTerminationRI.getLdnFromLine(stringArray[i]);
                if (string2 == null || !(arrayList = abstractTerminationRI.getReferencesToOtherMOs(string2, RESERVEDBY)).isEmpty() || (string = abstractTerminationRI.getSubLdn(string2, MimOs155SpiTtp.MOTYPENAME)) == null || abstractTerminationRI.isConnectedToSync(string)) continue;
                abstractTerminationRI.deleteRiMoIfNotExisting(string);
            }
        }
    }

    public static String[] getTerminationLdns(AbstractTerminationRI abstractTerminationRI) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = abstractTerminationRI.getSelectedLines();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = Etm4TerminationUtil.getLdn(stringArray[i], abstractTerminationRI);
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    private static String getLdn(String string, AbstractTerminationRI abstractTerminationRI) {
        String string2 = abstractTerminationRI.getLdnFromLine(string);
        if (string2 == null) {
            String string3 = abstractTerminationRI.generateTerminationLdn(MimOs155SpiTtp.MOTYPENAME, string);
            String string4 = abstractTerminationRI.getSelectedStandard();
            if (string4.equals("ETSI") || string4.equals("TTC")) {
                string2 = string3 + "," + MimVc4Ttp.MOTYPENAME + "=1";
            } else if (string4.equals("ANSI")) {
                string2 = string3 + "," + MimSts3CspeTtp.MOTYPENAME + "=1";
            }
        }
        return string2;
    }

    public static String generateTerminationLdn(AbstractTerminationRI abstractTerminationRI, String string) {
        String string2 = abstractTerminationRI.generateTerminationLdn(MimOs155SpiTtp.MOTYPENAME, string);
        String string3 = abstractTerminationRI.getLdnFromLine(string);
        if (string3 != null) {
            int n;
            int n2 = string3.indexOf(MimOs155SpiTtp.MOTYPENAME);
            if (n2 != -1 && (n = string3.indexOf(",", n2)) != -1) {
                string3 = string3.substring(0, n);
            }
            string2 = string3;
        }
        return string2;
    }

    public static String getSynchTerminationMoType() {
        return MimOs155SpiTtp.MOTYPENAME;
    }
}

