/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDeviceBoardRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTimingUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTuSyncRef;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class CbuRI
extends AbstractDeviceBoardRI {
    public static final String name = "CBU";
    public static final String WIZARD_SWALLOC_ROLE_CBU = "RBS_CBU_Main";
    public static final String WIZARD_REPERTOIRE_CBU = "RBS_MP_Main";
    public static final String WIZARD_REPERTOIRE_CBU_REDUNDANCY = "Cello_Common_Main_FTC_Redundancy";
    public static final String WIZARD_REPERTOIRE_CELLO_OLD = "Cello_Common_CBU";
    private final Integer PIU_GROUP_NUMBER = new Integer(1);
    private BemMo[] tuSyncRefMOs;
    private boolean redundancyChanged = false;
    private final boolean isRedundant;

    public CbuRI(Rbs rbs, int n, MoInstance moInstance) {
        this(rbs, n, moInstance, false, null);
    }

    public CbuRI(Rbs rbs, int n, MoInstance moInstance, boolean bl, String string) {
        super(name, rbs, n, MimCbu.MOTYPENAME, moInstance, false);
        this.isRedundant = bl;
        super.setRoleForSwAllocation(WIZARD_SWALLOC_ROLE_CBU);
        if (string == null) {
            super.addRepertoiresToInstall(WIZARD_REPERTOIRE_CBU);
        } else {
            super.addRepertoiresToInstall(string);
            super.addRepertoiresToUninstall(WIZARD_REPERTOIRE_CELLO_OLD);
        }
        super.createPiuAndBoard(true);
    }

    public CbuRI(Rbs rbs, int n, MoInstance moInstance, boolean bl, String string, String string2) {
        super(name, rbs, n, MimCbu.MOTYPENAME, moInstance, false);
        this.isRedundant = bl;
        super.setRoleForSwAllocation(WIZARD_SWALLOC_ROLE_CBU);
        if (string == null) {
            super.addRepertoiresToInstall(string2);
        } else {
            super.addRepertoiresToInstall(string);
            super.addRepertoiresToUninstall(WIZARD_REPERTOIRE_CELLO_OLD);
        }
        super.createPiuAndBoard(true);
    }

    private BemMo[] getTuSyncRefMOs() throws BemException {
        SingleChildMoi singleChildMoi = new SingleChildMoi(this.piuMoi, super.getBoardType(), "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimTimingUnit.MOTYPENAME, "1");
        String string = singleChildMoi2.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isExisting(bemMo);
        if (bl) {
            this.tuSyncRefMOs = this.getChildren(bemMo, 2, MimTuSyncRef.MOTYPENAME, "");
        }
        return this.tuSyncRefMOs;
    }

    public void install(String string) throws BemException {
        String string2;
        if (string.equals("DeviceBoardCreationPhase")) {
            if (this.rbs.getCustomerParameterObject("redundantControlSystem").hasValueChanged()) {
                this.redundancyChanged = true;
            }
            if ((string2 = this.rbs.getCustomerParameter("redundantControlSystem")).equals("YES")) {
                super.addRepertoiresToInstall(WIZARD_REPERTOIRE_CBU_REDUNDANCY);
            } else {
                super.addRepertoiresToUninstall(WIZARD_REPERTOIRE_CBU_REDUNDANCY);
            }
        }
        super.install(string);
        if (string.equals("DeviceBoardCreationPhase") && this.redundancyChanged && !this.isRedundant) {
            this.reconfigureProgramPrepare();
        }
        if (string.equals("DeviceBoardWaitingForPnpPhase")) {
            this.setPiuGroupNumberAttribute(this.PIU_GROUP_NUMBER);
            string2 = this.rbs.getRbsStep();
            if (string2.equals("STEP_CABINET")) {
                this.unlockDeviceBoard();
            }
        }
        if (string.equals("EcPortCreationPhase")) {
            super.installEcPort(name);
        }
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.getLdn());
    }

    public String[] getTuSynchRefLdns() throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{};
        BemMo[] bemMoArray = this.getTuSyncRefMOs();
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                arrayList.add(bemMoArray[i].getDN());
            }
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public boolean isTuSynchRef() throws BemException {
        boolean bl = false;
        BemMo[] bemMoArray = this.getTuSyncRefMOs();
        if (bemMoArray != null) {
            bl = true;
        }
        return bl;
    }
}

