/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.duw;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGeneralProcessorUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimMediumAccessUnit;

public class MediumAccessUnitRI
extends AbstractResourceItem {
    private static final String[] myInstallationPhases = new String[]{"MediumAccessUnitCreationPhase"};
    private static final String NAME = "MEDIUM_ACCESS_UNIT";
    private final String parentLdn;
    private final String mediumAccessUnitLdn;

    public MediumAccessUnitRI(Rbs rbs, String string) {
        super(NAME, rbs, myInstallationPhases);
        this.parentLdn = string + "," + MimGeneralProcessorUnit.MOTYPENAME + "=1";
        this.mediumAccessUnitLdn = this.parentLdn + "," + MimMediumAccessUnit.MOTYPENAME + "=1";
    }

    public void install(String string) throws BemException {
        if (myInstallationPhases[0].equals(string)) {
            this.createMediumAccessUnitIfNotExisting();
        }
    }

    private void createMediumAccessUnitIfNotExisting() throws BemException {
        boolean bl = super.isExisting(this.parentLdn);
        if (bl) {
            super.createMoIfNotExisting(this.mediumAccessUnitLdn);
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = super.isExisting(this.mediumAccessUnitLdn);
        return bl;
    }

    public String getDisplayName() {
        return NAME;
    }

    public String getLdn() {
        return this.mediumAccessUnitLdn;
    }
}

