/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class HwGroupRI
extends AbstractResourceItem {
    public static final String name = "HwGroup";
    private static final String[] myInstallationPhases = new String[]{"HwGroupCreationPhase"};
    private final String ldn;
    private final int index;

    public HwGroupRI(Rbs rbs, String string, int n) {
        super(name, rbs, myInstallationPhases);
        this.ldn = string;
        this.index = n;
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return this.ldn;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(myInstallationPhases, string)) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            String string2 = this.getHwGroupPrefix();
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2 + "positionInformation");
            if (customerParameterServer.hasValueChanged()) {
                vector.add(Nal.getFactory().getNameValue("positionInformation", customerParameterServer.getValueMom()));
            }
            if (!this.isExisting(this.ldn)) {
                if (vector.size() > 0) {
                    this.createMoIfNotExisting(this.ldn, vector);
                } else {
                    this.createMoIfNotExisting(this.ldn);
                }
            } else if (vector.size() > 0) {
                this.setAttributes(this.getMo(this.ldn), vector);
            }
        }
    }

    private String getHwGroupPrefix() {
        return PrefixUtil.getHwGroupPrefix(this.index);
    }

    public void setLoadedValues() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        if (bemMo.isExisting()) {
            String string = this.getHwGroupPrefix();
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "positionInformation");
            String string2 = (String)this.getAttribute(bemMo, "positionInformation");
            customerParameterServer.setLoadedValue(string2);
            customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "hwGroupId");
            customerParameterServer.setLoadedValue(bemMo.getId());
        }
    }
}

