/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractHwUnitWithEcPortRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwUnit;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SupRI
extends AbstractHwUnitWithEcPortRI {
    public static final String NAME = "SUP";
    private static final String piuTypeProductName = "SUP";
    private static final String piuTypeProductNumber = "SUPSS000";
    static final String[] myInstallationPhases = new String[]{"HwUnitDbControlledCreationPhase", "HwUnitReconfigureProgramPreparePhase", "UnlockAllUnitsPhase", "HwUnitDbControlledDeletionPhase", "LockPhase", "UnlockPhase"};
    private int supNumber;
    private String hwUnitLdn;
    protected FixedRdnMoi hwUnitMoi;

    public SupRI(Rbs rbs, int n) throws BemException {
        super("SUP", rbs, "SUP", piuTypeProductNumber, myInstallationPhases);
        this.supNumber = n;
        this.setSwLoadable(false);
        this.setupMoi();
    }

    public String getDisplayName() {
        return "SUP: " + this.getLdn();
    }

    public String getLdn() {
        return this.hwUnitLdn;
    }

    public MoInstance getHwUnitMoi() {
        return this.hwUnitMoi;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            super.install(string);
        }
    }

    protected void createEcPort(String string, String string2, Integer n) throws BemException {
        BemMo bemMo = this.getMo(string);
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("hubPosition", string2));
        vector.add(Nal.getFactory().getNameValue("cascadingOrder", n));
        if (DuwUtil.isDualBoxConfiguration(this.rbs.getRbsType())) {
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getMoiRefs().getEquipmentMoi(), MimEcBus.MOTYPENAME, String.valueOf(this.supNumber));
            BemMo bemMo2 = this.rbs.getMoHandler().getMo(fixedRdnMoi.getLdn());
            vector.add(Nal.getFactory().getNameValue("ecBusRef", bemMo2));
            if (!this.isExisting(bemMo)) {
                super.createMoIfNotExisting(string, vector);
            } else {
                this.setAttributes(bemMo, vector);
            }
        } else {
            super.createEcPort(string, string2, n);
        }
    }

    private void setupMoi() throws BemException {
        String string = "SUP-" + String.valueOf(this.supNumber);
        this.hwUnitMoi = new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimHwUnit.MOTYPENAME, string);
        this.hwUnitLdn = this.hwUnitMoi.getLdn();
    }
}

