/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.PowerSupplySystemRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.PcuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.PowerSubrackFanRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.PowerSupplySubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.PsuNpuRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPcuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPsu;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class PowerManager {
    private Rbs rbs;
    private String cabPosition;
    private String subrackPosition;
    private ArrayList listOfRIs;
    private PcuRI pcuRI;
    private PowerSupplySubrackRI powerSupplySubrackRI;
    private PowerSupplySystemRI powerSupplySystemRI;
    private PowerSubrackFanRI powerSubrackFanRI;
    private TreeMap psuRIs = new TreeMap();
    private int[] psuSlots = new int[0];
    private int noOfPsus;
    private int nrOfPSSlots;
    private IntegerRange psuRange;
    private boolean isPowerSupplyMandatory;
    private boolean hasMandatoryPowerSubrackFan;
    private boolean hasOptionalPowerSubrackFan;

    public PowerManager(Rbs rbs, boolean bl, String string, String string2, int[] nArray, IntegerRange integerRange, int n, boolean bl2) throws BemException {
        this.noOfPsus = nArray.length;
        this.rbs = rbs;
        this.cabPosition = string;
        this.subrackPosition = string2;
        this.psuSlots = nArray;
        this.nrOfPSSlots = n;
        this.psuRange = integerRange;
        this.isPowerSupplyMandatory = bl;
        this.hasMandatoryPowerSubrackFan = bl2;
        this.hasOptionalPowerSubrackFan = false;
        this.listOfRIs = new ArrayList(8);
        this.createRIs();
    }

    public PowerManager(Rbs rbs, boolean bl, String string, String string2, int[] nArray, IntegerRange integerRange, int n, boolean bl2, boolean bl3) throws BemException {
        this(rbs, bl, string, string2, nArray, integerRange, n, bl2);
        this.hasOptionalPowerSubrackFan = bl3;
    }

    private void createRIs() throws BemException {
        MoInstance moInstance = this.rbs.getEquipmentMoi();
        this.powerSupplySubrackRI = new PowerSupplySubrackRI(this.rbs, this.nrOfPSSlots, this.cabPosition, this.subrackPosition, moInstance);
        MoInstance moInstance2 = this.powerSupplySubrackRI.getMoiSlot(1);
        this.pcuRI = new PcuRI(this.rbs, 1, moInstance2);
        for (int i = 0; i < this.noOfPsus; ++i) {
            Integer n = new Integer(this.psuSlots[i]);
            MoInstance moInstance3 = this.powerSupplySubrackRI.getMoiSlot(n);
            PsuNpuRI psuNpuRI = new PsuNpuRI(this.rbs, this.psuSlots[i], moInstance3);
            this.psuRIs.put(n, psuNpuRI);
            this.listOfRIs.add(psuNpuRI);
        }
        this.powerSupplySystemRI = new PowerSupplySystemRI(this.rbs, moInstance);
        MoInstance moInstance4 = this.powerSupplySubrackRI.getMoiPowerSupplySubrack();
        this.powerSubrackFanRI = new PowerSubrackFanRI(this.rbs, moInstance4);
        this.listOfRIs.add(this.powerSupplySubrackRI);
        this.listOfRIs.add(this.pcuRI);
        this.listOfRIs.add(this.powerSupplySystemRI);
        this.listOfRIs.add(this.powerSubrackFanRI);
    }

    public ArrayList getRIsToBeInstalled(boolean bl, int n, boolean bl2) throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (bl) {
            arrayList.add(this.powerSupplySystemRI);
            arrayList.add(this.powerSupplySubrackRI);
            arrayList.add(this.pcuRI);
            if (this.hasMandatoryPowerSubrackFan || this.hasOptionalPowerSubrackFan && bl2) {
                arrayList.add(this.powerSubrackFanRI);
            }
            ArrayList arrayList2 = this.getPsuRIsToBeInstalled(n);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public ArrayList getRIsToBeUnInstalled(int n) throws BemException {
        ArrayList arrayList = this.getPsuRIsToBeUnInstalled(n);
        arrayList.add(this.pcuRI);
        this.pcuRI.setDeleteUnitRequested(false);
        this.pcuRI.setForceUnlockRequested(true);
        return arrayList;
    }

    private int countInstalledPsus(TreeMap treeMap) throws BemException {
        int n = 0;
        Set set = treeMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            PsuNpuRI psuNpuRI = (PsuNpuRI)entry.getValue();
            boolean bl = psuNpuRI.isInstalled();
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    protected ArrayList getPsuRIsToBeInstalled(int n) {
        ArrayList<PsuNpuRI> arrayList = new ArrayList<PsuNpuRI>();
        if (this.psuRIs != null) {
            Set set = this.psuRIs.keySet();
            Iterator iterator = set.iterator();
            for (int i = 0; i < n; ++i) {
                if (!iterator.hasNext()) continue;
                Object k = iterator.next();
                PsuNpuRI psuNpuRI = (PsuNpuRI)this.psuRIs.get(k);
                arrayList.add(psuNpuRI);
            }
        }
        return arrayList;
    }

    protected ArrayList getPsuRIsToBeUnInstalled(int n) throws BemException {
        ArrayList<PsuNpuRI> arrayList = new ArrayList<PsuNpuRI>();
        if (this.psuRIs != null) {
            int n2;
            Set set = this.psuRIs.keySet();
            Object[] objectArray = set.toArray();
            for (int i = n2 = objectArray.length - 1; i > 0; --i) {
                PsuNpuRI psuNpuRI = (PsuNpuRI)this.psuRIs.get(objectArray[i]);
                if (n <= 0 || !psuNpuRI.isInstalled()) continue;
                arrayList.add(psuNpuRI);
                --n;
            }
        }
        return arrayList;
    }

    public BemMo[] getConfiguredPsuMos() throws BemException {
        BemMo[] bemMoArray;
        String string = this.powerSupplySubrackRI.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string);
        try {
            bemMoArray = moHandler.getChildren(bemMo, 3, MimPsu.MOTYPENAME, "");
        }
        catch (MoHandlerException moHandlerException) {
            String string2 = moHandlerException.getAction();
            String string3 = moHandlerException.getAdditionalInfo();
            throw new BemException(string2, "checkConfiguration", string, string3, moHandlerException);
        }
        return bemMoArray;
    }

    public BemMo[] getConfiguredPcuMos() throws BemException {
        BemMo[] bemMoArray;
        String string = this.powerSupplySubrackRI.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string);
        try {
            bemMoArray = moHandler.getChildren(bemMo, 3, MimPcuDeviceGroup.MOTYPENAME, "");
        }
        catch (MoHandlerException moHandlerException) {
            String string2 = moHandlerException.getAction();
            String string3 = moHandlerException.getAdditionalInfo();
            throw new BemException(string2, "checkConfiguration", string, string3, moHandlerException);
        }
        return bemMoArray;
    }

    public int getInstalledNumberOfPsus() throws BemException {
        int n = this.countInstalledPsus(this.psuRIs);
        return n;
    }

    public boolean isPowerSupplyInstalled() throws BemException {
        boolean bl = this.powerSupplySubrackRI.isInstalled();
        return bl;
    }

    public boolean isPowerSubrackFanInstalled() throws BemException {
        boolean bl = this.powerSubrackFanRI.isInstalled();
        return bl;
    }

    public IntegerRange getPsuRange() {
        return this.psuRange;
    }

    public boolean isConfigurePowerSupplyMandatory() {
        return this.isPowerSupplyMandatory;
    }
}

