/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardListener;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;

public interface EtmBoardProvider {
    public static final String ETM1_TYPE = "Etm1";
    public static final String ETMC1_TYPE = "Etmc1";
    public static final String ETM3_TYPE = "Etm3";
    public static final String ETM4_TYPE = "Etm4";
    public static final String ETMC41_TYPE = "Etmc41";
    public static final String ETMFX11_TYPE = "Etmfx11";
    public static final String ETMFX14_TYPE = "Etmfx14";
    public static final String CBU_TYPE = "Cbu";
    public static final String DUW_TYPE = "Duw";
    public static final String PSEUDO_SLOTS_ETM1 = "slotsForETM1";
    public static final String PSEUDO_SLOTS_ETMC1 = "slotsForETMC1";
    public static final String PSEUDO_SLOTS_ETM3 = "slotsForETM3";
    public static final String PSEUDO_SLOTS_ETM4 = "slotsForETM4";
    public static final String PSEUDO_SLOTS_ETMC41 = "slotsForETMC41s";
    public static final String PSEUDO_SLOTS_ETMFX11 = "slotsForETMFX11";
    public static final String PSEUDO_SLOTS_ETMFX14 = "slotsForETMFX14";
    public static final String ETM1_DISPLAY_TYPE = "ET-M1";
    public static final String ETMC1_DISPLAY_TYPE = "ET-MC1";
    public static final String ETM3_DISPLAY_TYPE = "ET-M3";
    public static final String ETM4_DISPLAY_TYPE = "ET-M4";
    public static final String ETMC41_DISPLAY_TYPE = "ET-MC41s";
    public static final String ETMFX11_DISPLAY_TYPE = "ET-MFX11";
    public static final String ETMFX14_DISPLAY_TYPE = "ET-MFX14";
    public static final String CBU_DISPLAY_TYPE = "CBU";
    public static final String DUW_DISPLAY_TYPE = "DUW";
    public static final EtmTypeLookUpTable ETM_TYPE_MAPING = new EtmTypeLookUpTable();

    public void addEtmBoardListener(EtmBoardListener var1);

    public List getEtmCapableBoards();

    public String[] getAllSupportedSlots();

    public String getTypeForExistingBoard(String var1) throws BemException;

    public String[] getSupportedEtmBoardTypesForAtm();

    public String[] getSupportedEtmBoardTypesForIp();

    public MoInstance getExchangeTerminalMoi(String var1) throws BemException;

    public MoInstance getExchangeTerminalIpMoi();

    public String[] getAllPossibleEtmBoards();

    public String[] getAllPossibleEtmBoardsForSlot(String var1);

    public static class EtmTypeLookUpTable {
        private final Map type2display = new HashMap();
        private final Map display2type = new HashMap();
        private final Map pseudo2display = new HashMap();
        private final Map pseudo2type = new HashMap();
        private final Map display2pseudo = new HashMap();
        public final NamePair ETM1 = new NamePair("Etm1", "ET-M1", "slotsForETM1");
        public final NamePair ETM3 = new NamePair("Etm3", "ET-M3", "slotsForETM3");
        public final NamePair ETM4 = new NamePair("Etm4", "ET-M4", "slotsForETM4");
        public final NamePair ETMC1 = new NamePair("Etmc1", "ET-MC1", "slotsForETMC1");
        public final NamePair ETMC41 = new NamePair("Etmc41", "ET-MC41s", "slotsForETMC41s");
        public final NamePair ETMFX11 = new NamePair("Etmfx11", "ET-MFX11", "slotsForETMFX11");
        public final NamePair ETMFX14 = new NamePair("Etmfx14", "ET-MFX14", "slotsForETMFX14");
        public final NamePair DUW = new NamePair("Duw", "DUW", "Duw");
        public final NamePair CBU = new NamePair("Cbu", "CBU", "Cbu");

        public String display2type(String string) {
            return (String)this.display2type.get(string);
        }

        public String type2display(String string) {
            return (String)this.type2display.get(string);
        }

        public String pseudo2display(String string) {
            return (String)this.pseudo2display.get(string);
        }

        public String display2pseudo(String string) {
            return (String)this.display2pseudo.get(string);
        }

        public String pseudo2type(String string) {
            return (String)this.pseudo2type.get(string);
        }

        public class NamePair {
            public final String ETM_TYPE;
            public final String DISPLAY_TYPE;
            public final String PSEUDO;

            NamePair(String string, String string2, String string3) {
                this.ETM_TYPE = string;
                this.DISPLAY_TYPE = string2;
                this.PSEUDO = string3;
                EtmTypeLookUpTable.this.type2display.put(this.ETM_TYPE, this.DISPLAY_TYPE);
                EtmTypeLookUpTable.this.display2type.put(this.DISPLAY_TYPE, this.ETM_TYPE);
                EtmTypeLookUpTable.this.pseudo2display.put(this.PSEUDO, this.DISPLAY_TYPE);
                EtmTypeLookUpTable.this.display2pseudo.put(this.DISPLAY_TYPE, this.PSEUDO);
                EtmTypeLookUpTable.this.pseudo2type.put(this.PSEUDO, this.ETM_TYPE);
            }
        }
    }
}

