/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.CsasrClusterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class AddSectorHandler
extends ModifyHandler {
    public AddSectorHandler(ModifyManager modifyManager) {
        super(modifyManager);
    }

    public AddSectorHandler(ModifyManager modifyManager, int n) {
        super(modifyManager, n);
    }

    public List getAllCpPseudoNames() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public void updateScpmIfAppropriate(SectorCustomerParameterManager sectorCustomerParameterManager) throws BemException {
    }

    public void doModification() throws BemException {
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (!this.isRadioPositionAffected(i)) continue;
            this.requestResetSector(i);
            this.getRbs().setPositionFlag(true);
        }
    }

    public void checkConsistency() throws BemException {
        ServiceValue serviceValue = this.getModifyManager().getServiceValue();
        Vector vector = serviceValue.getValues("AddSector");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (!ModifyUtil.isScpmAttributeInNameValueVector(vector, i, "sectorNumber", this.startingSectorNumber)) continue;
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            if (this.isSectorExisting(i) && !this.getModifyManager().getDeleteHandler().isSectorDeleteRequested(i)) {
                throw new BemException("Sector number " + n + " is already existing and can therefore not be added.");
            }
            arrayList.add(n + "");
        }
        CsasrClusterManager.buildOneCluster(vector, arrayList, this.getModifyManager().getRbbManager());
    }

    public HashMap getRIsToUninstall() throws BemException {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (!this.isRadioPositionAffected(i)) continue;
            AbstractRbb abstractRbb = this.getLoadedRbb(i);
            List list = abstractRbb.getLoadedResourceItems();
            hashMap.putAll(ModifyManager.RIListToHashMap(list));
            if (!abstractRbb.getAuUnitType().equals("IRU")) continue;
            AbstractAntennaSystemCI abstractAntennaSystemCI = this.getModifyManager().getAntennaSystemCI();
            if (abstractAntennaSystemCI.isOpen()) {
                hashMap.putAll(ModifyManager.RIListToHashMap(abstractAntennaSystemCI.getRadioDotRI(i)));
                hashMap.putAll(ModifyManager.RIListToHashMap(abstractAntennaSystemCI.getRdiCableRI(i)));
                continue;
            }
            throw new BemException("Raido Dot could not be deleted when sector is deleted since AntennaSystemCI is not open.");
        }
        return hashMap;
    }

    public boolean isRadioPositionAffected(int n) throws BemException {
        boolean bl = false;
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            AbstractRbb abstractRbb = this.getRbb(i);
            if (this.isSectorExisting(i) || abstractRbb == null || !abstractRbb.needRuPositionAllocation()) continue;
            bl = true;
            break;
        }
        AbstractRbb abstractRbb = this.getRbb(n);
        return bl && this.isSectorExisting(n) && abstractRbb != null && abstractRbb.needRuPositionAllocation();
    }
}

