/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioEquipmentConstants;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class DeleteCarrierHandler
extends ModifyHandler {
    private Enumeration[][] deleteCarrierCustParams;
    private String[][] deleteCarrierCustParamNames;

    public DeleteCarrierHandler(ModifyManager modifyManager, int n) throws BemException {
        super(modifyManager);
        this.setupCustomerParameterNames();
        this.createCustomerParameters();
    }

    public void checkConsistency() throws BemException {
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            for (int j = 0; j < this.getMaxNoOfCarriers(); ++j) {
                int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                this.getCellAndCarrierProvider().getCellAndCarrierDomainForSector(n)[j].checkConsistency(1);
            }
        }
    }

    private CellAndCarrierProvider getCellAndCarrierProvider() throws BemException {
        int n = 0;
        if (this.getRbs().isPantherHybridRbs() && this.startingSectorNumber == 7) {
            n = 1;
        }
        CellAndCarrierProvider cellAndCarrierProvider = this.getRbs().getCellAndCarrierProvider(n);
        return cellAndCarrierProvider;
    }

    public void doModification() throws BemException {
    }

    private void createCustomerParameters() {
        this.deleteCarrierCustParams = new Enumeration[this.getMaxNoOfSectors()][this.getMaxNoOfCarriers()];
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            for (int j = 0; j < this.getMaxNoOfCarriers(); ++j) {
                String string = this.deleteCarrierCustParamNames[i][j];
                Enumeration enumeration = new Enumeration(string, RadioEquipmentConstants.getFullCarrierSequenceRange());
                enumeration.setLoadedValue("");
                this.deleteCarrierCustParams[i][j] = enumeration;
                this.getModifyManager().getRadioCI().addParameter(enumeration);
            }
        }
    }

    public List getAllCpPseudoNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            for (int j = 0; j < this.getMaxNoOfCarriers(); ++j) {
                arrayList.add(this.deleteCarrierCustParamNames[i][j]);
            }
        }
        return arrayList;
    }

    private void setupCustomerParameterNames() throws BemException {
        this.deleteCarrierCustParamNames = new String[this.getMaxNoOfSectors()][this.getMaxNoOfCarriers()];
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            this.deleteCarrierCustParamNames[i] = PrefixUtil.getCellsPrefix(n, 1, this.getMaxNoOfCarriers(), "deleteCell");
        }
    }

    public CustomerParameter getdeleteCarrierCP(int n, int n2) {
        return this.deleteCarrierCustParams[n][n2];
    }

    public HashMap getRIsToUninstall() throws BemException {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            for (int j = 0; j < this.getMaxNoOfCarriers(); ++j) {
                hashMap.putAll(this.getCellAndCarrierProvider().getAllCellAndCarrierDomain()[i][j].delete());
            }
        }
        return hashMap;
    }

    public void updateScpmIfAppropriate(SectorCustomerParameterManager sectorCustomerParameterManager) throws BemException {
    }
}

