/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EquippedSectorRadioInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.EquippedSectorRadioInfoImpl;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.AbstractDuwRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.atfmgmt.RadioEquipmentAtfNameManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbFactory;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParametersUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.AuUnitType;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SectorAntennaMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class RbbManager
implements RadioEquipmentProviderWithRbb {
    private RuwSubrackRI[] ruwSubrackRis;
    private Rbs rbs;
    private int maxNoSectors;
    private int startingSectorNumber;
    private AbstractRbb[] radioBuildingBlocks;
    private AbstractRbb[] loadedRadioBuildingBlocks;
    private AbstractDuwRadioEquipmentCI radioEquipmentCI;
    private static int[] marksOfLoadedRbb;
    private RbbFactory rbbFactory;
    private List radioEquipmentListeners;
    private List rbbUpdateListeners;
    private SectorCustomerParameterManager scpm;
    private static final int[][] oldRUSlotPositionBySectors;

    public RbbManager(Rbs rbs, AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, int n, RuwSubrackRI ruwSubrackRI, boolean bl, boolean bl2, RadioEquipmentAtfNameManager radioEquipmentAtfNameManager) {
        RuwSubrackRI[] ruwSubrackRIArray;
        if (ruwSubrackRI != null) {
            RuwSubrackRI[] ruwSubrackRIArray2 = new RuwSubrackRI[1];
            ruwSubrackRIArray = ruwSubrackRIArray2;
            ruwSubrackRIArray2[0] = ruwSubrackRI;
        } else {
            ruwSubrackRIArray = null;
        }
        this(rbs, abstractDuwRadioEquipmentCI, n, 1, ruwSubrackRIArray, false, bl, bl2, radioEquipmentAtfNameManager);
    }

    public RbbManager(Rbs rbs, AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, int n, int n2, RuwSubrackRI ruwSubrackRI, boolean bl, boolean bl2, RadioEquipmentAtfNameManager radioEquipmentAtfNameManager) throws BemException {
        RuwSubrackRI[] ruwSubrackRIArray;
        if (ruwSubrackRI != null) {
            RuwSubrackRI[] ruwSubrackRIArray2 = new RuwSubrackRI[1];
            ruwSubrackRIArray = ruwSubrackRIArray2;
            ruwSubrackRIArray2[0] = ruwSubrackRI;
        } else {
            ruwSubrackRIArray = null;
        }
        this(rbs, abstractDuwRadioEquipmentCI, n, n2, ruwSubrackRIArray, false, bl, bl2, radioEquipmentAtfNameManager);
    }

    public RbbManager(Rbs rbs, AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, int n, RuwSubrackRI ruwSubrackRI, RuwSubrackRI ruwSubrackRI2, boolean bl, boolean bl2, RadioEquipmentAtfNameManager radioEquipmentAtfNameManager) throws BemException {
        this(rbs, abstractDuwRadioEquipmentCI, n, 1, new RuwSubrackRI[]{ruwSubrackRI, ruwSubrackRI2}, false, bl, bl2, radioEquipmentAtfNameManager);
    }

    public RbbManager(Rbs rbs, AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, int n, RuwSubrackRI ruwSubrackRI, boolean bl, RadioEquipmentAtfNameManager radioEquipmentAtfNameManager) {
        RuwSubrackRI[] ruwSubrackRIArray;
        if (ruwSubrackRI != null) {
            RuwSubrackRI[] ruwSubrackRIArray2 = new RuwSubrackRI[1];
            ruwSubrackRIArray = ruwSubrackRIArray2;
            ruwSubrackRIArray2[0] = ruwSubrackRI;
        } else {
            ruwSubrackRIArray = null;
        }
        this(rbs, abstractDuwRadioEquipmentCI, n, 1, ruwSubrackRIArray, bl, false, false, radioEquipmentAtfNameManager);
    }

    private RbbManager(Rbs rbs, AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, int n, int n2, RuwSubrackRI[] ruwSubrackRIArray, boolean bl, boolean bl2, boolean bl3, RadioEquipmentAtfNameManager radioEquipmentAtfNameManager) {
        this.radioEquipmentListeners = new ArrayList();
        this.rbbUpdateListeners = new ArrayList();
        this.rbs = rbs;
        this.radioEquipmentCI = abstractDuwRadioEquipmentCI;
        this.maxNoSectors = n;
        this.startingSectorNumber = n2;
        this.ruwSubrackRis = ruwSubrackRIArray;
        this.radioBuildingBlocks = new AbstractRbb[n];
        this.loadedRadioBuildingBlocks = new AbstractRbb[n];
        marksOfLoadedRbb = new int[n];
        for (int i = 0; i < n; ++i) {
            RbbManager.marksOfLoadedRbb[i] = 0;
        }
        this.rbbFactory = new RbbFactory(this, this.ruwSubrackRis, radioEquipmentAtfNameManager);
    }

    public RuwSubrackRI[] getRuwSubrackRI() {
        if (this.scpm.hasAnySectorNeedRuPositionAllocation() && this.anySectorsEquipped()) {
            return this.ruwSubrackRis;
        }
        return null;
    }

    public AbstractRbb[] getRadioBuildingBlocks() {
        return this.radioBuildingBlocks;
    }

    public AbstractRbb getRadioBuildingBlock(int n) {
        if (this.rbs.isPantherHybridRbs() || n > 0 && n <= this.radioBuildingBlocks.length) {
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            return this.radioBuildingBlocks[n2];
        }
        return null;
    }

    public AbstractRbb getLoadedRadioBuildingBlock(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        return this.loadedRadioBuildingBlocks[n2];
    }

    public void setRadioBuildingBlock(int n, AbstractRbb abstractRbb) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        this.radioBuildingBlocks[n2] = abstractRbb;
        if (marksOfLoadedRbb[n2] == 0) {
            this.loadedRadioBuildingBlocks[n2] = abstractRbb;
            RbbManager.marksOfLoadedRbb[n2] = 1;
        }
    }

    public void notifyRadioEquipmentListeners() throws BemException {
        for (int i = 0; i < this.maxNoSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            this.notifyRadioEquipmentListeners(n);
        }
    }

    public void updateRadioBuildingBlock(int n, SectorCustomerParameterManager sectorCustomerParameterManager) throws BemException {
        AbstractRbb abstractRbb = this.rbbFactory.getRbb(n, sectorCustomerParameterManager);
        this.setRadioBuildingBlock(n, abstractRbb);
    }

    private int[] getExistingSectorsFromLdn() throws BemException {
        int[] nArray = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        try {
            BemMo bemMo = moHandlerImpl.getRoot();
            BemMo[] bemMoArray = moHandlerImpl.getChildren(bemMo, 2, MimSector.MOTYPENAME, "");
            if (bemMoArray != null) {
                for (int i = 0; i < bemMoArray.length; ++i) {
                    String string;
                    String string2;
                    if (bemMoArray[i] == null || Integer.valueOf(string2 = BemUtil.extractRdnId(string = bemMoArray[i].getDN(), MimSector.MOTYPENAME)) < 7) continue;
                    arrayList.add(Integer.valueOf(string2));
                }
            }
            Integer[] integerArray = arrayList.toArray(new Integer[0]);
            nArray = BemUtil.convertIntegerArrayToIntArray(integerArray);
        }
        catch (MoHandlerException moHandlerException) {
            moHandlerException.printStackTrace();
            throw new BemException(moHandlerException);
        }
        return nArray;
    }

    public int[] getEquippedSectors() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.maxNoSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            if (this.getRadioBuildingBlock(n) == null) continue;
            arrayList.add(new Integer(n));
        }
        return BemUtil.convertIntegerArrayToIntArray(arrayList.toArray(new Integer[0]));
    }

    public int[] getEquippedSectors(int n) {
        return this.getEquippedSectors();
    }

    public int[] getEquippedSectorsWithRuw() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.maxNoSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
            if (abstractRbb == null || !abstractRbb.needRuPositionAllocation()) continue;
            arrayList.add(new Integer(n));
        }
        return BemUtil.convertIntegerArrayToIntArray(arrayList.toArray(new Integer[0]));
    }

    public int[] getExistingSectors() throws BemException {
        int[] nArray = null;
        nArray = this.rbs.isPantherHybridRbs() ? this.getExistingSectorsFromLdn() : this.getEquippedSectors();
        return nArray;
    }

    public int[] getExistingSectorsWithRuw() throws BemException {
        int[] nArray = null;
        nArray = this.rbs.isPantherHybridRbs() ? this.getExistingSectorsFromLdn() : this.getEquippedSectorsWithRuw();
        return nArray;
    }

    public EquippedSectorRadioInfo[] getEquippedSectorsRadioInfo() {
        ArrayList<EquippedSectorRadioInfoImpl> arrayList = new ArrayList<EquippedSectorRadioInfoImpl>();
        for (int i = 0; i < this.maxNoSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
            String string = this.getAuUnitType(n);
            if (abstractRbb == null) continue;
            arrayList.add(new EquippedSectorRadioInfoImpl("" + n, abstractRbb.getName(), abstractRbb.getLineRate(), string));
        }
        return arrayList.toArray(new EquippedSectorRadioInfo[0]);
    }

    public String getTerminationObject(int n, String string) throws BemException {
        AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
        return abstractRbb != null ? abstractRbb.getTerminationObject(string) : null;
    }

    public String getLoadedTerminationObject(int n, String string) throws BemException {
        AbstractRbb abstractRbb = this.getLoadedRadioBuildingBlock(n);
        return abstractRbb != null ? abstractRbb.getTerminationObject(string) : null;
    }

    public boolean mainRemoteRbs() {
        if (!this.anySectorsEquipped()) {
            return RbsInfo.isMainRemoteRbs(this.rbs.getRbsType());
        }
        return this.scpm.hasMainRemoteRadio();
    }

    public int getMaxNumberOfCarriers(int n) {
        AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
        return abstractRbb != null ? abstractRbb.getMaxNumberOfCarriers() : 0;
    }

    public int getMinNumberOfCarriers(int n) {
        AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
        return abstractRbb != null ? abstractRbb.minNumberOfCarriers() : 1;
    }

    public int getNumberOfSupportedTxBranches(int n) {
        AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
        return abstractRbb != null ? abstractRbb.getNumberOfSupportedTxBranches() : 0;
    }

    public int getLoadedNumberOfSupportedTxBranches(int n) {
        int n2 = 0;
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.loadedRadioBuildingBlocks[n3] != null) {
            n2 = this.loadedRadioBuildingBlocks[n3].getNumberOfSupportedTxBranches();
        }
        return n2;
    }

    public int getNumberOfSupportedRxBranches(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
        AbstractRbb abstractRbb2 = this.loadedRadioBuildingBlocks[n2];
        int n3 = abstractRbb != null ? abstractRbb.getNumberOfSupportedRxBranches() : 0;
        int n4 = abstractRbb2 != null ? abstractRbb2.getNumberOfSupportedRxBranches() : 0;
        return n3 != 0 ? n3 : n4;
    }

    public int getLoadedNumberOfSupportedRxBranches(int n) {
        int n2 = 0;
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.loadedRadioBuildingBlocks[n3] != null) {
            n2 = this.loadedRadioBuildingBlocks[n3].getNumberOfSupportedRxBranches();
        }
        return n2;
    }

    public String[] getSlotArrayForTxDevices(int n) {
        return DuwUtil.getSlotArrayForTxDevices(n);
    }

    public Integer getTerminationConnector(int n, String string) throws BemException {
        return null;
    }

    public Integer getLoadedTerminationConnector(int n, String string) throws BemException {
        return null;
    }

    public Integer[] getTerminationConnectors(int n, String string) throws BemException {
        AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
        return abstractRbb != null ? abstractRbb.getTerminationConnectors(string) : null;
    }

    public Integer[] getLoadedTerminationConnectors(int n, String string) throws BemException {
        AbstractRbb abstractRbb = this.getLoadedRadioBuildingBlock(n);
        return abstractRbb != null ? abstractRbb.getTerminationConnectors(string) : null;
    }

    public boolean isExternalOutputPowerUsed() {
        return false;
    }

    public int getNumberOfDuwSlots() {
        int n = 1;
        if (!this.rbs.isPantherHybridRbs() && DuwUtil.hasDualDuws()) {
            n = 2;
        }
        return n;
    }

    public void addListener(RadioEquipmentListener radioEquipmentListener) {
        this.radioEquipmentListeners.add(radioEquipmentListener);
    }

    public void addRbbListener(RadioEquipmentListener radioEquipmentListener) {
        this.rbbUpdateListeners.add(radioEquipmentListener);
    }

    public boolean isSectorUninstalledBeforeAddCarrier(int n) {
        return false;
    }

    public boolean isUniniteSectorNeeded(int n) {
        return false;
    }

    void notifyRadioEquipmentListeners(int n) {
        Iterator iterator = this.radioEquipmentListeners.iterator();
        while (iterator.hasNext()) {
            RadioEquipmentListener radioEquipmentListener = (RadioEquipmentListener)iterator.next();
            radioEquipmentListener.update(n);
        }
    }

    public void notifyRbbUpdateListeners(int n) {
        Iterator iterator = this.rbbUpdateListeners.iterator();
        while (iterator.hasNext()) {
            RadioEquipmentListener radioEquipmentListener = (RadioEquipmentListener)iterator.next();
            radioEquipmentListener.update(n);
        }
    }

    public Rbs getRbs() {
        return this.rbs;
    }

    public int getMaxNumberOfSectors() {
        return this.maxNoSectors;
    }

    public AbstractRbb getRuForSectorCascading(int n, SectorCustomerParameterManager sectorCustomerParameterManager) throws BemException {
        int n2 = this.getPreviousSectorInCascadeChain(n, sectorCustomerParameterManager);
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n2, this.startingSectorNumber);
        AbstractRbb abstractRbb = this.radioBuildingBlocks[n3];
        return abstractRbb;
    }

    public int getPreviousSectorInCascadeChain(int n, SectorCustomerParameterManager sectorCustomerParameterManager) throws BemException {
        int[][] nArray = this.getEquippedSectorsCpriLinks();
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n2 = nArray[i][0];
            for (int j = 1; j < nArray[i].length; ++j) {
                if (nArray[i][j] == n) {
                    bl = true;
                    break;
                }
                n2 = nArray[i][j];
            }
            if (bl) break;
        }
        if (!bl) {
            throw new BemException("Can not find a sector prior to sector number=" + n);
        }
        return n2;
    }

    public String getConfigurationGroup() {
        return null;
    }

    public List getRruwMois() {
        ArrayList<MoInstance[]> arrayList = new ArrayList<MoInstance[]>();
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            String string = String.valueOf(n);
            AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
            if (abstractRbb == null) continue;
            int n2 = abstractRbb.getRadioUnitResourceItems() == null ? 0 : abstractRbb.getRadioUnitResourceItems().length;
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getNodeBFunctionMoi(), MimSector.MOTYPENAME, string);
            SectorAntennaMoi sectorAntennaMoi = new SectorAntennaMoi(this.rbs.getEquipmentMoi(), fixedRdnMoi, n, 1);
            MoInstance[] moInstanceArray = new MoInstance[n2];
            for (int j = 0; j < n2; ++j) {
                String string2 = "RRUW-" + String.valueOf(j + 1);
                ChildWithAttributeValues childWithAttributeValues = new ChildWithAttributeValues(sectorAntennaMoi, MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(20), string2);
                moInstanceArray[j] = new SingleChildMoi(childWithAttributeValues, MimRruDeviceGroup.MOTYPENAME, "1");
            }
            arrayList.add(moInstanceArray);
        }
        return arrayList;
    }

    public void notifyThatRbbsMightBeChanged(SectorCustomerParameterManager sectorCustomerParameterManager, boolean bl) throws BemException {
        for (int i = 0; i < this.maxNoSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            this.updateRadioBuildingBlock(n, sectorCustomerParameterManager);
        }
        this.updateRuwPositions(bl);
        this.updateCabinetNumber();
    }

    public void verifyThatAllRisAreInstalled() throws BemException {
        if (this.radioBuildingBlocks != null) {
            for (int i = 0; i < this.radioBuildingBlocks.length; ++i) {
                AbstractRbb abstractRbb = this.radioBuildingBlocks[i];
                if (abstractRbb == null) continue;
                abstractRbb.verifyThatAllRisAreInstalled(this);
            }
        }
    }

    public int[][] getEquippedSectorsCpriLinks() throws BemException {
        Object object;
        int n;
        int n2;
        String[] stringArray = SectorCustomerParametersUtil.getAllAllowedPortIds();
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if ("".equals(stringArray[n2])) continue;
            for (int i = 0; i < this.maxNoSectors; ++i) {
                String string;
                n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                object = this.getRadioBuildingBlock(n);
                if (object == null || !(string = ((AbstractRbb)object).getPrimaryPortId()).equals(stringArray[n2]) || this.scpm.isSharedSector(((AbstractRbb)object).getName(), n)) continue;
                arrayList2.add("" + n);
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.add(arrayList2);
            arrayList2 = new ArrayList();
        }
        n2 = arrayList.size();
        int[][] nArrayArray = new int[n2][];
        for (n = 0; n < n2; ++n) {
            object = (ArrayList)arrayList.get(n);
            int n3 = ((ArrayList)object).size();
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                String string = (String)((ArrayList)object).get(i);
                int n4 = Integer.parseInt(string);
                AbstractRbb abstractRbb = this.getRadioBuildingBlock(n4);
                String string2 = abstractRbb.getSectorSequence();
                int n5 = Integer.parseInt(string2);
                if (n5 > n3) {
                    throw new BemException("Sector number=" + n4 + " has a sectorSequence that is larger than the number of sectors in the current CPRI link");
                }
                if (this.scpm.isSharedSector(abstractRbb.getName(), n4)) continue;
                nArray[n5 - 1] = n4;
            }
            nArrayArray[n] = nArray;
        }
        return nArrayArray;
    }

    public boolean supportsTxDiversity(int n) {
        AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
        return abstractRbb != null ? abstractRbb.supportsTxDiversity() : false;
    }

    public boolean anySectorsEquipped() {
        boolean bl = false;
        for (int i = 0; i < this.maxNoSectors; ++i) {
            if (this.radioBuildingBlocks[i] == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean rbsWithRuifAndObif() {
        return false;
    }

    public int[] getCarriersInSector(int n, int n2) throws BemException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n2, this.startingSectorNumber);
        if (this.radioBuildingBlocks[n3] != null) {
            int n4 = this.radioBuildingBlocks[n3].getMaxNumberOfCarriers();
            CellAndCarrierProvider cellAndCarrierProvider = this.rbs.getCellAndCarrierProvider();
            for (int i = 1; i <= n4; ++i) {
                if (!cellAndCarrierProvider.isCarrierLocatedInBbp(n + 1, n2, i)) continue;
                arrayList.add(new Integer(i));
            }
        }
        Integer[] integerArray = arrayList.toArray(new Integer[0]);
        return BemUtil.convertIntegerArrayToIntArray(integerArray);
    }

    public boolean isDualRadioInterfaceBoardNeeded(int n) {
        return false;
    }

    public boolean isSectorRemote(int n) {
        AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
        return abstractRbb != null && !abstractRbb.needRuPositionAllocation();
    }

    public String getCarrierAllocationMode() throws BemException {
        String string;
        String string2 = "Basic";
        if (this.rbs.isParameterSupported("carrierAllocationMode") && (string = this.rbs.getCustomerParameter("carrierAllocationMode")) != null && !string.equals("")) {
            string2 = string;
        }
        return string2;
    }

    public String getRbConnectorLdn(int n, int n2) {
        return "";
    }

    public int[] getSupportedTxDivRange(int n) {
        if (n <= this.radioBuildingBlocks.length) {
            int[] nArray;
            if (this.supportsTxDiversity(n)) {
                int[] nArray2 = new int[2];
                nArray2[0] = 1;
                nArray = nArray2;
                nArray2[1] = 2;
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 1;
            }
            return nArray;
        }
        return new int[]{1};
    }

    public int getNumberOfExistingSectors() {
        return 0;
    }

    private void updateRuwPositions(boolean bl) throws BemException {
        Object object;
        int n;
        AbstractRbb[] abstractRbbArray = this.getRbbsWithMacroRadioNoSubrack();
        for (n = 0; n < abstractRbbArray.length; ++n) {
            object = abstractRbbArray[n];
            ((AbstractRbb)object).setRuwPositions(null, ((AbstractRbb)object).getSectorNumber(), 0);
        }
        if (this.ruwSubrackRis != null) {
            for (n = 0; n < this.ruwSubrackRis.length; ++n) {
                object = new ArrayList();
                AbstractRbb[] abstractRbbArray2 = this.getRbbsWithMacroRadioInSubrack();
                for (int i = 0; i < abstractRbbArray2.length; ++i) {
                    AbstractRbb abstractRbb = abstractRbbArray2[i];
                    if (this.getRuwSubrackForSector(abstractRbb.getSectorNumber(), bl) != n) continue;
                    object.add(abstractRbb);
                }
                int[] nArray = this.getRuPositionBySectors(this.getEquippedSectorsWithRuw().length, bl);
                this.setRuwSlots((List)object, this.ruwSubrackRis[n].getLdn(), nArray, bl);
            }
        }
    }

    private void setRuwSlots(List list, String string, int[] nArray, boolean bl) throws BemException {
        int n = 0;
        int[] nArray2 = this.getEquippedSectors();
        int n2 = this.getEquippedSectors().length;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractRbb abstractRbb = (AbstractRbb)iterator.next();
            int n3 = abstractRbb.getSectorNumber();
            int n4 = nArray[n];
            if (!bl) {
                n4 = nArray[nArray2[n] - 1];
            }
            if (list.size() == 4 && (n3 == 3 || n3 == 4) && abstractRbb.getNumOfRus() >= 2) {
                if (n < nArray.length) {
                    abstractRbb.setRuwPositions(string, n4 - 2, n2);
                }
            } else if (n < nArray.length) {
                abstractRbb.setRuwPositions(string, n4, n2);
            }
            this.notifyRbbUpdateListeners(n3);
            ++n;
        }
    }

    public int[] getRuPositionBySectors(int n, boolean bl) {
        int[] nArray = null;
        nArray = bl ? (n == 2 ? new int[]{3, 9} : (n == 4 ? new int[]{3, 9, 7, 13} : new int[]{3, 7, 11, 5, 9, 13})) : new int[]{3, 7, 11, 5, 9, 13};
        return nArray;
    }

    private String[] loadedRUBoardSlotNumber() throws MoHandlerException {
        MoHandler moHandler = this.rbs.getMoHandler();
        ArrayList<String> arrayList = new ArrayList<String>();
        BemMo[] bemMoArray = moHandler.getChildren(moHandler.getRoot(), 4, MimDigitalCable.MOTYPENAME, "");
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string;
                BemMo bemMo = (BemMo)bemMoArray[i].getAttribute("connectedToObjectARef");
                BemMo bemMo2 = (BemMo)bemMoArray[i].getAttribute("connectedToObjectBRef");
                Object object = ((NalStruct)((BemMo)bemMo.getAttribute("piuType")).getAttribute("productData")).getMember("productName").getValue();
                Object object2 = ((NalStruct)((BemMo)bemMo2.getAttribute("piuType")).getAttribute("productData")).getMember("productName").getValue();
                if (!object.toString().startsWith("DUW") || !object2.toString().startsWith("RU") || (string = bemMo2.getParent().getId()) == null) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[6]);
    }

    public BemMo[] getSectorsFromRbsMoHandler() {
        BemMo[] bemMoArray = null;
        try {
            MoHandler moHandler = this.rbs.getMoHandler();
            BemMo[] bemMoArray2 = moHandler.getChildren(moHandler.getRoot(), 3, MimSector.MOTYPENAME, "");
            if (this.rbs.isPantherHybridRbs()) {
                ArrayList<BemMo> arrayList = new ArrayList<BemMo>();
                for (int i = 0; i < bemMoArray2.length; ++i) {
                    String string = bemMoArray2[i].getDN();
                    String string2 = string.substring(string.lastIndexOf("=") + 1);
                    if (Integer.valueOf(string2) < 7) continue;
                    arrayList.add(bemMoArray2[i]);
                }
                BemMo[] bemMoArray3 = arrayList.toArray(new BemMo[0]);
                bemMoArray = bemMoArray3;
            } else {
                bemMoArray = bemMoArray2;
            }
        }
        catch (MoHandlerException moHandlerException) {
            moHandlerException.printStackTrace();
        }
        return bemMoArray;
    }

    public boolean checkSlotPosition() throws BemException {
        boolean bl = true;
        try {
            String[] stringArray;
            BemMo[] bemMoArray = this.getSectorsFromRbsMoHandler();
            ArrayList<BemMo> arrayList = new ArrayList<BemMo>();
            for (int i = 0; i < bemMoArray.length; ++i) {
                stringArray = bemMoArray[i].getId();
                if (!this.needRuPositionAllocation(Integer.valueOf((String)stringArray))) continue;
                arrayList.add(bemMoArray[i]);
            }
            BemMo[] bemMoArray2 = arrayList.toArray(new BemMo[arrayList.size()]);
            stringArray = this.loadedRUBoardSlotNumber();
            boolean bl2 = this.sectorNumberIsConsecutive(bemMoArray2);
            if (bemMoArray2 != null && stringArray != null && bemMoArray2.length > 0 && stringArray.length > 0) {
                int n = 0;
                for (int i = 0; i < bemMoArray2.length; ++i) {
                    String string = bemMoArray2[i].getId();
                    String string2 = stringArray[i];
                    if (string == null || string2 == null || oldRUSlotPositionBySectors[Integer.valueOf(string) - 1][1] != Integer.valueOf(string2)) continue;
                    ++n;
                }
                bl = n == bemMoArray2.length ? bemMoArray2.length != 2 && bemMoArray2.length != 4 && bl2 : true;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
        return bl;
    }

    private boolean sectorNumberIsConsecutive(BemMo[] bemMoArray) throws BemException {
        boolean bl = true;
        if (bemMoArray != null && bemMoArray.length > 0) {
            int n;
            int[] nArray = new int[bemMoArray.length];
            for (n = 0; n < bemMoArray.length; ++n) {
                String string = bemMoArray[n].getId();
                if (string == null) continue;
                nArray[n] = Integer.valueOf(string);
            }
            Arrays.sort(nArray);
            n = nArray[bemMoArray.length - 1] - nArray[0];
            bl = n + 1 == bemMoArray.length && 1 == nArray[0];
        }
        return bl;
    }

    public AbstractRuRI[] getSectorRadioUnits(int n) throws BemException {
        AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
        return abstractRbb.getRadioUnitResourceItems();
    }

    public int getRuwSubrackForSector(int n, boolean bl) {
        int n2 = 0;
        if (this.isMultipleRuwRbbInConfiguration() && this.rbsHasMultipleRuwSubracks()) {
            if (n == 3 && this.getEquippedSectorsWithRuw().length == 4) {
                n2 = 1;
            } else if (n > 3) {
                ArrayList<AbstractRbb> arrayList = new ArrayList<AbstractRbb>();
                AbstractRbb[] abstractRbbArray = this.getRbbsWithMacroRadioInSubrack();
                for (int i = 0; i < abstractRbbArray.length; ++i) {
                    AbstractRbb abstractRbb = abstractRbbArray[i];
                    if (null == abstractRbb || abstractRbb.getSectorNumber() <= 3) continue;
                    arrayList.add(abstractRbb);
                }
                int[] nArray = this.getRuPositionBySectors(this.getEquippedSectorsWithRuw().length, bl);
                if (arrayList.size() <= nArray.length) {
                    n2 = 1;
                }
            }
        }
        return n2;
    }

    private boolean isMultipleRuwRbbInConfiguration() {
        boolean bl = false;
        for (int i = 0; i < this.radioBuildingBlocks.length; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
            if (abstractRbb == null || !abstractRbb.needRuPositionAllocation() || abstractRbb.getNumOfRus() <= 1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean rbsHasMultipleRuwSubracks() {
        return this.ruwSubrackRis != null && this.ruwSubrackRis.length > 1;
    }

    public int getMaxSectorOutputPower(int n) {
        return this.radioBuildingBlocks[n] != null ? this.radioBuildingBlocks[n].getMaxPowerOutput() : 0;
    }

    public int getMaxSectorOutputPowerLow(int n) {
        return this.radioBuildingBlocks[n] != null ? this.radioBuildingBlocks[n].getMaxPowerOutputLow() : 0;
    }

    public int getMinSectorOutputPowerLow(int n) {
        return this.radioBuildingBlocks[n] != null ? this.radioBuildingBlocks[n].getMinPowerOutputLow() : 0;
    }

    public CustomerParameterListener getCarrierAllocationModeListener() {
        return new CarrierAllocationModeListener();
    }

    public void addSectorCustomerParameterManagerAfterInitialization(SectorCustomerParameterManager sectorCustomerParameterManager) {
        this.scpm = sectorCustomerParameterManager;
    }

    public Object getConfiguredRbb(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        return this.radioBuildingBlocks[n2];
    }

    public int[] getSupportedConfiguration(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        AbstractRbb abstractRbb = this.radioBuildingBlocks[n2];
        if (abstractRbb != null) {
            return abstractRbb.getSupportedConfiguration();
        }
        return new int[0];
    }

    public int[] getNumberOfRxBranchesPerAntenna(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        AbstractRbb abstractRbb = this.radioBuildingBlocks[n2];
        if (abstractRbb != null) {
            return abstractRbb.getNumberOfRxBranchesPerAntenna();
        }
        return new int[0];
    }

    public boolean isDeleteCellAndCarrierNeededAfterModification(int n) {
        return this.radioEquipmentCI.isSectorDowngradedAfterConfiguration(n);
    }

    public boolean isLocalCellDeletedWhenModify(int n, int n2) {
        return this.radioEquipmentCI.isLocalCellNeedToBeDeleted(n, n2);
    }

    public int[] getRadioSharedBySectorArray() {
        int[] nArray = new int[this.maxNoSectors];
        for (int i = 0; i < this.maxNoSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            AbstractRbb abstractRbb = this.getRadioBuildingBlock(n);
            String string = "0";
            if (abstractRbb != null && ((string = this.scpm.getRadioSharedBySectorForSector(n)) == null || string.equals("") || string.equals("##UNDEFINED"))) {
                string = "0";
            }
            nArray[i] = Integer.valueOf(string);
        }
        return nArray;
    }

    public String getRbbName(int n) {
        return this.scpm.getRbbNameForSector(n);
    }

    public String getAuUnitType(int n) {
        return this.scpm.getAuUnitTypeForSector(n);
    }

    public String getLoadedAuUnitType(int n) {
        return this.scpm.getLoadedAuUnitTypeForSector(n);
    }

    public boolean needRuPositionAllocation(int n) {
        return this.scpm.needRuPositionAllocation(n);
    }

    private void updateCabinetNumber() throws BemException {
        AbstractRbb[] abstractRbbArray = this.getRadioBuildingBlocks();
        for (int i = 0; i < abstractRbbArray.length; ++i) {
            AbstractRbb abstractRbb = abstractRbbArray[i];
            if (null == abstractRbb) continue;
            abstractRbb.setCabinetNumberForAux(abstractRbb.getSectorNumber());
        }
    }

    public AbstractRbb[] getRbbsWithMacroRadioInSubrack() {
        AbstractRbb[] abstractRbbArray = this.getRadioBuildingBlocks();
        ArrayList<AbstractRbb> arrayList = new ArrayList<AbstractRbb>();
        for (int i = 0; i < abstractRbbArray.length; ++i) {
            AbstractRbb abstractRbb = abstractRbbArray[i];
            if (abstractRbb == null || !abstractRbb.needRuPositionAllocation()) continue;
            arrayList.add(abstractRbb);
        }
        return arrayList.toArray(new AbstractRbb[0]);
    }

    public AbstractRbb[] getRbbsWithMacroRadioNoSubrack() {
        AbstractRbb[] abstractRbbArray = this.getRadioBuildingBlocks();
        ArrayList<AbstractRbb> arrayList = new ArrayList<AbstractRbb>();
        for (int i = 0; i < abstractRbbArray.length; ++i) {
            AbstractRbb abstractRbb = abstractRbbArray[i];
            if (null == abstractRbb) continue;
            int n = abstractRbb.getSectorNumber();
            if (!abstractRbb.needRuPositionAllocation() && AuUnitType.isMacroAuUnitType(abstractRbb.getAuUnitType())) {
                arrayList.add(abstractRbb);
                continue;
            }
            if (!abstractRbb.needRuPositionAllocation() || !AuUnitType.isMacroAuUnitType(this.getLoadedAuUnitType(n)) || abstractRbb.getNeedRuPostionAllocationLoadedValue()) continue;
            this.scpm.markAsNeedRuPositionAllocationForSector(n, "NO");
            arrayList.add(abstractRbb);
        }
        return arrayList.toArray(new AbstractRbb[0]);
    }

    public String[] getAllRruLdnUnderEquipmentBySector(int n) {
        List list = new ArrayList();
        list.addAll(SectorUtil.getLoadedRruLdnUnderEquipmentBySector(this.rbs, n));
        if (list.isEmpty()) {
            list = this.getAuxPiuLdnByRadioRI(n);
        }
        return list.isEmpty() ? null : list.toArray(new String[0]);
    }

    private List getAuxPiuLdnByRadioRI(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            AbstractRuRI[] abstractRuRIArray = this.getSectorRadioUnits(n);
            if (abstractRuRIArray.length > 0) {
                for (int i = 0; i < abstractRuRIArray.length; ++i) {
                    BemMo bemMo;
                    if (abstractRuRIArray[i].getAuType() != 20 || !(bemMo = moHandler.getMo(abstractRuRIArray[i].getAuxPiuLdn())).getParent().getType().equals(MimEquipment.MOTYPENAME)) continue;
                    arrayList.add(abstractRuRIArray[i].getAuxPiuLdn());
                }
            }
        }
        catch (Exception exception) {
            BemLog.log(2, "getAuxPiuLdnByRadioRI() :" + exception.getMessage());
        }
        return arrayList;
    }

    public String[] getAllRruLdnUnderEquipmentByEquippedSector() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            String[] stringArray = this.getAllRruLdnUnderEquipmentBySector(nArray[i]);
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                arrayList.add(stringArray[j]);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getRruLdnByRadioSharedEquippedSector(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.scpm.getRadioSharedBySectorForSector(n).equals(String.valueOf(nArray[i]))) continue;
            String[] stringArray = this.getAllRruLdnUnderEquipmentBySector(nArray[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                arrayList.add(stringArray[j]);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean isRadioSharedSector(int n) {
        int n2;
        String string = this.scpm.getRadioSharedBySectorForSector(n);
        return string != null && !string.equals("") && !string.equals("##UNDEFINED") && this.isSectorEquipped(n2 = new Integer(string).intValue());
    }

    public boolean isSectorEquipped(int n) {
        boolean bl = false;
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static {
        oldRUSlotPositionBySectors = new int[][]{{1, 3}, {2, 7}, {3, 11}, {4, 5}, {5, 9}, {6, 13}};
    }

    private class CarrierAllocationModeListener
    implements CustomerParameterListener {
        private CarrierAllocationModeListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (customerParameter.getValue().equals("Flexible") && !RbbManager.this.rbs.isCabinetWiz() && RbbManager.this.scpm != null) {
                try {
                    RbbManager.this.scpm.setCustomerParameterRestrictions();
                }
                catch (BemException bemException) {
                    Nal.getLog().nalTrace(1, this.getClass(), "Failed to set customer parameter restrictions on SectorCustomerParameterManager");
                }
            }
        }
    }
}

