/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FreeConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RfCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class RB3
extends AbstractRadioBuildingBlock {
    public static final String name = "RB3";
    private static final int NO_OF_CARRIERS = 2;
    private static final int NO_OF_RUS = 2;
    private static final int NO_OF_TX_BRANCHES = 2;
    private static final int NOT_USED = -1;
    private Rbs rbs;
    private List ris;
    private DigitalCableRI digitalCable1;
    private DigitalCableRI digitalCable2;
    private RfCableRI txRfCable1;
    private RfCableRI rxARfCable1;
    private RfCableRI rxBRfCable1;
    private RfCableRI txRfCable2;
    private RfCableRI rxARfCable2;
    private RfCableRI rxBRfCable2;
    private FuRI fu1;
    protected RuRI ru1;
    private FuRI fu2;
    protected RuRI ru2;
    private int dcElectricalDelay;
    private int rfElectricalUlDelay;
    private int rfElectricalDlDelay;
    private int rfUlAttenuation;
    private int rfDlAttenuation;
    private List freeConnectors;
    ReservedConnectorRI[][] reservedConnectors;
    private String allocationMode;

    public RB3(Rbs rbs, int n, FuRI fuRI, FuRI fuRI2, RuRI ruRI, RuRI ruRI2, RadioInterfaceBoard radioInterfaceBoard, RadioInterfaceBoard radioInterfaceBoard2, int n2, int n3, int n4, int n5, int n6, String string) throws BemException {
        RadioInterfaceBoard[] radioInterfaceBoardArray;
        if (radioInterfaceBoard2 != null) {
            RadioInterfaceBoard[] radioInterfaceBoardArray2 = new RadioInterfaceBoard[2];
            radioInterfaceBoardArray2[0] = radioInterfaceBoard;
            radioInterfaceBoardArray = radioInterfaceBoardArray2;
            radioInterfaceBoardArray2[1] = radioInterfaceBoard2;
        } else {
            RadioInterfaceBoard[] radioInterfaceBoardArray3 = new RadioInterfaceBoard[1];
            radioInterfaceBoardArray = radioInterfaceBoardArray3;
            radioInterfaceBoardArray3[0] = radioInterfaceBoard;
        }
        super(string, n, 2, 2, 2, radioInterfaceBoardArray);
        this.ris = new ArrayList();
        this.digitalCable1 = null;
        this.digitalCable2 = null;
        this.txRfCable1 = null;
        this.rxARfCable1 = null;
        this.rxBRfCable1 = null;
        this.txRfCable2 = null;
        this.rxARfCable2 = null;
        this.rxBRfCable2 = null;
        this.fu1 = null;
        this.ru1 = null;
        this.fu2 = null;
        this.ru2 = null;
        super.setmaxNoCarrierTxBranches(2);
        this.rbs = rbs;
        this.ru1 = ruRI;
        this.ru2 = ruRI2;
        this.fu1 = fuRI;
        this.fu2 = fuRI2;
        this.dcElectricalDelay = n2;
        this.rfElectricalUlDelay = n3;
        this.rfElectricalDlDelay = n4;
        this.rfUlAttenuation = n5;
        this.rfDlAttenuation = n6;
        this.allocationMode = radioInterfaceBoard2 == null ? "Basic" : "Advanced";
        this.createResourceItems(radioInterfaceBoard, radioInterfaceBoard2);
    }

    public RB3(Rbs rbs, int n, FuRI fuRI, FuRI fuRI2, RuRI ruRI, RuRI ruRI2, RadioInterfaceBoard radioInterfaceBoard, int n2, int n3, int n4, int n5, int n6) throws BemException {
        this(rbs, n, fuRI, fuRI2, ruRI, ruRI2, radioInterfaceBoard, null, n2, n3, n4, n5, n6, name);
    }

    public RB3(Rbs rbs, int n, FuRI fuRI, FuRI fuRI2, RuRI ruRI, RuRI ruRI2, RadioInterfaceBoard radioInterfaceBoard, int n2, int n3, int n4, int n5, int n6, String string) throws BemException {
        this(rbs, n, fuRI, fuRI2, ruRI, ruRI2, radioInterfaceBoard, null, n2, n3, n4, n5, n6, string);
    }

    public RB3(Rbs rbs, int n, FuRI fuRI, FuRI fuRI2, RuRI ruRI, RuRI ruRI2, RadioInterfaceBoard radioInterfaceBoard, RadioInterfaceBoard radioInterfaceBoard2, int n2, int n3, int n4, int n5, int n6) throws BemException {
        this(rbs, n, fuRI, fuRI2, ruRI, ruRI2, radioInterfaceBoard, radioInterfaceBoard2, n2, n3, n4, n5, n6, name);
    }

    public void setRadioIfConnectors(ReservedConnectorRI reservedConnectorRI, ReservedConnectorRI reservedConnectorRI2, ReservedConnectorRI reservedConnectorRI3, ReservedConnectorRI reservedConnectorRI4, ReservedConnectorRI reservedConnectorRI5, ReservedConnectorRI reservedConnectorRI6) {
        ReservedConnectorRI[][] reservedConnectorRIArrayArray = new ReservedConnectorRI[][]{{reservedConnectorRI6, reservedConnectorRI5}, {reservedConnectorRI4, reservedConnectorRI3}, {reservedConnectorRI2, reservedConnectorRI}, {reservedConnectorRI6, reservedConnectorRI5}};
        this.reservedConnectors = reservedConnectorRIArrayArray;
    }

    private void createResourceItems(RadioInterfaceBoard radioInterfaceBoard, RadioInterfaceBoard radioInterfaceBoard2) throws BemException {
        String string;
        String string2;
        int n;
        int n2;
        if (this.allocationMode.equals("Advanced")) {
            n = n2 = this.getDigitalCableConnectorA();
            string2 = radioInterfaceBoard.getLdn();
            string = radioInterfaceBoard2.getLdn();
        } else {
            n = this.getDigitalCableConnectorA();
            n2 = n - 1;
            string2 = string = radioInterfaceBoard.getLdn();
        }
        this.ris.add(this.ru1);
        this.ris.add(this.ru2);
        this.ris.add(this.fu1);
        this.ris.add(this.fu2);
        this.freeConnectors = new ArrayList();
        String string3 = this.ru1.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string3, 2, MimDigitalCable.MOTYPENAME, "objectBConnector"));
        String string4 = this.fu1.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string4, 9, MimRfCable.MOTYPENAME, "objectAConnector"));
        String string5 = this.ru2.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string5, 2, MimDigitalCable.MOTYPENAME, "objectBConnector"));
        String string6 = this.fu2.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string6, 9, MimRfCable.MOTYPENAME, "objectAConnector"));
        this.digitalCable1 = new DigitalCableRI(this.rbs, string2, n, this.ru1.getLdn(), 1, this.dcElectricalDelay);
        this.ris.add(this.digitalCable1);
        this.txRfCable1 = new RfCableRI(this.rbs, this.ru1.getLdn(), 11, this.fu1.getLdn(), 17, -1, this.rfElectricalDlDelay, -1, this.rfDlAttenuation);
        this.ris.add(this.txRfCable1);
        this.rxARfCable1 = new RfCableRI(this.rbs, this.fu1.getLdn(), 6, this.ru1.getLdn(), 3, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxARfCable1);
        this.rxBRfCable1 = new RfCableRI(this.rbs, this.fu2.getLdn(), 8, this.ru1.getLdn(), 4, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxBRfCable1);
        this.digitalCable2 = new DigitalCableRI(this.rbs, string, n2, this.ru2.getLdn(), 1, this.dcElectricalDelay);
        this.ris.add(this.digitalCable2);
        this.txRfCable2 = new RfCableRI(this.rbs, this.ru2.getLdn(), 11, this.fu2.getLdn(), 17, -1, this.rfElectricalDlDelay, -1, this.rfDlAttenuation);
        this.ris.add(this.txRfCable2);
        this.rxARfCable2 = new RfCableRI(this.rbs, this.fu2.getLdn(), 6, this.ru2.getLdn(), 3, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxARfCable2);
        this.rxBRfCable2 = new RfCableRI(this.rbs, this.fu1.getLdn(), 8, this.ru2.getLdn(), 4, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxBRfCable2);
    }

    public List getResourceItems() throws BemException {
        this.fu1.setSecondAiLocked(true);
        this.fu2.setSecondAiLocked(true);
        return this.ris;
    }

    public List getAllocatedResources() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.ru1);
        arrayList.add(this.ru2);
        arrayList.add(this.fu1);
        arrayList.add(this.fu2);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][0]);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][1]);
        return arrayList;
    }

    private int getDigitalCableConnectorA() throws BemException {
        int n = 0;
        int n2 = this.getSectorNo();
        switch (n2) {
            case 1: {
                n = 6;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            default: {
                throw new BemException("Wrong sector: " + n2);
            }
        }
        return n;
    }

    public Integer getTerminationConnector(String string) {
        return new Integer(1);
    }

    public String getTerminationObject(String string) throws BemException {
        String string2 = null;
        if (string.equalsIgnoreCase("A")) {
            string2 = this.fu1.getAuxPiuLdn();
        } else if (string.equalsIgnoreCase("B")) {
            string2 = this.fu2.getAuxPiuLdn();
        } else {
            throw new BemException(this.getClass().getName() + " getFuReference(): Antenna branch " + string + " not supported");
        }
        return string2;
    }

    protected List getFreeConnectors() {
        return this.freeConnectors;
    }

    public void updateCableCharacteristics(AbstractCableSet abstractCableSet, int n) throws BemException {
        NalNameValue[] nalNameValueArray = null;
        nalNameValueArray = abstractCableSet.getRxACableAttributes(n);
        this.rxARfCable1.setAttributes(nalNameValueArray);
        this.rxARfCable2.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getRxBCableAttributes(n);
        this.rxBRfCable1.setAttributes(nalNameValueArray);
        this.rxBRfCable2.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getTxCableAttributes(n);
        this.txRfCable1.setAttributes(nalNameValueArray);
        this.txRfCable2.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getData1CableAttributes(n);
        this.digitalCable1.setAttributes(nalNameValueArray);
        this.digitalCable2.setAttributes(nalNameValueArray);
    }

    public int minNumberOfCarriers() {
        return 1;
    }

    public String getCarrierAllocationMode() {
        return this.allocationMode;
    }

    public String getConnectorLdn(int n) {
        if (n == 0) {
            return this.digitalCable1.getConnectedToObjectALdn();
        }
        return this.digitalCable2.getConnectedToObjectALdn();
    }

    public boolean isEulInTwoBaseBandPoolsSupported() {
        return this.getCarrierAllocationMode().equals("Advanced");
    }

    public List getAtfRoleMapping() {
        ArrayList<RadioBuildingBlock.SlotToBBPools> arrayList = new ArrayList<RadioBuildingBlock.SlotToBBPools>();
        if (this.allocationMode.equals("Advanced")) {
            arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ru1.getSlotNumber(), new int[]{0}));
            arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ru2.getSlotNumber(), new int[]{1}));
        } else {
            arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ru1.getSlotNumber(), new int[]{0}));
            arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ru2.getSlotNumber(), new int[]{0}));
        }
        return arrayList;
    }

    public int[] getSupportedTxDivRange() {
        return new int[]{1, 2};
    }
}

