/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configlogic;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.IntegrationTypeReporter;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.RbsNclException;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.RbsNodeConfigurationLogic;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;

public class RbsNclFactory {
    private static final Class THIS_CLASS = RbsNclFactory.class;
    private static RbsNodeConfigurationLogic theRbsConfigurationLogic = null;
    public static final String RBS_NCL_IMPL_CLASS_NAME = "se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl.RbsNclImpl";

    private RbsNclFactory() {
    }

    public static RbsNodeConfigurationLogic getRbsNcl(NalLog nalLog, ProgressReporter progressReporter, IntegrationTypeReporter integrationTypeReporter) {
        try {
            nalLog.nalTraceEnter(THIS_CLASS, "getRbsNcl()-->");
            if (theRbsConfigurationLogic == null) {
                nalLog.nalTrace(3, THIS_CLASS, "Creating RBS Node Configurartion Logic (RbsNcl) for use with autoconf.smartmos");
                Nal.setLog(nalLog);
                NalFactory nalFactory = Nal.newFactoryNeal();
                Nal.setFactory(nalFactory);
                Nal.connectToMib("127.0.0.1");
                theRbsConfigurationLogic = RbsNclFactory.newInstance(progressReporter, integrationTypeReporter);
            }
            nalLog.nalTraceReturn(THIS_CLASS, "getRbsNcl()<--");
            return theRbsConfigurationLogic;
        }
        catch (Throwable throwable) {
            String string = "FATAL! Failed creating RbsNcl!";
            nalLog.nalTraceError(THIS_CLASS, string, throwable);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new RbsNclException(string, throwable);
        }
    }

    public static RbsNodeConfigurationLogic getRbsNcl(NalLog nalLog, ProgressReporter progressReporter) {
        return RbsNclFactory.getRbsNcl(nalLog, progressReporter, null);
    }

    public static RbsNodeConfigurationLogic getRbsNcl(NalFactory nalFactory, ProgressReporter progressReporter) {
        if (theRbsConfigurationLogic == null) {
            theRbsConfigurationLogic = RbsNclFactory.newInstance(progressReporter, null);
            Nal.setFactory(nalFactory);
        }
        return theRbsConfigurationLogic;
    }

    private static RbsNodeConfigurationLogic newInstance(ProgressReporter progressReporter, IntegrationTypeReporter integrationTypeReporter) {
        Object var2_2 = null;
        String string = null;
        try {
            Class<?> clazz = Class.forName(RBS_NCL_IMPL_CLASS_NAME);
            Class[] classArray = new Class[]{ProgressReporter.class, IntegrationTypeReporter.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            string = constructor.toString();
            Object[] objectArray = new Object[]{progressReporter, integrationTypeReporter};
            var2_2 = constructor.newInstance(objectArray);
            return var2_2;
        }
        catch (Exception exception) {
            String string2 = RbsNclFactory.getStackTrace(exception);
            throw new Error("FATAL ERROR! Failed instanciating : \n   class       se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl.RbsNclImpl\n   constructor " + string + "\n   Error       " + exception.toString() + "\n   Stack Trace " + string2);
        }
    }

    public static final String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        byteArrayOutputStream.reset();
        throwable.printStackTrace(printWriter);
        return byteArrayOutputStream.toString();
    }
}

