/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.custparam;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;

public class IntegerRange
implements ParameterRange {
    private Integer[] minValues = null;
    private Integer[] maxValues = null;
    private Integer stepValue = new Integer(1);

    public IntegerRange(Integer[] integerArray, Integer[] integerArray2) {
        this.minValues = integerArray;
        this.maxValues = integerArray2;
        boolean bl = true;
        if (integerArray == null || integerArray2 == null) {
            bl = false;
        } else {
            int n;
            if (integerArray.length < integerArray2.length) {
                this.maxValues = new Integer[integerArray.length];
                for (n = 0; n < integerArray.length; ++n) {
                    this.maxValues[n] = integerArray2[n];
                }
            } else if (integerArray.length > integerArray2.length) {
                this.minValues = new Integer[integerArray2.length];
                for (n = 0; n < integerArray2.length; ++n) {
                    this.minValues[n] = integerArray[n];
                }
            }
            for (n = 0; n < integerArray.length; ++n) {
                if (this.minValues[n] != null && this.maxValues != null) continue;
                bl = false;
            }
        }
        if (!bl) {
            this.minValues = new Integer[0];
            this.maxValues = new Integer[0];
        }
    }

    public IntegerRange(Integer[] integerArray, Integer[] integerArray2, Integer n) {
        this(integerArray, integerArray2);
        this.stepValue = n;
    }

    public IntegerRange(Integer n, Integer n2) {
        this(new Integer[]{n}, new Integer[]{n2});
    }

    public IntegerRange(Integer n, Integer n2, Integer n3) {
        this(new Integer[]{n}, new Integer[]{n2}, n3);
    }

    public IntegerRange(int n, int n2) {
        this(IntegerRange.toIntegerArr(n), IntegerRange.toIntegerArr(n2));
    }

    public IntegerRange(int n, int n2, int n3) {
        this(IntegerRange.toIntegerArr(n), IntegerRange.toIntegerArr(n2), new Integer(n3));
    }

    public IntegerRange(Integer[] integerArray) {
        this.stepValue = new Integer(1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n = integerArray[0];
        int n2 = integerArray[0];
        for (int i = 1; i < integerArray.length; ++i) {
            int n3 = integerArray[i];
            if (n3 == n2 + 1) {
                ++n2;
                continue;
            }
            arrayList.add(new Integer(n));
            arrayList2.add(new Integer(n2));
            n = n3;
            n2 = n3;
        }
        arrayList.add(new Integer(n));
        arrayList2.add(new Integer(n2));
        this.minValues = arrayList.toArray(new Integer[0]);
        this.maxValues = arrayList2.toArray(new Integer[0]);
    }

    private static Integer[] toIntegerArr(int n) {
        Integer[] integerArray = new Integer[]{new Integer(n)};
        return integerArray;
    }

    public Integer getMinValue() {
        return this.getSmallestMin();
    }

    public Integer getMaxValue() {
        return this.getLargestMax();
    }

    public Integer[] getMinValues() {
        return this.minValues;
    }

    public Integer[] getMaxValues() {
        return this.maxValues;
    }

    public void setStepValue(Integer n) {
        this.stepValue = n;
    }

    public Integer getStepValue() {
        return this.stepValue;
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.minValues.length; ++i) {
            int n = this.minValues[i];
            int n2 = this.maxValues[i];
            if (n == 0 && n2 == 0) continue;
            stringBuffer.append("[").append(n);
            if (this.stepValue != null && this.stepValue != 1) {
                stringBuffer.append(",").append(n + this.stepValue).append(",");
            }
            stringBuffer.append("..").append(n2).append("] ");
        }
        return stringBuffer.toString();
    }

    public boolean equals(ParameterRange parameterRange) {
        if (parameterRange instanceof IntegerRange) {
            IntegerRange integerRange = (IntegerRange)parameterRange;
            Integer[] integerArray = integerRange.getMinValues();
            Integer[] integerArray2 = integerRange.getMaxValues();
            if (this.minValues.length == integerArray.length) {
                for (int i = 0; i < this.minValues.length; ++i) {
                    if (this.minValues[i].equals(integerArray[i]) && this.maxValues[i].equals(integerArray2[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isValueInRange(Object object) {
        boolean bl = false;
        try {
            int n = Integer.parseInt((String)object);
            for (int i = 0; i < this.minValues.length; ++i) {
                if (n < this.minValues[i] || n > this.maxValues[i]) continue;
                if (n % this.stepValue == 0) {
                    bl = true;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public ParameterRange copyAndRetainRange(ParameterRange parameterRange) {
        return this.copyAndRetainRangePrivate(parameterRange);
    }

    private ParameterRange copyAndRetainRangePrivate(ParameterRange parameterRange) {
        if (parameterRange instanceof IntegerRange) {
            IntegerRange integerRange = (IntegerRange)parameterRange;
            Integer[] integerArray = integerRange.getMinValues();
            Integer[] integerArray2 = integerRange.getMaxValues();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i = 0; i < this.minValues.length; ++i) {
                for (int j = 0; j < integerArray.length; ++j) {
                    Integer n = null;
                    Integer n2 = null;
                    if (this.isValueWithinRange(integerArray[j], this.minValues[i], this.maxValues[i])) {
                        n = integerArray[j];
                        n2 = this.isValueWithinRange(integerArray2[j], this.minValues[i], this.maxValues[i]) ? integerArray2[j] : this.maxValues[i];
                    } else if (this.isValueWithinRange(this.minValues[i], integerArray[j], integerArray2[j])) {
                        n = this.minValues[i];
                        n2 = this.isValueWithinRange(this.maxValues[i], integerArray[j], integerArray2[j]) ? this.maxValues[i] : integerArray2[j];
                    }
                    if (n == null || n2 == null) continue;
                    arrayList.add(n);
                    arrayList2.add(n2);
                }
            }
            Integer[] integerArray3 = arrayList.toArray(new Integer[0]);
            Integer[] integerArray4 = arrayList2.toArray(new Integer[0]);
            return new IntegerRange(integerArray3, integerArray4);
        }
        throw new Error(" Unsupported type " + parameterRange);
    }

    private boolean isValueWithinRange(Integer n, Integer n2, Integer n3) {
        return n >= n2 && n <= n3;
    }

    public ParameterRange copyAndRemove(ParameterRange parameterRange) {
        if (parameterRange instanceof IntegerRange) {
            IntegerRange integerRange = this;
            IntegerRange integerRange2 = (IntegerRange)parameterRange;
            Integer[] integerArray = integerRange2.getMinValues();
            Integer[] integerArray2 = integerRange2.getMaxValues();
            Integer n = this.getSmallestMin();
            Integer n2 = this.getLargestMax();
            for (int i = 0; i < integerArray.length; ++i) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                if (n < integerArray[i]) {
                    arrayList.add(n);
                    arrayList2.add(new Integer(integerArray[i] - 1));
                }
                if (n2 > integerArray2[i]) {
                    arrayList.add(new Integer(integerArray2[i] + 1));
                    arrayList2.add(n2);
                }
                Integer[] integerArray3 = arrayList.toArray(new Integer[0]);
                Integer[] integerArray4 = arrayList2.toArray(new Integer[0]);
                IntegerRange integerRange3 = new IntegerRange(integerArray3, integerArray4);
                integerRange = (IntegerRange)integerRange.copyAndRetainRangePrivate(integerRange3);
            }
            return integerRange;
        }
        throw new Error(" unsupported type " + parameterRange);
    }

    private Integer getSmallestMin() {
        Integer n = null;
        for (int i = 0; i < this.minValues.length; ++i) {
            if (n != null && n <= this.minValues[i]) continue;
            n = this.minValues[i];
        }
        return n;
    }

    private Integer getLargestMax() {
        Integer n = null;
        for (int i = 0; i < this.maxValues.length; ++i) {
            if (n != null && n >= this.maxValues[i]) continue;
            n = this.maxValues[i];
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.minValues.length; ++i) {
            stringBuffer.append("[").append(this.minValues[i]).append("..").append(this.maxValues[i]).append("]");
            if (i >= this.minValues.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

