/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaFeederConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetSwitchProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.RbsUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.AtmAndPtInformativeText;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.Report;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.XalmInformativeText;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class InformativeText {
    private CustomerParameter[] custParams = null;
    private int MAX_SECTORS;
    private int MAX_CELLS;
    private int MAX_SEQUENCE = 6;
    private String[] SECTOR_PREFIX;
    private String[] CELL_PREFIX;
    private String[] SEQUENCE_PREFIX;
    private String[] HWGROUP_PREFIX;
    private String[] RADIOUNIT_PREFIX;
    private String[] ANTENNA_PREFIX;
    private ArrayList registeredList;
    private static final String DEFAULT_VALUE_ENDING = " (Default)";
    private Rbs rbs;
    private int noOfHwGroups;
    private static final String[] apcParameterNames = new String[]{"configureSau", "configureXalm", "configureScu", "configurePowerSupply", "batteryCapacity", "noOfPsu", "noOfPdu", "configureBatteryBackup", "noOfBfu", "batteryType", "configurePowerShelfFan", "fanSpeedSupervision", "sharedBattery", "chargingMode", "testMode", "minimumStateOfHealth", "minimumBackupTime", "testStartDay", "testStartTime", "testStartMonths", "batteryInstallationDate"};
    private static final String[] batteryTestNames = new String[]{"chargingVoltage", "tempCompVoltageSlope", "nominalTemp", "tempCompMinVoltage", "tempCompMaxVoltage", "increasedChargeVoltage", "boostChargeTime", "boostChargeTriggerVoltage", "equalizeChargeTime", "equalizeChargeCyclicInterval", "intermittentChargeConnectVoltage", "intermittentChargeConnectTime", "intermittentChargeDisconnectTime"};
    private List cabinetNoList;
    static /* synthetic */ Class class$se$ericsson$wcdma$rbs$bem$common$config$configitem$provider$EthernetSwitchProvider;

    public InformativeText(Rbs rbs) throws BemException {
        int n;
        this.rbs = rbs;
        this.custParams = this.rbs.getCustomerParameterObjects();
        this.MAX_SECTORS = this.rbs.getMaxNumberOfSectors();
        this.MAX_CELLS = this.rbs.getMaxNumberOfCarriers();
        this.registeredList = this.rbs.getCustomerParameterInRegisteredOrder();
        this.SECTOR_PREFIX = new String[this.MAX_SECTORS];
        this.cabinetNoList = this.rbs.getCabinetNumberList();
        this.RADIOUNIT_PREFIX = new String[3];
        this.ANTENNA_PREFIX = new String[3];
        this.noOfHwGroups = RbsUtil.isApcLightSupported(this.rbs) ? ((PowerSupplyProvider)this.rbs.getProvider(PowerSupplyProvider.class)).getNumberOfHwGroup() : 0;
        this.HWGROUP_PREFIX = new String[this.noOfHwGroups];
        for (n = 0; n < this.MAX_SECTORS; ++n) {
            this.SECTOR_PREFIX[n] = MessageFormat.format("S{0}_", new Integer(n + 1));
        }
        this.CELL_PREFIX = new String[this.MAX_CELLS];
        for (n = 0; n < this.MAX_CELLS; ++n) {
            this.CELL_PREFIX[n] = MessageFormat.format("C{0}_", new Integer(n + 1));
        }
        this.SEQUENCE_PREFIX = new String[this.MAX_SEQUENCE];
        for (n = 0; n < this.MAX_SEQUENCE; ++n) {
            this.SEQUENCE_PREFIX[n] = MessageFormat.format("SEQ{0}_", new Integer(n + 1));
        }
        for (n = 0; n < this.noOfHwGroups; ++n) {
            this.HWGROUP_PREFIX[n] = PrefixUtil.getHwGroupPrefix(n);
        }
        for (n = 0; n < 3; ++n) {
            this.RADIOUNIT_PREFIX[n] = MessageFormat.format("RadioUnit{0}_", new Integer(n + 1));
            this.ANTENNA_PREFIX[n] = MessageFormat.format("Antenna{0}_", new Integer(n + 1));
        }
    }

    public String getInformativeText() throws BemException {
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Vector[] vectorArray = null;
        Vector[] vectorArray2 = null;
        Vector[][] vectorArray3 = null;
        vector = this.getChangedCustParams();
        vector = this.sortParamsInAlpha(vector);
        Map map = null;
        vectorArray2 = this.extractAndStripSectorNames(vector);
        vectorArray3 = this.extractAndStripCellNames(vectorArray2);
        vector2 = this.extractAndStripSiteNames(vector);
        vector3 = this.extractNetworkNames(vector);
        vector4 = this.extractAndStripEcPortNames(vector);
        vectorArray = this.extractAndStripCabinetNames(vector);
        map = this.extractAndStripHwGroupNames(vector);
        return this.createText(vectorArray2, vectorArray3, vector2, vector3, vector4, vectorArray, map);
    }

    public Vector getSiteParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractAndStripModifyNames(vector);
    }

    public Vector[] getSectorParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractAndStripSectorNames(vector);
    }

    public Vector[][] getCellParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        Vector[] vectorArray = this.extractAndStripSectorNames(vector);
        return this.extractAndStripCellNames(vectorArray);
    }

    public Vector getNetworkParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractNetworkNames(vector);
    }

    public Vector getGpsParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractGpsSyncNames(vector);
    }

    public Vector getEcPortParams() throws BemException {
        Vector vector = null;
        vector = this.extractAndStripEcPortNames(this.getChangedCustParams());
        return this.extractEcPortNames(vector);
    }

    public Vector getDeleteRaxParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractDeleteRaxNames(vector);
    }

    public Vector getClimateSystemParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractClimateSystemNames(vector);
    }

    public Vector getClimateRegulationSystemParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractClimateRegulationSystemNames(vector);
    }

    public Vector getAddDuwDataParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractAddDuwDataNames(vector);
    }

    public Vector getRadioDotNamesParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractAddRadioDot(vector);
    }

    public Vector getAtmNamesParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractAtmNames(vector);
    }

    public Vector getEcPortNamesParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractEcPortNames(vector);
    }

    public Vector getCommonSupportSystemParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractCommonSupportSystemParams(vector);
    }

    public Vector[] getCabinetParams() throws BemException {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractAndStripModifyCabinetNames(vector);
    }

    public Vector getECBusParams() {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractAndStripECBusNames(vector);
    }

    private Vector extractCommonSupportSystemParams(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (!string.startsWith("supportSystemControl")) continue;
            NalNameValue nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue2);
        }
        return vector2;
    }

    private Vector getChangedCustParams() {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        for (int i = 0; i < this.custParams.length; ++i) {
            if (!this.custParams[i].hasValueChanged()) continue;
            StringBuffer stringBuffer = new StringBuffer(this.custParams[i].getValue());
            boolean bl = true;
            if (stringBuffer.toString().equals("")) {
                bl = false;
            }
            if (this.custParams[i].isDefault()) {
                stringBuffer.append(DEFAULT_VALUE_ENDING);
            }
            if (this.custParams[i].getAccessLevel() == 1) {
                bl = false;
            }
            if (!bl) continue;
            vector.add(Nal.getFactory().getNameValue(this.custParams[i].getName(), stringBuffer.toString()));
        }
        return vector;
    }

    private Vector[] extractAndStripSectorNames(Vector vector) {
        int n;
        Vector[] vectorArray = new Vector[this.MAX_SECTORS];
        Vector<Integer> vector2 = new Vector<Integer>();
        for (int i = 0; i < this.MAX_SECTORS; ++i) {
            vectorArray[i] = new Vector();
        }
        NalNameValue nalNameValue = null;
        String string = null;
        for (n = 0; n < vector.size(); ++n) {
            int n2;
            nalNameValue = (NalNameValue)vector.get(n);
            string = nalNameValue.getName();
            NalNameValue nalNameValue2 = null;
            int n3 = this.isSectorName(string);
            if (n3 <= 0) continue;
            String string2 = this.stripSectorName(string, n3 - 1);
            if (this.isSequenceName(string2) > 0) {
                string2 = this.stripSequenceName(string2);
            }
            if ((n2 = this.isRadioUnitName(string2)) > 0) {
                string2 = this.stripRadioUnitName(string2, n2 - 1);
            }
            if ((n2 = this.isAntennaName(string2)) > 0) {
                string2 = this.stripAntennaName(string2, n2 - 1);
            }
            nalNameValue2 = Nal.getFactory().getNameValue(string2, nalNameValue.getValue());
            String string3 = nalNameValue2.getName();
            boolean bl = true;
            boolean bl2 = false;
            for (int i = 0; i < AbstractAntennaSystemCI.getMaxNumberOfBranches(); ++i) {
                bl2 = bl2 || string3.equals("dlFeederAttenuationBranch" + AbstractAntennaSystemCI.getBranchType(i)) || string3.equals("ulFeederAttenuationBranch" + AbstractAntennaSystemCI.getBranchType(i)) || string3.equals("dlFeederDelayBranch" + AbstractAntennaSystemCI.getBranchType(i)) || string3.equals("ulFeederDelayBranch" + AbstractAntennaSystemCI.getBranchType(i)) || string3.equals("dlAttenuationPerFqRangeBranch" + AbstractAntennaSystemCI.getBranchType(i)) || string3.equals("ulAttenuationPerFqRangeBranch" + AbstractAntennaSystemCI.getBranchType(i)) || string3.equals("dlDelayPerFqRangeBranch" + AbstractAntennaSystemCI.getBranchType(i)) || string3.equals("ulDelayPerFqRangeBranch" + AbstractAntennaSystemCI.getBranchType(i));
            }
            if (bl2 || string3.equals("sectorOutputPower")) {
                bl = false;
                String string4 = (String)nalNameValue2.getValue();
                CustomerParameterServer customerParameterServer = null;
                String string5 = "";
                try {
                    int[] nArray;
                    AntennaFeederConversion antennaFeederConversion;
                    int[] nArray2;
                    customerParameterServer = this.rbs.getCustomerParameterServerObject(string);
                    string5 = customerParameterServer.getLoadedValue();
                    bl = !string5.equals("##UNDEFINED") ? !Arrays.equals(nArray2 = (int[])(antennaFeederConversion = new AntennaFeederConversion()).convertToMomValue(string4), nArray = (int[])antennaFeederConversion.convertToMomValue(string5)) : true;
                }
                catch (BemException bemException) {
                    bemException.printStackTrace();
                }
            }
            if (this.isUnusedCP(string3, n3)) {
                bl = false;
            }
            if (this.shouldAirFilteredParameters(string3, n3)) {
                bl = false;
            }
            if (!bl) continue;
            vectorArray[n3 - 1].add(nalNameValue2);
            vector2.add(new Integer(n));
        }
        for (n = 0; n < vector2.size(); ++n) {
            int n4 = vector2.size() - n - 1;
            vector.remove((Integer)vector2.get(n4));
        }
        return vectorArray;
    }

    private boolean shouldAirFilteredParameters(String string, int n) {
        boolean bl = false;
        if (AIRUtil.getInstance(this.rbs).isAirConfigured(n) && string.startsWith("antennaType") || string.startsWith("tmaType") || string.startsWith("retType") || string.startsWith("riuInstalled") || string.startsWith("antennaSupervisionBranch")) {
            bl = true;
        }
        return bl;
    }

    private boolean isUnusedCP(String string, int n) {
        boolean bl = false;
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = 0;
            if (this.rbs.isPantherHybridRbs() && n >= 7) {
                n7 = 1;
            }
            if ((n6 = this.rbs.getAntennaSystemProvider(n7).getNumOfSupportedAntennaBranches(n)) < (n5 = AbstractAntennaSystemCI.getMaxNumberOfBranches())) {
                for (n4 = n6; n4 < n5; ++n4) {
                    if (!this.isBranchesRelatedParameter(string, n4)) continue;
                    bl = true;
                    break;
                }
            }
            if ((n4 = this.rbs.getAntennaSystemProvider(n7).getNumOfSectorAntennas(n)) < (n3 = this.rbs.getAntennaSystemProvider(n7).getMaxNoOfSectorAntennasPerSector())) {
                for (n2 = n4; n2 < n3; ++n2) {
                    if (!this.isSectorAntennaRelatedParameter(string, n2 + 1)) continue;
                    bl = true;
                    break;
                }
            }
            n2 = 1;
            if (n >= 7) {
                n2 = 7;
            }
            int n8 = SectorUtil.getSectorIndexFromSectorNumber(n, n2);
            if (!this.rbs.getAntennaSystemProvider(n7).isPsiConfiguration(n8) && (string.equals("beamDirection2") || string.equals("beamDirection3"))) {
                bl = true;
            }
            if (string.equals("mixedModeRadio")) {
                bl = true;
            }
            for (int i = 1; i <= 3; ++i) {
                String string2 = MessageFormat.format("AUX{0}_", new Integer(i));
                String string3 = string2 + "isSharedWithExternalMe";
                if (!string.equals(string3) || this.isMixedModeRadioConfigured(n, i)) continue;
                bl = true;
            }
            if ("needRuPositionAllocation".equals(string)) {
                bl = true;
            }
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
        }
        return bl;
    }

    private boolean isMixedModeRadioConfigured(int n, int n2) throws BemException {
        int[] nArray = this.rbs.getRadioEquipmentProvider().getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            AbstractRuRI[] abstractRuRIArray;
            if (n != nArray[i] || n2 > (abstractRuRIArray = this.rbs.getRadioEquipmentProvider().getSectorRadioUnits(n)).length) continue;
            return true;
        }
        return false;
    }

    private boolean isBranchesRelatedParameter(String string, int n) {
        return string.equals("fqBandHighEdgeBranch" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("fqBandLowEdgeBranch" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("antennaSupervisionBranch" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("currentLowSupervision_" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("dlFeederAttenuationBranch" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("ulFeederAttenuationBranch" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("dlFeederDelayBranch" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("ulFeederDelayBranch" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("dlTrafficDelay" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("ulTrafficDelay" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("currentLowLim" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("currentHighLim" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("dlAttenuationPerFqRangeBranch" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("ulAttenuationPerFqRangeBranch" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("dlDelayPerFqRangeBranch" + AbstractAntennaSystemCI.getBranchType(n)) || string.equals("ulDelayPerFqRangeBranch" + AbstractAntennaSystemCI.getBranchType(n));
    }

    private boolean isSectorAntennaRelatedParameter(String string, int n) {
        return string.equals(BemUtil.getCustomerParameterName("", "electricalTilt", n)) || string.equals(BemUtil.getCustomerParameterName("", "mechanicalTilt", n)) || string.equals(BemUtil.getCustomerParameterName("", "riuInstalled", n)) || string.equals(BemUtil.getCustomerParameterName("", "typeOfRet", n)) || string.equals(BemUtil.getCustomerParameterName("", "maxTilt", n)) || string.equals(BemUtil.getCustomerParameterName("", "minTilt", n)) || string.equals(BemUtil.getCustomerParameterName("", "antennaType", n)) || string.equals(BemUtil.getCustomerParameterName("", "beamDirection", n)) || string.equals(BemUtil.getCustomerParameterName("", "internalPower", n)) || string.equals(BemUtil.getCustomerParameterName("", "dcVoltage", n)) || string.equals(BemUtil.getCustomerParameterName("", "dlAttenuation", n)) || string.equals(BemUtil.getCustomerParameterName("", "ulGain", n)) || string.equals(BemUtil.getCustomerParameterName("", "tmaDegradedSupported", n)) || string.equals(BemUtil.getCustomerParameterName("", "dlAttenuation_ATMA", n)) || string.equals(BemUtil.getCustomerParameterName("", "dlTrafficDelay", n)) || string.equals(BemUtil.getCustomerParameterName("", "ulTrafficDelay", n)) || string.equals(BemUtil.getCustomerParameterName("", "tmaType", n));
    }

    private Vector extractAndStripAiNames(Vector vector) {
        int n;
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        Vector<Integer> vector3 = new Vector<Integer>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (n = 0; n < vector.size(); ++n) {
            nalNameValue = (NalNameValue)vector.get(n);
            string = nalNameValue.getName();
            if (!string.startsWith("AI_")) continue;
            NalNameValue nalNameValue2 = null;
            nalNameValue2 = string.equals("AI_password") ? Nal.getFactory().getNameValue(string, "*******") : Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue2);
            vector3.add(new Integer(n));
        }
        for (n = 0; n < vector3.size(); ++n) {
            int n2 = vector3.size() - n - 1;
            vector.remove((Integer)vector3.get(n2));
        }
        return vector2;
    }

    private Vector extractAndStripSiteNames(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            NalNameValue nalNameValue2;
            int n;
            int n2;
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (string.equals("siteName") || string.equals("logicalName")) {
                NalNameValue nalNameValue3 = null;
                nalNameValue3 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue3);
            }
            for (n2 = 0; n2 < apcParameterNames.length - 1; ++n2) {
                n = string.indexOf(apcParameterNames[n2]);
                if (n <= -1) continue;
                nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue2);
                break;
            }
            for (n2 = 0; n2 < batteryTestNames.length; ++n2) {
                n = string.indexOf(batteryTestNames[n2]);
                if (n <= -1) continue;
                nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue2);
                break;
            }
            if (string.indexOf("SauExternalAlarm") > -1 || string.indexOf("XalmExternalAlarm") > -1 || string.indexOf("ScuExternalAlarm") > -1 || string.indexOf("RruwExternalAlarm") > -1 || string.indexOf("SupExternalAlarm") > -1 || string.indexOf("IruExternalAlarm") > -1) {
                NalNameValue nalNameValue4 = null;
                nalNameValue4 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue4);
            }
            if (string.indexOf("SauControl") > -1 || string.indexOf("XalmControl") > -1 || string.indexOf("ScuControl") > -1 || string.indexOf("SupControl") > -1) {
                NalNameValue nalNameValue5 = null;
                nalNameValue5 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue5);
            }
            if (string.equals("steeredHsAllocation") || string.endsWith("numHsCodeResources") || string.endsWith("numEulResources") || string.endsWith("numHsCodeResources1stBBP") || string.endsWith("numHsCodeResources2ndBBP")) {
                NalNameValue nalNameValue6 = null;
                nalNameValue6 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue6);
            }
            if (string.startsWith("carrierAllocationMode")) {
                NalNameValue nalNameValue7 = null;
                nalNameValue7 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue7);
            }
            if (string.startsWith("supportSystemControl")) {
                NalNameValue nalNameValue8 = null;
                nalNameValue8 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue8);
            }
            if (!string.equals("altitude") && !string.equals("latitude") && !string.equals("longitude") && !string.equals("tolerance")) continue;
            NalNameValue nalNameValue9 = null;
            nalNameValue9 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue9);
        }
        return vector2;
    }

    private Vector extractAndStripModifyNames(Vector vector) {
        NalNameValue nalNameValue = null;
        String string = null;
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (string.equals("steeredHsAllocation") || string.endsWith("numHsCodeResources") || string.endsWith("numEulResources") || string.endsWith("numHsCodeResources1stBBP") || string.endsWith("numHsCodeResources2ndBBP")) {
                vector2.add(Nal.getFactory().getNameValue(string, nalNameValue.getValue()));
            }
            if (string.startsWith("carrierAllocationMode")) {
                vector2.add(Nal.getFactory().getNameValue(string, nalNameValue.getValue()));
            }
            if (string.startsWith("supportSystemControl")) {
                vector2.add(Nal.getFactory().getNameValue(string, nalNameValue.getValue()));
            }
            if (!string.equals("altitude") && !string.equals("latitude") && !string.equals("longitude") && !string.equals("tolerance")) continue;
            vector2.add(Nal.getFactory().getNameValue(string, nalNameValue.getValue()));
        }
        return vector2;
    }

    private NalNameValue subCabPrefix(NalNameValue nalNameValue) {
        int n;
        NalNameValue nalNameValue2 = nalNameValue;
        boolean bl = true;
        String string = nalNameValue.getName();
        boolean bl2 = false;
        if (string.startsWith("DCAB")) {
            bl2 = true;
        }
        if ((n = this.isCabinetNumber(string)) > 0) {
            String string2 = this.stripCabinetName(string, n, bl2);
            if (string2.equals("cabinetNumber") && nalNameValue.getValue() == "##UNDEFINED") {
                bl = false;
            } else if (this.rbs.isParameterSupported("supportSystemControl")) {
                try {
                    if ("FALSE".equals(this.rbs.getCustomerParameter("supportSystemControl")) && (string2.equals("ecBusNumber") || string2.equals("cabinetType") || string2.equals("smokeDetector") || string2.equals("climateSystem"))) {
                        bl = false;
                    }
                }
                catch (BemException bemException) {
                    Nal.getLog().nalTraceEnter(InformativeText.class, "supportSystemControl has not existed, Exception: " + bemException.toString());
                }
            }
            if (bl && this.isCabinetModifyAttrs(string2)) {
                if (string2.equals("cabinetNumber") && bl2) {
                    string2 = "DeleteCabinet";
                }
                nalNameValue2 = Nal.getFactory().getNameValue(string2, nalNameValue.getValue());
            }
        }
        return nalNameValue2;
    }

    private Vector extractAndStripEcPortNames(Vector vector) throws BemException {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (!string.startsWith("EcPort")) continue;
            NalNameValue nalNameValue2 = null;
            nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue2);
        }
        return vector2;
    }

    private Vector[] extractAndStripCabinetNames(Vector vector) throws BemException {
        Vector[] vectorArray = new Vector[this.cabinetNoList.size()];
        for (int i = 0; i < this.cabinetNoList.size(); ++i) {
            vectorArray[i] = new Vector();
        }
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            boolean bl = true;
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            boolean bl2 = false;
            if (string.startsWith("DCAB")) {
                bl2 = true;
            }
            if ((n = this.isCabinetNumber(string)) <= 0) continue;
            String string2 = this.stripCabinetName(string, n, bl2);
            if (string2.equals("cabinetNumber") && nalNameValue.getValue() == "##UNDEFINED") {
                bl = false;
            } else if (this.rbs.isParameterSupported("supportSystemControl") && "FALSE".equals(this.rbs.getCustomerParameter("supportSystemControl")) && (string2.equals("ecBusNumber") || string2.equals("cabinetType") || string2.equals("smokeDetector") || string2.equals("climateSystem"))) {
                bl = false;
            }
            if (!bl || !this.isCabinetAttrs(string2)) continue;
            if (string2.equals("cabinetNumber") && bl2) {
                string2 = "DeleteCabinet";
            }
            NalNameValue nalNameValue2 = Nal.getFactory().getNameValue(string2, nalNameValue.getValue());
            vectorArray[n - 1].add(nalNameValue2);
        }
        return vectorArray;
    }

    private Vector[] extractAndStripModifyCabinetNames(Vector vector) throws BemException {
        Vector[] vectorArray = new Vector[this.cabinetNoList.size()];
        for (int i = 0; i < this.cabinetNoList.size(); ++i) {
            vectorArray[i] = new Vector();
        }
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            boolean bl = true;
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            boolean bl2 = false;
            if (string.startsWith("DCAB")) {
                bl2 = true;
            }
            if ((n = this.isCabinetNumber(string)) <= 0) continue;
            String string2 = this.stripCabinetName(string, n, bl2);
            if (string2.equals("cabinetNumber") && nalNameValue.getValue() == "##UNDEFINED") {
                bl = false;
            } else if (this.rbs.isParameterSupported("supportSystemControl") && "FALSE".equals(this.rbs.getCustomerParameter("supportSystemControl")) && (string2.equals("ecBusNumber") || string2.equals("cabinetType") || string2.equals("smokeDetector") || string2.equals("climateSystem"))) {
                bl = false;
            }
            if (!bl || !this.isCabinetModifyAttrs(string2)) continue;
            if (string2.equals("cabinetNumber") && bl2) {
                string2 = "DeleteCabinet";
            }
            NalNameValue nalNameValue2 = Nal.getFactory().getNameValue(string2, nalNameValue.getValue());
            vectorArray[this.cabinetNoList.size() - 1].add(nalNameValue2);
        }
        return vectorArray;
    }

    private Vector extractAndStripECBusNames(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (!string.startsWith("EcBus") && !string.startsWith("ModEcBus")) continue;
            NalNameValue nalNameValue2 = null;
            string = string.substring(string.indexOf("_") + 1);
            nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue2);
        }
        return vector2;
    }

    private int getHwGroupIndex(String string) {
        for (int i = 0; i < this.noOfHwGroups; ++i) {
            if (!string.startsWith(this.HWGROUP_PREFIX[i])) continue;
            return i;
        }
        return -1;
    }

    private Map extractAndStripHwGroupNames(Vector vector) throws BemException {
        HashMap<String, Vector<NalNameValue>> hashMap = new HashMap<String, Vector<NalNameValue>>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string2;
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            int n = this.getHwGroupIndex(string);
            if (n < 0 || string.equals((string2 = PrefixUtil.getHwGroupPrefix(n)) + "hwGroupId")) continue;
            String string3 = this.rbs.getCustomerParameter(string2 + "hwGroupId");
            String string4 = string.substring(string2.length());
            NalNameValue nalNameValue2 = Nal.getFactory().getNameValue(string4, nalNameValue.getValue());
            Vector<NalNameValue> vector2 = (Vector<NalNameValue>)hashMap.get(string3);
            if (null == vector2) {
                vector2 = new Vector<NalNameValue>();
                hashMap.put(string3, vector2);
            }
            vector2.add(nalNameValue2);
        }
        return hashMap;
    }

    public Map getHwGroupParams() throws BemException {
        Vector vector = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        return this.extractAndStripHwGroupNames(vector);
    }

    private boolean shouldFilterNetworkName(String string) {
        boolean bl = false;
        if (string.equals("EthernetSwitchvlan")) {
            try {
                CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.rbs.getCustomerParameterObject(string);
                String string2 = customerParameterImpl.getLoadedValue();
                String string3 = customerParameterImpl.getValue();
                if ((string2.equals("NO") || string2.equals("##UNDEFINED")) && string3.equals("NO")) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
        } else if (string.equals("IPoverGigabitEthernet_etIPSynchSlot")) {
            bl = true;
        }
        return bl;
    }

    private Vector extractNetworkNames(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            NalNameValue nalNameValue2;
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (this.shouldFilterNetworkName(string)) continue;
            if (string.startsWith("EthernetSwitch") || string.startsWith("IPoverGigabitEthernet") || string.equals("gigaBitEthernetPort") || string.equals("autoNegotiation") || string.equals("masterMode") || string.equals("configuredSpeedDuplex") || string.startsWith("slotsForET") || string.startsWith("firstOAMatm") || string.startsWith("secondOAMatm") || string.startsWith("OamIpHost_")) {
                nalNameValue2 = null;
                nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue2);
                continue;
            }
            if (string.startsWith("R_") && (string.endsWith("routeIpAddress") || string.endsWith("routeSubnetMask") || string.endsWith("hopIpAddress") || string.endsWith("routeMetric") || string.endsWith("redistribute"))) {
                nalNameValue2 = null;
                nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue2);
                continue;
            }
            if (string.startsWith("Y_") && (string.endsWith("synchSlot") || string.endsWith("synchPort") || string.endsWith("synchPriority") || string.endsWith("synchGuiBoard"))) {
                nalNameValue2 = null;
                nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue2);
                continue;
            }
            if (string.startsWith("Y_") && string.endsWith("action")) {
                nalNameValue2 = null;
                nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue2);
                int n = string.indexOf("_");
                int n2 = string.lastIndexOf("_");
                String string2 = ((Object)string.subSequence(n + 1, n2)).toString();
                if (!nalNameValue2.getValue().equals("DELETE")) continue;
                for (int j = 0; j < this.custParams.length; ++j) {
                    if (!this.custParams[j].getName().startsWith("Y_" + string2) || !this.custParams[j].getName().endsWith("synchSlot") && !this.custParams[j].getName().endsWith("synchPort") && !this.custParams[j].getName().endsWith("synchPriority") && !this.custParams[j].getName().endsWith("synchGuiBoard")) continue;
                    NalNameValue nalNameValue3 = null;
                    nalNameValue3 = Nal.getFactory().getNameValue(this.custParams[j].getName(), this.custParams[j].getValue());
                    vector2.add(nalNameValue3);
                }
                continue;
            }
            if (!string.equals("configureCpriBasedSync") && !string.equals("administrativeState") && !string.equals("selectionMode") && !string.equals("syncNodePriority") && !string.equals("syncRiPortCandidate")) continue;
            nalNameValue2 = null;
            nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue2);
        }
        return vector2;
    }

    private Vector extractDeleteRaxNames(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (!string.startsWith("DeleteRaxBoard")) continue;
            NalNameValue nalNameValue2 = null;
            nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue2);
        }
        return vector2;
    }

    private Vector extractAtmNames(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (!string.startsWith("ATM") && !string.startsWith("DeleteAtmPort") && !string.startsWith("PhysPathTerm") && !string.startsWith("DeletePhysPathTerm")) continue;
            NalNameValue nalNameValue2 = null;
            nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue2);
        }
        return vector2;
    }

    private Vector extractAddDuwDataNames(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (!string.startsWith("AddDuwBoard") && (!string.startsWith("slot") || string.startsWith("slotsFor"))) continue;
            NalNameValue nalNameValue2 = null;
            nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue2);
        }
        return vector2;
    }

    private Vector extractAddRadioDot(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (!string.startsWith("AddRadioDot") && !string.startsWith("DeleteRadioDot")) continue;
            vector2.add(Nal.getFactory().getNameValue(string, nalNameValue.getValue()));
        }
        return vector2;
    }

    private Vector[][] extractAndStripCellNames(Vector[] vectorArray) {
        Vector[][] vectorArray2 = new Vector[this.MAX_SECTORS][this.MAX_CELLS];
        for (int i = 0; i < this.MAX_SECTORS; ++i) {
            for (int j = 0; j < this.MAX_CELLS; ++j) {
                vectorArray2[i][j] = new Vector();
            }
        }
        NalNameValue nalNameValue = null;
        NalNameValue nalNameValue2 = null;
        String string = null;
        Vector vector = null;
        for (int i = 0; i < vectorArray.length; ++i) {
            int n;
            int n2;
            Vector<Integer> vector2 = new Vector<Integer>();
            vector = vectorArray[i];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                nalNameValue = (NalNameValue)vector.get(n2);
                string = nalNameValue.getName();
                n = this.isCellName(string);
                if (n <= 0) continue;
                String string2 = this.stripCellName(string);
                nalNameValue2 = Nal.getFactory().getNameValue(string2, nalNameValue.getValue());
                vectorArray2[i][n - 1].add(nalNameValue2);
                vector2.add(new Integer(n2));
            }
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                n = vector2.size() - n2 - 1;
                vectorArray[i].remove((Integer)vector2.get(n));
            }
        }
        return vectorArray2;
    }

    private Vector extractClimateSystemNames(Vector vector) {
        return this.extractCustomerParameterNames(vector, "climateSystem");
    }

    private Vector extractClimateRegulationSystemNames(Vector vector) {
        return this.extractCustomerParameterNames(vector, "climateRegulationSystem");
    }

    private Vector extractCustomerParameterNames(Vector vector, String string) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            string2 = nalNameValue.getName();
            if (!string2.startsWith(string)) continue;
            NalNameValue nalNameValue2 = null;
            nalNameValue2 = Nal.getFactory().getNameValue(string2, nalNameValue.getValue());
            vector2.add(nalNameValue2);
        }
        return vector2;
    }

    private int isSectorName(String string) {
        int n = 0;
        for (int i = 0; i < this.MAX_SECTORS; ++i) {
            if (!string.startsWith(this.SECTOR_PREFIX[i])) continue;
            n = i + 1;
        }
        return n;
    }

    private String stripSectorName(String string, int n) {
        return string.substring(this.SECTOR_PREFIX[n].length(), string.length());
    }

    private int isCellName(String string) {
        int n = 0;
        for (int i = 0; i < this.MAX_CELLS; ++i) {
            if (!string.startsWith(this.CELL_PREFIX[i])) continue;
            n = i + 1;
        }
        return n;
    }

    private String stripCellName(String string) {
        return string.substring(this.CELL_PREFIX[0].length(), string.length());
    }

    private int isSequenceName(String string) {
        int n = 0;
        for (int i = 0; i < this.MAX_SEQUENCE; ++i) {
            if (!string.startsWith(this.SEQUENCE_PREFIX[i])) continue;
            n = i + 1;
        }
        return n;
    }

    private String stripSequenceName(String string) {
        String string2 = string.substring(this.SEQUENCE_PREFIX[0].length(), string.length());
        string2 = string2 + " (" + string.substring(0, this.SEQUENCE_PREFIX[0].length() - 1) + ")";
        return string2;
    }

    private int isRadioUnitName(String string) {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (!string.startsWith(this.RADIOUNIT_PREFIX[i])) continue;
            n = i + 1;
        }
        return n;
    }

    private String stripRadioUnitName(String string, int n) {
        String string2 = string.substring(this.RADIOUNIT_PREFIX[n].length(), string.length());
        string2 = string2 + " (" + string.substring(0, this.RADIOUNIT_PREFIX[n].length() - 1) + ")";
        return string2;
    }

    private int isAntennaName(String string) {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (!string.startsWith(this.ANTENNA_PREFIX[i])) continue;
            n = i + 1;
        }
        return n;
    }

    private String stripAntennaName(String string, int n) {
        String string2 = string.substring(this.ANTENNA_PREFIX[n].length(), string.length());
        string2 = string2 + " (" + string.substring(0, this.ANTENNA_PREFIX[n].length() - 1) + ")";
        return string2;
    }

    private Vector sortParams(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        String string = null;
        NalNameValue nalNameValue = null;
        for (int i = 0; i < this.registeredList.size(); ++i) {
            string = this.registeredList.get(i).toString();
            for (int j = 0; j < vector.size(); ++j) {
                nalNameValue = (NalNameValue)vector.get(j);
                if (!string.equals(nalNameValue.getName())) continue;
                vector2.add(nalNameValue);
            }
        }
        return vector2;
    }

    private Vector sortParamsInAlpha(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        String string = null;
        NalNameValue nalNameValue = null;
        Vector<String> vector3 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            vector3.add(nalNameValue.getName());
        }
        Object[] objectArray = vector3.toArray();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            string = (String)objectArray[i];
            for (int j = 0; j < vector.size(); ++j) {
                nalNameValue = (NalNameValue)vector.get(j);
                if (!string.equals(nalNameValue.getName())) continue;
                vector2.add(nalNameValue);
            }
        }
        return vector2;
    }

    private String createText(Vector[] vectorArray, Vector[][] vectorArray2, Vector vector, Vector vector2, Vector vector3, Vector[] vectorArray3, Map map) throws BemException {
        int n;
        int n2;
        Report report = new Report();
        NalNameValue nalNameValue = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            nalNameValue = (NalNameValue)vector.get(n2);
            if (!nalNameValue.getName().equals("rbsType")) continue;
            Report.Table table = report.addTable("Changed Product Name");
            table.addRow(nalNameValue);
            vector.remove(n2);
        }
        for (n2 = 0; n2 < this.MAX_SECTORS; ++n2) {
            if (this.shouldSectorBeFiltered(n2)) continue;
            boolean bl = false;
            if (vectorArray[n2].size() > 0) {
                Report.Table table = this.addSectorTable(report, n2);
                bl = true;
                for (int i = 0; i < vectorArray[n2].size(); ++i) {
                    nalNameValue = (NalNameValue)vectorArray[n2].get(i);
                    table.addRow(nalNameValue);
                }
            }
            for (n = 0; n < this.MAX_CELLS; ++n) {
                if (vectorArray2[n2][n].size() <= 0) continue;
                if (!bl) {
                    this.addSectorTable(report, n2);
                    bl = true;
                }
                Report.Table table = report.addTable("Sector " + (n2 + 1) + ", Cell " + (n + 1));
                for (int i = 0; i < vectorArray2[n2][n].size(); ++i) {
                    nalNameValue = (NalNameValue)vectorArray2[n2][n].get(i);
                    table.addRow(nalNameValue);
                }
            }
        }
        n2 = 0;
        for (int i = 0; i < this.cabinetNoList.size(); ++i) {
            n = n2 != 0 ? i - 1 : i;
            String string = this.cabinetNoList.get(i).toString();
            if (Integer.parseInt(string) == 0) {
                n2 = 1;
                report.addTable("Cabinet " + string);
                this.externalAlarmText(report, vector, Integer.parseInt(string));
                continue;
            }
            if (vectorArray3[n].size() <= 0) continue;
            Report.Table table = report.addTable("Cabinet " + string);
            for (int j = 0; j < vectorArray3[n].size(); ++j) {
                NalNameValue nalNameValue2 = (NalNameValue)vectorArray3[n].get(j);
                table.addRow(nalNameValue2);
                String string2 = PrefixUtil.getCabinetPrefix(string);
                arrayList.add(string2 + nalNameValue2.getName());
            }
            this.powerSupplyText(report, vector, Integer.parseInt(string));
            this.externalAlarmText(report, vector, Integer.parseInt(string));
        }
        this.gpsSynchText(report, vector);
        this.atmText(report, vector);
        this.atmText(report, vector2);
        this.ipOatmText(report, vector2);
        this.networkSynchText(report, vector2);
        this.staticRoutingText(report, vector2);
        this.ipOgigText(report, vector2);
        this.ipHostLinkText(report, vector2);
        this.switchText(report, vector2);
        this.slotText(report, vector2);
        this.hsdpaAndEulText(report, vector);
        this.ecPortText(report, vector3, DuwUtil.isDualDuwAndPrimaryIsV2());
        this.hwGroupText(report, map);
        if (vector.size() > 0) {
            Report.Table table = report.addTable("Other settings");
            for (n = 0; n < vector.size(); ++n) {
                nalNameValue = (NalNameValue)vector.get(n);
                if (arrayList.contains(nalNameValue.getName())) continue;
                table.addRow(nalNameValue);
            }
        }
        return report.toString();
    }

    private void addMapToText(Report report, Map map, String string) {
        Object[] objectArray = map.keySet().toArray();
        Arrays.sort(objectArray, new HwGroupIdComparator());
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = objectArray[i].toString();
            Vector vector = (Vector)map.get(string2);
            Report.Table table = new Report.Table(string + string2);
            for (int j = 0; j < vector.size(); ++j) {
                NalNameValue nalNameValue = (NalNameValue)vector.get(j);
                table.addRow(nalNameValue);
            }
            report.addTable(table);
        }
    }

    private void hwGroupText(Report report, Map map) {
        this.addMapToText(report, map, "HwGroup ");
    }

    private boolean shouldSectorBeFiltered(int n) {
        boolean bl = false;
        String string = MessageFormat.format("S{0}_", new Integer(n + 1));
        String string2 = string + "createSector";
        if (this.rbs.isParameterSupported(string2)) {
            try {
                CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.rbs.getCustomerParameterObject(string2);
                String string3 = customerParameterImpl.getLoadedValue();
                String string4 = customerParameterImpl.getValue();
                if (string3.equals("NO") && string4.equals("NO")) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private Report.Table addSectorTable(Report report, int n) {
        return report.addTable("Sector " + (n + 1));
    }

    private String createText(Vector vector) throws BemException {
        NalNameValue nalNameValue = null;
        if (vector != null && vector.size() > 0) {
            Report.Table table = new Report.Table("Auto Integration");
            for (int i = 0; i < vector.size(); ++i) {
                nalNameValue = (NalNameValue)vector.get(i);
                if (nalNameValue.getName().endsWith("AI_autoIntegrate")) {
                    table.addRow("Auto Integrate:", nalNameValue);
                    continue;
                }
                if (nalNameValue.getName().endsWith("AI_logicalName")) {
                    table.addRow("Logical Name:", nalNameValue);
                    continue;
                }
                if (nalNameValue.getName().endsWith("AI_oamFilePath")) {
                    table.addRow("Oam file path:", nalNameValue);
                    continue;
                }
                if (nalNameValue.getName().endsWith("AI_siteFilePath")) {
                    table.addRow("Site file path:", nalNameValue);
                    continue;
                }
                if (nalNameValue.getName().endsWith("AI_user_name")) {
                    table.addRow("Username:", nalNameValue);
                    continue;
                }
                if (nalNameValue.getName().endsWith("AI_password")) {
                    table.addRow("Password:", nalNameValue);
                    continue;
                }
                if (nalNameValue.getName().endsWith("AI_vlan")) {
                    table.addRow("Vlan:", nalNameValue);
                    continue;
                }
                if (nalNameValue.getName().endsWith("AI_vid")) {
                    table.addRow("Vlan ID:", nalNameValue);
                    continue;
                }
                if (nalNameValue.getName().endsWith("AI_waitForOss")) {
                    table.addRow("Wait for OSS:", nalNameValue);
                    continue;
                }
                if (nalNameValue.getName().endsWith("ftpStoreReport") || nalNameValue.getName().endsWith("clientStoreReport")) continue;
                table.addRow(nalNameValue);
            }
            if (DuwUtil.hasDuw()) {
                String string = "NO";
                if (DuwUtil.hasDualDuws()) {
                    string = "YES";
                }
                table.addRow("Is Dual DUW node:", string);
            }
            return table.toString();
        }
        return "";
    }

    private NalNameValue findParameterAndRemove(String string, List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NalNameValue nalNameValue = (NalNameValue)iterator.next();
                if (!nalNameValue.getName().equals(string)) continue;
                list.remove(nalNameValue);
                return nalNameValue;
            }
        }
        return null;
    }

    private void atmText(Report report, List list) {
        AtmAndPtInformativeText atmAndPtInformativeText = new AtmAndPtInformativeText();
        atmAndPtInformativeText.setCustomerParameters(list);
        atmAndPtInformativeText.appendReport(report);
    }

    private void ipOgigText(Report report, List list) {
        Iterator iterator = list.iterator();
        Report.Table table = new Report.Table("IP Sync Configuration");
        while (iterator.hasNext()) {
            NalNameValue nalNameValue = (NalNameValue)iterator.next();
            if (!nalNameValue.getName().startsWith("IPoverGigabitEthernet") || nalNameValue.getName().equals("IPoverGigabitEthernet_transportOption")) continue;
            if (nalNameValue.getName().endsWith("_ntpServerIpAddress")) {
                table.addRow("NTP IP address:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("IPoverGigabitEthernet_syncIpAddress")) {
                table.addRow("IP Address:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("IPoverGigabitEthernet_syncSubnetMask")) {
                table.addRow("Subnet Mask:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("IPoverGigabitEthernet_defaultRouter0")) {
                table.addRow("Default Router 0:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("IPoverGigabitEthernet_syncVid")) {
                table.addRow("Vlan ID:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("syncServerType")) continue;
            table.addRow(nalNameValue);
        }
        if (table.hasData()) {
            report.addTable(table);
        }
    }

    private void ipHostLinkText(Report report, List list) {
        Iterator iterator = list.iterator();
        Report.Table table = new Report.Table("IP O&M Configuration");
        while (iterator.hasNext()) {
            NalNameValue nalNameValue = (NalNameValue)iterator.next();
            if (!nalNameValue.getName().startsWith("OamIpHost_")) continue;
            if (nalNameValue.getName().endsWith("OamIpHost_oamIpAddress")) {
                table.addRow("IP address:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("OamIpHost_oamSubnetMask")) {
                table.addRow("Subnet Mask:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("OamIpHost_oamDefaultRouter0")) {
                table.addRow("Default Router 0:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("OamIpHost_oamVid")) {
                table.addRow("Vlan ID:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("OamIpHost_configurationMode")) {
                table.addRow("Configuration Mode:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("OamIpHost_dnsAutoConfig")) {
                table.addRow("DNS Auto Config:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("OamIpHost_DhcpClientIdentifier_clientIdentifierType")) {
                table.addRow("Client Identifier Type:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("OamIpHost_DhcpClientIdentifier_clientIdentifier")) {
                table.addRow("Client Identifier:", nalNameValue);
                continue;
            }
            table.addRow(nalNameValue);
        }
        if (table.hasData()) {
            report.addTable(table);
        }
    }

    private void ipOatmText(Report report, List list) {
        Iterator iterator = list.iterator();
        Report.Table table = new Report.Table("IP over ATM");
        while (iterator.hasNext()) {
            NalNameValue nalNameValue = (NalNameValue)iterator.next();
            if (!nalNameValue.getName().startsWith("firstOAMatm") && !nalNameValue.getName().startsWith("secondOAMatm")) continue;
            if (nalNameValue.getName().endsWith("name")) {
                table.addRow("Name:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("etbSlot")) {
                table.addRow("Etb Slot:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("physicalLine")) {
                table.addRow("Physical Line:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("terminationType")) {
                table.addRow("Termination Type:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("timeSlotsInFraction")) {
                table.addRow("Time Slots In Fraction:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("externalVpi")) {
                table.addRow("External VPI:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("vpPeakCellRate")) {
                table.addRow("VP Peak Cell Rate:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("vpMinimumCellRate")) {
                table.addRow("VP Minimum Cell Rate:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("vpServiceCategory")) {
                table.addRow("VP Service Category:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("externalVci")) {
                table.addRow("External VCI:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("vcServiceCategory")) {
                table.addRow("VC Service Category:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("atmIpAddress")) {
                table.addRow("ATM Ip Address:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("atmSubnetMask")) {
                table.addRow("ATM Subnet Mask:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("requiredNumberOfLinks")) {
                table.addRow("Required Number of Links:", nalNameValue);
                continue;
            }
            table.addRow(nalNameValue);
        }
        if (table.hasData()) {
            report.addTable(table);
        }
    }

    private void networkSynchText(Report report, List list) {
        Iterator iterator = list.iterator();
        Report.Table table = new Report.Table("Network Synch");
        while (iterator.hasNext()) {
            NalNameValue nalNameValue = (NalNameValue)iterator.next();
            if (!nalNameValue.getName().startsWith("Y_")) continue;
            if (nalNameValue.getName().endsWith("synchSlot")) {
                table.addRow("Synch Slot:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("synchPort")) {
                table.addRow("Synch Port:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("synchPriority")) {
                table.addRow("Synch Priority:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("synchGuiBoard")) {
                table.addRow("Synch GUI Board:", nalNameValue);
                continue;
            }
            table.addRow(nalNameValue);
        }
        if (table.hasData()) {
            report.addTable(table);
        }
    }

    private void staticRoutingText(Report report, List list) {
        Iterator iterator = list.iterator();
        Report.Table table = new Report.Table("Static Routing");
        while (iterator.hasNext()) {
            NalNameValue nalNameValue = (NalNameValue)iterator.next();
            if (!nalNameValue.getName().startsWith("R_")) continue;
            if (nalNameValue.getName().endsWith("routeIpAddress")) {
                table.addRow("Router IP Address:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("routeSubnetMask")) {
                table.addRow("Router Subnet Mask:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("hopIpAddress")) {
                table.addRow("Hop IP Address:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("routeMetric")) {
                table.addRow("Router Metric:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().endsWith("redistribute")) {
                table.addRow("Redistribute:", nalNameValue);
                continue;
            }
            table.addRow(nalNameValue);
        }
        if (table.hasData()) {
            report.addTable(table);
        }
    }

    private void switchText(Report report, List list) {
        int n;
        Iterator iterator = list.iterator();
        Report.Table table = new Report.Table("Ethernet Switch");
        Report.Table table2 = new Report.Table("Ethernet Switch Port");
        table2.addColumnTitles(new String[]{"Port", "Adm State", "System Port", "Untagged Vid"});
        Report.Table table3 = new Report.Table("Vlan Membership");
        table3.addColumnTitles(new String[]{"Port", "Action", "Vid", "Egress"});
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0};
        String[][] stringArray = new String[7][3];
        String[][][] stringArray2 = new String[7][256][3];
        boolean[] blArray = new boolean[]{false, false, false};
        for (n = 0; n < 7; ++n) {
            for (int i = 0; i < 3; ++i) {
                stringArray[n][i] = "-";
            }
        }
        while (iterator.hasNext()) {
            NalNameValue nalNameValue = (NalNameValue)iterator.next();
            if (nalNameValue.getName().startsWith("EthernetSwitchPort")) {
                blArray[1] = true;
                EthernetSwitchProvider ethernetSwitchProvider = (EthernetSwitchProvider)this.rbs.getProvider(class$se$ericsson$wcdma$rbs$bem$common$config$configitem$provider$EthernetSwitchProvider == null ? InformativeText.class$("se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetSwitchProvider") : class$se$ericsson$wcdma$rbs$bem$common$config$configitem$provider$EthernetSwitchProvider);
                int n2 = ethernetSwitchProvider.getPortNumberFromEthernetSwitchPortPseudo(nalNameValue.getName());
                String string = nalNameValue.getName();
                if (string.endsWith("administrativeState")) {
                    stringArray[n2 - 1][0] = nalNameValue.getValue().toString();
                    continue;
                }
                if (string.endsWith("systemPort")) {
                    stringArray[n2 - 1][1] = nalNameValue.getValue().toString();
                    continue;
                }
                if (nalNameValue.getName().endsWith("untaggedIngressVid")) {
                    stringArray[n2 - 1][2] = nalNameValue.getValue().toString();
                    continue;
                }
                if (string.indexOf("VlanMembership") == -1) continue;
                blArray[2] = true;
                int n3 = nalNameValue.getName().lastIndexOf("_");
                int n4 = "EthernetSwitchPort".length();
                n4 = "EthernetSwitchPort_{0}_VlanMembership".length();
                String string2 = nalNameValue.getName().substring(n4 + 1, n3);
                String string3 = new Integer(n2).toString() + string2;
                if (!hashMap.containsKey(string3)) {
                    hashMap.put(string3, new Integer(nArray[n2 - 1]));
                    int n5 = n2 - 1;
                    nArray[n5] = nArray[n5] + 1;
                }
                Integer n6 = (Integer)hashMap.get(string3);
                if (nalNameValue.getName().endsWith("_action")) {
                    stringArray2[n2 - 1][n6.intValue()][0] = nalNameValue.getValue().toString();
                    continue;
                }
                if (nalNameValue.getName().endsWith("_vid")) {
                    stringArray2[n2 - 1][n6.intValue()][1] = nalNameValue.getValue().toString();
                    continue;
                }
                if (!nalNameValue.getName().endsWith("_egressUntag")) continue;
                stringArray2[n2 - 1][n6.intValue()][2] = nalNameValue.getValue().toString();
                continue;
            }
            if (!nalNameValue.getName().startsWith("EthernetSwitch")) continue;
            blArray[0] = true;
            if (nalNameValue.getName().equals("EthernetSwitchvlan")) {
                table.addRow("Enable Vlan:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().startsWith("EthernetSwitchVlanMembership") && nalNameValue.getName().endsWith("action")) {
                table.addRow("Vlan Membership Action:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().startsWith("EthernetSwitchVlanMembership") && nalNameValue.getName().endsWith("vid")) {
                table.addRow("Vlan Membership Vid:", nalNameValue);
                continue;
            }
            if (nalNameValue.getName().startsWith("EthernetSwitchVlanMembership") && nalNameValue.getName().endsWith("egressUntag")) {
                table.addRow("Vlan Membership Egress:", nalNameValue);
                continue;
            }
            table.addRow(nalNameValue);
        }
        if (blArray[1]) {
            for (n = 0; n < 7; ++n) {
                String[] stringArray3 = new String[4];
                stringArray3[0] = Integer.toString(n + 1);
                System.arraycopy(stringArray[n], 0, stringArray3, 1, stringArray[n].length);
                table2.addRow(stringArray3);
                if (!blArray[2]) continue;
                for (int i = 0; i < 256; ++i) {
                    if (i >= nArray[n]) continue;
                    String[] stringArray4 = new String[4];
                    stringArray4[0] = Integer.toString(n + 1);
                    System.arraycopy(stringArray2[n][i], 0, stringArray4, 1, stringArray2[n][i].length);
                    table3.addColumnTitles(stringArray4);
                }
            }
        }
        if (table.hasData()) {
            report.addTable(table);
            if (table2.hasData()) {
                report.addTable(table2);
                if (table3.hasData()) {
                    report.addTable(table3);
                }
            }
        }
    }

    private void slotText(Report report, List list) {
        Iterator iterator = list.iterator();
        Report.Table table = new Report.Table("ET Slots");
        while (iterator.hasNext()) {
            NalNameValue nalNameValue = (NalNameValue)iterator.next();
            if (!nalNameValue.getName().startsWith("slotsForET")) continue;
            table.addRow(nalNameValue);
        }
        if (table.hasData()) {
            report.addTable(table);
        }
    }

    private void externalAlarmText(Report report, List list, int n) {
        XalmInformativeText xalmInformativeText = new XalmInformativeText("Xalm", n);
        xalmInformativeText.setCustomerParameters(list);
        XalmInformativeText xalmInformativeText2 = new XalmInformativeText("Sau", n);
        xalmInformativeText2.setCustomerParameters(list);
        XalmInformativeText xalmInformativeText3 = new XalmInformativeText("Scu", n);
        xalmInformativeText3.setCustomerParameters(list);
        XalmInformativeText xalmInformativeText4 = new XalmInformativeText("Sup", n);
        xalmInformativeText4.setCustomerParameters(list);
        XalmInformativeText xalmInformativeText5 = new XalmInformativeText("Rruw", n);
        xalmInformativeText5.setCustomerParameters(list);
        XalmInformativeText xalmInformativeText6 = new XalmInformativeText("Iru", n);
        xalmInformativeText6.setCustomerParameters(list);
        String string = "External Alarm and Control Unit";
        Report report2 = new Report();
        report2.addHeading(string);
        int n2 = report2.getAddedPartsCount();
        report2.addReport(xalmInformativeText.getInformativeText());
        report2.addReport(xalmInformativeText2.getInformativeText());
        report2.addReport(xalmInformativeText3.getInformativeText());
        report2.addReport(xalmInformativeText4.getInformativeText());
        report2.addReport(xalmInformativeText5.getInformativeText());
        report2.addReport(xalmInformativeText6.getInformativeText());
        if (n2 < report2.getAddedPartsCount()) {
            report.addReport(report2);
        }
    }

    private void gpsSynchText(Report report, List list) {
        Report.Table table = new Report.Table("GPS synchronization");
        NalNameValue nalNameValue = null;
        nalNameValue = this.findParameterAndRemove("absoluteTimeSynchEnabled", list);
        table.addRow("Absolute time synch enabled: ", nalNameValue);
        nalNameValue = this.findParameterAndRemove("gpsOutEnabled", list);
        table.addRow("GPS out enabled: ", nalNameValue);
        nalNameValue = this.findParameterAndRemove("gpsOutEnabledOnSlot2", list);
        table.addRow("GPS out enabled: ", nalNameValue);
        if (table.hasData()) {
            report.addTable(table);
        }
    }

    private Vector extractGpsSyncNames(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            NalNameValue nalNameValue2;
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (string.startsWith("absoluteTimeSynchEnabled")) {
                nalNameValue2 = null;
                nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue2);
                continue;
            }
            if (string.startsWith("gpsOutEnabled")) {
                nalNameValue2 = null;
                nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
                vector2.add(nalNameValue2);
                continue;
            }
            if (!string.startsWith("gpsOutEnabledOnSlot2")) continue;
            nalNameValue2 = null;
            nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue2);
        }
        return vector2;
    }

    private void powerSupplyText(Report report, List list, int n) {
        Report.Table table = new Report.Table("Power Supply");
        NalNameValue nalNameValue = null;
        String string = PrefixUtil.getCabinetPrefix(String.valueOf(n));
        nalNameValue = this.findParameterAndRemove(string + "batteryType", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "batteryInstallationDate", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "configureBatteryBackup", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove("batteryCapacity", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove("configurePowerShelfFan", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "sharedBattery", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "chargingMode", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "testMode", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "minimumStateOfHealth", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "minimumBackupTime", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "testStartDay", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "testStartTime", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        for (int i = 0; i < 12; ++i) {
            int n2 = i + 1;
            nalNameValue = this.findParameterAndRemove(string + "testStartMonths" + n2, list);
            table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        }
        nalNameValue = this.findParameterAndRemove(string + "chargingVoltage", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "tempCompVoltageSlope", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "nominalTemp", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "tempCompMinVoltage", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "tempCompMaxVoltage", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "increasedChargeVoltage", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "boostChargeTime", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "boostChargeTriggerVoltage", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "equalizeChargeTime", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "equalizeChargeCyclicInterval", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "intermittentChargeConnectVoltage", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "intermittentChargeConnectTime", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        nalNameValue = this.findParameterAndRemove(string + "intermittentChargeDisconnectTime", list);
        table.addRow(nalNameValue == null ? null : this.subCabPrefix(nalNameValue));
        if (table.hasData()) {
            report.addTable(table);
        }
    }

    private void hsdpaAndEulText(Report report, List list) throws BemException {
        int n;
        Object object;
        Iterator iterator = null;
        Vector<Object> vector = new Vector<Object>();
        Report.Table table = new Report.Table("HSDPA and EUL");
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (NalNameValue)iterator.next();
            if (!object.getName().equals("steeredHsAllocation")) continue;
            table.addRow((NalNameValue)object);
            vector.add(object);
            break;
        }
        if (table.hasData()) {
            report.addTable(table);
        }
        object = this.rbs.getRadioEquipmentProvider();
        for (n = 0; n < object.getNumberOfDuwSlots(); ++n) {
            Report.Table table2 = new Report.Table("HSDPA and EUL, DU board " + (n + 1));
            String[] stringArray = object.getSlotArrayForTxDevices(n);
            for (int i = 0; i < stringArray.length; ++i) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    NalNameValue nalNameValue = (NalNameValue)iterator.next();
                    String string = MessageFormat.format("hsSlot{0}_numHsCodeResources", stringArray[i]);
                    String string2 = MessageFormat.format("hsSlot{0}_numHsCodeResources1stBBP", stringArray[i]);
                    String string3 = MessageFormat.format("hsSlot{0}_numHsCodeResources2ndBBP", stringArray[i]);
                    String string4 = MessageFormat.format("eulSlot{0}_numEulResources", stringArray[i]);
                    if (nalNameValue.getName().equals(string)) {
                        table2.addRow("numHsCodeResources (slot " + stringArray[i] + ")", nalNameValue);
                        vector.add(nalNameValue);
                        continue;
                    }
                    if (nalNameValue.getName().equals(string4)) {
                        table2.addRow("numEulResources (slot " + stringArray[i] + ")", nalNameValue);
                        vector.add(nalNameValue);
                        continue;
                    }
                    if (nalNameValue.getName().equals(string2)) {
                        table2.addRow("numHsCodeResources1stBBP (slot " + stringArray[i] + ")", nalNameValue);
                        vector.add(nalNameValue);
                        continue;
                    }
                    if (!nalNameValue.getName().equals(string3)) continue;
                    table2.addRow("numHsCodeResources2ndBBP (slot " + stringArray[i] + ")", nalNameValue);
                    vector.add(nalNameValue);
                }
            }
            if (!table2.hasData()) continue;
            report.addTable(table2);
        }
        for (n = 0; n < vector.size(); ++n) {
            list.remove(vector.get(n));
        }
    }

    private void ecPortText(Report report, List list, boolean bl) throws BemException {
        Iterator iterator = list.iterator();
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            NalNameValue nalNameValue = (NalNameValue)iterator.next();
            String string = null;
            if (!nalNameValue.getValue().toString().endsWith(DEFAULT_VALUE_ENDING) && nalNameValue.getName().endsWith("cascadingOrder")) {
                string = nalNameValue.getName().substring(0, nalNameValue.getName().indexOf("cascadingOrder"));
            } else if (nalNameValue.getName().endsWith("hubPosition")) {
                string = nalNameValue.getName().substring(0, nalNameValue.getName().indexOf("hubPosition"));
            } else if (nalNameValue.getName().endsWith("referredCabinetNumber")) {
                string = nalNameValue.getName().substring(0, nalNameValue.getName().indexOf("referredCabinetNumber"));
            }
            if (string == null || hashSet.contains(string)) continue;
            hashSet.add(string);
            EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)((Object)this.rbs.getConfigItem("CabinetBasicCI"));
            EcPortInfo ecPortInfo = ecPortCustomerParameterProvider.getEcPortCustomerParameter(string);
            Report.Table table = new Report.Table("EcPort " + ecPortInfo.getPortNumberValue() + ", " + ecPortInfo.getUnitTypeValue() + " " + ecPortInfo.getUnitNumberValue());
            table.addRow("hubPosition", ecPortInfo.getHubPositionValueMom());
            table.addRow("cascadingOrder", ecPortInfo.getCascadingOrderValue());
            if (ecPortInfo.getUnitTypeValue().equals("EXTNODE")) {
                table.addRow("referredCabinetNumber", ecPortInfo.getReferredCabinetNumberValue());
            }
            report.addTable(table);
            vector.add(nalNameValue);
        }
        for (int i = 0; i < vector.size(); ++i) {
            list.remove(vector.get(i));
        }
    }

    private String stripCabinetName(String string, int n, boolean bl) {
        if (bl) {
            String string2 = PrefixUtil.getDeleteCabinetPrefix(String.valueOf(n));
            return string.substring(string2.length(), string.length());
        }
        String string3 = PrefixUtil.getCabinetPrefix(String.valueOf(n));
        return string.substring(string3.length(), string.length());
    }

    private int isCabinetNumber(String string) {
        int n = 0;
        for (int i = 0; i < this.cabinetNoList.size(); ++i) {
            int n2 = Integer.parseInt(this.cabinetNoList.get(i).toString());
            String string2 = PrefixUtil.getDeleteCabinetPrefix(String.valueOf(n2));
            String string3 = PrefixUtil.getCabinetPrefix(String.valueOf(n2));
            if (string.startsWith(string2)) {
                n = n2;
                break;
            }
            if (!string.startsWith(string3)) continue;
            n = n2;
            break;
        }
        return n;
    }

    private boolean isCabinetAttrs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cabinetNumber");
        arrayList.add("sharedCabinetIdentifier");
        arrayList.add("referredCabinetNumber");
        arrayList.add("cabinetType");
        arrayList.add("ecBusNumber");
        arrayList.add("climateSystem");
        arrayList.add("smokeDetector");
        arrayList.add("configureXalm");
        arrayList.add("configureSau");
        arrayList.add("configureScu");
        arrayList.add("configureSup");
        arrayList.add("configurePowerSupply");
        arrayList.add("noOfPsu");
        arrayList.add("noOfPdu");
        arrayList.add("noOfBfu");
        arrayList.add("fanSpeedSupervision");
        return arrayList.contains(string);
    }

    private boolean isCabinetModifyAttrs(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cabinetNumber");
        arrayList.add("sharedCabinetIdentifier");
        arrayList.add("referredCabinetNumber");
        arrayList.add("cabinetType");
        arrayList.add("ecBusNumber");
        arrayList.add("climateSystem");
        arrayList.add("smokeDetector");
        arrayList.add("configureXalm");
        arrayList.add("configureSau");
        arrayList.add("configureScu");
        arrayList.add("configureSup");
        arrayList.add("configurePowerSupply");
        arrayList.add("noOfPsu");
        arrayList.add("noOfPdu");
        arrayList.add("noOfBfu");
        arrayList.add("fanSpeedSupervision");
        arrayList.add("configureSau");
        arrayList.add("configureXalm");
        arrayList.add("configureScu");
        arrayList.add("batteryCapacity");
        arrayList.add("configureBatteryBackup");
        arrayList.add("batteryType");
        arrayList.add("configurePowerShelfFan");
        arrayList.add("multiplePowerSystem");
        arrayList.add("sharedBattery");
        arrayList.add("chargingMode");
        arrayList.add("testMode");
        arrayList.add("minimumStateOfHealth");
        arrayList.add("minimumBackupTime");
        arrayList.add("testStartDay");
        arrayList.add("testStartTime");
        arrayList.add("testStartMonths");
        for (n = 0; n < 12; ++n) {
            int n2 = n + 1;
            arrayList.add("testStartMonths" + n2);
        }
        arrayList.add("batteryInstallationDate");
        arrayList.add("chargingVoltage");
        arrayList.add("tempCompVoltageSlope");
        arrayList.add("nominalTemp");
        arrayList.add("tempCompMinVoltage");
        arrayList.add("tempCompMaxVoltage");
        arrayList.add("increasedChargeVoltage");
        arrayList.add("boostChargeTime");
        arrayList.add("boostChargeTriggerVoltage");
        arrayList.add("equalizeChargeTime");
        arrayList.add("equalizeChargeCyclicInterval");
        arrayList.add("intermittentChargeConnectVoltage");
        arrayList.add("intermittentChargeConnectTime");
        arrayList.add("intermittentChargeDisconnectTime");
        for (n = 0; n < arrayList.size(); ++n) {
            if (((String)arrayList.get(n)).indexOf(string) <= -1) continue;
            return true;
        }
        return string.indexOf("ExternalAlarm") > -1 || string.indexOf("ControlPort") > -1;
    }

    private Vector extractEcPortNames(Vector vector) {
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            nalNameValue = (NalNameValue)vector.get(i);
            string = nalNameValue.getName();
            if (!string.startsWith("EcPort")) continue;
            if (!RbsInfo.RBS_6601W.NAME.equals(this.rbs.getRbsType()) && string.endsWith("cascadingOrder")) {
                return vector2;
            }
            NalNameValue nalNameValue2 = null;
            nalNameValue2 = Nal.getFactory().getNameValue(string, nalNameValue.getValue());
            vector2.add(nalNameValue2);
        }
        return vector2;
    }

    public String getAiInformativeText() throws BemException {
        Vector vector = null;
        Vector vector2 = null;
        vector = this.getChangedCustParams();
        vector = this.sortParams(vector);
        vector2 = this.extractAndStripAiNames(vector);
        String string = "\nSettings from user\n";
        string = string + "==================\n";
        string = string + this.createText(vector2);
        return string;
    }

    private static class HwGroupIdComparator
    implements Comparator {
        private HwGroupIdComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            if (string.length() > string2.length()) {
                return 1;
            }
            if (string.length() < string2.length()) {
                return -1;
            }
            return string.compareTo(string2);
        }
    }
}

