/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3308.configitem;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuifRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet5;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet6;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.RbsCableSets;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.GenericRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB1;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB4;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.Reconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.UninitSectorReconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class RadioEquipment3308CI
extends GenericRadioEquipmentCI {
    private static final int MAX_NO_OF_SECTORS = 1;
    private static final int MAX_NO_OF_RUS = 1;
    private static final int MAX_NO_OF_CARRIERS = 2;
    private ReservedConnectorRI a;
    private ReservedConnectorRI b;
    private ReservedConnectorRI c;
    private ReservedConnectorRI d;
    private ReservedConnectorRI e;
    private ReservedConnectorRI f;
    private EnumeratedRange radioIfTypeRange;

    public RadioEquipment3308CI(Rbs rbs) {
        super(rbs, 1, 1, 2, false);
        this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"5"});
        this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"3", "4"});
    }

    public boolean open() throws BemException {
        this.initiateCPRanges();
        return super.open();
    }

    protected void createRadioBuildingBlocks() throws BemException {
        int n = this.getMaxNoOfSectors();
        this.radioBuildingBlocks = new RadioBuildingBlock[n];
        this.createReservedConnectors();
        for (int i = 1; i <= n; ++i) {
            SectorCapability sectorCapability = new SectorCapability();
            int n2 = 1;
            RuRI ruRI = this.ruSubrack.getSlot(n2);
            FuRI fuRI = this.fuSubrack.getSlot(n2);
            RB1 rB1 = new RB1(this.rbs, i, fuRI, ruRI, this.ruif[0], 60, 0, 0, 0, 0);
            rB1.setRadioIfConnectors(this.a, this.b, this.c, this.d, this.e, this.f);
            RB4 rB4 = new RB4(this.rbs, i, fuRI, ruRI, this.ruif[0], 60, 0, 0, 0, 0);
            rB4.setRadioIfConnectors(this.a, this.b, this.c, this.d, this.e, this.f);
            Reconfiguration[] reconfigurationArray = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB1, rB4, i)};
            sectorCapability.addConfiguration(rB1, reconfigurationArray);
            sectorCapability.addConfiguration(rB4);
            this.addSectorCapability(i, sectorCapability);
        }
    }

    protected void createRadioInterfaceBoard() {
        this.ruif[0] = new RuifRI(this.rbs, 6, BemLdn.LDN_DIGITAL_SUBRACK, "REIF");
    }

    protected void createSubracks() throws BemException {
        this.ruSubrack = new RuSubrackRI(this.rbs, 1, "1", "1B2", 1);
        this.fuSubrack = new FuSubrackRI(this.rbs, 1, "1", "1B1", 1);
    }

    protected RbsCableSets getRbsCableSets() {
        RbsCableSets rbsCableSets = new RbsCableSets();
        rbsCableSets.addCableSet("RB1", new CableSet5());
        rbsCableSets.addCableSet("RB4", new CableSet6());
        return rbsCableSets;
    }

    private void createReservedConnectors() {
        String string = MimDigitalCable.MOTYPENAME;
        String string2 = "objectAConnector";
        this.a = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 1, string, string2);
        this.b = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 2, string, string2);
        this.c = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 3, string, string2);
        this.d = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 4, string, string2);
        this.e = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 5, string, string2);
        this.f = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 6, string, string2);
    }

    private void initiateCPRanges() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("RUIF");
        this.radioIfTypeRange = new EnumeratedRange(arrayList);
    }

    protected EnumeratedRange getRadioIfTypeRange() {
        return this.radioIfTypeRange;
    }
}

