/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.rbs;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaSystemTmaCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AtmAndPtCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.CommonAlarmCI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.common.AbstractRbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3206.configitem.EtmBoard3206CI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.configitem.CabinetBasic6102CI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.configitem.CabinetBasic6102MCI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.configitem.EtmBoard6102MCI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.configitem.PowerSupply6102CI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.configitem.PowerSupply6102MCI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.configitem.RadioEquipment6102CI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.configitem.RadioEquipment6102MCI;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;

public class Rbs6102
extends AbstractRbs {
    private static boolean semiSubrackHardware = false;
    private static int maxNumberOfSectors = 6;
    private static int maxNumberOfCarriers = 4;
    private static String slotForCbu = "1, 24";

    public Rbs6102(MoHandler moHandler, String string) {
        super(moHandler, string);
    }

    protected void createAllConfigurationItems() {
        if (semiSubrackHardware) {
            this.registerConfigItem(new CabinetBasic6102MCI(this));
            this.registerConfigItem(new EtmBoard6102MCI(this));
            this.registerConfigItem(new PowerSupply6102MCI(this));
            this.registerConfigItem(new RadioEquipment6102MCI(this));
        } else {
            this.registerConfigItem(new CabinetBasic6102CI(this));
            this.registerConfigItem(new EtmBoard3206CI(this));
            this.registerConfigItem(new PowerSupply6102CI(this));
            this.registerConfigItem(new RadioEquipment6102CI(this));
        }
        this.registerConfigItem(new CommonAlarmCI(this, true, true));
        this.registerConfigItem(new AtmAndPtCI(this));
        this.registerConfigItem(new CellAndCarrierCI(this));
        this.registerConfigItem(new AntennaSystemTmaCI(this, false));
    }

    public String getRbsType() {
        return RbsInfo.RBS_6102W.NAME;
    }

    public int getMaxNumberOfCarriers() {
        return maxNumberOfCarriers;
    }

    public static void setMaxNumberOfCarriers(int n) {
        maxNumberOfCarriers = n;
    }

    public int getMaxNumberOfSectors() {
        return maxNumberOfSectors;
    }

    public static void setMaxNumberOfSectors(int n) {
        maxNumberOfSectors = n;
    }

    public String getSlotsForCbu() {
        return slotForCbu;
    }

    public static void setSlotsForCbu(String string) {
        slotForCbu = string;
    }

    public static void setSemiSubrackHardware(boolean bl) {
        semiSubrackHardware = bl;
    }

    public static boolean backPlaneSemiSubrackHardware() {
        return semiSubrackHardware;
    }
}

