/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractSwHandlingRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAlarmPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimControlPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwUnit;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public abstract class AbstractHwUnitRI
extends AbstractSwHandlingRI
implements ResourceItem {
    private boolean newBoard = false;
    private boolean isDeleted = false;
    private final String piuTypeProductName;
    private final String piuTypeProductNumber;
    private String referredCabinetNumber = "1";

    public AbstractHwUnitRI(String string, Rbs rbs, String string2, String string3, String[] stringArray) {
        super(string, rbs, stringArray);
        this.piuTypeProductName = string2;
        this.piuTypeProductNumber = string3;
    }

    private void verifyHwUnitMo(BemMo bemMo) throws BemException {
        String string = bemMo.getType();
        if (!string.equals(MimHwUnit.MOTYPENAME)) {
            throw new BemException("AbstractHwUnitRI.verifyHwUnitMo(): MO is not a HwUnit:" + bemMo.getDN());
        }
    }

    protected final void createHwUnitIfNotExisting(String string) throws BemException {
        BemMo bemMo = this.getMo(string);
        BemMo bemMo2 = super.getPiuType();
        if (bemMo2 == null) {
            bemMo2 = this.getPiuTypeFromProductNameAndNumber();
        }
        try {
            this.verifyHwUnitMo(bemMo);
            boolean bl = this.isExisting(bemMo);
            if (!bl) {
                this.newBoard = true;
                this.createHwUnit(bemMo, bemMo2);
            }
        }
        catch (RuntimeException runtimeException) {
            String string2 = "AbstractHwUnit.create()";
            String string3 = runtimeException.toString();
            throw new BemException(string2, "createHwUnitIfNotExisting()", string, string3, runtimeException);
        }
    }

    private final void deleteHwUnit() throws BemException {
        String string = this.getLdn();
        try {
            this.deleteMoIfExisting(string);
        }
        catch (RuntimeException runtimeException) {
            String string2 = "AbstractHwUnit.delete()";
            String string3 = runtimeException.toString();
            throw new BemException(string2, "deleteHwUnitAndBoard", string, string3, runtimeException);
        }
        this.isDeleted = true;
    }

    private void createHwUnit(BemMo bemMo, BemMo bemMo2) throws BemException {
        this.verifyHwUnitMo(bemMo);
        Vector<NalNameValue> vector = new Vector<NalNameValue>(0);
        vector.addElement(Nal.getFactory().getNameValue("piuType", bemMo2));
        vector.addElement(Nal.getFactory().getNameValue("administrativeState", new Integer(0)));
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getMoiRefs().getEquipmentMoi(), MimCabinet.MOTYPENAME, this.getReferredCabinetNumber());
        BemMo bemMo3 = this.rbs.getMoHandler().getMo(fixedRdnMoi.getLdn());
        vector.addElement(Nal.getFactory().getNameValue("positionRef", bemMo3));
        this.create(bemMo, vector);
    }

    protected void setSwLoadable(boolean bl) {
    }

    public void install(String string) throws BemException {
        if (string.equals("InstallPiuTypesPhase")) {
            if (!this.isDeleted) {
                this.installPiuTypes();
            }
        } else if (super.containsPhase(this.getInstallationPhases(), string)) {
            if (string.equals("HwUnitDbControlledCreationPhase")) {
                String string2 = this.getLdn();
                this.createHwUnitIfNotExisting(string2);
            } else if (string.equals("UnlockAllUnitsPhase")) {
                this.unlock("administrativeState");
            } else if (string.equals("UnlockPhase")) {
                this.handleUnlockPhase();
            }
        }
    }

    protected void handleUnlockPhase() throws BemException {
        if (this.newBoard) {
            this.unlock("administrativeState");
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("LockPhase")) {
            this.lock("administrativeState");
        }
        if (super.containsPhase(this.getInstallationPhases(), string) && string.equals("HwUnitDbControlledDeletionPhase")) {
            this.handleDeletionPhase();
        }
    }

    protected void lock(String string) throws BemException {
        String string2 = null;
        string2 = this.getLdn();
        BemMo bemMo = this.getMo(string2);
        try {
            if (this.isExisting(bemMo)) {
                BemLog.log(7, this.getName() + " lock()");
                this.rbs.getMoHandler().setAttribute(bemMo, string, new Integer(0));
            }
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("Problem, Low Level", "Failed locking MO using adminStateAttrName=" + string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", string2);
            bemException.setProperty("Failing Method", "lock()");
            throw bemException;
        }
    }

    protected void unlock(String string) throws BemException {
        String string2 = null;
        try {
            Integer n;
            string2 = this.getLdn();
            BemMo bemMo = this.getMo(string2);
            MoHandler moHandler = this.rbs.getMoHandler();
            if (this.isExisting(bemMo) && (n = (Integer)moHandler.getAttribute(bemMo, string)) != null && n == 0) {
                BemLog.log(7, this.getName() + " unlock()");
                moHandler.setAttribute(bemMo, string, new Integer(1));
            }
        }
        catch (Exception exception) {
            BemException bemException = new BemException(exception);
            bemException.setProperty("Problem, Low Level", "Failed unlocking MO using adminStateAttrName=" + string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", this.getLdn());
            bemException.setProperty("Failing Method", "unlock()");
            throw bemException;
        }
    }

    protected void handleDeletionPhase() throws BemException {
        this.deletePorts();
        this.deleteHwUnit();
    }

    private void deletePorts() throws BemException {
        String string = this.getLdn();
        BemMo bemMo = this.getMo(string);
        try {
            if (!bemMo.isExisting()) {
                return;
            }
            BemMo[] bemMoArray = this.getChildren(bemMo, 10, "", "");
            if (bemMoArray != null) {
                for (int i = 0; i < bemMoArray.length; ++i) {
                    BemMo bemMo2 = bemMoArray[i];
                    String string2 = bemMo2.getType();
                    if (!string2.equals(MimEcPort.MOTYPENAME) && !string2.equals(MimAlarmPort.MOTYPENAME) && !string2.equals(MimControlPort.MOTYPENAME)) continue;
                    this.delete(bemMo2);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            String string3 = "AbstractHwUnit.uninstall()";
            String string4 = runtimeException.toString();
            throw new BemException(string3, "deletePorts()", string, string4, runtimeException);
        }
    }

    public abstract String getLdn();

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.getLdn());
    }

    private BemMo getPiuTypeFromProductNameAndNumber() throws BemException {
        BemMo bemMo = null;
        if (this.piuTypeProductName != null && this.piuTypeProductNumber != null) {
            String string = this.findPiuType();
            if (string != null) {
                bemMo = this.getMo(string);
            } else {
                throw new BemException(this.getClass().toString(), "getPiuType()", null, "\tNeeded PiuType not found! PiuTypeProductName = " + this.piuTypeProductName + " PiuTypeProductNumber = " + this.piuTypeProductNumber + "\n\tMake sure that a HwUnit with PiuTypeName = " + this.piuTypeProductName + " and PiuTypeNumber = " + this.piuTypeProductNumber + " is installed on the RBS", null);
            }
        }
        return bemMo;
    }

    private String findPiuType() throws BemException {
        String string = null;
        try {
            HashMap hashMap = this.rbs.getAllPiuTypes();
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                NalStruct nalStruct = (NalStruct)entry.getValue();
                String string3 = (String)nalStruct.getMemberValue("productName");
                String string4 = (String)nalStruct.getMemberValue("productNumber");
                if (!string3.equals(this.piuTypeProductName) || !string4.equals(this.piuTypeProductNumber)) continue;
                string = string2;
                break;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException(this.getClass().getName(), "findPiuType()", null, "\tCould not find field: productName", noSuchFieldException);
        }
        return string;
    }

    public String getReferredCabinetNumber() {
        return this.referredCabinetNumber;
    }

    public void setReferredCabinetNumber(String string) {
        this.referredCabinetNumber = string;
    }
}

