/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSubrackProdType;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public abstract class AbstractSubrackRI
extends AbstractResourceItem
implements ResourceItem {
    private static final String[] myInstallationPhases = new String[]{"SubrackCreationPhase"};
    private final int noSlots;
    private final String cabinetPosition;
    private final String subrackPosition;
    private final String subrackLdn;
    private final Hashtable boardResourceItems = new Hashtable();
    private final Hashtable rIs = new Hashtable();
    private BemMo subrackProdTypeMo;
    private static final String MISSING_SUBRACK_PROD_TYPE = "Couldnt find matching subrackProdType MO for the either operational or administrative data";

    protected AbstractSubrackRI(String string, Rbs rbs, int n, String string2, String string3, String string4) {
        super(string, rbs, myInstallationPhases);
        this.noSlots = n;
        this.cabinetPosition = string2;
        this.subrackPosition = string3;
        this.subrackLdn = string4;
    }

    public void install(String string) throws BemException {
        if (myInstallationPhases[0].equals(string)) {
            BemMo bemMo = this.getMo(this.subrackLdn);
            this.findSubrackProdType();
            BemMo bemMo2 = (BemMo)this.getAttribute(bemMo, "subrackProdTypeRef");
            if (this.subrackProdTypeMo != null && !((Object)this.subrackProdTypeMo).equals(bemMo2) && !DuwUtil.isMicroRbsDuw()) {
                this.setAttribute(bemMo, "subrackProdTypeForSwUpgrade", (Object)this.subrackProdTypeMo);
            }
            this.setSubrackPositions();
            this.adjustNoOfSlots();
        }
    }

    private void setSubrackPositions() throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("subrackPosition", this.subrackPosition));
        vector.add(Nal.getFactory().getNameValue("cabinetPosition", this.cabinetPosition));
        BemMo bemMo = this.getMo(this.subrackLdn);
        this.setAttributes(bemMo, vector);
    }

    public String getLdn() {
        return this.subrackLdn;
    }

    public String getDisplayName() {
        String string = this.cabinetPosition + " :" + this.subrackPosition + " :" + super.getName();
        return string;
    }

    private boolean adjustNoOfSlots() throws BemException {
        boolean bl = true;
        String string = "removeSlots";
        String string2 = "numberOfSlotsToRemove";
        BemMo bemMo = this.getMo(this.subrackLdn);
        Integer n = (Integer)this.getAttribute(bemMo, "numberOfSlots");
        if (this.noSlots < n) {
            int n2 = n - this.noSlots;
            Integer n3 = new Integer(n2);
            NalNameValue nalNameValue = Nal.getFactory().getNameValue(string2, n3);
            NalNameValue[] nalNameValueArray = new NalNameValue[]{nalNameValue};
            this.action(bemMo, string, nalNameValueArray);
        }
        return bl;
    }

    public ArrayList getSubResourceItems() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Collection collection = this.boardResourceItems.values();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public ResourceItem getSubResourceItem(Integer n) {
        ResourceItem resourceItem = null;
        if (this.boardResourceItems.containsKey(n)) {
            resourceItem = (ResourceItem)this.boardResourceItems.get(n);
        }
        return resourceItem;
    }

    protected Hashtable getBoardResourceItems() {
        return this.boardResourceItems;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractSubrackRI)) {
            return false;
        }
        AbstractSubrackRI abstractSubrackRI = (AbstractSubrackRI)object;
        String string = this.getLdn();
        String string2 = abstractSubrackRI.getLdn();
        return string.equals(string2);
    }

    public int hashCode() {
        return this.getLdn().hashCode() * 11;
    }

    public void addToRIs(Integer n, ResourceItem resourceItem) {
        this.rIs.put(n, resourceItem);
    }

    public ResourceItem getRIs(Integer n) {
        return (ResourceItem)this.rIs.get(n);
    }

    private void findSubrackProdType() throws BemException {
        Object object;
        BemMo bemMo;
        if (this.subrackProdTypeMo == null && DuwUtil.hasDuw()) {
            this.subrackProdTypeMo = this.findSubrackProdTypeMo("ROJ999999/2");
        }
        if (this.subrackProdTypeMo == null) {
            bemMo = this.getMo(this.subrackLdn);
            object = (NalStruct)this.getAttribute(bemMo, "operationalProductData");
            try {
                String string = (String)object.getMemberValue("productNumber");
                if (string != null && !string.equals("")) {
                    this.subrackProdTypeMo = this.findSubrackProdTypeMo(string);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Nal.getFactory().getLog().nalTrace(4, this.getClass(), "findSubrackProdType()", noSuchFieldException);
            }
        }
        if (this.subrackProdTypeMo == null) {
            bemMo = this.getMo(this.rbs.getNodeBFunctionMoi().getLdn());
            object = (String)this.getAttribute(bemMo, "backplanePid");
            if ((object = BemUtil.getTrimString((String)object)) != null && !((String)object).equals("")) {
                this.subrackProdTypeMo = this.findSubrackProdTypeMo((String)object);
            }
        }
        if (this.subrackProdTypeMo == null) {
            Nal.getFactory().getLog().nalTrace(2, this.getClass(), "findSubrackProdType()Couldnt find matching subrackProdType MO for the either operational or administrative data");
        }
    }

    private BemMo findSubrackProdTypeMo(String string) throws BemException {
        BemMo bemMo = null;
        BemMo bemMo2 = this.getMo(this.rbs.getEquipmentMoi().getLdn());
        BemMo[] bemMoArray = this.getChildren(bemMo2, 1, MimSubrackProdType.MOTYPENAME, "");
        for (int i = 0; bemMoArray.length > i; ++i) {
            BemMo bemMo3 = bemMoArray[i];
            NalStruct nalStruct = (NalStruct)this.getAttribute(bemMo3, "productData");
            String string2 = (String)this.getValeOfStructMember(nalStruct, "productNumber");
            if (!BemUtil.getTrimString(string2).equals(BemUtil.getTrimString(string))) continue;
            bemMo = bemMo3;
            break;
        }
        return bemMo;
    }
}

