/*
 *  COPYRIGHT
 *  ---------
 *  Copyright (C) 2008-2010 by
 *  Ericsson AB
 *
 *  The program may be used and/or copied only with the written
 *  permission from Ericsson AB, or in
 *  accordance with the terms and conditions stipulated in the
 *  agreement/contract under which the program has been supplied.
 *
 *  All rights reserved.
 *
 */
/*
 *  COPYRIGHT
 *  ---------
 *  Ericsson AB 2008 All rights reserved.
 *
 * The information in this document is the property of Ericsson.
 * Except as specifically authorized in writing by Ericsson, the
 * receiver of this document shall keep the information contained
 * herein confidential and shall protect the same in whole or in
 * part from disclosure and dissemination to third parties.
 * Disclosure and disseminations to the receiver's employees shall
 * only be made on a strict need to know basis.
 *
 *
 *  REVISION HISTORY
 *  ----------------
 *
 *  Revised: Johan Flinck 14 Feb 2008
 *  Changes: First revision.
 *  UABtr62651 has been corrected by uabflik 
 *  
 *  2008-08-11 qdengra UABtr63853 Throw a NoUpException if there is no Up (no view files either).
 *  
 *  2008-09-05 uabflik UABtr62664 CPPClientConfig.xml should be generated on target
 *  
 *  2010-09-01 ehsake HM11102 Total refactoring for separating ViewFile and CPPClientConfig.
 *  
 *  2010-10-04 ehsake HM83870 UP can be null at initial configuration.
 *
 */

package se.ericsson.cello.viewfilecreator.mao;


import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.viewfilecreator.log.Logger;

public class LoadModuleCollector {


	private ConfigurationVersionMo cvMo;
	private ManagedObject[] loadModules;

	public LoadModuleCollector() throws Exception
	{

		MoIterator moIt = MoRepository.instance().lookupType(ConfigurationVersionMo.TYPE_NAME);
		if(moIt==null) {
		    throw new Exception("Could not find ConfigurationVersion MO.");
		}
	
		cvMo = (ConfigurationVersionMo) moIt.nextMo();
		
	}
	
	public LoadModuleCollector(ConfigurationVersionMo cvMo) {
		
		this.cvMo = cvMo;
	}
	

	public ManagedObject[] getLoadModules() throws NoUpException, LoadModuleCollectionException  {
		if(loadModules == null) {
			fetchLoadModules();
		}
		return loadModules;
	}
	


	private void fetchLoadModules() throws NoUpException, LoadModuleCollectionException   {
		
		Logger.trace(this.getClass(),"Fetching LoadModules");
		UpgradePackageMo upMo;
		try {
			// At initial configuration the current UP will be null
			upMo = (UpgradePackageMo)cvMo.getCurrentUpgradePackage(null);
			if(upMo == null) {
				throw new NoUpException("No current upgrade package available");
			}
			loadModules = upMo.getLoadModuleList(null);
			if(loadModules == null) {
				Logger.trace(getClass(), "Upgrade Package returned null LoadModule list");
				throw new LoadModuleCollectionException("Could not get LoadModules from UP");
			}
			Logger.trace(this.getClass(),"No of LMs = " + loadModules.length);

		} catch (MoAccessException e) {
			Logger.trace(this.getClass(), "Could not fetch LoadModules from upgrade package:" + e.getMessage());
			throw new LoadModuleCollectionException("Could not fetch LoadModules from upgrade package");
		}
		
	}
	
	public class LoadModuleCollectionException extends Exception {

		public LoadModuleCollectionException() {
			super();
		}

		public LoadModuleCollectionException(String message, Throwable cause) {
			super(message, cause);
		}

		public LoadModuleCollectionException(String message) {
			super(message);
		}

		public LoadModuleCollectionException(Throwable cause) {
			super(cause);
		}

		
	}



}
