/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.sync.TimingUnitMoImpl;
import se.ericsson.cello.sync.TuSyncRefMo;
import se.ericsson.cello.sync.fropxy.NssTuSyncRefCreateFroRsp;
import se.ericsson.cello.sync.fropxy.NssTuSyncRefDeleteFroRsp;
import se.ericsson.cello.sync.fropxy.NssTuSyncRefGetAttrRsp;
import se.ericsson.cello.sync.fropxy.NssTuSyncRefProxy;
import se.ericsson.cello.transaction.Coordinator;

public class TuSyncRefMoImpl
extends CelloMao
implements TuSyncRefMo,
SyncReservable {
    private static NssTuSyncRefProxy roProxy = NssTuSyncRefProxy.instance();
    private MoData myData;
    private StringAttribute userLabel;
    private SequenceAttribute reservedBy;
    private IntegerAttribute froId;
    private static final int MO_DATA_REVISION_2_6 = 0;
    private static final int MO_DATA_REVISION_2_6_1 = 1;
    private static final int MO_DATA_REVISION_3_1 = 3000;
    private static final int MO_DATA_REVISION_6 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;

    public static TuSyncRefMoImpl create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TimingUnit");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"TuSyncRef", (int)3);
        MoAttributeValidator.checkIdentity((String)"TuSyncRef", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"TuSyncRef", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"TuSyncRef");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"TuSyncRef");
        return new TuSyncRefMoImpl(managedObject, string2, n, string, coordinator, initialMaoContext);
    }

    private TuSyncRefMoImpl(ManagedObject managedObject, String string, int n, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, "TuSyncRef", string2, coordinator, initialMaoContext);
        NssTuSyncRefCreateFroRsp nssTuSyncRefCreateFroRsp = roProxy.sendNssTuSyncRefCreateFroReq(coordinator.getTransactionID(), n, ((TimingUnitMoImpl)managedObject).getFroId(coordinator));
        if (nssTuSyncRefCreateFroRsp == null) {
            throw new FroNotAccessibleException("TuSyncRef", "create NssTuSyncReferenceFro");
        }
        if (nssTuSyncRefCreateFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("TuSyncRef", "NssTuSyncReferenceFro", "create: " + roProxy.getResultMsg(nssTuSyncRefCreateFroRsp.getResult()), nssTuSyncRefCreateFroRsp.getResult());
        }
        int n2 = nssTuSyncRefCreateFroRsp.getFroId();
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true);
        this.userLabel.setValue(string);
        this.myData.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.myData.registerPersistentAttr((Attribute)this.reservedBy);
        this.froId = new IntegerAttribute("froId", false);
        this.froId.setValue(n2);
        this.myData.registerPersistentAttr((Attribute)this.froId);
        roProxy.registerForNotifications(coordinator, this, this.froId.getValue(coordinator));
        this.myData.setRevision(6000);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public TuSyncRefMoImpl(MoData moData, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.myData = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.myData, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.userLabel = (StringAttribute)this.myData.getAttribute("userLabel");
        this.froId = (IntegerAttribute)this.myData.getAttribute("froId");
        this.reservedBy = (SequenceAttribute)this.myData.getAttribute("reservedBy");
        roProxy.registerForNotifications(null, this, this.froId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("TuSyncRef");
        }
        NssTuSyncRefDeleteFroRsp nssTuSyncRefDeleteFroRsp = roProxy.sendNssTuSyncRefDeleteFroReq(coordinator.getTransactionID(), this.froId.getValue(coordinator));
        if (nssTuSyncRefDeleteFroRsp == null) {
            throw new FroNotAccessibleException("TuSyncRef", "delete NssTuSyncReferenceFro");
        }
        if (nssTuSyncRefDeleteFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("TuSyncRef", "NssTuSyncReferenceFro", "delete: " + roProxy.getResultMsg(nssTuSyncRefDeleteFroRsp.getResult()), nssTuSyncRefDeleteFroRsp.getResult());
        }
        roProxy.deregisterForNotifications(coordinator, this.froId.getValue(coordinator));
        this.myData.delete(coordinator);
        super.delete(coordinator);
    }

    public String getType() {
        return "TuSyncRef";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"TuSyncRef", (int)128, (int)0);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = coordinator == null ? 0 : coordinator.getTransactionID();
        NssTuSyncRefGetAttrRsp nssTuSyncRefGetAttrRsp = roProxy.sendNssTuSyncRefGetAttrReq(n, this.froId.getValue(coordinator));
        if (nssTuSyncRefGetAttrRsp == null) {
            throw new FroNotAccessibleException("TuSyncRef", "get, NssTuSyncReferenceFro");
        }
        if (nssTuSyncRefGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("TuSyncRef", "NssTuSyncReferenceFro", "get: " + roProxy.getResultMsg(nssTuSyncRefGetAttrRsp.getResult()), nssTuSyncRefGetAttrRsp.getResult());
        }
        return nssTuSyncRefGetAttrRsp.getAvailabilityStatus();
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = coordinator == null ? 0 : coordinator.getTransactionID();
        NssTuSyncRefGetAttrRsp nssTuSyncRefGetAttrRsp = roProxy.sendNssTuSyncRefGetAttrReq(n, this.froId.getValue(coordinator));
        if (nssTuSyncRefGetAttrRsp == null) {
            throw new FroNotAccessibleException("TuSyncRef", "get NssTuSyncReferenceFro");
        }
        if (nssTuSyncRefGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("TuSyncRef", "NssTuSyncReferenceFro", "getAttr: " + roProxy.getResultMsg(nssTuSyncRefGetAttrRsp.getResult()), nssTuSyncRefGetAttrRsp.getResult());
        }
        return nssTuSyncRefGetAttrRsp.getOperState();
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = coordinator == null ? 0 : coordinator.getTransactionID();
        NssTuSyncRefGetAttrRsp nssTuSyncRefGetAttrRsp = roProxy.sendNssTuSyncRefGetAttrReq(n, this.froId.getValue(coordinator));
        if (nssTuSyncRefGetAttrRsp == null) {
            throw new FroNotAccessibleException("TuSyncRef", "get NssTuSyncReferenceFro");
        }
        if (nssTuSyncRefGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("TuSyncRef", "NssTuSyncReferenceFro", "getAttr: " + roProxy.getResultMsg(nssTuSyncRefGetAttrRsp.getResult()), nssTuSyncRefGetAttrRsp.getResult());
        }
        return nssTuSyncRefGetAttrRsp.getAdmState();
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        Object[] objectArray;
        String[] stringArray;
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n == 2) {
            n = 0;
        }
        switch (n) {
            case 0: {
                stringArray = roProxy.sendNssLockTuSyncRefReq(coordinator.getTransactionID(), this.froId.getValue(coordinator));
                if (stringArray == null) {
                    throw new FroNotAccessibleException("TuSyncRef", "set NssTuSyncReferenceFro");
                }
                if (stringArray.getResult() == 0) break;
                throw new FroRequestFailedException("TuSyncRef", "NssTuSyncReferenceFro", "set adminState locked: " + roProxy.getResultMsg(stringArray.getResult()), stringArray.getResult());
            }
            case 1: {
                objectArray = roProxy.sendNssUnlockTuSyncRefReq(coordinator.getTransactionID(), this.froId.getValue(coordinator));
                if (objectArray == null) {
                    throw new FroNotAccessibleException("TuSyncRef", "set NssTuSyncReferenceFro");
                }
                if (objectArray.getResult() == 0) break;
                throw new FroRequestFailedException("TuSyncRef", "NssTuSyncReferenceFro", "set adminState unlocked: " + roProxy.getResultMsg(objectArray.getResult()), objectArray.getResult());
            }
            default: {
                throw new ValueOutOfRangeException("administrativeState", "TuSyncRef");
            }
        }
        stringArray = new String[]{"administrativeState"};
        objectArray = new Object[]{new Integer(n)};
        TuSyncRefMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.myData.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reserve(managedObject, coordinator);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.release(managedObject, coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.froId.getValue(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.myData, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.myData, (String)"reservedBy");
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }
}

