/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync.fropxy;

import enea.ose.io.SignalInputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.sync.SatellitesInformationStruct;

public class NssGpsSyncRefGetAttrRsp
extends UnlinkedSignal {
    public static final int SIGNO = 645633;
    private int result;
    private int operState;
    private int availabilityStatus;
    private int admState;
    private int gpsCompensationDelay;
    private int gpsRefState;
    private int noOfSatellitesInView;
    private Struct[] satellitesInformation;
    private int satellite;
    private int elevation;
    private int azimuth;
    private int signalNoiseRation;
    private String latitude;
    private String longitude;
    private String altitude;
    private String hDop;
    private String vDop;
    private int observationPoint;
    private int filterTimeGpsAlarm;
    private int gnssRecControlPath;
    private int multipleGnssActual;
    private int multipleGnssStatus;
    private int multipleGnssWanted;
    private static final int NSS_CBM_GPS_ATTRIB_NUM_SATETTELITES = 12;
    private static final int NSS_GPSREF_ATTRIB_GEO_LATITUDE_STRING_LENGTH = 13;
    private static final int NSS_GPSREF_ATTRIB_GEO_LONGITUDE_STRING_LENGTH = 14;
    private static final int NSS_GPSREF_ATTRIB_GEO_ALTITUDE_STRING_LENGTH = 8;
    private static final int NSS_GPSREF_ATTRIB_DOP_STRING_LENGTH = 10;

    public int getSignalNumber() {
        return 645633;
    }

    public NssGpsSyncRefGetAttrRsp() {
        super(645633);
    }

    public int getResult() {
        return this.result;
    }

    public int getOperState() {
        return this.operState;
    }

    public int getAvailabilityStatus() {
        return this.availabilityStatus;
    }

    public int getAdmState() {
        return this.admState;
    }

    public int getGpsCompensationDelay() {
        return this.gpsCompensationDelay;
    }

    public int getGpsRefState() {
        return this.gpsRefState;
    }

    public int getNoOfSatellitesInView() {
        return this.noOfSatellitesInView;
    }

    public Struct[] getSatelliteInformation() {
        return this.satellitesInformation;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public String getAltitude() {
        return this.altitude;
    }

    public String getHDop() {
        return this.hDop;
    }

    public String getVDop() {
        return this.vDop;
    }

    public int getObservationPoint() {
        return this.observationPoint;
    }

    public int getFilterTimeGpsAlarm() {
        return this.filterTimeGpsAlarm;
    }

    public int getGnssRecControlPath() {
        return this.gnssRecControlPath;
    }

    public int getMultipleGnssActual() {
        return this.multipleGnssActual;
    }

    public int getMultipleGnssStatus() {
        return this.multipleGnssStatus;
    }

    public int getMultipleGnssWanted() {
        return this.multipleGnssWanted;
    }

    public void initReceive() {
        SignalInputStream signalInputStream = this.getSignalInputStream();
        try {
            long l = 0L;
            this.result = (int)signalInputStream.readU32();
            this.operState = signalInputStream.readU16();
            this.availabilityStatus = signalInputStream.readU16();
            this.admState = signalInputStream.readU16();
            this.gpsCompensationDelay = signalInputStream.readU16();
            this.gpsRefState = signalInputStream.readU8();
            this.noOfSatellitesInView = signalInputStream.readU8();
            this.satellitesInformation = new Struct[12];
            for (int i = 0; i < 12; ++i) {
                this.satellite = signalInputStream.readU16();
                this.elevation = signalInputStream.readU16();
                this.azimuth = signalInputStream.readU16();
                this.signalNoiseRation = signalInputStream.readU16();
                Object[] objectArray = new Integer[]{new Integer(this.satellite), new Integer(this.elevation), new Integer(this.azimuth), new Integer(this.signalNoiseRation)};
                this.satellitesInformation[i] = SatellitesInformationStruct.createStruct(objectArray);
            }
            this.latitude = signalInputStream.readString();
            l = signalInputStream.skip((long)(13 - this.latitude.length() - 1));
            this.checkSkippedBytes(l, 13 - this.latitude.length() - 1);
            this.longitude = signalInputStream.readString();
            l = signalInputStream.skip((long)(14 - this.longitude.length() - 1));
            this.checkSkippedBytes(l, 14 - this.longitude.length() - 1);
            this.altitude = signalInputStream.readString();
            l = signalInputStream.skip((long)(8 - this.altitude.length() - 1));
            this.checkSkippedBytes(l, 8 - this.altitude.length() - 1);
            this.hDop = signalInputStream.readString();
            l = signalInputStream.skip((long)(10 - this.hDop.length() - 1));
            this.checkSkippedBytes(l, 10 - this.hDop.length() - 1);
            this.vDop = signalInputStream.readString();
            l = signalInputStream.skip((long)(10 - this.vDop.length() - 1));
            this.checkSkippedBytes(l, 10 - this.vDop.length() - 1);
            this.observationPoint = signalInputStream.readU8();
            this.filterTimeGpsAlarm = (int)signalInputStream.readU32();
            this.gnssRecControlPath = signalInputStream.readU8();
            this.multipleGnssActual = signalInputStream.readU8();
            this.multipleGnssStatus = signalInputStream.readU8();
            this.multipleGnssWanted = signalInputStream.readU8();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkSkippedBytes(long l, long l2) {
        if (l != l2) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)"An error occured when skipping over bytes !");
        }
    }

    public void initSend() {
    }
}

