/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import java.util.StringTokenizer;

public class IpCalc {
    private String ipStr;
    private int[] ipN;
    private String maskStr;
    private int[] maskN;
    private String bcStr;
    private int[] bcN;
    private String nwStr;
    private int[] nwN;
    private String NetworkClass;

    public IpCalc() {
    }

    public IpCalc(String string, String string2) {
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        this.ipStr = string;
        this.ipN = this.str2intArr(string);
        this.maskStr = string2;
        this.maskN = this.str2intArr(string2);
        this.nwN = this.calcNetworkAddressN(this.ipN, this.maskN);
        this.nwStr = this.intArr2str(this.nwN);
        this.bcN = this.calcBroadcastAddressN(this.nwN, this.maskN);
        this.bcStr = this.intArr2str(this.bcN);
        this.NetworkClass = this.calcClass(this.nwN);
    }

    private int[] calcNetworkAddressN(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray3[i] = nArray[i] & nArray2[i];
        }
        return nArray3;
    }

    private int[] calcBroadcastAddressN(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray3[i] = nArray[i] | nArray2[i] ^ 0xFF;
        }
        return nArray3;
    }

    private String calcClass(int[] nArray) {
        String string = "NONE";
        if ((nArray[0] & 0x80) == 0) {
            string = "A";
        } else if ((nArray[0] & 0xC0) == 128) {
            string = "B";
        } else if ((nArray[0] & 0xE0) == 192) {
            string = "C";
        } else if ((nArray[0] & 0xF0) == 224) {
            string = "D";
        } else if ((nArray[0] & 0xF8) == 240) {
            string = "E";
        }
        return string;
    }

    private int[] str2intArr(String string) {
        String[] stringArray = this.splitStr(string, ".");
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    private String intArr2str(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toString(nArray[0]);
        stringBuffer.append(string);
        for (int i = 1; i < 4; ++i) {
            stringBuffer.append(".");
            stringBuffer.append(Integer.toString(nArray[i]));
        }
        return stringBuffer.toString();
    }

    private String[] splitStr(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[4];
        for (n = 0; stringTokenizer.hasMoreTokens() && n < 4; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        if (!stringTokenizer.hasMoreTokens() && n < stringArray.length) {
            return null;
        }
        if (stringTokenizer.hasMoreTokens() && n == stringArray.length) {
            ++n;
            return null;
        }
        return stringArray;
    }

    public void config(String string, String string2) {
        this.init(string, string2);
    }

    public boolean isBroadcastAddress(String string) {
        String[] stringArray = this.splitStr(string, ".");
        int n = Integer.parseInt(stringArray[3]);
        return n == 255;
    }

    public String calcNetworkAddress(String string, String string2) {
        this.config(string, string2);
        return this.nwStr;
    }

    public String calcBroadcastAddress(String string, String string2) {
        this.config(string, string2);
        return this.bcStr;
    }

    public String getIpAddress() {
        return this.ipStr;
    }

    public String getSubnetMask() {
        return this.maskStr;
    }

    public String getBroadcastAddress() {
        return this.bcStr;
    }

    public String getNetworkAddress() {
        return this.nwStr;
    }

    public String getNetworkClass() {
        return this.NetworkClass;
    }
}

