/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam.fropxy;

import enea.ose.io.SignalInputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.common.fropxy.MaoFroFormatConvert;

public class OsaIpLinkGetAttributeConf
extends UnlinkedSignal {
    private static final int SIGNO = 66219;
    private static final int MACADDRESS_LENGTH = 6;
    private static final int N_ATTRIBUTES = 20;
    public static final int ETHERNET_LINK_RSP_OK = 1;
    private int result;
    private int linkId;
    private int broadcastAddress;
    private String interfaceName = "";
    private int mtuSize;
    private int operationalState;
    private int metric;
    private int monitor;
    private int monitorInterval;
    private int monitorRetries;
    private int subnetMask;
    private int ipAddress;
    private int[] macAddress = new int[6];
    private String macAddressStr = "";
    private int availabilityStatus;
    private int[] availableMaus;
    private int activeMau;
    private int pmNoOfIfInUcastPkts;
    private int pmNoOfIfInNUcastPkts;
    private int pmNoOfIfOutUcastPkts;
    private int pmNoOfIfOutNUcastPkts;
    private int pmNoOfIfInErrors;
    private int pmNoOfIfInDiscards;
    private int pmNoOfIfOutDiscards;

    public int getSignalNumber() {
        return 66219;
    }

    public OsaIpLinkGetAttributeConf() {
        super(66219);
    }

    public int getResult() {
        return this.result;
    }

    public int getLinkId() {
        return this.linkId;
    }

    public void initReceive() {
        SignalInputStream signalInputStream = this.getSignalInputStream();
        try {
            this.linkId = (int)signalInputStream.readU32();
            this.result = (int)signalInputStream.readU32();
            if (this.result == 1) {
                block26: for (int i = 1; i <= 20; ++i) {
                    int n = (int)signalInputStream.readU32();
                    switch (n) {
                        case -1: {
                            return;
                        }
                        case 5: {
                            this.interfaceName = signalInputStream.readString();
                            signalInputStream.align(4);
                            continue block26;
                        }
                        case 0: {
                            this.ipAddress = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 3: {
                            this.metric = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 16: {
                            this.monitor = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 17: {
                            this.monitorInterval = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 18: {
                            this.monitorRetries = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 8: {
                            this.broadcastAddress = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 4: {
                            this.operationalState = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 2: {
                            this.mtuSize = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 1: {
                            this.subnetMask = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 6: {
                            int n2;
                            for (n2 = 0; n2 < 6; ++n2) {
                                this.macAddress[n2] = (int)signalInputStream.readU32();
                            }
                            this.macAddressStr = MaoFroFormatConvert.macaddrArr2String((int[])this.macAddress);
                            continue block26;
                        }
                        case 9: {
                            this.availabilityStatus = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 23: {
                            this.activeMau = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 22: {
                            int n2 = (int)signalInputStream.readU32();
                            this.availableMaus = new int[n2];
                            for (int j = 0; j < n2; ++j) {
                                this.availableMaus[j] = (int)signalInputStream.readU32();
                            }
                            continue block26;
                        }
                        case 10: {
                            this.pmNoOfIfInUcastPkts = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 11: {
                            this.pmNoOfIfInNUcastPkts = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 12: {
                            this.pmNoOfIfOutUcastPkts = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 13: {
                            this.pmNoOfIfOutNUcastPkts = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 14: {
                            this.pmNoOfIfInErrors = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 15: {
                            this.pmNoOfIfInDiscards = (int)signalInputStream.readU32();
                            continue block26;
                        }
                        case 19: {
                            this.pmNoOfIfOutDiscards = (int)signalInputStream.readU32();
                            continue block26;
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void initSend() {
    }

    public int getIpAddress() {
        return this.ipAddress;
    }

    public int getBroadcastAddress() {
        return this.broadcastAddress;
    }

    public int getSubnetMask() {
        return this.subnetMask;
    }

    public int getActiveMau() {
        return this.activeMau;
    }

    public int[] getAvailableMaus() {
        return this.availableMaus;
    }

    public int getMetric() {
        return this.metric;
    }

    public int getMonitor() {
        return this.monitor;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public int getMonitorRetries() {
        return this.monitorRetries;
    }

    public String getMacAddress() {
        return this.macAddressStr;
    }

    public int getOperationalState() {
        return this.operationalState;
    }

    public int getMtuSize() {
        return this.mtuSize;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public int getAvailabilityStatus() {
        return this.availabilityStatus;
    }

    public int getPmNoOfIfInUcastPkts() {
        return this.pmNoOfIfInUcastPkts;
    }

    public int getPmNoOfIfInNUcastPkts() {
        return this.pmNoOfIfInNUcastPkts;
    }

    public int getPmNoOfIfOutUcastPkts() {
        return this.pmNoOfIfOutUcastPkts;
    }

    public int getPmNoOfIfOutNUcastPkts() {
        return this.pmNoOfIfOutNUcastPkts;
    }

    public int getPmNoOfIfInErrors() {
        return this.pmNoOfIfInErrors;
    }

    public int getPmNoOfIfInDiscards() {
        return this.pmNoOfIfInDiscards;
    }

    public int getPmNoOfIfOutDiscards() {
        return this.pmNoOfIfOutDiscards;
    }

    public void setPmCountersUnavailable() {
        this.pmNoOfIfInUcastPkts = -1;
        this.pmNoOfIfInNUcastPkts = -1;
        this.pmNoOfIfOutUcastPkts = -1;
        this.pmNoOfIfOutNUcastPkts = -1;
        this.pmNoOfIfInErrors = -1;
        this.pmNoOfIfInDiscards = -1;
        this.pmNoOfIfOutDiscards = -1;
    }
}

