/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.TopologyModel;
import se.ericsson.cello.support.gui.ViewElementEvent;
import se.ericsson.cello.support.gui.ViewElementListener;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;

class DetailModel
extends AbstractTableModel
implements ViewElementListener {
    private static final long serialVersionUID = 8076831735523132395L;
    private ResourceBundle resourceBundle;
    private Locale locale;
    private Vector columnNames = new Vector(20);
    private static final String FIRST_COLUMN_NAME = "VIEWELEMENT_NAME";
    private AbstractViewElement parentElement;
    private TopologyModel mgrPresentationModel;

    public DetailModel(TopologyModel mgrPresentationModel, ResourceBundle resourceBundle) {
        if (mgrPresentationModel == null) {
            throw new IllegalArgumentException("mgrPresentationModel==null");
        }
        this.mgrPresentationModel = mgrPresentationModel;
        this.setResourceBundle(resourceBundle);
        this.setColumnNames(mgrPresentationModel.getStandardAttributes());
        this.parentElement = (AbstractViewElement)mgrPresentationModel.getRoot();
        this.parentElement.addViewElementListener(this);
        this.parentElement.addListenerToPropertyElements(this);
        this.parentElement.addListenerToSubordinates(this);
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public AbstractViewElement getElement(int row) {
        if (this.parentElement == null) {
            return null;
        }
        return this.parentElement.getChildAt(row);
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public int getRowCount() {
        return this.parentElement == null ? 0 : this.parentElement.getChildCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        AbstractViewElement elt = this.getElement(rowIndex);
        if (columnIndex == 0 || elt == null) {
            return elt;
        }
        return elt.getAttributeValue((String)this.columnNames.get(columnIndex));
    }

    public void setParentElement(AbstractViewElement newParent) {
        if (newParent == null) {
            throw new IllegalArgumentException("newParent == null");
        }
        if (this.parentElement != null) {
            this.parentElement.removeViewElementListener(this);
            AbstractViewElement[] children = this.parentElement.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].removeViewElementListener(this);
            }
        }
        this.parentElement = newParent;
        this.parentElement.addViewElementListener(this);
        this.parentElement.addListenerToPropertyElements(this);
        this.parentElement.addListenerToSubordinates(this);
        this.setColumnNames(this.parentElement.getChildrenAttributes());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DetailModel.this.fireTableStructureChanged();
            }
        });
    }

    public AbstractViewElement getParentElement() {
        return this.parentElement;
    }

    protected void setColumnNames(String[] newColumnNames) {
        Log.trace("setColumnNames");
        int nrOfColumns = newColumnNames != null ? newColumnNames.length + 1 : 1;
        this.columnNames.ensureCapacity(nrOfColumns);
        this.columnNames.clear();
        this.columnNames.add(FIRST_COLUMN_NAME);
        for (int i = 0; i < nrOfColumns - 1; ++i) {
            this.columnNames.add(newColumnNames[i]);
        }
    }

    public String getColumnName(int column) {
        String columnName = "";
        ResourceBundle bundle = null;
        if (column == 0) {
            columnName = FIRST_COLUMN_NAME;
            bundle = this.resourceBundle;
        } else if (column > 0 && column < this.columnNames.size()) {
            columnName = (String)this.columnNames.get(column);
            if (this.mgrPresentationModel.getResourceBundleBasename() != null) {
                bundle = this.locale == null ? GuilibResourceBundle.getBundle(this.mgrPresentationModel.getResourceBundleBasename(), this.getClass().getClassLoader()) : GuilibResourceBundle.getBundle(this.mgrPresentationModel.getResourceBundleBasename(), this.locale, this.getClass().getClassLoader());
            }
        }
        if (bundle != null) {
            columnName = bundle.getString(columnName);
        }
        return columnName;
    }

    public void viewElementInserted(ViewElementEvent event) {
        AbstractViewElement child;
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (event.getPath().getLastPathComponent() == this.parentElement && (child = (AbstractViewElement)event.getChangedObject()) != null) {
            int indexOfElt = event.getIndex();
            if (child.childrenAreAllowed()) {
                indexOfElt += this.parentElement.getPropertyElementCount();
            }
            this.fireTableRowsInserted(indexOfElt, indexOfElt);
            child.addViewElementListener(this);
        }
    }

    public void viewElementDeleted(ViewElementEvent event) {
        AbstractViewElement child;
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (event.getPath().getLastPathComponent() == this.parentElement && (child = (AbstractViewElement)event.getChangedObject()) != null) {
            int indexOfElt = event.getIndex();
            if (child.childrenAreAllowed()) {
                indexOfElt += this.parentElement.getPropertyElementCount();
            }
            child.removeViewElementListener(this);
            this.fireTableRowsDeleted(indexOfElt, indexOfElt);
        }
    }

    public void viewElementUpdated(ViewElementEvent event) {
        AbstractViewElement child;
        if (event == null) {
            throw new IllegalArgumentException();
        }
        TreePath parentPathFromEvent = event.getPath();
        AbstractViewElement parentObjectFromEvent = (AbstractViewElement)(parentPathFromEvent == null ? this.mgrPresentationModel.getRoot() : parentPathFromEvent.getLastPathComponent());
        if (parentObjectFromEvent == this.parentElement && (child = (AbstractViewElement)event.getChangedObject()) != null) {
            int indexOfElt = event.getIndex();
            if (child.childrenAreAllowed()) {
                indexOfElt += this.parentElement.getPropertyElementCount();
            }
            this.fireTableRowsUpdated(indexOfElt, indexOfElt);
        }
    }

    public void viewElementStructureChanged(ViewElementEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        TreePath parentPathFromEvent = event.getPath();
        AbstractViewElement parentObjectFromEvent = (AbstractViewElement)(parentPathFromEvent == null ? this.mgrPresentationModel.getRoot() : parentPathFromEvent.getLastPathComponent());
        if (parentObjectFromEvent == this.parentElement) {
            this.fireTableStructureChanged();
        }
    }

    public void viewElementChildrenLoaded(ViewElementEvent event) {
    }

    public void cleanup() {
        Log.logNotify("entering cleanup of tablemodel");
        this.columnNames.clear();
        if (this.parentElement != null) {
            Log.logNotify(" nullifying the parentElement");
            this.parentElement.removeViewElementListener(this);
            this.parentElement = null;
        }
        if (this.mgrPresentationModel != null) {
            Log.logNotify(" nullifying the mgrPresentationModel");
            this.mgrPresentationModel = null;
        }
    }
}

