/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.security.InvalidParameterException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.gui.guilib.infra.DefaultErrorReporterImpl;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.ResourceBundleDelegator;
import se.ericsson.cello.support.proxy.BaseException;

public class EmasErrorReporterImpl
extends DefaultErrorReporterImpl {
    protected static final String ERROR_LANGUAGE_BUNDLE_KEY = "emas.general.error.language.properties";
    protected static final String ERROR_LANGUAGE_BUNDLE_DEFAULT = "se.ericsson.cello.support.gui.resources.language.ErrorLanguage";
    protected Locale currentLocale = Locale.getDefault();
    protected Vector bundles = new Vector();
    protected ResourceBundleDelegator errorLanguageBundles = new ResourceBundleDelegator();

    public EmasErrorReporterImpl() {
        this.addErrorLanguageBundle(EmasSystemProperties.getProperty(ERROR_LANGUAGE_BUNDLE_KEY, ERROR_LANGUAGE_BUNDLE_DEFAULT));
    }

    public void addErrorLanguageBundle(String bundleName) {
        this.bundles.add(bundleName);
        ResourceBundle bundle = this.getBundle(bundleName, this.currentLocale);
        if (bundle != null) {
            this.errorLanguageBundles.add(bundle);
        }
    }

    protected String getErrorDescription(Exception e, AbstractController controller) {
        String str = null;
        String key = this.getErrorTag(e);
        try {
            if (controller == null) {
                throw new InvalidParameterException("controller=" + controller);
            }
        }
        catch (Exception e1) {
            Log.logError("Controller is null : " + e1);
        }
        try {
            this.reloadBundles(controller.getApplication().getLocale());
        }
        catch (Exception e2) {
            Log.logError("Exception while reloading bundles : " + e2);
        }
        String dummy = e.toString().trim();
        try {
            str = this.errorLanguageBundles.getString(key);
        }
        catch (MissingResourceException mre) {
            if (dummy.indexOf(":") > -1) {
                String theKey = dummy.substring(dummy.lastIndexOf(":") + 1);
                key = theKey.trim();
            }
            str = controller.getString(key, null);
        }
        return str;
    }

    protected String getErrorTag(Exception e) {
        String tag = "";
        String fullName = e.getClass().getName();
        String shortName = fullName.substring(fullName.lastIndexOf(".") + 1);
        tag = e instanceof BaseException ? shortName + "." + ((BaseException)e).getExceptionTag() : shortName;
        return tag;
    }

    protected void reloadBundles(Locale locale) {
        if (!locale.equals(this.currentLocale)) {
            this.currentLocale = locale;
            this.errorLanguageBundles = new ResourceBundleDelegator();
            for (int i = 0; i < this.bundles.size(); ++i) {
                this.errorLanguageBundles.add(this.getBundle((String)this.bundles.elementAt(i), this.currentLocale));
            }
        }
    }

    protected ResourceBundle getBundle(String bundleName, Locale locale) {
        ResourceBundle bundle = null;
        if (bundleName != null) {
            Log.assertion(!bundleName.equals(""), "Not allowed to specify empty string as bundle name");
            try {
                bundle = GuilibResourceBundle.getBundle(bundleName, locale, this.getClass().getClassLoader());
            }
            catch (Throwable t) {
                String msg = "Could not load bundle named: " + bundleName;
                Log.logError(msg, t);
                Log.assertion(false, msg);
            }
        }
        return bundle;
    }
}

