/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import javax.swing.Action;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.LDNIndexService;
import se.ericsson.cello.support.gui.MappedController;
import se.ericsson.cello.support.gui.TopologyModel;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class IndexingServiceRegistrator
implements TreeModelListener {
    protected TopologyModel model;
    protected MappedController controller;
    Action action;
    LDNIndexService ldnIs = LDNIndexService.getInstance();

    public IndexingServiceRegistrator(MappedController controller, TopologyModel model, Action action) {
        this.model = model;
        this.controller = controller;
        this.action = action;
        this.registerSubtree((AbstractViewElement)model.getRoot());
        model.addTreeModelListener(this);
    }

    public void registerSubtree(AbstractViewElement root) {
        this.registerViewElement(root);
        if (root.childrenAreLoaded()) {
            AbstractViewElement[] children = root.getChildrenUnsorted();
            for (int i = 0; i < children.length; ++i) {
                if (!this.isVEInTree(children[i])) continue;
                this.registerSubtree(children[i]);
            }
        }
    }

    public void registerViewElement(AbstractViewElement ve) {
        if (this.isVEInTree(ve)) {
            Log.trace("registerViewElement " + ve);
            String[] keys = ve.getIndexKeys();
            Log.trace("              keys: " + keys);
            for (int i = 0; i < keys.length; ++i) {
                this.ldnIs.register(keys[i], this.controller, ve, this.action);
            }
        } else {
            Log.trace("registerViewElement( deleted view element )");
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
        Log.trace("treeNodesChanged " + e);
        AbstractViewElement parentVe = (AbstractViewElement)e.getTreePath().getLastPathComponent();
        int[] newChildren = e.getChildIndices();
        for (int i = 0; i < newChildren.length; ++i) {
            AbstractViewElement child = parentVe.getChildAt(newChildren[i]);
            this.ldnIs.unregister(this.controller, child);
            this.registerViewElement(child);
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        Log.trace("treeNodesInserted " + e);
        AbstractViewElement parentVe = (AbstractViewElement)e.getTreePath().getLastPathComponent();
        int[] newChildren = e.getChildIndices();
        for (int i = 0; i < newChildren.length; ++i) {
            this.registerViewElement(parentVe.getChildAt(newChildren[i]));
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        Log.trace("treeNodesRemoved " + e);
        this.ldnIs.unregister(this.controller);
        this.registerSubtree((AbstractViewElement)this.model.getRoot());
    }

    public void treeStructureChanged(TreeModelEvent e) {
        Log.trace("treeStructureChanged " + e);
        this.ldnIs.unregister(this.controller);
        this.registerSubtree((AbstractViewElement)this.model.getRoot());
    }

    public final boolean isVEInTree(AbstractViewElement ve) {
        return ve.getParent() != null || ve.getModel() == this.model;
    }
}

