/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import se.ericsson.cello.support.gui.DetailModel;
import se.ericsson.cello.support.gui.DetailTable;
import se.ericsson.cello.support.gui.TopologyTree;
import se.ericsson.cello.support.gui.ViewSelectorComboBox;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationView;

public class MainWindowView
extends AbstractApplicationView {
    private static final long serialVersionUID = 2618634505216067252L;
    protected ViewSelectorComboBox selector = new ViewSelectorComboBox();
    protected JScrollPane leftScrollPane = new JScrollPane();
    protected JScrollPane rightScrollPane = new JScrollPane();
    protected JSplitPane topPane = new JSplitPane();
    protected JPanel leftPanel = new JPanel();
    protected JPanel rightPanel = new JPanel();
    protected JLabel noViewLabel = new JLabel("NO_VIEW_AVAILABLE");
    protected JLabel currentElementLabel = new JLabel();
    protected TopologyTree tree = new TopologyTree();
    public DetailTable table;
    protected JMenu[] menu;
    JMenuItem settingsMenuItem = new JMenuItem("SETTINGS");
    JMenuItem printMenuItem = new JMenuItem("PRINT");
    JMenuItem pageLayoutMenuItem = new JMenuItem("PAGE_LAYOUT");
    JMenuItem searchMenuItem = new JMenuItem("LDN_INDEX_QUERY");
    JButton refreshButton;

    public JMenu[] getMenus() {
        return this.menu;
    }

    public JComponent[] getToolBarComponents() {
        return new JComponent[0];
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(100, 100));
        this.putClientProperty("HELP_KEY", "EMAS_MAINWINDOW_BUTTON_HELP");
        this.noViewLabel.setVerticalAlignment(1);
        this.leftPanel.setLayout(new BorderLayout());
        this.rightPanel.setLayout(new BorderLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.topPane, c);
        this.topPane.add((Component)this.leftPanel, "left");
        this.leftPanel.add((Component)this.selector, "North");
        this.selector.setMaximumRowCount(16);
        this.leftPanel.add((Component)this.leftScrollPane, "Center");
        this.leftScrollPane.getViewport().add((Component)this.noViewLabel, null);
        this.topPane.add((Component)this.rightPanel, "right");
        this.rightPanel.add((Component)this.currentElementLabel, "North");
        this.rightPanel.add((Component)this.rightScrollPane, "Center");
        this.refreshButton = new JButton("REFRESH_BUTTON");
        this.refreshButton.setToolTipText("REFRESH_BUTTON_TOOLTIP");
        JPanel p = new JPanel(new BorderLayout(0, 0));
        p.add((Component)this.refreshButton, "East");
        p.add((Component)this.currentElementLabel, "Center");
        this.rightPanel.add((Component)p, "North");
        this.topPane.setDividerLocation(200);
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
        this.selector.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.currentElementLabel.setOpaque(true);
        this.currentElementLabel.setBackground(Color.white);
        this.currentElementLabel.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.setPreferredSize(new Dimension(600, 400));
    }

    public JMenuItem[] getFileMenuItems() {
        return new JMenuItem[]{this.settingsMenuItem, this.printMenuItem, this.pageLayoutMenuItem};
    }

    public JMenuItem[] getToolsMenuItems() {
        return new JMenuItem[]{this.searchMenuItem};
    }

    public void initializeTree() {
        this.leftScrollPane.getViewport().add((Component)this.tree, null);
        this.tree.setBackground(Color.white);
        this.leftScrollPane.getViewport().setBackground(this.tree.getBackground());
    }

    public void initializeTable(DetailModel m) {
        this.table = new DetailTable(m);
        this.table.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.table.setBackground(Color.white);
        this.rightScrollPane.getViewport().setBackground(this.table.getBackground());
        this.rightScrollPane.getViewport().add((Component)this.table, null);
        this.rightPanel.setBackground(this.table.getBackground());
    }

    protected void setRefreshButtonVisible(boolean visible) {
        this.refreshButton.setVisible(visible);
    }
}

